(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6284,        219]
NotebookOptionsPosition[      4505,        162]
NotebookOutlinePosition[      5586,        192]
CellTagsIndexPosition[      5543,        189]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GEODESY PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Geodesy Package" :> 
          Documentation`HelpLookup["paclet:Geodesy/tutorial/Geodesy"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Geodesy Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SpheroidalDistance" :> 
          Documentation`HelpLookup[
           "paclet:Geodesy/ref/SpheroidalDistance"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SpheroidalDistance\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Eccentricity", "ObjectName",
 CellID->25301],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Eccentricity"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["SpheroidalDistance",
       BaseStyle->"Link",
       ButtonData->"paclet:Geodesy/ref/SpheroidalDistance"]], 
      "InlineFormula"],
     " which specifies the eccentricity of the ellipsoid in the spheroidal \
model."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11726]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Eccentricity", "->", 
   StyleBox["v", "TI"]}]], "InlineFormula"],
 " specifies that the eccentricity of spheroidal model is the number ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->27059],

Cell[TextData[{
 "The default setting for the Earth, is ",
 Cell[BoxData["0.081819"], "InlineFormula"],
 ", from the WGS\[Dash]84 standard."
}], "Notes",
 CellID->28107]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15179],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["SpheroidalDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:Geodesy/ref/SpheroidalDistance"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->19787]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20381],

Cell[TextData[ButtonBox["Geodesy Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Geodesy/tutorial/Geodesy"]], "Tutorials",
 CellID->24450]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Eccentricity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 53.0381230}", "context" -> "Geodesy`", 
    "keywords" -> {}, "index" -> True, "label" -> "Geodesy Package Symbol", 
    "language" -> "en", "paclet" -> "Geodesy Package", "status" -> "None", 
    "summary" -> 
    "Eccentricity is an option for SpheroidalDistance which specifies the \
eccentricity of the ellipsoid in the spheroidal model.", "synonyms" -> {}, 
    "title" -> "Eccentricity", "type" -> "Symbol", "uri" -> 
    "Geodesy/ref/Eccentricity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1184, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1807, 58, 50, 1, 70, "ObjectName",
 CellID->25301],
Cell[1860, 61, 575, 17, 70, "Usage",
 CellID->11726]
}, Open  ]],
Cell[CellGroupData[{
Cell[2472, 83, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2950, 100, 271, 9, 70, "Notes",
 CellID->27059],
Cell[3224, 111, 169, 5, 70, "Notes",
 CellID->28107]
}, Closed]],
Cell[CellGroupData[{
Cell[3430, 121, 311, 9, 70, "SeeAlsoSection",
 CellID->15179],
Cell[3744, 132, 224, 6, 70, "SeeAlso",
 CellID->19787]
}, Open  ]],
Cell[CellGroupData[{
Cell[4005, 143, 314, 9, 70, "TutorialsSection",
 CellID->20381],
Cell[4322, 154, 141, 3, 70, "Tutorials",
 CellID->24450]
}, Open  ]],
Cell[4478, 160, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

