(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6313,        219]
NotebookOptionsPosition[      4535,        162]
NotebookOutlinePosition[      5620,        192]
CellTagsIndexPosition[      5577,        189]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GEODESY PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Geodesy Package" :> 
          Documentation`HelpLookup["paclet:Geodesy/tutorial/Geodesy"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Geodesy Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SpheroidalDistance" :> 
          Documentation`HelpLookup[
           "paclet:Geodesy/ref/SpheroidalDistance"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SpheroidalDistance\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SemimajorAxis", "ObjectName",
 CellID->22971],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["SemimajorAxis"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["SpheroidalDistance",
       BaseStyle->"Link",
       ButtonData->"paclet:Geodesy/ref/SpheroidalDistance"]], 
      "InlineFormula"],
     " which specifies the length of the semi-major axis in the spheroidal \
model."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11470]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SemimajorAxis", "->", 
   StyleBox["length", "TI"]}]], "InlineFormula"],
 " specifies that the length of the semi-major axis of the spheroid is ",
 Cell[BoxData[
  StyleBox["length", "TI"]], "InlineFormula"],
 " kilometers."
}], "Notes",
 CellID->8463],

Cell[TextData[{
 "The default setting, representing the Earth, is ",
 Cell[BoxData["6378.14"], "InlineFormula"],
 ", from the WGS\[Dash]84 standard."
}], "Notes",
 CellID->19537]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17516],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["SpheroidalDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:Geodesy/ref/SpheroidalDistance"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->8583]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->302],

Cell[TextData[ButtonBox["Geodesy Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Geodesy/tutorial/Geodesy"]], "Tutorials",
 CellID->4763]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SemimajorAxis - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 53.3506310}", "context" -> "Geodesy`", 
    "keywords" -> {}, "index" -> True, "label" -> "Geodesy Package Symbol", 
    "language" -> "en", "paclet" -> "Geodesy Package", "status" -> "None", 
    "summary" -> 
    "SemimajorAxis is an option for SpheroidalDistance which specifies the \
length of the semi-major axis in the spheroidal model.", "synonyms" -> {}, 
    "title" -> "SemimajorAxis", "type" -> "Symbol", "uri" -> 
    "Geodesy/ref/SemimajorAxis"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1184, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1807, 58, 51, 1, 70, "ObjectName",
 CellID->22971],
Cell[1861, 61, 576, 17, 70, "Usage",
 CellID->11470]
}, Open  ]],
Cell[CellGroupData[{
Cell[2474, 83, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2952, 100, 294, 9, 70, "Notes",
 CellID->8463],
Cell[3249, 111, 178, 5, 70, "Notes",
 CellID->19537]
}, Closed]],
Cell[CellGroupData[{
Cell[3464, 121, 311, 9, 70, "SeeAlsoSection",
 CellID->17516],
Cell[3778, 132, 223, 6, 70, "SeeAlso",
 CellID->8583]
}, Open  ]],
Cell[CellGroupData[{
Cell[4038, 143, 312, 9, 70, "TutorialsSection",
 CellID->302],
Cell[4353, 154, 140, 3, 70, "Tutorials",
 CellID->4763]
}, Open  ]],
Cell[4508, 160, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

