(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8855,        317]
NotebookOptionsPosition[      6725,        248]
NotebookOutlinePosition[      7828,        278]
CellTagsIndexPosition[      7785,        275]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GEODESY PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Geodesy Package" :> 
          Documentation`HelpLookup["paclet:Geodesy/tutorial/Geodesy"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Geodesy Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SpheroidalDistance" :> 
          Documentation`HelpLookup["paclet:Geodesy/ref/SpheroidalDistance"], 
          "CountryData" :> 
          Documentation`HelpLookup["paclet:ref/CountryData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SpheroidalDistance\"\>", 
       2->"\<\"CountryData\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SphericalDistance", "ObjectName",
 CellID->1008],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SphericalDistance", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["pt", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["pt", "TI"], 
         StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the distance between points ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " on the Earth using a spherical model of the planet. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A point ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["pt", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is expressed as a pair of numbers ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["latitude", "TI"], ",", 
    StyleBox["longitude", "TI"]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9983],

Cell[TextData[{
 "Each coordinate ",
 Cell[BoxData[
  StyleBox["latitude", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["longitude", "TI"]], "InlineFormula"],
 " can be given in degrees, or as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["degrees", "TI"], ",", 
    StyleBox["minutes", "TI"]}], "}"}]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["degrees", "TI"], ",", 
    StyleBox["minutes", "TI"], ",", 
    StyleBox["seconds", "TI"]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7191],

Cell["\<\
A negative value for a coordinate indicates that the coordinate is South \
latitude or West longitude.\
\>", "Notes",
 CellID->2984],

Cell["Distances are returned in kilometers.", "Notes",
 CellID->27158],

Cell["The spherical model is based on an exact formula.", "Notes",
 CellID->14938],

Cell["The following option can be given:", "Notes",
 CellID->28174],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "Radius", 
    RowBox[{"6371007", "/", "1000"}], Cell[
    "specify the radius of the sphere", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->28643],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Radius", " ", "->"}], 
   StyleBox["r", "TI"]}]], "InlineFormula"],
 " the radius of the spherical model is assumed to be ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " kilometers."
}], "Notes",
 CellID->13379]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4706],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpheroidalDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:Geodesy/ref/SpheroidalDistance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CountryData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CountryData"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9988]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26488],

Cell[TextData[ButtonBox["Geodesy Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Geodesy/tutorial/Geodesy"]], "Tutorials",
 CellID->29453]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SphericalDistance - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 53.5068850}", "context" -> "Geodesy`", 
    "keywords" -> {}, "index" -> True, "label" -> "Geodesy Package Symbol", 
    "language" -> "en", "paclet" -> "Geodesy Package", "status" -> "None", 
    "summary" -> 
    "SphericalDistance[pt_1, pt_2] gives the distance between points pt_1 and \
pt_2 on the Earth using a spherical model of the planet. ", "synonyms" -> {}, 
    "title" -> "SphericalDistance", "type" -> "Symbol", "uri" -> 
    "Geodesy/ref/SphericalDistance"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1297, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1920, 60, 54, 1, 70, "ObjectName",
 CellID->1008],
Cell[1977, 63, 872, 28, 70, "Usage",
 CellID->2436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2886, 96, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3364, 113, 344, 14, 70, "Notes",
 CellID->9983],
Cell[3711, 129, 570, 22, 70, "Notes",
 CellID->7191],
Cell[4284, 153, 142, 4, 70, "Notes",
 CellID->2984],
Cell[4429, 159, 70, 1, 70, "Notes",
 CellID->27158],
Cell[4502, 162, 82, 1, 70, "Notes",
 CellID->14938],
Cell[4587, 165, 67, 1, 70, "Notes",
 CellID->28174],
Cell[4657, 168, 392, 10, 70, "3ColumnTableMod",
 CellID->28643],
Cell[5052, 180, 302, 11, 70, "Notes",
 CellID->13379]
}, Closed]],
Cell[CellGroupData[{
Cell[5391, 196, 310, 9, 70, "SeeAlsoSection",
 CellID->4706],
Cell[5704, 207, 484, 17, 70, "SeeAlso",
 CellID->9988]
}, Open  ]],
Cell[CellGroupData[{
Cell[6225, 229, 314, 9, 70, "TutorialsSection",
 CellID->26488],
Cell[6542, 240, 141, 3, 70, "Tutorials",
 CellID->29453]
}, Open  ]],
Cell[6698, 246, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

