(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9505,        336]
NotebookOptionsPosition[      7312,        265]
NotebookOutlinePosition[      8421,        295]
CellTagsIndexPosition[      8378,        292]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GEODESY PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Geodesy Package" :> 
          Documentation`HelpLookup["paclet:Geodesy/tutorial/Geodesy"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Geodesy Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CountryData" :> 
          Documentation`HelpLookup["paclet:ref/CountryData"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"CountryData\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SpheroidalDistance", "ObjectName",
 CellID->26239],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SpheroidalDistance", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["pt", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["pt", "TI"], 
         StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the distance between points ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " on the Earth using the spheroidal model of the planet."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23380]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A point ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["pt", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is expressed as a pair of numbers ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["latitude", "TI"], ",", 
    StyleBox["longitude", "TI"]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26314],

Cell[TextData[{
 "Each coordinate ",
 Cell[BoxData[
  StyleBox["latitude", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["longitude", "TI"]], "InlineFormula"],
 " can be given in degrees, or as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["degrees", "TI"], ",", 
    StyleBox["minutes", "TI"]}], "}"}]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["degrees", "TI"], ",", 
    StyleBox["minutes", "TI"], ",", 
    StyleBox["seconds", "TI"]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6137],

Cell["\<\
A negative value for a coordinate indicates that the coordinate is South \
latitude or West longitude.\
\>", "Notes",
 CellID->5486],

Cell["Distances are returned in kilometers.", "Notes",
 CellID->1782],

Cell[TextData[{
 "Note that the model is an approximation formula that only employs machine \
precision computation. It is fairly accurate to distances of up to ",
 Cell[BoxData["10000"], "InlineFormula"],
 " kilometers on the standard model of the Earth."
}], "Notes",
 CellID->24020],

Cell["The following options can be given:", "Notes",
 CellID->23368],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SemimajorAxis",
     BaseStyle->"Link",
     ButtonData->"paclet:Geodesy/ref/SemimajorAxis"], "6378.14", Cell[
    "specify the length of the semi-major axis", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Eccentricity",
     BaseStyle->"Link",
     ButtonData->"paclet:Geodesy/ref/Eccentricity"], "0.081819", Cell[
    "specify the value of the eccentricity", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->3955],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SemimajorAxis",
    BaseStyle->"Link",
    ButtonData->"paclet:Geodesy/ref/SemimajorAxis"], "->", 
   StyleBox["length", "TI"]}]], "InlineFormula"],
 " the length of the semi-major axis in the spheroidal model is assumed to be \
",
 Cell[BoxData[
  StyleBox["length", "TI"]], "InlineFormula"],
 " kilometers."
}], "Notes",
 CellID->5447],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Eccentricity",
    BaseStyle->"Link",
    ButtonData->"paclet:Geodesy/ref/Eccentricity"], "->", 
   StyleBox["v", "TI"]}]], "InlineFormula"],
 " the eccentricity in the spheroidal model is assumed to be ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->25856]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13743],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["CountryData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CountryData"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->23418]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14762],

Cell[TextData[ButtonBox["Geodesy Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Geodesy/tutorial/Geodesy"]], "Tutorials",
 CellID->31194]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SpheroidalDistance - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 53.6787644}", "context" -> "Geodesy`", 
    "keywords" -> {}, "index" -> True, "label" -> "Geodesy Package Symbol", 
    "language" -> "en", "paclet" -> "Geodesy Package", "status" -> "None", 
    "summary" -> 
    "SpheroidalDistance[pt_1, pt_2] gives the distance between points pt_1 \
and pt_2 on the Earth using the spheroidal model of the planet.", 
    "synonyms" -> {}, "title" -> "SpheroidalDistance", "type" -> "Symbol", 
    "uri" -> "Geodesy/ref/SpheroidalDistance"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1151, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1774, 58, 56, 1, 70, "ObjectName",
 CellID->26239],
Cell[1833, 61, 876, 28, 70, "Usage",
 CellID->23380]
}, Open  ]],
Cell[CellGroupData[{
Cell[2746, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3224, 111, 345, 14, 70, "Notes",
 CellID->26314],
Cell[3572, 127, 570, 22, 70, "Notes",
 CellID->6137],
Cell[4145, 151, 142, 4, 70, "Notes",
 CellID->5486],
Cell[4290, 157, 69, 1, 70, "Notes",
 CellID->1782],
Cell[4362, 160, 285, 6, 70, "Notes",
 CellID->24020],
Cell[4650, 168, 68, 1, 70, "Notes",
 CellID->23368],
Cell[4721, 171, 706, 17, 70, "3ColumnTableMod",
 CellID->3955],
Cell[5430, 190, 415, 14, 70, "Notes",
 CellID->5447],
Cell[5848, 206, 374, 13, 70, "Notes",
 CellID->25856]
}, Closed]],
Cell[CellGroupData[{
Cell[6259, 224, 311, 9, 70, "SeeAlsoSection",
 CellID->13743],
Cell[6573, 235, 202, 6, 70, "SeeAlso",
 CellID->23418]
}, Open  ]],
Cell[CellGroupData[{
Cell[6812, 246, 314, 9, 70, "TutorialsSection",
 CellID->14762],
Cell[7129, 257, 141, 3, 70, "Tutorials",
 CellID->31194]
}, Open  ]],
Cell[7285, 263, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

