(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6637,        229]
NotebookOptionsPosition[      4811,        172]
NotebookOutlinePosition[      5943,        202]
CellTagsIndexPosition[      5900,        199]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GEODESY PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Geodesy Package" :> 
          Documentation`HelpLookup["paclet:Geodesy/tutorial/Geodesy"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Geodesy Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GeodeticToAuthalic" :> 
          Documentation`HelpLookup["paclet:Geodesy/ref/GeodeticToAuthalic"], 
          "CountryData" :> 
          Documentation`HelpLookup["paclet:ref/CountryData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GeodeticToAuthalic\"\>", 
       2->"\<\"CountryData\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToAuthalicRadius", "ObjectName",
 CellID->1951],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ToAuthalicRadius", "[", 
       RowBox[{
        StyleBox["semimajor", "TI"], ",", 
        StyleBox["eccentricity", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the radius of the authalic sphere based on the \
spheroid with semi-major axis ",
     Cell[BoxData[
      StyleBox["semimajor", "TI"]], "InlineFormula"],
     " and eccentricity ",
     Cell[BoxData[
      StyleBox["eccentricity", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23619]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The simplest way to convert from a spheroid to a sphere is to use the \
authalic sphere.\
\>", "Notes",
 CellID->31147],

Cell["\<\
The authalic sphere has the same surface area as the reference spheroid.\
\>", "Notes",
 CellID->22117]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4838],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeodeticToAuthalic",
    BaseStyle->"Link",
    ButtonData->"paclet:Geodesy/ref/GeodeticToAuthalic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CountryData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CountryData"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3650]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19603],

Cell[TextData[ButtonBox["Geodesy Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Geodesy/tutorial/Geodesy"]], "Tutorials",
 CellID->867]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToAuthalicRadius - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 53.8506438}", "context" -> "Geodesy`", 
    "keywords" -> {}, "index" -> True, "label" -> "Geodesy Package Symbol", 
    "language" -> "en", "paclet" -> "Geodesy Package", "status" -> "None", 
    "summary" -> 
    "ToAuthalicRadius[semimajor, eccentricity] gives the radius of the \
authalic sphere based on the spheroid with semi-major axis semimajor and \
eccentricity eccentricity.", "synonyms" -> {}, "title" -> "ToAuthalicRadius", 
    "type" -> "Symbol", "uri" -> "Geodesy/ref/ToAuthalicRadius"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1297, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1920, 60, 53, 1, 70, "ObjectName",
 CellID->1951],
Cell[1976, 63, 706, 21, 70, "Usage",
 CellID->23619]
}, Open  ]],
Cell[CellGroupData[{
Cell[2719, 89, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3197, 106, 129, 4, 70, "Notes",
 CellID->31147],
Cell[3329, 112, 113, 3, 70, "Notes",
 CellID->22117]
}, Closed]],
Cell[CellGroupData[{
Cell[3479, 120, 310, 9, 70, "SeeAlsoSection",
 CellID->4838],
Cell[3792, 131, 484, 17, 70, "SeeAlso",
 CellID->3650]
}, Open  ]],
Cell[CellGroupData[{
Cell[4313, 153, 314, 9, 70, "TutorialsSection",
 CellID->19603],
Cell[4630, 164, 139, 3, 70, "Tutorials",
 CellID->867]
}, Open  ]],
Cell[4784, 170, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

