(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7706,        275]
NotebookOptionsPosition[      5877,        218]
NotebookOutlinePosition[      7005,        248]
CellTagsIndexPosition[      6962,        245]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GEODESY PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Geodesy Package" :> 
          Documentation`HelpLookup["paclet:Geodesy/tutorial/Geodesy"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Geodesy Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ToDMS" :> Documentation`HelpLookup["paclet:Geodesy/ref/ToDMS"],
           "CountryData" :> 
          Documentation`HelpLookup["paclet:ref/CountryData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ToDMS\"\>", 
       2->"\<\"CountryData\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToDegrees", "ObjectName",
 CellID->10848],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ToDegrees", "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["degrees", "TI"], ",", 
         StyleBox["minutes", "TI"], ",", 
         StyleBox["seconds", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]converts a coordinate in degree-minute-second format \
to degrees."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ToDegrees", "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["degrees", "TI"], ",", 
         StyleBox["minutes", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]converts from degrees-minutes format to degrees."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->32392]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The coordinates are adjusted to stay within ",
 Cell[BoxData[
  RowBox[{"[", 
   RowBox[{
    RowBox[{"-", 
     StyleBox["180", "TR"]}], ",", 
    StyleBox["180", "TR"]}], "]"}]], "InlineFormula"],
 " degrees."
}], "Notes",
 CellID->26327],

Cell[TextData[{
 "Note that the sign of ",
 Cell[BoxData[
  StyleBox["degrees", "TI"]], "InlineFormula"],
 " is enforced on ",
 Cell[BoxData[
  StyleBox["minutes", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["seconds", "TI"]], "InlineFormula"],
 "; so ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", 
     StyleBox["34", "TI"]}], ",", 
    StyleBox["3", "TI"], ",", 
    StyleBox["2", "TI"]}], "}"}]], "InlineFormula"],
 " means ",
 Cell[BoxData[
  StyleBox["34", "TR"]], "InlineFormula"],
 " degrees, ",
 Cell[BoxData[
  StyleBox["3", "TR"]], "InlineFormula"],
 " minutes, and ",
 Cell[BoxData[
  StyleBox["2", "TR"]], "InlineFormula"],
 " seconds W (or S), as does ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", 
     StyleBox["34", "TI"]}], ",", 
    RowBox[{"-", 
     StyleBox["3", "TI"]}], ",", 
    RowBox[{"-", 
     StyleBox["2", "TI"]}]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->30790]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28928],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToDMS",
    BaseStyle->"Link",
    ButtonData->"paclet:Geodesy/ref/ToDMS"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CountryData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CountryData"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22725]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15058],

Cell[TextData[ButtonBox["Geodesy Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Geodesy/tutorial/Geodesy"]], "Tutorials",
 CellID->19666]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToDegrees - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 58.3663844}", "context" -> "Geodesy`", 
    "keywords" -> {}, "index" -> True, "label" -> "Geodesy Package Symbol", 
    "language" -> "en", "paclet" -> "Geodesy Package", "status" -> "None", 
    "summary" -> 
    "ToDegrees[{degrees, minutes, seconds}] converts a coordinate in \
degree-minute-second format to degrees. ToDegrees[{degrees, minutes}] \
converts from degrees-minutes format to degrees.", "synonyms" -> {}, "title" -> 
    "ToDegrees", "type" -> "Symbol", "uri" -> "Geodesy/ref/ToDegrees"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1247, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1870, 59, 47, 1, 70, "ObjectName",
 CellID->10848],
Cell[1920, 62, 876, 26, 70, "Usage",
 CellID->32392]
}, Open  ]],
Cell[CellGroupData[{
Cell[2833, 93, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3311, 110, 258, 10, 70, "Notes",
 CellID->26327],
Cell[3572, 122, 958, 39, 70, "Notes",
 CellID->30790]
}, Closed]],
Cell[CellGroupData[{
Cell[4567, 166, 311, 9, 70, "SeeAlsoSection",
 CellID->28928],
Cell[4881, 177, 459, 17, 70, "SeeAlso",
 CellID->22725]
}, Open  ]],
Cell[CellGroupData[{
Cell[5377, 199, 314, 9, 70, "TutorialsSection",
 CellID->15058],
Cell[5694, 210, 141, 3, 70, "Tutorials",
 CellID->19666]
}, Open  ]],
Cell[5850, 216, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

