(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15814,        512]
NotebookOptionsPosition[     12188,        403]
NotebookOutlinePosition[     14114,        448]
CellTagsIndexPosition[     14071,        445]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GEODESY PACKAGE TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Eccentricity" :> 
         Documentation`HelpLookup["paclet:Geodesy/ref/Eccentricity"], 
         "GeodeticToAuthalic" :> 
         Documentation`HelpLookup["paclet:Geodesy/ref/GeodeticToAuthalic"], 
         "SemimajorAxis" :> 
         Documentation`HelpLookup["paclet:Geodesy/ref/SemimajorAxis"], 
         "SphericalDistance" :> 
         Documentation`HelpLookup["paclet:Geodesy/ref/SphericalDistance"], 
         "SpheroidalDistance" :> 
         Documentation`HelpLookup["paclet:Geodesy/ref/SpheroidalDistance"], 
         "ToAuthalicRadius" :> 
         Documentation`HelpLookup["paclet:Geodesy/ref/ToAuthalicRadius"], 
         "ToDegrees" :> 
         Documentation`HelpLookup["paclet:Geodesy/ref/ToDegrees"], "ToDMS" :> 
         Documentation`HelpLookup["paclet:Geodesy/ref/ToDMS"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Eccentricity\"\>", 
      2->"\<\"GeodeticToAuthalic\"\>", 3->"\<\"SemimajorAxis\"\>", 
      4->"\<\"SphericalDistance\"\>", 5->"\<\"SpheroidalDistance\"\>", 
      6->"\<\"ToAuthalicRadius\"\>", 7->"\<\"ToDegrees\"\>", 
      8->"\<\"ToDMS\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Geodesy Package", "Title",
 CellID->2305],

Cell["\<\
Geodesy is the branch of science that deals with such topics as determining \
positions and areas over large parts of the Earth, the shape and size of the \
Earth, and the variations in the Earth\[CloseCurlyQuote]s gravitational and \
magnetic fields. The primary functions in this package are used for \
determining the distance between two points. \
\>", "Text",
 CellID->8548],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SphericalDistance",
      BaseStyle->"Link",
      ButtonData->"paclet:Geodesy/ref/SphericalDistance"], "[", 
     SubscriptBox[
      StyleBox["pos", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["pos", "TI"], "2"], "]"}], Cell[TextData[{
     "calculate the distance between the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pos", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " using a spherical model"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SpheroidalDistance",
      BaseStyle->"Link",
      ButtonData->"paclet:Geodesy/ref/SpheroidalDistance"], "[", 
     SubscriptBox[
      StyleBox["pos", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["pos", "TI"], "2"], "]"}], Cell[TextData[{
     "calculate the distance between the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pos", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " using a spheroidal model"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->2192],

Cell["Finding the distance between two points on a sphere. ", "Caption",
 CellID->24702],

Cell[TextData[{
 "Each position can be given in degrees as a latitude\[Hyphen]longitude pair. \
A coordinate can also be expressed in the form ",
 StyleBox["{", "MR"],
 StyleBox["degrees", "TI"],
 StyleBox[",", "MR"],
 " ",
 StyleBox["minutes", "TI"],
 StyleBox[",", "MR"],
 " ",
 StyleBox["seconds", "TI"],
 StyleBox["}", "MR"],
 ". A negative value for a coordinate indicates that the coordinate is South \
latitude or West longitude. Distances are returned in kilometers as the \
default. "
}], "Text",
 CellID->5393],

Cell["This loads the package. ", "MathCaption",
 CellID->21556],

Cell[BoxData[
 RowBox[{"<<", "Geodesy`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2660],

Cell[TextData[{
 "This gives the distance between ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula"],
 " lat., ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula"],
 " long., and ",
 Cell[BoxData[
  FormBox["45", TraditionalForm]], "InlineFormula"],
 " N. lat., ",
 Cell[BoxData[
  FormBox["45", TraditionalForm]], "InlineFormula"],
 " E. long., using a spherical model. "
}], "MathCaption",
 CellID->11897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"SphericalDistance", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"45", ",", "45"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18942],

Cell[BoxData["6671.702929056382`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->222076760]
}, Open  ]],

Cell["\<\
Here is the distance between the same points using a spheroidal model. \
\>", "MathCaption",
 CellID->15420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"SpheroidalDistance", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"45", ",", "45"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->23054],

Cell[BoxData["6662.472787675837`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->212430910]
}, Open  ]],

Cell["This is the difference between the two models. ", "MathCaption",
 CellID->16935],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "-", "%%"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->29817],

Cell[BoxData[
 RowBox[{"-", "9.23014138054532`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->369540028]
}, Open  ]],

Cell[TextData[{
 "The spherical model is based on an exact formula, while the spheroidal \
model is an approximation algorithm that is fairly good for distances of less \
than 10,000 kilometers. Because of the nature of this approximation, all \
computation with ",
 Cell[BoxData[
  ButtonBox["SpheroidalDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:Geodesy/ref/SpheroidalDistance"]], "InlineFormula"],
 " is done with machine\[Hyphen]precision numbers. "
}], "Text",
 CellID->1789],

Cell[BoxData[GridBox[{
   {
    RowBox[{"Radius", "\[Rule]", 
     StyleBox["radius", "TI"]}], Cell[
    "specify the radius of the sphere in the spherical model", "TableText"]},
   {
    RowBox[{
     ButtonBox["SemimajorAxis",
      BaseStyle->"Link",
      ButtonData->"paclet:Geodesy/ref/SemimajorAxis"], "\[Rule]", 
     StyleBox["length", "TI"]}], Cell["\<\
specify the length of the semimajor axis in the spheroidal model\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Eccentricity",
      BaseStyle->"Link",
      ButtonData->"paclet:Geodesy/ref/Eccentricity"], "\[Rule]", 
     StyleBox["value", "TI"]}], Cell["\<\
specify the value of the eccentricity in the spheroidal model\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->18801],

Cell["Options to control the size of the shape in the models. ", "Caption",
 CellID->16229],

Cell[TextData[{
 "The distances between points can be modified by using different values for \
the radius of the sphere, or the length of the semimajor axis and the \
eccentricity of the spheroid using the options ",
 StyleBox["Radius", "MR"],
 ", ",
 Cell[BoxData[
  ButtonBox["SemimajorAxis",
   BaseStyle->"Link",
   ButtonData->"paclet:Geodesy/ref/SemimajorAxis"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Eccentricity",
   BaseStyle->"Link",
   ButtonData->"paclet:Geodesy/ref/Eccentricity"]], "InlineFormula"],
 ", respectively. The default values for these options are those for the \
Earth from the WGS\[Hyphen]84 standard, in kilometers. "
}], "Text",
 CellID->28682],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ToAuthalicRadius",
      BaseStyle->"Link",
      ButtonData->"paclet:Geodesy/ref/ToAuthalicRadius"], "[", 
     StyleBox["semimajor", "TI"], ",", 
     StyleBox["eccentricity", "TI"], "]"}], Cell["\<\
compute radius of authalic sphere given spheroid\[CloseCurlyQuote]s semimajor \
axis and eccentricity\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["GeodeticToAuthalic",
      BaseStyle->"Link",
      ButtonData->"paclet:Geodesy/ref/GeodeticToAuthalic"], "[", "{", 
     StyleBox["lat", "TI"], ",", 
     StyleBox["long", "TI"], "}", ",", 
     StyleBox["eccentricity", "TI"], "]"}], Cell["\<\
compute coordinates of corresponding point on authalic sphere given latitude \
and longitude of point on spheroid with specified eccentricity\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["ToDegrees",
      BaseStyle->"Link",
      ButtonData->"paclet:Geodesy/ref/ToDegrees"], "[", "{", 
     StyleBox["deg", "TI"], ",", 
     StyleBox["min", "TI"], ",", 
     StyleBox["sec", "TI"], "}", "]"}], Cell["\<\
convert coordinate in degree\[Hyphen]minute\[Hyphen]second format to degrees\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["ToDMS",
      BaseStyle->"Link",
      ButtonData->"paclet:Geodesy/ref/ToDMS"], "[", 
     StyleBox["deg", "TI"], "]"}], Cell["\<\
convert coordinate in degrees to degree\[Hyphen]minute\[Hyphen]second format\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, True, {False}, False}, 
   "RowsIndexed" -> {}}},
 CellID->1867],

Cell["Conversions between models and coordinate systems. ", "Caption",
 CellID->25580],

Cell["\<\
The simplest way to convert to the sphere from the spheroid is to use the \
authalic sphere. This sphere has the same surface area as the reference \
spheroid. \
\>", "Text",
 CellID->19725],

Cell["\<\
Here is a comparison of the two shapes, with an ellipse whose eccentricity is \
much larger than the Earth, for effect. \
\>", "MathCaption",
 CellID->8717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"ToAuthalicRadius", "[", 
        RowBox[{"1", ",", ".6"}], "]"}]}], "]"}], ",", 
     RowBox[{"Dashing", "[", 
      RowBox[{"{", ".03", "}"}], "]"}], ",", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"1", "-", 
           RowBox[{
            RowBox[{"(", ".6", ")"}], "^", "2"}]}], "]"}]}], "}"}]}], "]"}]}],
     "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->2453],

Cell[BoxData[
 GraphicsBox[{CircleBox[{0, 0}, 0.93257], 
   {Dashing[{0.03}], CircleBox[{0, 0}, {1., 0.8}]}},
  AspectRatio->Automatic,
  ImageMargins->0.,
  ImageSize->Medium]], "Output",
 ImageSize->{364, 336},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->305620356]
}, Open  ]],

Cell["\<\
Note that the eccentricity used in the above diagram was .6. The actual \
eccentricity of the Earth\[CloseCurlyQuote]s spheroid is approximately .081. \
\
\>", "Text",
 CellID->5930]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Geodesy Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 58.6945178}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Geodesy Package Tutorial", 
    "language" -> "en", "paclet" -> "Geodesy Package", "status" -> "None", 
    "summary" -> 
    "Geodesy is the branch of science that deals with such topics as \
determining positions and areas over large parts of the Earth, the shape and \
size of the Earth, and the variations in the Earth's gravitational and \
magnetic fields. The primary functions in this package are used for \
determining the distance between two points. Finding the distance between two \
points on a sphere. Each position can be given in degrees as a \
latitude-longitude pair. A coordinate can also be expressed in the form \
{degrees, minutes, seconds}. A negative value for a coordinate indicates that \
the coordinate is South latitude or West longitude. Distances are returned in \
kilometers as the default. ", "synonyms" -> {}, "title" -> "Geodesy Package", 
    "type" -> "Tutorial", "uri" -> "Geodesy/tutorial/Geodesy"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1513, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2138, 58, 47, 1, 70, "Title",
 CellID->2305],
Cell[2188, 61, 389, 7, 70, "Text",
 CellID->8548],
Cell[2580, 70, 1196, 38, 70, "DefinitionBox",
 CellID->2192],
Cell[3779, 110, 88, 1, 70, "Caption",
 CellID->24702],
Cell[3870, 113, 520, 16, 70, "Text",
 CellID->5393],
Cell[4393, 131, 63, 1, 70, "MathCaption",
 CellID->21556],
Cell[4459, 134, 90, 3, 70, "Input",
 CellID->2660],
Cell[4552, 139, 441, 15, 70, "MathCaption",
 CellID->11897],
Cell[CellGroupData[{
Cell[5018, 158, 265, 9, 28, "Input",
 CellID->18942],
Cell[5286, 169, 175, 5, 36, "Output",
 CellID->222076760]
}, Open  ]],
Cell[5476, 177, 118, 3, 70, "MathCaption",
 CellID->15420],
Cell[CellGroupData[{
Cell[5619, 184, 266, 9, 70, "Input",
 CellID->23054],
Cell[5888, 195, 175, 5, 36, "Output",
 CellID->212430910]
}, Open  ]],
Cell[6078, 203, 86, 1, 70, "MathCaption",
 CellID->16935],
Cell[CellGroupData[{
Cell[6189, 208, 89, 3, 70, "Input",
 CellID->29817],
Cell[6281, 213, 191, 6, 36, "Output",
 CellID->369540028]
}, Open  ]],
Cell[6487, 222, 492, 11, 70, "Text",
 CellID->1789],
Cell[6982, 235, 890, 26, 70, "DefinitionBox",
 CellID->18801],
Cell[7875, 263, 91, 1, 70, "Caption",
 CellID->16229],
Cell[7969, 266, 693, 18, 70, "Text",
 CellID->28682],
Cell[8665, 286, 1655, 46, 70, "DefinitionBox",
 CellID->1867],
Cell[10323, 334, 86, 1, 70, "Caption",
 CellID->25580],
Cell[10412, 337, 200, 5, 70, "Text",
 CellID->19725],
Cell[10615, 344, 166, 4, 70, "MathCaption",
 CellID->8717],
Cell[CellGroupData[{
Cell[10806, 352, 810, 26, 70, "Input",
 CellID->2453],
Cell[11619, 380, 320, 10, 357, "Output",
 CellID->305620356]
}, Open  ]],
Cell[11954, 393, 192, 5, 70, "Text",
 CellID->5930]
}, Open  ]],
Cell[12161, 401, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

