(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8752,        287]
NotebookOptionsPosition[      6767,        224]
NotebookOutlinePosition[      7884,        254]
CellTagsIndexPosition[      7841,        251]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PseudoDiameter" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/PseudoDiameter"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"PseudoDiameter\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Aggressive", "ObjectName",
 CellID->21320],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Aggressive"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["PseudoDiameter",
       BaseStyle->"Link",
       ButtonData->"paclet:GraphUtilities/ref/PseudoDiameter"]], 
      "InlineFormula"],
     " that specifies whether an extra iteration is to be carried out."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10873]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A graph geodesic is a shortest path between two vertices of a graph. The \
graph diameter is the longest possible length of all graph geodesics of the \
graph. ",
 Cell[BoxData[
  RowBox[{" ", 
   ButtonBox["PseudoDiameter",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/PseudoDiameter"]}]], 
  "InlineFormula"],
 " finds an approximate graph diameter. It works by starting from a vertex ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 ", and finds a vertex ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " that is farthest away from ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 ". This process is repeated by treating ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " as the new starting vertex, and ends when the graph distance no longer \
increases. A vertex from the last level set that has the smallest degree is \
chosen as the final starting vertex ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 ", and a traversal is done to see if the graph distance can be increased. \
This graph distance is taken to be the pseudo diameter."
}], "Notes",
 CellID->52933267],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"Aggressive", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", a traversal is carried out from each vertex in the last level set. This \
can given larger pseudo diameter on occasions."
}], "Notes",
 CellID->14087]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10649],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["PseudoDiameter",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/PseudoDiameter"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->10308]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24292],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->3328]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->1297301311],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Aggressive - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 59.3820354}", "context" -> 
    "GraphUtilities`", "keywords" -> {"graph diameter graph geodesic"}, 
    "index" -> True, "label" -> "Graph Utilities Package Symbol", "language" -> 
    "en", "paclet" -> "GraphUtilities Package", "status" -> "None", "summary" -> 
    "Aggressive is an option to PseudoDiameter that specifies whether an \
extra iteration is to be carried out.", "synonyms" -> {}, "title" -> 
    "Aggressive", "type" -> "Symbol", "uri" -> 
    "GraphUtilities/ref/Aggressive"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1837, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2460, 75, 48, 1, 70, "ObjectName",
 CellID->21320],
Cell[2511, 78, 558, 16, 70, "Usage",
 CellID->10873]
}, Open  ]],
Cell[CellGroupData[{
Cell[3106, 99, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3584, 116, 1175, 30, 70, "Notes",
 CellID->52933267],
Cell[4762, 148, 339, 10, 70, "Notes",
 CellID->14087]
}, Closed]],
Cell[CellGroupData[{
Cell[5138, 163, 311, 9, 70, "SeeAlsoSection",
 CellID->10649],
Cell[5452, 174, 223, 6, 70, "SeeAlso",
 CellID->10308]
}, Open  ]],
Cell[CellGroupData[{
Cell[5712, 185, 314, 9, 70, "TutorialsSection",
 CellID->24292],
Cell[6029, 196, 162, 3, 70, "Tutorials",
 CellID->3328]
}, Open  ]],
Cell[CellGroupData[{
Cell[6228, 204, 320, 9, 70, "MoreAboutSection",
 CellID->1297301311],
Cell[6551, 215, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[6740, 222, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

