(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23231,        767]
NotebookOptionsPosition[     18698,        609]
NotebookOutlinePosition[     20097,        650]
CellTagsIndexPosition[     19988,        644]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StrongComponents" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/StrongComponents"], "WeakComponents" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/WeakComponents"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"StrongComponents\"\>", 
       2->"\<\"WeakComponents\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Bicomponents", "ObjectName",
 CellID->30452],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Bicomponents", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the biconnected components of the undirected \
graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18470]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A biconnected component is a maximal subgraph that has no cutpoint, where a \
cutpoint is a vertex ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " such that the subgraph becomes disconnected if ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " and all its edges are removed."
}], "Notes",
 CellID->11549],

Cell[TextData[{
 Cell[BoxData["Bicomponents"], "InlineFormula"],
 " treats the input ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " as an undirected graph."
}], "Notes",
 CellID->1615408077]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->513646512],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->137883173],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->2064817],

Cell["\<\
This shows that a simple line with two vertices is biconnected:\
\>", "ExampleText",
 CellTags->"b:0.9",
 CellID->1764493809],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{"1", "\[Rule]", "2"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->260696594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->18467],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAFiEQkGIPs/kAXG
W/7/B9IQkgtEMn95XP3hZgwQMXCDCOaPt+J+vt8FkqoDy/98PxcoBJLiAct/
edz5HwwYOJFM+fai/eeHRf//n2HgBhEQ/iEkUz4sAgoh5MH8WSAprhFiChOQ
YAFGASsB05iBBDNcHSFTmcEEKGaBNBGmsyCpR/AJ2YJdF1D+4oKi/fX1DHUg
gmJbWNF0MdPXFqqGGBNYKUIXrWIG5HomoCY2IlIVQt1QyjcDb8rXZ60fbiCX
kDdjf308jjDl18elQCGEPFDx12czEKZASlsGRgDXrYKD\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->457492111]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Bicomponents", "[", "g", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->26500],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2"}], "}"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1609729604]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->48386895],

Cell["This defines a small graph:", "ExampleText",
 CellID->11942],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "15"}], ",", 
     RowBox[{"15", "\[Rule]", "7"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}], ",", 
     RowBox[{"8", "\[Rule]", "9"}], ",", 
     RowBox[{"9", "\[Rule]", "10"}], ",", 
     RowBox[{"10", "\[Rule]", "11"}], ",", 
     RowBox[{"11", "\[Rule]", "12"}], ",", 
     RowBox[{"12", "\[Rule]", "7"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1860757518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->4827],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{400, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->71534150]
}, Open  ]],

Cell["\<\
The graph has four bicomponents, one for each cycle and two for the line \
joining the cycles:\
\>", "ExampleText",
 CellID->3902],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Bicomponents", "[", "g", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1732636812],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"9", ",", "8", ",", "10", ",", "11", ",", "12", ",", "7"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "4", ",", "5", ",", "6", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{389, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->284160089]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12202],

Cell["This defines a graph:", "ExampleText",
 CellID->19190672],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->849252474],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "5"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1529801329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->122927460],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.2738142740300609`, -1.2449048105258724`}, {
    0.27442115038368076`, -1.2709675853024325`}, {
    0.2451515744442991, -0.2715827434517266}, {
    1.2450901376681767`, -0.24515157444429914`}, {
    0.7420776589714069, -1.7612707341910308`}, {
    1.2451452470652749`, -2.6255179175226555`}, {
    0.24515157444429905`, -2.629063542234945}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 1}, {5, 6}, {6, 7}, {7, 5}}]}, {
      InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.2738142740300609`, -1.2449048105258724`}, {
     0.27442115038368076`, -1.2709675853024325`}, {
     0.2451515744442991, -0.2715827434517266}, {
     1.2450901376681767`, -0.24515157444429914`}, {
     0.7420776589714069, -1.7612707341910308`}, {
     1.2451452470652749`, -2.6255179175226555`}, {
     0.24515157444429905`, -2.629063542234945}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{98, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2011880467]
}, Open  ]],

Cell["\<\
This shows its biconnected components and connected components:\
\>", "ExampleText",
 CellID->1232485228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Bicomponents", "[", "g", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1406473664],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7", ",", "5"}], "}"}]}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1741162968]
}, Open  ]],

Cell[TextData[{
 "The result from ",
 Cell[BoxData[
  ButtonBox["WeakComponents",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/WeakComponents"]], 
  "InlineFormula"],
 " is always smaller than that of ",
 Cell[BoxData["Bicomponents"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->555095459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeakComponents", "[", "g", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->727630043],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "7"}], "}"}]}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1140102488]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2722],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StrongComponents",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/StrongComponents"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WeakComponents",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/WeakComponents"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->221416186]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26756],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->23452]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->8954624],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Bicomponents - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 59.5851656}", "context" -> 
    "GraphUtilities`", "keywords" -> {"connected components"}, "index" -> 
    True, "label" -> "Graph Utilities Package Symbol", "language" -> "en", 
    "paclet" -> "GraphUtilities Package", "status" -> "None", "summary" -> 
    "Bicomponents[g] gives the biconnected components of the undirected graph \
g.", "synonyms" -> {}, "title" -> "Bicomponents", "type" -> "Symbol", "uri" -> 
    "GraphUtilities/ref/Bicomponents"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4272, 143, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->513646512]},
 "b:0.9"->{
  Cell[4948, 170, 135, 4, 70, "ExampleText",
   CellTags->"b:0.9",
   CellID->1764493809]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19741, 633},
 {"b:0.9", 19873, 637}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1993, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2616, 78, 50, 1, 70, "ObjectName",
 CellID->30452],
Cell[2669, 81, 492, 16, 70, "Usage",
 CellID->18470]
}, Open  ]],
Cell[CellGroupData[{
Cell[3198, 102, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3676, 119, 350, 10, 70, "Notes",
 CellID->11549],
Cell[4029, 131, 206, 7, 70, "Notes",
 CellID->1615408077]
}, Closed]],
Cell[CellGroupData[{
Cell[4272, 143, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->513646512],
Cell[CellGroupData[{
Cell[4657, 157, 148, 5, 70, "ExampleSection",
 CellID->137883173],
Cell[4808, 164, 137, 4, 70, "Input",
 CellID->2064817],
Cell[4948, 170, 135, 4, 70, "ExampleText",
 CellTags->"b:0.9",
 CellID->1764493809],
Cell[5086, 176, 165, 6, 70, "Input",
 CellID->260696594],
Cell[CellGroupData[{
Cell[5276, 186, 170, 5, 28, "Input",
 CellID->18467],
Cell[5449, 193, 561, 13, 41, "Output",
 Evaluatable->False,
 CellID->457492111]
}, Open  ]],
Cell[CellGroupData[{
Cell[6047, 211, 104, 3, 70, "Input",
 CellID->26500],
Cell[6154, 216, 228, 8, 36, "Output",
 CellID->1609729604]
}, Open  ]],
Cell[6397, 227, 118, 3, 70, "ExampleDelimiter",
 CellID->41],
Cell[6518, 232, 138, 4, 70, "Input",
 CellID->48386895],
Cell[6659, 238, 66, 1, 70, "ExampleText",
 CellID->11942],
Cell[6728, 241, 736, 20, 70, "Input",
 CellID->1860757518],
Cell[CellGroupData[{
Cell[7489, 265, 169, 5, 28, "Input",
 CellID->4827],
Cell[7661, 272, 3488, 61, 89, "Output",
 Evaluatable->False,
 CellID->71534150]
}, Open  ]],
Cell[11164, 336, 140, 4, 70, "ExampleText",
 CellID->3902],
Cell[CellGroupData[{
Cell[11329, 344, 109, 3, 70, "Input",
 CellID->1732636812],
Cell[11441, 349, 512, 17, 36, "Output",
 CellID->284160089]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12002, 372, 233, 7, 70, "ExampleSection",
 CellID->12202],
Cell[12238, 381, 63, 1, 70, "ExampleText",
 CellID->19190672],
Cell[12304, 384, 139, 4, 70, "Input",
 CellID->849252474],
Cell[12446, 390, 434, 13, 70, "Input",
 CellID->1529801329],
Cell[CellGroupData[{
Cell[12905, 407, 174, 5, 70, "Input",
 CellID->122927460],
Cell[13082, 414, 2238, 56, 237, "Output",
 CellID->2011880467]
}, Open  ]],
Cell[15335, 473, 115, 3, 70, "ExampleText",
 CellID->1232485228],
Cell[CellGroupData[{
Cell[15475, 480, 109, 3, 70, "Input",
 CellID->1406473664],
Cell[15587, 485, 333, 11, 36, "Output",
 CellID->1741162968]
}, Open  ]],
Cell[15935, 499, 315, 11, 70, "ExampleText",
 CellID->555095459],
Cell[CellGroupData[{
Cell[16275, 514, 110, 3, 70, "Input",
 CellID->727630043],
Cell[16388, 519, 333, 11, 36, "Output",
 CellID->1140102488]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16782, 537, 310, 9, 70, "SeeAlsoSection",
 CellID->2722],
Cell[17095, 548, 513, 17, 70, "SeeAlso",
 CellID->221416186]
}, Open  ]],
Cell[CellGroupData[{
Cell[17645, 570, 314, 9, 70, "TutorialsSection",
 CellID->26756],
Cell[17962, 581, 163, 3, 70, "Tutorials",
 CellID->23452]
}, Open  ]],
Cell[CellGroupData[{
Cell[18162, 589, 317, 9, 70, "MoreAboutSection",
 CellID->8954624],
Cell[18482, 600, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[18671, 607, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

