(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34938,       1084]
NotebookOptionsPosition[     29302,        889]
NotebookOutlinePosition[     30607,        926]
CellTagsIndexPosition[     30522,        921]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PageRanks" :> 
          Documentation`HelpLookup["paclet:GraphUtilities/ref/PageRanks"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"PageRanks\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ClosenessCentrality", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ClosenessCentrality", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]finds the closeness centrality."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The closeness centrality of a vertex ",
 StyleBox["u", "TI"],
 " is defined as the inverse of the sum of the distance from ",
 StyleBox["u", "TI"],
 " to all other vertices. The closeness centrality of a vertex in a \
disconnected graph is based on the closeness centrality of the component \
where this vertex belongs."
}], "Notes",
 CellID->1496149871],

Cell["The following options can be given:", "Notes",
 CellID->1067943069],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Weighted",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/Weighted"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether edge weight is to be used in calculating distance", 
     "TableText"]},
   {" ", 
    ButtonBox["Normalize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Normalize"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], 
    StyleBox[
     RowBox[{
     "whether", " ", "to", " ", "normalize", " ", "the", " ", "output"}],
     FontFamily->"Verdana",
     FontSize->10]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->270562]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->186332360],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->333118727],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->36355221],

Cell["This defines a small graph:", "ExampleText",
 CellID->1172741669],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1528823234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1934494070],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.811567349479424, -2.492483805489247}, {
    1.314634937573292, -3.3567309888208716`}, {
    0.31464126495231615`, -3.360276613533161}, {
    1.6039665298594217`, -0.31464126495231626`}, {
    1.9323950128921872`, -1.2588567715091448`}, {
    1.135785817361242, -1.8632012755846146`}, {
    0.31464126495231626`, -1.2928360462470445`}, {
    0.6033246963890936, -0.3356982030966429}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.02875633311779315, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{2, 3}], ArrowBox[{3, 1}], ArrowBox[{4, 5}], 
      ArrowBox[{5, 6}], ArrowBox[{6, 7}], ArrowBox[{7, 8}], 
      ArrowBox[{8, 4}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["8",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.811567349479424, -2.492483805489247}, {
     1.314634937573292, -3.3567309888208716`}, {
     0.31464126495231615`, -3.360276613533161}, {
     1.6039665298594217`, -0.31464126495231626`}, {
     1.9323950128921872`, -1.2588567715091448`}, {
     1.135785817361242, -1.8632012755846146`}, {
     0.31464126495231626`, -1.2928360462470445`}, {
     0.6033246963890936, -0.3356982030966429}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{161., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{165, 302},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1730351361]
}, Open  ]],

Cell["\<\
This shows that vertex 2, being at the center of this graph, has a higher \
closeness centrality:\
\>", "ExampleText",
 CellID->1449356200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"VertexList", "[", "g", "]"}], "->", 
   RowBox[{"ClosenessCentrality", "[", "g", "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->897077387],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "0.3333333333333333`"}], ",", 
   RowBox[{"2", "\[Rule]", "0.3333333333333333`"}], ",", 
   RowBox[{"3", "\[Rule]", "0.3333333333333333`"}], ",", 
   RowBox[{"4", "\[Rule]", "0.1`"}], ",", 
   RowBox[{"5", "\[Rule]", "0.1`"}], ",", 
   RowBox[{"6", "\[Rule]", "0.1`"}], ",", 
   RowBox[{"7", "\[Rule]", "0.1`"}], ",", 
   RowBox[{"8", "\[Rule]", "0.1`"}]}], "}"}]], "Output",
 ImageSize->{554, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1149419484]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1145097784],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->2057494921],

Cell["\<\
This defines a disconnected graph and finds the closeness centrality:\
\>", "ExampleText",
 CellID->114230516],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}], ",", 
     RowBox[{"8", "\[Rule]", "4"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->331498499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->898556548],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.811567349479424, -2.492483805489247}, {
    1.314634937573292, -3.3567309888208716`}, {
    0.31464126495231615`, -3.360276613533161}, {
    1.6039665298594217`, -0.31464126495231626`}, {
    1.9323950128921872`, -1.2588567715091448`}, {
    1.135785817361242, -1.8632012755846146`}, {
    0.31464126495231626`, -1.2928360462470445`}, {
    0.6033246963890936, -0.3356982030966429}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {3, 1}, {4, 5}, {5, 6}, {6, 7}, {7, 8}, {8, 
       4}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["8",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.811567349479424, -2.492483805489247}, {
     1.314634937573292, -3.3567309888208716`}, {
     0.31464126495231615`, -3.360276613533161}, {
     1.6039665298594217`, -0.31464126495231626`}, {
     1.9323950128921872`, -1.2588567715091448`}, {
     1.135785817361242, -1.8632012755846146`}, {
     0.31464126495231626`, -1.2928360462470445`}, {
     0.6033246963890936, -0.3356982030966429}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{119, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->83795032]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"VertexList", "[", "g", "]"}], "->", 
   RowBox[{"ClosenessCentrality", "[", "g", "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->537039398],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "0.3333333333333333`"}], ",", 
   RowBox[{"2", "\[Rule]", "0.3333333333333333`"}], ",", 
   RowBox[{"3", "\[Rule]", "0.3333333333333333`"}], ",", 
   RowBox[{"4", "\[Rule]", "0.1`"}], ",", 
   RowBox[{"5", "\[Rule]", "0.1`"}], ",", 
   RowBox[{"6", "\[Rule]", "0.1`"}], ",", 
   RowBox[{"7", "\[Rule]", "0.1`"}], ",", 
   RowBox[{"8", "\[Rule]", "0.1`"}]}], "}"}]], "Output",
 ImageSize->{554, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->659367601]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->49712837],

Cell["\<\
The centrality of a vertex that cannot reach all other vertices in its \
component is zero:\
\>", "ExampleText",
 CellID->903707316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClosenessCentrality", "[", 
  RowBox[{"{", 
   RowBox[{"1", "\[Rule]", "2"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1683590231],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "0.`"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1420403143]
}, Open  ]],

Cell["\<\
The centrality of a disconnected graph is calculated by treating each \
component separately:\
\>", "ExampleText",
 CellID->1685495443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClosenessCentrality", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"3", "\[Rule]", "4"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->249218654],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "0.`", ",", "1.`", ",", "0.`"}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->921202378]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->654131586],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Weighted",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->12759408],

Cell["This defines a graph with edge weights:", "ExampleText",
 CellID->559406688],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->448138177],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", ".0"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->965621645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "2"}], ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "\[Rule]", "1"}], ",", "1."}], "}"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1801814521],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytVl9Ik1EUv+77ZnNb5NMaUrS3RiHYU0JQPpkvgS+J1BCHBBOKxPYgERkh
TEiwh8CQYCGBPgT2MFhRMCjChxZ76MEsyAejCUHO1Jb5sH7nnO1+n1+C5ja2
u/vnnPP73d/9zj3fhWg8duVaNN7fFw2dH4wOxPr7boTarw9iyqhTSqXwCwQV
+iX0+JcqlfB/Ea2JoYtGBs3zR3XxapdtFq26zP9ent3ITxYWIvgqPzXGZiFT
9g1Q494qFhczGfm+m5hQxzLDw8qQQGyAhufcc+Pj2rK4sqIOc/yttdzqQg+F
9nH8wsfI+tcxWvLaWPxaTmwWpkqlrPJRI+PXtHSImgbEE3wgzXR2Pm5rG21s
vKPUiMejDIyUkYrFsEZEjqJx6mBUWB58PjAAe/nqGOg/6ejAuuxhLZ8XXKgx
BSoWLx5P7p09r/tXFhfnZ2cRHjhAAyw6QhjzItdxB+Mwe4r6n9NpmArzsWBQ
CL8aGvowPf19ft5bE6b1rPPS3BwkeNrdDZj7oRCkBjAYgIc6SRamxVCpU+wj
HN8kEnB7EA5jd3DDELEkatXc+DQ9iIeoOCfs/1FrK+TA/nFUxMIFNqfZClJC
U4gDExjCXKi49s+kAePl90k7OOLjUEiVQUZFD2M7qiD594QCblkS1k0DN+Zf
xtsthJusuyBIVBN2RsV+1+gGN3xuWaW9LHVvO5QxbfbWeDeUnb1qjeJ2ePHe
TKy/Hb2E2wHZcIs90BGofzyqwPFg/cuLe0hcPOZIEDzvghkn7wPoYCi5A4Oq
8F1sanmVT82v9cQHjz4SQLORpEMmXqVYPnsmwwBmki1YrIoZKUHZVu84Xzff
BQCQ7MMFhasV2QBgqEJ3QTMsjB1qVDN75nO5XDKJpIaPeOoEl9i2Z2c7h33d
yaQPeIGd4EEiUNYVAGyU80Y+wX44ZV2JkOYPW1rgjfZZby9caZ+1uY+5/ngE
TV/+goYLxsU1D6dbrnkursqQS8qvaqLGUaWP8JwUIu3jA297MRQdpDbhviEd
alMJA5VbTBiCqsmcsQfBV028JwdnnpMypDmbeFD0a0bgP9htfLu77V3n9490
+WzPOM76HI///JxZ/dRj2a8vjZTXG3RUqJM9u4M3zftLlbcvelojsrW6v1NG
vX4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->163563481]
}, Open  ]],

Cell["By default, edge weights are taken into account:", "ExampleText",
 CellID->1356393510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClosenessCentrality", "[", "g", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2056878537],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5`", ",", "1.`"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1534708241]
}, Open  ]],

Cell["\<\
This gives the closeness centrality if edge weights are assumed to be 1.:\
\>", "ExampleText",
 CellID->1783089294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClosenessCentrality", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Weighted", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1345474767],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "1.`"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1265025393]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["\<\
A plot of a grid graph with vertices of high centrality in red:\
\>", "ExampleText",
 CellID->1496472769],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->66336998],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"GridGraph", "[", 
    RowBox[{"10", ",", "14"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cs", "=", 
   RowBox[{"ClosenessCentrality", "[", "g", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "=", 
   RowBox[{"0.7", "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"cs", "/", 
       RowBox[{"Max", "[", "cs", "]"}]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "\[Rule]", "None"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", 
         RowBox[{"color", "[", 
          RowBox[{"[", "#3", "]"}], "]"}], "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#", ",", ".2"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->379950264],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{152, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->171094496]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["PageRanks",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/PageRanks"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ClosenessCentrality - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 59.8976736}", "context" -> 
    "GraphUtilities`", 
    "keywords" -> {"graph centrality graph distance graph geodesic"}, "index" -> 
    True, "label" -> "Graph Utilities Package Symbol", "language" -> "en", 
    "paclet" -> "GraphUtilities Package", "status" -> "None", "summary" -> 
    "ClosenessCentrality[g] finds the closeness centrality.", 
    "synonyms" -> {}, "title" -> "ClosenessCentrality", "type" -> "Symbol", 
    "uri" -> "GraphUtilities/ref/ClosenessCentrality"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4829, 159, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->186332360]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30379, 914}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1819, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2442, 75, 62, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2507, 78, 400, 12, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2944, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3422, 112, 372, 9, 70, "Notes",
 CellID->1496149871],
Cell[3797, 123, 73, 1, 70, "Notes",
 CellID->1067943069],
Cell[3873, 126, 919, 28, 70, "3ColumnTableMod",
 CellID->270562]
}, Closed]],
Cell[CellGroupData[{
Cell[4829, 159, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->186332360],
Cell[CellGroupData[{
Cell[5214, 173, 148, 5, 70, "ExampleSection",
 CellID->333118727],
Cell[5365, 180, 138, 4, 70, "Input",
 CellID->36355221],
Cell[5506, 186, 71, 1, 70, "ExampleText",
 CellID->1172741669],
Cell[5580, 189, 308, 10, 70, "Input",
 CellID->1528823234],
Cell[CellGroupData[{
Cell[5913, 203, 230, 6, 28, "Input",
 CellID->1934494070],
Cell[6146, 211, 2638, 64, 323, "Output",
 CellID->1730351361]
}, Open  ]],
Cell[8799, 278, 149, 4, 70, "ExampleText",
 CellID->1449356200],
Cell[CellGroupData[{
Cell[8973, 286, 211, 6, 70, "Input",
 CellID->897077387],
Cell[9187, 294, 574, 15, 36, "Output",
 CellID->1149419484]
}, Open  ]],
Cell[9776, 312, 126, 3, 70, "ExampleDelimiter",
 CellID->1145097784],
Cell[9905, 317, 140, 4, 70, "Input",
 CellID->2057494921],
Cell[10048, 323, 120, 3, 70, "ExampleText",
 CellID->114230516],
Cell[10171, 328, 475, 14, 70, "Input",
 CellID->331498499],
Cell[CellGroupData[{
Cell[10671, 346, 174, 5, 70, "Input",
 CellID->898556548],
Cell[10848, 353, 2487, 62, 237, "Output",
 CellID->83795032]
}, Open  ]],
Cell[CellGroupData[{
Cell[13372, 420, 211, 6, 70, "Input",
 CellID->537039398],
Cell[13586, 428, 573, 15, 36, "Output",
 CellID->659367601]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14208, 449, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[14432, 458, 138, 4, 70, "Input",
 CellID->49712837],
Cell[14573, 464, 142, 4, 70, "ExampleText",
 CellID->903707316],
Cell[CellGroupData[{
Cell[14740, 472, 169, 5, 70, "Input",
 CellID->1683590231],
Cell[14912, 479, 208, 7, 36, "Output",
 CellID->1420403143]
}, Open  ]],
Cell[15135, 489, 145, 4, 70, "ExampleText",
 CellID->1685495443],
Cell[CellGroupData[{
Cell[15305, 497, 224, 7, 70, "Input",
 CellID->249218654],
Cell[15532, 506, 232, 7, 36, "Output",
 CellID->921202378]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15813, 519, 222, 7, 70, "ExampleSection",
 CellID->654131586],
Cell[CellGroupData[{
Cell[16060, 530, 228, 7, 70, "ExampleSubsection",
 CellID->12759408],
Cell[16291, 539, 82, 1, 70, "ExampleText",
 CellID->559406688],
Cell[16376, 542, 139, 4, 70, "Input",
 CellID->448138177],
Cell[16518, 548, 267, 10, 70, "Input",
 CellID->965621645],
Cell[CellGroupData[{
Cell[16810, 562, 400, 13, 70, "Input",
 CellID->1801814521],
Cell[17213, 577, 1375, 27, 70, "Output",
 Evaluatable->False,
 CellID->163563481]
}, Open  ]],
Cell[18603, 607, 92, 1, 70, "ExampleText",
 CellID->1356393510],
Cell[CellGroupData[{
Cell[18720, 612, 116, 3, 70, "Input",
 CellID->2056878537],
Cell[18839, 617, 209, 7, 36, "Output",
 CellID->1534708241]
}, Open  ]],
Cell[19063, 627, 125, 3, 70, "ExampleText",
 CellID->1783089294],
Cell[CellGroupData[{
Cell[19213, 634, 180, 5, 70, "Input",
 CellID->1345474767],
Cell[19396, 641, 208, 7, 36, "Output",
 CellID->1265025393]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[19665, 655, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[19895, 664, 115, 3, 70, "ExampleText",
 CellID->1496472769],
Cell[20013, 669, 138, 4, 70, "Input",
 CellID->66336998],
Cell[CellGroupData[{
Cell[20176, 677, 976, 32, 70, "Input",
 CellID->379950264],
Cell[21155, 711, 6451, 110, 70, "Output",
 Evaluatable->False,
 CellID->171094496]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27667, 828, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[27986, 839, 217, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[28240, 850, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[28561, 861, 167, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[28765, 869, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[29086, 880, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[29275, 887, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

