(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26632,        934]
NotebookOptionsPosition[     21577,        765]
NotebookOutlinePosition[     22995,        803]
CellTagsIndexPosition[     22910,        798]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CommunityStructureAssignment" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/CommunityStructureAssignment"], 
          "CommunityStructurePartition" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/CommunityStructurePartition"], "MinCut" :> 
          Documentation`HelpLookup["paclet:GraphUtilities/ref/MinCut"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"CommunityStructureAssignment\"\>", 
       2->"\<\"CommunityStructurePartition\"\>", 
       3->"\<\"MinCut\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CommunityModularity", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CommunityModularity", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["partition", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the community modularity of a partition."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CommunityModularity", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["assignment", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the community modularity of an assignment."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
A community in a network is a group of vertices such that there is a higher \
density of edges within the group than between them.\
\>", "Notes",
 CellID->170740048],

Cell[TextData[{
 "Given a graph ",
 Cell[BoxData[
  RowBox[{
   StyleBox["g", "TI"], "=", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["V", "TI"], ",", 
     StyleBox["E", "TI"]}], "}"}]}]], "InlineFormula"],
 ", let the vertex set ",
 StyleBox["V", "TI"],
 " be partitioned into ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " subsets ",
 Cell[BoxData[
  RowBox[{
   StyleBox["V", "TI"], "=", 
   RowBox[{"\[Union]", 
    SubscriptBox[
     StyleBox["V", "TI"], 
     StyleBox["i", "TI"]]}]}]], "InlineFormula"],
 " such that each subset belongs to one community. The community modularity \
",
 Cell[BoxData[
  StyleBox["Q", "TI"]], "InlineFormula"],
 " of this partition is defined as"
}], "Notes",
 CellID->1626430468],

Cell[TextData[Cell[BoxData[
 RowBox[{
  StyleBox["Q", "TI"], "=", " ", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{
     StyleBox["i", "TI"], "=", "1"}], 
    StyleBox["k", "TI"]], 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["ii", "TI"]], " ", "-", " ", 
     SuperscriptBox[
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["ii", "TI"]], "2"]}], ")"}]}]}]], "InlineFormula"]], "Notes",
 CellID->937409174],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  SubscriptBox["e", "ii"]], "InlineFormula"],
 " is the percentage of number of edges that has both ends in community ",
 Cell[BoxData[
  SubscriptBox["V", "i"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  SubscriptBox["a", "i"]], "InlineFormula"],
 " is the percentage of edges that start from community ",
 Cell[BoxData[
  SubscriptBox["V", "i"]], "InlineFormula"],
 ". In other words, "
}], "Notes",
 CellID->1637911689],

Cell[TextData[Cell[BoxData[
 RowBox[{
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["ii", "TI"]], " ", "=", " ", 
  RowBox[{"|", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"]}], ")"}], "|", 
      RowBox[{
       StyleBox["u", "TI"], "\[Element]", 
       SubscriptBox[
        StyleBox["V", "TI"], 
        StyleBox["i", "TI"]]}]}], ",", 
     RowBox[{
      StyleBox["v", "TI"], " ", "\[Element]", 
      SubscriptBox[
       StyleBox["V", "TI"], 
       StyleBox["i", "TI"]]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"]}], ")"}], "\[Element]", "E"}]}], "}"}], "|", 
   RowBox[{"/", 
    RowBox[{"|", "E", "|"}]}]}]}]], "InlineFormula"]], "Notes",
 CellID->889193056],

Cell["and", "Notes",
 CellID->1913286558],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["a", "TI"], 
    StyleBox["i", "TI"]], " ", "=", " ", 
   RowBox[{"|", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         StyleBox["u", "TI"], ",", 
         StyleBox["v", "TI"]}], ")"}], "|", 
       RowBox[{
        StyleBox["u", "TI"], "\[Element]", 
        SubscriptBox[
         StyleBox["V", "TI"], 
         StyleBox["i", "TI"]]}]}], ",", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         StyleBox["u", "TI"], ",", 
         StyleBox["v", "TI"]}], ")"}], "\[Element]", "E"}]}], "}"}], "|", 
    RowBox[{"/", 
     RowBox[{"|", "E", "|"}]}]}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2068955800],

Cell[TextData[{
 "The community modularity ",
 Cell[BoxData[
  StyleBox["Q", "TI"]], "InlineFormula"],
 " is a number less than or equal to 1. A large positive value indicates that \
the vertex partition gives significant community structure."
}], "Notes",
 CellID->1047161295],

Cell["The following option can be given:", "Notes",
 CellID->1067943069],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Weighted",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/Weighted"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether edges with higher weights are preferred during matching\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->644055005]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->180601100],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->200105411],

Cell["This defines a small graph:", "ExampleText",
 CellID->511707182],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->547790834],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "4"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1945466067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->75760771],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{3.2342712370199784`, 0.0003038330952451207}, {
    3.2345206716088244`, 0.7344345520225397}, {2.287874251024187, 
    0.36744303300528086`}, {0.9457927613084317, 0.367446973828632}, {0., 
    0.7347609437618081}, {0.0001426203143779503, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {3, 1}, {3, 4}, {4, 5}, {5, 6}, {6, 4}}]}, {
      InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{3.2342712370199784`, 0.0003038330952451207}, {
     3.2345206716088244`, 0.7344345520225397}, {2.287874251024187, 
     0.36744303300528086`}, {0.9457927613084317, 0.367446973828632}, {0., 
     0.7347609437618081}, {0.0001426203143779503, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{288., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{292, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->414629859]
}, Open  ]],

Cell[TextData[{
 "This gives the community modularity, assuming a partition ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1817580054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CommunityModularity", "[", 
  RowBox[{"g", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->662594987],

Cell[BoxData["0.3469387755102041`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->209161275]
}, Open  ]],

Cell[TextData[{
 "This gives the community modularity, assuming a partition ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "6"}], "}"}]}], "}"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1684291762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CommunityModularity", "[", 
  RowBox[{"g", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3", ",", "6"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->763020275],

Cell[BoxData[
 RowBox[{"-", "0.08163265306122448`"}]], "Output",
 ImageSize->{75, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->2108360279]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->63974891],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Weighted",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->268911304],

Cell["This defines a graph with edge weights:", "ExampleText",
 CellID->363788730],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->2091685420],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2016018998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"m", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Line", "[", "#", "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"m", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"First", "[", "#4", "]"}], ",", 
             RowBox[{"Last", "[", "#4", "]"}]}], "]"}], "]"}], ",", 
          RowBox[{"LineScaledCoordinate", "[", "#", "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->816780673],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAFiEQkGIPs/kAXG
W/7/B9IQkgtEMn95XP3hZgwQMXCDCOaPt+J+vt8FkpIHy3+6m4Yqfzvh36/X
ICk5sPy/X/uBQiApHrD8p7tZ/8EAKv/z/VygkQj5L487ofKcSK749qL954dF
//+fYeAGERD+ISRX3Mv++2sfQh7MR3IFUBIohJAH8wsR+oGGA41EyIP5s0BS
XKOuGBKuYAISLMAkzIrmGl4gwQwU50dzFTOQYIarR7iOC6oeaN5/JiDNi+Za
FrB6UF75fwbBR7ge1T6EL5ig9rER5RtmJFsYsPiKD6weLP8fwUf4DrsrEb7k
BhEsCP0Q/yKbyEWiv7G7COF/VjT9zESFA3ZbgfKNFV729vYMPEAC3eV8IAli
wiI0yBmklBNmBs7wAKniApuKCA/U9AYUv3UsEr+LKA0L7LoGS1ggp1Y2MsIE
5BsmovMHzrAYsPyB6n7i8wV2lxBT2kHddwYS6ANfQpAbAuTlBlTbUMt7kLgA
mn9R1aOW9yBx5v/kl/cI+8gt7wdHHTrqisHhiq/PWj/cQG5T34z99fE4wpTP
D/JR2tyf7qT8+/MB4Yp/fw4BhRBt6s8PKqB5DyL/6+NSoJEI/UDLvj6bgXAF
pP3PwAgAbiRZLw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->153126867]
}, Open  ]],

Cell[TextData[{
 "The community modularity of partition ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}]], "InlineFormula"],
 ", ignoring edge weights:"
}], "ExampleText",
 CellID->1145551369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CommunityModularity", "[", 
  RowBox[{"m", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1075060657],

Cell[BoxData["0.16666666666666666`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1550416850]
}, Open  ]],

Cell[TextData[{
 "The community modularity of partition ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}]], "InlineFormula"],
 ", taking into account edge weights:"
}], "ExampleText",
 CellID->952660664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CommunityModularity", "[", 
  RowBox[{"m", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"Weighted", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1302209826],

Cell[BoxData[
 RowBox[{"-", "0.23958333333333334`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1995415659]
}, Open  ]],

Cell[TextData[{
 "When taking into account edge weights, partition ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "}"}]], "InlineFormula"],
 " has higher community modularity:"
}], "ExampleText",
 CellID->1131602924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CommunityModularity", "[", 
  RowBox[{"m", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"Weighted", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->2087265001],

Cell[BoxData[
 RowBox[{"-", "0.013888888888888888`"}]], "Output",
 ImageSize->{75, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->356793059]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CommunityStructureAssignment",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/CommunityStructureAssignment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CommunityStructurePartition",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/CommunityStructurePartition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MinCut",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/MinCut"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1900161498]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CommunityModularity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 6.4290908}", "context" -> 
    "GraphUtilities`", 
    "keywords" -> {"network analysis graph partition graph partitioning"}, 
    "index" -> True, "label" -> "Graph Utilities Package Symbol", "language" -> 
    "en", "paclet" -> "GraphUtilities Package", "status" -> "None", "summary" -> 
    "CommunityModularity[g, partition] gives the community modularity of a \
partition. CommunityModularity[g, assignment] gives the community modularity \
of an assignment.", "synonyms" -> {}, "title" -> "CommunityModularity", 
    "type" -> "Symbol", "uri" -> "GraphUtilities/ref/CommunityModularity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8660, 299, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->180601100]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22767, 791}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2202, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2825, 82, 62, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2890, 85, 769, 22, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3696, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4174, 129, 175, 4, 70, "Notes",
 CellID->170740048],
Cell[4352, 135, 736, 28, 70, "Notes",
 CellID->1626430468],
Cell[5091, 165, 484, 17, 70, "Notes",
 CellID->937409174],
Cell[5578, 184, 468, 15, 70, "Notes",
 CellID->1637911689],
Cell[6049, 201, 851, 30, 70, "Notes",
 CellID->889193056],
Cell[6903, 233, 41, 1, 70, "Notes",
 CellID->1913286558],
Cell[6947, 236, 744, 28, 70, "Notes",
 CellID->2068955800],
Cell[7694, 266, 277, 7, 70, "Notes",
 CellID->1047161295],
Cell[7974, 275, 72, 1, 70, "Notes",
 CellID->1067943069],
Cell[8049, 278, 574, 16, 70, "3ColumnTableMod",
 CellID->644055005]
}, Closed]],
Cell[CellGroupData[{
Cell[8660, 299, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->180601100],
Cell[CellGroupData[{
Cell[9045, 313, 148, 5, 70, "ExampleSection",
 CellID->200105411],
Cell[9196, 320, 70, 1, 70, "ExampleText",
 CellID->511707182],
Cell[9269, 323, 139, 4, 70, "Input",
 CellID->547790834],
Cell[9411, 329, 444, 13, 70, "Input",
 CellID->1945466067],
Cell[CellGroupData[{
Cell[9880, 346, 173, 5, 28, "Input",
 CellID->75760771],
Cell[10056, 353, 1912, 47, 93, "Output",
 CellID->414629859]
}, Open  ]],
Cell[11983, 403, 330, 11, 70, "ExampleText",
 CellID->1817580054],
Cell[CellGroupData[{
Cell[12338, 418, 313, 10, 70, "Input",
 CellID->662594987],
Cell[12654, 430, 176, 5, 36, "Output",
 CellID->209161275]
}, Open  ]],
Cell[12845, 438, 330, 11, 70, "ExampleText",
 CellID->1684291762],
Cell[CellGroupData[{
Cell[13200, 453, 313, 10, 70, "Input",
 CellID->763020275],
Cell[13516, 465, 195, 6, 36, "Output",
 CellID->2108360279]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13760, 477, 221, 7, 70, "ExampleSection",
 CellID->63974891],
Cell[CellGroupData[{
Cell[14006, 488, 229, 7, 70, "ExampleSubsection",
 CellID->268911304],
Cell[14238, 497, 82, 1, 70, "ExampleText",
 CellID->363788730],
Cell[14323, 500, 140, 4, 70, "Input",
 CellID->2091685420],
Cell[14466, 506, 477, 15, 70, "Input",
 CellID->2016018998],
Cell[CellGroupData[{
Cell[14968, 525, 748, 21, 70, "Input",
 CellID->816780673],
Cell[15719, 548, 899, 19, 70, "Output",
 Evaluatable->False,
 CellID->153126867]
}, Open  ]],
Cell[16633, 570, 313, 11, 70, "ExampleText",
 CellID->1145551369],
Cell[CellGroupData[{
Cell[16971, 585, 294, 10, 70, "Input",
 CellID->1075060657],
Cell[17268, 597, 178, 5, 36, "Output",
 CellID->1550416850]
}, Open  ]],
Cell[17461, 605, 323, 11, 70, "ExampleText",
 CellID->952660664],
Cell[CellGroupData[{
Cell[17809, 620, 344, 11, 70, "Input",
 CellID->1302209826],
Cell[18156, 633, 195, 6, 36, "Output",
 CellID->1995415659]
}, Open  ]],
Cell[18366, 642, 333, 11, 70, "ExampleText",
 CellID->1131602924],
Cell[CellGroupData[{
Cell[18724, 657, 344, 11, 70, "Input",
 CellID->2087265001],
Cell[19071, 670, 195, 6, 36, "Output",
 CellID->356793059]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19339, 684, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[19658, 695, 820, 26, 70, "SeeAlso",
 CellID->1900161498]
}, Open  ]],
Cell[CellGroupData[{
Cell[20515, 726, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[20836, 737, 167, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[21040, 745, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[21361, 756, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[21550, 763, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

