(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    132560,       3756]
NotebookOptionsPosition[    127425,       3585]
NotebookOutlinePosition[    128916,       3624]
CellTagsIndexPosition[    128829,       3619]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TreeForm" :> Documentation`HelpLookup["paclet:ref/TreeForm"], 
          "TreePlot" :> Documentation`HelpLookup["paclet:ref/TreePlot"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"TreeForm\"\>", 
       2->"\<\"TreePlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ExpressionTreePlot", "ObjectName", "GraphToSparseArray",
 CellID->31079],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ExpressionTree", "[", 
       StyleBox["e", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots the expression tree of ",
     StyleBox["e.", "TI"]
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ExpressionTreePlot", "[", 
       RowBox[{
        StyleBox["e", "TI"], ",", " ", 
        StyleBox["pos", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots the expression tree of ",
     StyleBox["e ", "TI"],
     " with its root placed at position ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ExpressionTreePlot", "[", 
       RowBox[{
        StyleBox["e", "TI"], ",", " ", 
        StyleBox["pos", "TI"], 
        StyleBox[",", "TI"], 
        StyleBox[" ", "TI"], 
        StyleBox["lev", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots the expression tree of ",
     StyleBox["e ", "TI"],
     " up to level ",
     Cell[BoxData[
      StyleBox["lev", "TI"]], "InlineFormula"],
     " with its root placed at position ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->2703]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["ExpressionTreePlot"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->300046863]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->346746561],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->341004404],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->280857217],

Cell["\<\
An expression tree plot, with tooltips for each vertex giving the \
subexpression from that vertex down:\
\>", "ExampleText",
 CellID->5097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpressionTreePlot", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"E", "^", "x"}], "+", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Cos", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16512],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.831299685083074, 2.1975596220996887`}, {
    0.3662599370166148, 1.465039748066459}, {0., 0.7325198740332295}, {
    0.7325198740332296, 0.7325198740332295}, {1.831299685083074, 
    1.465039748066459}, {1.4650397480664592`, 0.7325198740332295}, {
    2.1975596220996887`, 0.7325198740332295}, {3.2963394331495333`, 
    1.465039748066459}, {2.9300794961329184`, 0.7325198740332295}, {
    2.9300794961329184`, 0.}, {3.662599370166148, 0.7325198740332295}, {
    3.662599370166148, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 5}, {1, 8}, {2, 3}, {2, 4}, {5, 6}, {5, 7}, {8, 
       9}, {8, 11}, {9, 10}, {11, 12}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Plus", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{
           SuperscriptBox["\[ExponentialE]", "x"], "+", 
           SuperscriptBox["x", "2"], "+", 
           RowBox[{
             RowBox[{"Cos", "[", "x", "]"}], " ", 
             RowBox[{"Sin", "[", "x", "]"}]}]}], HoldForm]],
       Annotation[#, 
        HoldForm[
        E^$CellContext`x + $CellContext`x^2 + 
         Cos[$CellContext`x] Sin[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         SuperscriptBox["\[ExponentialE]", "x"], HoldForm]],
       Annotation[#, 
        HoldForm[E^$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["\[ExponentialE]",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox["\[ExponentialE]", HoldForm]],
       Annotation[#, 
        HoldForm[E], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox[
         SuperscriptBox["x", "2"], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x^2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Times", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox[
         RowBox[{
           RowBox[{"Cos", "[", "x", "]"}], " ", 
           RowBox[{"Sin", "[", "x", "]"}]}], HoldForm]],
       Annotation[#, 
        HoldForm[Cos[$CellContext`x] Sin[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Cos", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox[
         RowBox[{"Cos", "[", "x", "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Cos[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 10],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Sin", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 11],
        TagBox[
         RowBox[{"Sin", "[", "x", "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Sin[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 12],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.831299685083074, 2.1975596220996887`}, {
     0.3662599370166148, 1.465039748066459}, {0., 0.7325198740332295}, {
     0.7325198740332296, 0.7325198740332295}, {1.831299685083074, 
     1.465039748066459}, {1.4650397480664592`, 0.7325198740332295}, {
     2.1975596220996887`, 0.7325198740332295}, {3.2963394331495333`, 
     1.465039748066459}, {2.9300794961329184`, 0.7325198740332295}, {
     2.9300794961329184`, 0.}, {3.662599370166148, 0.7325198740332295}, {
     3.662599370166148, 0.}}]& ],
  AspectRatio->NCache[2 Rational[2, 15]^Rational[1, 2], 0.7302967433402214],
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->760023925]
}, Open  ]],

Cell["An expression tree up to level 2 with its root at the left:", \
"ExampleText",
 CellID->1108291180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpressionTreePlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"E", "^", "x"}], "+", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Cos", "[", "x", "]"}]}]}], ",", "Left", ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->638430509],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 1.7437145811572876`}, {0.6974858324629172, 
    0.34874291623145715`}, {1.3949716649258332`, 0.}, {1.3949716649258324`, 
    0.6974858324629158}, {0.6974858324629157, 1.7437145811572883`}, {
    1.3949716649258317`, 1.3949716649258315`}, {1.394971664925831, 
    2.092457497388747}, {0.6974858324629143, 3.13868624608312}, {
    1.3949716649258301`, 2.7899433298516625`}, {1.3949716649258295`, 
    3.4874291623145783`}}, {
     {RGBColor[0.55, 0.45, 0.45], LineBox[{1, 2}], LineBox[{1, 5}], 
      LineBox[{1, 8}], LineBox[{2, 3}], LineBox[{2, 4}], LineBox[{5, 6}], 
      LineBox[{5, 7}], LineBox[{8, 9}], LineBox[{8, 10}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Plus", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{
           SuperscriptBox["\[ExponentialE]", "x"], "+", 
           SuperscriptBox["x", "2"], "+", 
           RowBox[{
             RowBox[{"Cos", "[", "x", "]"}], " ", 
             RowBox[{"Sin", "[", "x", "]"}]}]}], HoldForm]],
       Annotation[#, 
        HoldForm[
        E^$CellContext`x + $CellContext`x^2 + 
         Cos[$CellContext`x] Sin[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         SuperscriptBox["\[ExponentialE]", "x"], HoldForm]],
       Annotation[#, 
        HoldForm[E^$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["\[ExponentialE]",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox["\[ExponentialE]", HoldForm]],
       Annotation[#, 
        HoldForm[E], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox[
         SuperscriptBox["x", "2"], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x^2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Times", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox[
         RowBox[{
           RowBox[{"Cos", "[", "x", "]"}], " ", 
           RowBox[{"Sin", "[", "x", "]"}]}], HoldForm]],
       Annotation[#, 
        HoldForm[Cos[$CellContext`x] Sin[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox[
            RowBox[{"cos", "(", "x", ")"}],
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox[
         RowBox[{"Cos", "[", "x", "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Cos[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox[
            RowBox[{"sin", "(", "x", ")"}],
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 10],
        TagBox[
         RowBox[{"Sin", "[", "x", "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Sin[$CellContext`x]], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 1.7437145811572876`}, {0.6974858324629172, 
     0.34874291623145715`}, {1.3949716649258332`, 0.}, {1.3949716649258324`, 
     0.6974858324629158}, {0.6974858324629157, 1.7437145811572883`}, {
     1.3949716649258317`, 1.3949716649258315`}, {1.394971664925831, 
     2.092457497388747}, {0.6974858324629143, 3.13868624608312}, {
     1.3949716649258301`, 2.7899433298516625`}, {1.3949716649258295`, 
     3.4874291623145783`}}]& ],
  AspectRatio->NCache[
   Rational[1, 2] Rational[3, 2]^Rational[1, 2], 0.6123724356957945],
  FrameTicks->None,
  ImageSize->{278., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.03]]], "Output",
 ImageSize->{282, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1009040438]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1877069017],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 ", etc. are used, the expressions inside them are not evaluated:"
}], "ExampleText",
 CellID->1377026911],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->2042614859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpressionTreePlot", "[", 
  RowBox[{"Hold", "[", 
   RowBox[{"1", "+", "2", "+", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->87413592],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.816496580927726, 1.632993161855452}, {
    0.816496580927726, 0.816496580927726}, {0., 0.}, {0.816496580927726, 
    0.}, {1.632993161855452, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {2, 3}, {2, 4}, {2, 5}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Hold", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{"Hold", "[", 
           RowBox[{"1", "+", "2", "+", "3"}], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Hold[1 + 2 + 3]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Plus", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         RowBox[{"1", "+", "2", "+", "3"}], HoldForm]],
       Annotation[#, 
        HoldForm[1 + 2 + 3], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["1",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["3",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox["3", HoldForm]],
       Annotation[#, 
        HoldForm[3], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.816496580927726, 1.632993161855452}, {
     0.816496580927726, 0.816496580927726}, {0., 0.}, {0.816496580927726, 
     0.}, {1.632993161855452, 0.}}]& ],
  AspectRatio->NCache[Rational[3, 2]^Rational[1, 2], 1.224744871391589],
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{181, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1770658771]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1477999851],

Cell["\<\
This gives an expression tree with no vertex labels, except that all \
subexpressions are shown as tooltips:\
\>", "ExampleText",
 CellID->731129807],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->343805533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpressionTreePlot", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"x", "^", "3"}], "+", "1"}], ")"}]}]}], ",", "x"}], "]"}], 
   ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1899889660],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{3.113530577615031, 3.83203763398773}, {
    0.638672938997955, 3.193364694989775}, {1.27734587799591, 
    3.193364694989775}, {0.3193364694989775, 2.5546917559918203`}, {0., 
    1.916018816993865}, {0.638672938997955, 1.916018816993865}, {
    0.3193364694989775, 1.2773458779959102`}, {0.9580094084969324, 
    1.2773458779959102`}, {2.2353552864928425`, 2.5546917559918203`}, {
    2.2353552864928425`, 1.916018816993865}, {1.5966823474948875`, 
    1.2773458779959102`}, {1.27734587799591, 0.6386729389979551}, {
    1.9160188169938648`, 0.6386729389979551}, {1.5966823474948875`, 0.}, {
    2.2353552864928425`, 0.}, {2.8740282254907976`, 1.2773458779959102`}, {
    2.55469175599182, 0.6386729389979551}, {3.193364694989775, 
    0.6386729389979551}, {2.8740282254907976`, 0.}, {3.5127011644887527`, 
    0.}, {3.6723693992382413`, 3.193364694989775}, {3.193364694989775, 
    2.5546917559918203`}, {2.8740282254907976`, 1.916018816993865}, {
    3.5127011644887527`, 1.916018816993865}, {4.151374103486707, 
    2.5546917559918203`}, {4.151374103486707, 1.916018816993865}, {
    3.83203763398773, 1.2773458779959102`}, {4.470710572985685, 
    1.2773458779959102`}, {5.588388216232106, 3.193364694989775}, {
    5.10938351198364, 2.5546917559918203`}, {4.790047042484662, 
    1.916018816993865}, {5.428719981482617, 1.916018816993865}, {
    6.067392920480572, 2.5546917559918203`}, {6.067392920480572, 
    1.916018816993865}, {5.10938351198364, 1.2773458779959102`}, {
    5.748056450981594, 1.2773458779959102`}, {5.428719981482617, 
    0.6386729389979551}, {6.067392920480572, 0.6386729389979551}, {
    7.0254023289775045`, 1.2773458779959102`}, {6.706065859478527, 
    0.6386729389979551}, {7.344738798476482, 0.6386729389979551}}, {
     {RGBColor[0.55, 0.45, 0.45], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{1, 21}], LineBox[{1, 29}], LineBox[{3, 4}], LineBox[{3, 9}], 
      LineBox[{4, 5}], LineBox[{4, 6}], LineBox[{6, 7}], LineBox[{6, 8}], 
      LineBox[{9, 10}], LineBox[{10, 11}], LineBox[{10, 16}], 
      LineBox[{11, 12}], LineBox[{11, 13}], LineBox[{13, 14}], 
      LineBox[{13, 15}], LineBox[{16, 17}], LineBox[{16, 18}], 
      LineBox[{18, 19}], LineBox[{18, 20}], LineBox[{21, 22}], 
      LineBox[{21, 25}], LineBox[{22, 23}], LineBox[{22, 24}], 
      LineBox[{25, 26}], LineBox[{26, 27}], LineBox[{26, 28}], 
      LineBox[{29, 30}], LineBox[{29, 33}], LineBox[{30, 31}], 
      LineBox[{30, 32}], LineBox[{33, 34}], LineBox[{34, 35}], 
      LineBox[{34, 36}], LineBox[{34, 39}], LineBox[{36, 37}], 
      LineBox[{36, 38}], LineBox[{39, 40}], LineBox[{39, 41}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        TagBox[
         RowBox[{"x", "+", 
           FractionBox[
            RowBox[{"ArcTan", "[", 
              FractionBox[
               RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 RowBox[{"2", " ", "x"}]}], 
               SqrtBox["3"]], "]"}], 
            SqrtBox["3"]], "+", 
           RowBox[{
             FractionBox["1", "3"], " ", 
             RowBox[{"Log", "[", 
               RowBox[{"1", "+", "x"}], "]"}]}], "-", 
           RowBox[{
             FractionBox["1", "6"], " ", 
             RowBox[{"Log", "[", 
               RowBox[{"1", "-", "x", "+", 
                 SuperscriptBox["x", "2"]}], "]"}]}]}], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x + 
         3^Rational[-1, 2] ArcTan[3^Rational[-1, 2] (-1 + 2 $CellContext`x)] + 
         Rational[1, 3] Log[1 + $CellContext`x] + 
         Rational[-1, 6] Log[1 - $CellContext`x + $CellContext`x^2]], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        TagBox[
         FractionBox[
          RowBox[{"ArcTan", "[", 
            FractionBox[
             RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{"2", " ", "x"}]}], 
             SqrtBox["3"]], "]"}], 
          SqrtBox["3"]], HoldForm]],
       Annotation[#, 
        HoldForm[
        3^Rational[-1, 2] ArcTan[3^Rational[-1, 2] (-1 + 2 $CellContext`x)]], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        TagBox[
         FractionBox["1", 
          SqrtBox["3"]], HoldForm]],
       Annotation[#, 
        HoldForm[3^Rational[-1, 2]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        TagBox["3", HoldForm]],
       Annotation[#, 
        HoldForm[3], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        TagBox[
         RowBox[{"-", 
           FractionBox["1", "2"]}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Rational[-1, 2]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        TagBox[
         RowBox[{"-", "1"}], HoldForm]],
       Annotation[#, 
        HoldForm[-1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        TagBox[
         RowBox[{"ArcTan", "[", 
           FractionBox[
            RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", "x"}]}], 
            SqrtBox["3"]], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         ArcTan[3^Rational[-1, 2] (-1 + 2 $CellContext`x)]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        TagBox[
         FractionBox[
          RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"2", " ", "x"}]}], 
          SqrtBox["3"]], HoldForm]],
       Annotation[#, 
        HoldForm[3^Rational[-1, 2] (-1 + 2 $CellContext`x)], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        TagBox[
         FractionBox["1", 
          SqrtBox["3"]], HoldForm]],
       Annotation[#, 
        HoldForm[3^Rational[-1, 2]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        TagBox["3", HoldForm]],
       Annotation[#, 
        HoldForm[3], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        TagBox[
         RowBox[{"-", 
           FractionBox["1", "2"]}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Rational[-1, 2]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        TagBox[
         RowBox[{"-", "1"}], HoldForm]],
       Annotation[#, 
        HoldForm[-1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        TagBox[
         RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"2", " ", "x"}]}], HoldForm]],
       Annotation[#, 
        HoldForm[-1 + 2 $CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        TagBox[
         RowBox[{"-", "1"}], HoldForm]],
       Annotation[#, 
        HoldForm[-1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        TagBox[
         RowBox[{"2", " ", "x"}], HoldForm]],
       Annotation[#, 
        HoldForm[2 $CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        TagBox[
         RowBox[{
           FractionBox["1", "3"], " ", 
           RowBox[{"Log", "[", 
             RowBox[{"1", "+", "x"}], "]"}]}], HoldForm]],
       Annotation[#, 
        HoldForm[Rational[1, 3] Log[1 + $CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        TagBox[
         FractionBox["1", "3"], HoldForm]],
       Annotation[#, 
        HoldForm[
         Rational[1, 3]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        TagBox["3", HoldForm]],
       Annotation[#, 
        HoldForm[3], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        TagBox[
         RowBox[{"Log", "[", 
           RowBox[{"1", "+", "x"}], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Log[1 + $CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        TagBox[
         RowBox[{"1", "+", "x"}], HoldForm]],
       Annotation[#, 
        HoldForm[1 + $CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        TagBox[
         RowBox[{
           RowBox[{"-", 
             FractionBox["1", "6"]}], " ", 
           RowBox[{"Log", "[", 
             RowBox[{"1", "-", "x", "+", 
               SuperscriptBox["x", "2"]}], "]"}]}], HoldForm]],
       Annotation[#, 
        HoldForm[Rational[-1, 6] Log[1 - $CellContext`x + $CellContext`x^2]], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        TagBox[
         RowBox[{"-", 
           FractionBox["1", "6"]}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Rational[-1, 6]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        TagBox[
         RowBox[{"-", "1"}], HoldForm]],
       Annotation[#, 
        HoldForm[-1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        TagBox["6", HoldForm]],
       Annotation[#, 
        HoldForm[6], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        TagBox[
         RowBox[{"Log", "[", 
           RowBox[{"1", "-", "x", "+", 
             SuperscriptBox["x", "2"]}], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Log[1 - $CellContext`x + $CellContext`x^2]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        TagBox[
         RowBox[{"1", "-", "x", "+", 
           SuperscriptBox["x", "2"]}], HoldForm]],
       Annotation[#, 
        HoldForm[1 - $CellContext`x + $CellContext`x^2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        TagBox[
         RowBox[{"-", "x"}], HoldForm]],
       Annotation[#, 
        HoldForm[-$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        TagBox[
         RowBox[{"-", "1"}], HoldForm]],
       Annotation[#, 
        HoldForm[-1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        TagBox[
         SuperscriptBox["x", "2"], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x^2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{3.113530577615031, 3.83203763398773}, {
     0.638672938997955, 3.193364694989775}, {1.27734587799591, 
     3.193364694989775}, {0.3193364694989775, 2.5546917559918203`}, {0., 
     1.916018816993865}, {0.638672938997955, 1.916018816993865}, {
     0.3193364694989775, 1.2773458779959102`}, {0.9580094084969324, 
     1.2773458779959102`}, {2.2353552864928425`, 2.5546917559918203`}, {
     2.2353552864928425`, 1.916018816993865}, {1.5966823474948875`, 
     1.2773458779959102`}, {1.27734587799591, 0.6386729389979551}, {
     1.9160188169938648`, 0.6386729389979551}, {1.5966823474948875`, 0.}, {
     2.2353552864928425`, 0.}, {2.8740282254907976`, 1.2773458779959102`}, {
     2.55469175599182, 0.6386729389979551}, {3.193364694989775, 
     0.6386729389979551}, {2.8740282254907976`, 0.}, {3.5127011644887527`, 
     0.}, {3.6723693992382413`, 3.193364694989775}, {3.193364694989775, 
     2.5546917559918203`}, {2.8740282254907976`, 1.916018816993865}, {
     3.5127011644887527`, 1.916018816993865}, {4.151374103486707, 
     2.5546917559918203`}, {4.151374103486707, 1.916018816993865}, {
     3.83203763398773, 1.2773458779959102`}, {4.470710572985685, 
     1.2773458779959102`}, {5.588388216232106, 3.193364694989775}, {
     5.10938351198364, 2.5546917559918203`}, {4.790047042484662, 
     1.916018816993865}, {5.428719981482617, 1.916018816993865}, {
     6.067392920480572, 2.5546917559918203`}, {6.067392920480572, 
     1.916018816993865}, {5.10938351198364, 1.2773458779959102`}, {
     5.748056450981594, 1.2773458779959102`}, {5.428719981482617, 
     0.6386729389979551}, {6.067392920480572, 0.6386729389979551}, {
     7.0254023289775045`, 1.2773458779959102`}, {6.706065859478527, 
     0.6386729389979551}, {7.344738798476482, 0.6386729389979551}}]& ],
  AspectRatio->NCache[Rational[14, 33]^Rational[1, 2], 0.6513389472789296],
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.03]]], "Output",
 ImageSize->{184, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1920953111]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->800150908],

Cell["This plots a binary tree:", "ExampleText",
 CellID->134501579],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->730833356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpressionTreePlot", "[", 
  RowBox[{
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", "#"}], "}"}], "&"}], ",", "x", ",", "4"}], "]"}], 
   ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->914122792],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{4.330127018922194, 2.309401076758503}, {
    2.0207259421636903`, 1.7320508075688772`}, {0.8660254037844386, 
    1.1547005383792515`}, {0.28867513459481287`, 0.5773502691896257}, {0., 
    0.}, {0.5773502691896257, 0.}, {1.4433756729740643`, 
    0.5773502691896257}, {1.1547005383792515`, 0.}, {1.7320508075688772`, 
    0.}, {3.1754264805429417`, 1.1547005383792515`}, {2.598076211353316, 
    0.5773502691896257}, {2.309401076758503, 0.}, {2.8867513459481287`, 0.}, {
    3.7527767497325675`, 0.5773502691896257}, {3.4641016151377544`, 0.}, {
    4.041451884327381, 0.}, {6.639528095680697, 1.7320508075688772`}, {
    5.484827557301445, 1.1547005383792515`}, {4.907477288111819, 
    0.5773502691896257}, {4.618802153517006, 0.}, {5.196152422706632, 0.}, {
    6.06217782649107, 0.5773502691896257}, {5.773502691896257, 0.}, {
    6.3508529610858835`, 0.}, {7.794228634059948, 1.1547005383792515`}, {
    7.216878364870322, 0.5773502691896257}, {6.928203230275509, 0.}, {
    7.505553499465135, 0.}, {8.371578903249574, 0.5773502691896257}, {
    8.082903768654761, 0.}, {8.660254037844387, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], LineBox[{1, 2}], LineBox[{1, 17}], 
      LineBox[{2, 3}], LineBox[{2, 10}], LineBox[{3, 4}], LineBox[{3, 7}], 
      LineBox[{4, 5}], LineBox[{4, 6}], LineBox[{7, 8}], LineBox[{7, 9}], 
      LineBox[{10, 11}], LineBox[{10, 14}], LineBox[{11, 12}], 
      LineBox[{11, 13}], LineBox[{14, 15}], LineBox[{14, 16}], 
      LineBox[{17, 18}], LineBox[{17, 25}], LineBox[{18, 19}], 
      LineBox[{18, 22}], LineBox[{19, 20}], LineBox[{19, 21}], 
      LineBox[{22, 23}], LineBox[{22, 24}], LineBox[{25, 26}], 
      LineBox[{25, 29}], LineBox[{26, 27}], LineBox[{26, 28}], 
      LineBox[{29, 30}], LineBox[{29, 31}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}]}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}]}], "}"}]}], "}"}]}], "}"}],
          HoldForm]],
       Annotation[#, 
        HoldForm[{{{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}, {{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}}, {{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}, {{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}]}], "}"}]}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}, {{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}]}], "}"}]}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}, {{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{4.330127018922194, 2.309401076758503}, {
     2.0207259421636903`, 1.7320508075688772`}, {0.8660254037844386, 
     1.1547005383792515`}, {0.28867513459481287`, 0.5773502691896257}, {0., 
     0.}, {0.5773502691896257, 0.}, {1.4433756729740643`, 
     0.5773502691896257}, {1.1547005383792515`, 0.}, {1.7320508075688772`, 
     0.}, {3.1754264805429417`, 1.1547005383792515`}, {2.598076211353316, 
     0.5773502691896257}, {2.309401076758503, 0.}, {2.8867513459481287`, 
     0.}, {3.7527767497325675`, 0.5773502691896257}, {3.4641016151377544`, 
     0.}, {4.041451884327381, 0.}, {6.639528095680697, 1.7320508075688772`}, {
     5.484827557301445, 1.1547005383792515`}, {4.907477288111819, 
     0.5773502691896257}, {4.618802153517006, 0.}, {5.196152422706632, 0.}, {
     6.06217782649107, 0.5773502691896257}, {5.773502691896257, 0.}, {
     6.3508529610858835`, 0.}, {7.794228634059948, 1.1547005383792515`}, {
     7.216878364870322, 0.5773502691896257}, {6.928203230275509, 0.}, {
     7.505553499465135, 0.}, {8.371578903249574, 0.5773502691896257}, {
     8.082903768654761, 0.}, {8.660254037844387, 0.}}]& ],
  AspectRatio->NCache[Rational[1, 4] 5^Rational[1, 2], 0.5590169943749475],
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.03]]], "Output",
 ImageSize->{184, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1169704000]
}, Open  ]],

Cell["This plots a 5-ary tree:", "ExampleText",
 CellID->25451541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpressionTreePlot", "[", 
  RowBox[{
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", "#", ",", "#", ",", "#", ",", "#"}], "}"}], "&"}], 
     ",", "x", ",", "3"}], "]"}], ",", "Center", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2112586847],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJw1lnk4VWsbxveEkD3Ye6+tkgxFoSKnSfQ+J98plEREuwmJQiJEIgqlRB0N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    "], {
     {RGBColor[0.55, 0.45, 0.45], LineBox[{1, 2}], LineBox[{1, 33}], 
      LineBox[{1, 64}], LineBox[{1, 95}], LineBox[{1, 126}], LineBox[{2, 3}], 
      LineBox[{2, 9}], LineBox[{2, 15}], LineBox[{2, 21}], LineBox[{2, 27}], 
      LineBox[{3, 4}], LineBox[{3, 5}], LineBox[{3, 6}], LineBox[{3, 7}], 
      LineBox[{3, 8}], LineBox[{9, 10}], LineBox[{9, 11}], LineBox[{9, 12}], 
      LineBox[{9, 13}], LineBox[{9, 14}], LineBox[{15, 16}], 
      LineBox[{15, 17}], LineBox[{15, 18}], LineBox[{15, 19}], 
      LineBox[{15, 20}], LineBox[{21, 22}], LineBox[{21, 23}], 
      LineBox[{21, 24}], LineBox[{21, 25}], LineBox[{21, 26}], 
      LineBox[{27, 28}], LineBox[{27, 29}], LineBox[{27, 30}], 
      LineBox[{27, 31}], LineBox[{27, 32}], LineBox[{33, 34}], 
      LineBox[{33, 40}], LineBox[{33, 46}], LineBox[{33, 52}], 
      LineBox[{33, 58}], LineBox[{34, 35}], LineBox[{34, 36}], 
      LineBox[{34, 37}], LineBox[{34, 38}], LineBox[{34, 39}], 
      LineBox[{40, 41}], LineBox[{40, 42}], LineBox[{40, 43}], 
      LineBox[{40, 44}], LineBox[{40, 45}], LineBox[{46, 47}], 
      LineBox[{46, 48}], LineBox[{46, 49}], LineBox[{46, 50}], 
      LineBox[{46, 51}], LineBox[{52, 53}], LineBox[{52, 54}], 
      LineBox[{52, 55}], LineBox[{52, 56}], LineBox[{52, 57}], 
      LineBox[{58, 59}], LineBox[{58, 60}], LineBox[{58, 61}], 
      LineBox[{58, 62}], LineBox[{58, 63}], LineBox[{64, 65}], 
      LineBox[{64, 71}], LineBox[{64, 77}], LineBox[{64, 83}], 
      LineBox[{64, 89}], LineBox[{65, 66}], LineBox[{65, 67}], 
      LineBox[{65, 68}], LineBox[{65, 69}], LineBox[{65, 70}], 
      LineBox[{71, 72}], LineBox[{71, 73}], LineBox[{71, 74}], 
      LineBox[{71, 75}], LineBox[{71, 76}], LineBox[{77, 78}], 
      LineBox[{77, 79}], LineBox[{77, 80}], LineBox[{77, 81}], 
      LineBox[{77, 82}], LineBox[{83, 84}], LineBox[{83, 85}], 
      LineBox[{83, 86}], LineBox[{83, 87}], LineBox[{83, 88}], 
      LineBox[{89, 90}], LineBox[{89, 91}], LineBox[{89, 92}], 
      LineBox[{89, 93}], LineBox[{89, 94}], LineBox[{95, 96}], 
      LineBox[{95, 102}], LineBox[{95, 108}], LineBox[{95, 114}], 
      LineBox[{95, 120}], LineBox[{96, 97}], LineBox[{96, 98}], 
      LineBox[{96, 99}], LineBox[{96, 100}], LineBox[{96, 101}], 
      LineBox[{102, 103}], LineBox[{102, 104}], LineBox[{102, 105}], 
      LineBox[{102, 106}], LineBox[{102, 107}], LineBox[{108, 109}], 
      LineBox[{108, 110}], LineBox[{108, 111}], LineBox[{108, 112}], 
      LineBox[{108, 113}], LineBox[{114, 115}], LineBox[{114, 116}], 
      LineBox[{114, 117}], LineBox[{114, 118}], LineBox[{114, 119}], 
      LineBox[{120, 121}], LineBox[{120, 122}], LineBox[{120, 123}], 
      LineBox[{120, 124}], LineBox[{120, 125}], LineBox[{126, 127}], 
      LineBox[{126, 133}], LineBox[{126, 139}], LineBox[{126, 145}], 
      LineBox[{126, 151}], LineBox[{127, 128}], LineBox[{127, 129}], 
      LineBox[{127, 130}], LineBox[{127, 131}], LineBox[{127, 132}], 
      LineBox[{133, 134}], LineBox[{133, 135}], LineBox[{133, 136}], 
      LineBox[{133, 137}], LineBox[{133, 138}], LineBox[{139, 140}], 
      LineBox[{139, 141}], LineBox[{139, 142}], LineBox[{139, 143}], 
      LineBox[{139, 144}], LineBox[{145, 146}], LineBox[{145, 147}], 
      LineBox[{145, 148}], LineBox[{145, 149}], LineBox[{145, 150}], 
      LineBox[{151, 152}], LineBox[{151, 153}], LineBox[{151, 154}], 
      LineBox[{151, 155}], LineBox[{151, 156}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
                   "}"}]}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}}, {{$CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x}}, {{$CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x}}, \
{{$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x}}, {{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}]}],
            "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}]}],
            "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[53],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[54],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[55],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[56],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[57],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[58],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[59],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[60],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[61],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[62],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[63],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[64],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}]}],
            "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[65],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[66],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[67],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[68],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[69],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[70],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[71],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[72],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[73],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[74],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[75],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[76],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[77],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[78],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[79],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[80],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[81],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[82],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[83],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[84],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[85],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[86],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[87],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[88],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[89],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[90],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[91],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[92],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[93],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[94],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[95],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}]}],
            "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[96],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[97],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[98],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[99],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[100],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[101],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[102],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[103],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[104],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[105],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[106],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[107],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[108],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[109],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[110],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[111],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[112],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[113],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[114],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[115],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[116],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[117],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[118],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[119],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[120],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[121],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[122],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[123],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[124],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[125],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[126],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}]}],
            "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[127],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[128],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[129],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[130],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[131],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[132],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[133],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[134],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[135],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[136],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[137],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[138],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[139],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[140],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[141],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[142],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[143],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[144],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[145],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[146],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[147],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[148],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[149],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[150],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[151],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x, \
$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[152],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[153],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[154],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[155],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[156],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw1lnk4VWsbxveEkD3Ye6+tkgxFoSKnSfQ+J98plEREuwmJQiJEIgqlRB0N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     "]]& ],
  AspectRatio->1,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.03]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1187244897]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->593713242],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->1594516220],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TreeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreeForm"]], "InlineFormula"],
 " also gives the expression tree, although the orientation of the tree \
cannot be specified:"
}], "ExampleText",
 CellID->1775324560],

Cell[BoxData[
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"E", "^", "x"}], "+", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Cos", "[", "x", "]"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1875542353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", "expr", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->629840852],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.831299685083074, 2.1975596220996887`}, {
    0.3662599370166148, 1.465039748066459}, {0., 0.7325198740332295}, {
    0.7325198740332296, 0.7325198740332295}, {1.831299685083074, 
    1.465039748066459}, {1.4650397480664592`, 0.7325198740332295}, {
    2.1975596220996887`, 0.7325198740332295}, {3.2963394331495333`, 
    1.465039748066459}, {2.9300794961329184`, 0.7325198740332295}, {
    2.9300794961329184`, 0.}, {3.662599370166148, 0.7325198740332295}, {
    3.662599370166148, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 5}, {1, 8}, {2, 3}, {2, 4}, {5, 6}, {5, 7}, {8, 
       9}, {8, 11}, {9, 10}, {11, 12}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Plus", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{
           SuperscriptBox["\[ExponentialE]", "x"], "+", 
           SuperscriptBox["x", "2"], "+", 
           RowBox[{
             RowBox[{"Cos", "[", "x", "]"}], " ", 
             RowBox[{"Sin", "[", "x", "]"}]}]}], HoldForm]],
       Annotation[#, 
        HoldForm[
        E^$CellContext`x + $CellContext`x^2 + 
         Cos[$CellContext`x] Sin[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         SuperscriptBox["\[ExponentialE]", "x"], HoldForm]],
       Annotation[#, 
        HoldForm[E^$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["\[ExponentialE]",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox["\[ExponentialE]", HoldForm]],
       Annotation[#, 
        HoldForm[E], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox[
         SuperscriptBox["x", "2"], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x^2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Times", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox[
         RowBox[{
           RowBox[{"Cos", "[", "x", "]"}], " ", 
           RowBox[{"Sin", "[", "x", "]"}]}], HoldForm]],
       Annotation[#, 
        HoldForm[Cos[$CellContext`x] Sin[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Cos", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox[
         RowBox[{"Cos", "[", "x", "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Cos[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 10],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Sin", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 11],
        TagBox[
         RowBox[{"Sin", "[", "x", "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Sin[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 12],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.831299685083074, 2.1975596220996887`}, {
     0.3662599370166148, 1.465039748066459}, {0., 0.7325198740332295}, {
     0.7325198740332296, 0.7325198740332295}, {1.831299685083074, 
     1.465039748066459}, {1.4650397480664592`, 0.7325198740332295}, {
     2.1975596220996887`, 0.7325198740332295}, {3.2963394331495333`, 
     1.465039748066459}, {2.9300794961329184`, 0.7325198740332295}, {
     2.9300794961329184`, 0.}, {3.662599370166148, 0.7325198740332295}, {
     3.662599370166148, 0.}}]& ],
  AspectRatio->NCache[2 Rational[2, 15]^Rational[1, 2], 0.7302967433402214],
  FrameTicks->None,
  ImageMargins->0.,
  ImageSize->{193., Automatic},
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{197, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TreeForm=",
 CellID->1934666496]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["ExpressionTreePlot"], "InlineFormula"],
 " can specify root position:"
}], "ExampleText",
 CellID->1870431580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpressionTreePlot", "[", 
  RowBox[{"expr", ",", "Center"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1205057723],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.7593285240454724`, 1.523623195557607}, {
    0.9975169263654037, 1.9634553266259795`}, {0.8796642621139436, 
    3.047246391036226}, {0., 1.5236231957155826`}, {1.7593285239269905`, 
    0.6439589335348708}, {0.8796642618403215, 2.3696355988533924`*^-10}, {
    2.6389927858401903`, 0.}, {2.521140121844023, 1.963455326420763}, {
    3.5186570480909447`, 1.5236231952416555`}, {4.398321310113681, 
    1.5236231950836798`}, {2.6389927863874343`, 3.0472463907992626`}, {
    3.078824917558415, 3.809057988420091}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 5}, {1, 8}, {2, 3}, {2, 4}, {5, 6}, {5, 7}, {8, 
       9}, {8, 11}, {9, 10}, {11, 12}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Plus", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{
           SuperscriptBox["\[ExponentialE]", "x"], "+", 
           SuperscriptBox["x", "2"], "+", 
           RowBox[{
             RowBox[{"Cos", "[", "x", "]"}], " ", 
             RowBox[{"Sin", "[", "x", "]"}]}]}], HoldForm]],
       Annotation[#, 
        HoldForm[
        E^$CellContext`x + $CellContext`x^2 + 
         Cos[$CellContext`x] Sin[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         SuperscriptBox["\[ExponentialE]", "x"], HoldForm]],
       Annotation[#, 
        HoldForm[E^$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["\[ExponentialE]",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox["\[ExponentialE]", HoldForm]],
       Annotation[#, 
        HoldForm[E], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox[
         SuperscriptBox["x", "2"], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x^2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Times", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox[
         RowBox[{
           RowBox[{"Cos", "[", "x", "]"}], " ", 
           RowBox[{"Sin", "[", "x", "]"}]}], HoldForm]],
       Annotation[#, 
        HoldForm[Cos[$CellContext`x] Sin[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Cos", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox[
         RowBox[{"Cos", "[", "x", "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Cos[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 10],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Sin", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 11],
        TagBox[
         RowBox[{"Sin", "[", "x", "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Sin[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 12],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.7593285240454724`, 1.523623195557607}, {
     0.9975169263654037, 1.9634553266259795`}, {0.8796642621139436, 
     3.047246391036226}, {0., 1.5236231957155826`}, {1.7593285239269905`, 
     0.6439589335348708}, {0.8796642618403215, 2.3696355988533924`*^-10}, {
     2.6389927858401903`, 0.}, {2.521140121844023, 1.963455326420763}, {
     3.5186570480909447`, 1.5236231952416555`}, {4.398321310113681, 
     1.5236231950836798`}, {2.6389927863874343`, 3.0472463907992626`}, {
     3.078824917558415, 3.809057988420091}}]& ],
  AspectRatio->NCache[2 Rational[2, 15]^Rational[1, 2], 0.7302967433402214],
  FrameTicks->None,
  ImageSize->{281., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{285, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1588580220]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23910],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TreeForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TreeForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TreePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TreePlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1989491363]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18957],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->24801]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->1028483359],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExpressionTreePlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 7.5228688}", "context" -> 
    "GraphUtilities`", "keywords" -> {"expression tree tree plot"}, "index" -> 
    True, "label" -> "Graph Utilities Package Symbol", "language" -> "en", 
    "paclet" -> "GraphUtilities Package", "status" -> "None", "summary" -> 
    "ExpressionTree[e] plots the expression tree of e. ExpressionTreePlot[e, \
pos] plots the expression tree of e with its root placed at position pos. \
ExpressionTreePlot[e, pos, lev] plots the expression tree of e up to level \
lev with its root placed at position pos.", "synonyms" -> {}, "title" -> 
    "ExpressionTreePlot", "type" -> "Symbol", "uri" -> 
    "GraphUtilities/ref/ExpressionTreePlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4827, 159, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->346746561]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 128686, 3612}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1887, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2510, 75, 78, 1, 70, "ObjectName",
 CellID->31079],
Cell[2591, 78, 1427, 45, 70, "Usage",
 CellID->2703]
}, Open  ]],
Cell[CellGroupData[{
Cell[4055, 128, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4533, 145, 257, 9, 70, "Notes",
 CellID->300046863]
}, Closed]],
Cell[CellGroupData[{
Cell[4827, 159, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->346746561],
Cell[CellGroupData[{
Cell[5212, 173, 148, 5, 70, "ExampleSection",
 CellID->341004404],
Cell[5363, 180, 139, 4, 70, "Input",
 CellID->280857217],
Cell[5505, 186, 150, 4, 70, "ExampleText",
 CellID->5097],
Cell[CellGroupData[{
Cell[5680, 194, 274, 9, 28, "Input",
 CellID->16512],
Cell[5957, 205, 9069, 251, 153, "Output",
 CellID->760023925]
}, Open  ]],
Cell[15041, 459, 105, 2, 70, "ExampleText",
 CellID->1108291180],
Cell[CellGroupData[{
Cell[15171, 465, 323, 11, 70, "Input",
 CellID->638430509],
Cell[15497, 478, 8012, 221, 70, "Output",
 CellID->1009040438]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23558, 705, 221, 7, 70, "ExampleSection",
 CellID->1877069017],
Cell[23782, 714, 369, 13, 70, "ExampleText",
 CellID->1377026911],
Cell[24154, 729, 140, 4, 70, "Input",
 CellID->2042614859],
Cell[CellGroupData[{
Cell[24319, 737, 178, 5, 70, "Input",
 CellID->87413592],
Cell[24500, 744, 3766, 109, 70, "Output",
 CellID->1770658771]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28315, 859, 223, 7, 70, "ExampleSection",
 CellID->1477999851],
Cell[28541, 868, 159, 4, 70, "ExampleText",
 CellID->731129807],
Cell[28703, 874, 139, 4, 70, "Input",
 CellID->343805533],
Cell[CellGroupData[{
Cell[28867, 882, 395, 13, 70, "Input",
 CellID->1899889660],
Cell[29265, 897, 13767, 373, 70, "Output",
 CellID->1920953111]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[43081, 1276, 227, 7, 70, "ExampleSection",
 CellID->800150908],
Cell[43311, 1285, 68, 1, 70, "ExampleText",
 CellID->134501579],
Cell[43382, 1288, 139, 4, 70, "Input",
 CellID->730833356],
Cell[CellGroupData[{
Cell[43546, 1296, 335, 11, 70, "Input",
 CellID->914122792],
Cell[43884, 1309, 12384, 322, 70, "Output",
 CellID->1169704000]
}, Open  ]],
Cell[56283, 1634, 66, 1, 70, "ExampleText",
 CellID->25451541],
Cell[CellGroupData[{
Cell[56374, 1639, 433, 12, 70, "Input",
 CellID->2112586847],
Cell[56810, 1653, 48953, 1281, 70, "Output",
 CellID->1187244897]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[105812, 2940, 237, 7, 70, "ExampleSection",
 CellID->593713242],
Cell[106052, 2949, 140, 4, 70, "Input",
 CellID->1594516220],
Cell[106195, 2955, 270, 8, 70, "ExampleText",
 CellID->1775324560],
Cell[106468, 2965, 284, 10, 70, "Input",
 CellID->1875542353],
Cell[CellGroupData[{
Cell[106777, 2979, 107, 3, 70, "Input",
 CellID->629840852],
Cell[106887, 2984, 9130, 253, 70, "Output",
 CellID->1934666496]
}, Open  ]],
Cell[116032, 3240, 141, 4, 70, "ExampleText",
 CellID->1870431580],
Cell[CellGroupData[{
Cell[116198, 3248, 146, 4, 70, "Input",
 CellID->1205057723],
Cell[116347, 3254, 9154, 252, 70, "Output",
 CellID->1588580220]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[125562, 3513, 311, 9, 70, "SeeAlsoSection",
 CellID->23910],
Cell[125876, 3524, 456, 17, 70, "SeeAlso",
 CellID->1989491363]
}, Open  ]],
Cell[CellGroupData[{
Cell[126369, 3546, 314, 9, 70, "TutorialsSection",
 CellID->18957],
Cell[126686, 3557, 163, 3, 70, "Tutorials",
 CellID->24801]
}, Open  ]],
Cell[CellGroupData[{
Cell[126886, 3565, 320, 9, 70, "MoreAboutSection",
 CellID->1028483359],
Cell[127209, 3576, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[127398, 3583, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

