(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     54925,       1603]
NotebookOptionsPosition[     49382,       1414]
NotebookOutlinePosition[     50835,       1454]
CellTagsIndexPosition[     50749,       1449]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphCoordinates3D" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/GraphCoordinates3D"], "VertexList" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/VertexList"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GraphCoordinates3D\"\>", 
       2->"\<\"VertexList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GraphCoordinates", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GraphCoordinates", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["options", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]calculates a visually appealing 2D layout of the \
vertices of the graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " and returns the coordinates of the vertices."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["GraphCoordinates"], "InlineFormula"],
 " returns the coordinates of the vertices as computed using a graph drawing \
algorithm. It is useful when the coordinates of the vertices are needed, \
rather than a drawing of the graph, or when one needs to draw a graph \
repeatedly using the same layout but different style."
}], "Notes",
 CellID->996693321],

Cell[TextData[{
 Cell[BoxData["GraphCoordinates"], "InlineFormula"],
 " accepts the same options as ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->462235767],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->209143349],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->169314463],

Cell["This plots a graph:", "Notes",
 CellID->300553277],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"10", "\[Rule]", "11"}], ",", 
     RowBox[{"11", "\[Rule]", "12"}], ",", 
     RowBox[{"12", "\[Rule]", "7"}], ",", 
     RowBox[{"1", "\[Rule]", "7"}], ",", 
     RowBox[{"2", "\[Rule]", "8"}], ",", 
     RowBox[{"3", "\[Rule]", "9"}], ",", 
     RowBox[{"4", "\[Rule]", "10"}], ",", 
     RowBox[{"5", "\[Rule]", "11"}], ",", 
     RowBox[{"6", "\[Rule]", "12"}], ",", 
     RowBox[{"7", "\[Rule]", "13"}], ",", 
     RowBox[{"9", "\[Rule]", "13"}], ",", 
     RowBox[{"11", "\[Rule]", "13"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}], ",", 
     RowBox[{"8", "\[Rule]", "9"}], ",", 
     RowBox[{"9", "\[Rule]", "10"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1262698933],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", "g", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->964060317],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.5204017052454, 0.0475667629182976}, {
    2.71048552807284, 1.10946721384445}, {2.19056735780271, 
    2.11208475685359}, {1.20651991492417, 1.6071153596889}, {0.4650206714862, 
    1.99552304602094}, {0., 0.934279107694042}, {0.640207391529389, 
    0.762153597698539}, {0.705102208648647, 0.}, {1.40890983979502, 
    0.0471333378864375}, {1.89042461310716, 0.235582073071872}, {
    2.20302987010773, 1.45439754859347}, {1.50780526551756, 
    2.3889321027749}, {1.84499003033791, 0.885128543209283}}, {
     {RGBColor[0.647058823529412, 0.121965362020294, 0.], LineBox[{1, 2}], 
      LineBox[{2, 3}], LineBox[{2, 13}], LineBox[{3, 4}], LineBox[{4, 13}], 
      LineBox[{4, 7}], LineBox[{5, 4}], LineBox[{5, 6}], LineBox[{6, 7}], 
      LineBox[{6, 8}], LineBox[{7, 9}], LineBox[{8, 9}], LineBox[{8, 10}], 
      LineBox[{9, 13}], LineBox[{9, 1}], LineBox[{10, 1}], LineBox[{10, 11}], 
      LineBox[{11, 2}], LineBox[{11, 12}], LineBox[{12, 3}], 
      LineBox[{12, 5}]}, 
     {RGBColor[1., 0.905455100328069, 0.421469443808652], EdgeForm[RGBColor[
      0.447959105821317, 0.084443427176318, 0.]], 
      TagBox[
       TooltipBox[DiskBox[1, 0.032174],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[DiskBox[2, 0.032174],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[DiskBox[3, 0.032174],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[DiskBox[4, 0.032174],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[DiskBox[5, 0.032174],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[DiskBox[6, 0.032174],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[DiskBox[7, 0.032174],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[DiskBox[8, 0.032174],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[DiskBox[9, 0.032174],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[DiskBox[10, 0.032174],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[DiskBox[11, 0.032174],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[DiskBox[12, 0.032174],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[DiskBox[13, 0.032174],
        "13"],
       Annotation[#, 13, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.5204017052454, 0.0475667629182976}, {
     2.71048552807284, 1.10946721384445}, {2.19056735780271, 
     2.11208475685359}, {1.20651991492417, 1.6071153596889}, {0.4650206714862,
      1.99552304602094}, {0., 0.934279107694042}, {0.640207391529389, 
     0.762153597698539}, {0.705102208648647, 0.}, {1.40890983979502, 
     0.0471333378864375}, {1.89042461310716, 0.235582073071872}, {
     2.20302987010773, 1.45439754859347}, {1.50780526551756, 
     2.3889321027749}, {1.84499003033791, 0.885128543209283}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1557591525]
}, Open  ]],

Cell["\<\
This gives the coordinates of the vertices in the previous drawing:\
\>", "Notes",
 CellID->1556303008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coords", "=", 
  RowBox[{"GraphCoordinates", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1350283272],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2.5204017052453995`", ",", "0.047566762918297645`"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"2.710485528072843`", ",", "1.109467213844454`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.19056735780271`", ",", "2.112084756853589`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2065199149241677`", ",", "1.6071153596889034`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4650206714861995`", ",", "1.995523046020941`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.934279107694042`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6402073915293885`", ",", "0.7621535976985391`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7051022086486474`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.408909839795017`", ",", "0.047133337886437476`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"1.8904246131071645`", ",", "0.23558207307187184`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"2.203029870107729`", ",", "1.4543975485934673`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.50780526551756`", ",", "2.3889321027749038`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.8449900303379148`", ",", "0.885128543209283`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{538, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->422193698]
}, Open  ]],

Cell["\<\
This plots the graph with two different styles, using the layout already \
calculated:\
\>", "Notes",
 CellID->2044539646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"GraphPlot", "[", 
     RowBox[{"g", ",", 
      RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
      RowBox[{"VertexCoordinateRules", "\[Rule]", "coords"}]}], "]"}], ",", 
    RowBox[{"GraphPlot", "[", 
     RowBox[{"g", ",", 
      RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
      RowBox[{"VertexCoordinateRules", "\[Rule]", "coords"}]}], "]"}]}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->893076608],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{2.5204017052454, 0.0475667629182976}, {
      2.71048552807284, 1.10946721384445}, {2.19056735780271, 
      2.11208475685359}, {1.20651991492417, 1.6071153596889}, {
      0.4650206714862, 1.99552304602094}, {0., 0.934279107694042}, {
      0.640207391529389, 0.762153597698539}, {0.705102208648647, 0.}, {
      1.40890983979502, 0.0471333378864375}, {1.89042461310716, 
      0.235582073071872}, {2.20302987010773, 1.45439754859347}, {
      1.50780526551756, 2.3889321027749}, {1.84499003033791, 
      0.885128543209283}}, {
       {RGBColor[0.647058823529412, 0.121965362020294, 0.], LineBox[{1, 2}], 
        LineBox[{2, 3}], LineBox[{2, 13}], LineBox[{3, 4}], LineBox[{4, 13}], 
        LineBox[{4, 7}], LineBox[{5, 4}], LineBox[{5, 6}], LineBox[{6, 7}], 
        LineBox[{6, 8}], LineBox[{7, 9}], LineBox[{8, 9}], LineBox[{8, 10}], 
        LineBox[{9, 13}], LineBox[{9, 1}], LineBox[{10, 1}], 
        LineBox[{10, 11}], LineBox[{11, 2}], LineBox[{11, 12}], 
        LineBox[{12, 3}], LineBox[{12, 5}]}, {InsetBox[
         FrameBox["10",
          Background->RGBColor[1, 1, 0.8],
          
          FrameStyle->RGBColor[
           0.904982070649271, 0.595727473868925, 0.0308079652094301],
          StripOnInput->False], 1], InsetBox[
         FrameBox["11",
          Background->RGBColor[1, 1, 0.8],
          
          FrameStyle->RGBColor[
           0.904982070649271, 0.595727473868925, 0.0308079652094301],
          StripOnInput->False], 2], InsetBox[
         FrameBox["12",
          Background->RGBColor[1, 1, 0.8],
          
          FrameStyle->RGBColor[
           0.904982070649271, 0.595727473868925, 0.0308079652094301],
          StripOnInput->False], 3], InsetBox[
         FrameBox["7",
          Background->RGBColor[1, 1, 0.8],
          
          FrameStyle->RGBColor[
           0.904982070649271, 0.595727473868925, 0.0308079652094301],
          StripOnInput->False], 4], InsetBox[
         FrameBox["1",
          Background->RGBColor[1, 1, 0.8],
          
          FrameStyle->RGBColor[
           0.904982070649271, 0.595727473868925, 0.0308079652094301],
          StripOnInput->False], 5], InsetBox[
         FrameBox["2",
          Background->RGBColor[1, 1, 0.8],
          
          FrameStyle->RGBColor[
           0.904982070649271, 0.595727473868925, 0.0308079652094301],
          StripOnInput->False], 6], InsetBox[
         FrameBox["8",
          Background->RGBColor[1, 1, 0.8],
          
          FrameStyle->RGBColor[
           0.904982070649271, 0.595727473868925, 0.0308079652094301],
          StripOnInput->False], 7], InsetBox[
         FrameBox["3",
          Background->RGBColor[1, 1, 0.8],
          
          FrameStyle->RGBColor[
           0.904982070649271, 0.595727473868925, 0.0308079652094301],
          StripOnInput->False], 8], InsetBox[
         FrameBox["9",
          Background->RGBColor[1, 1, 0.8],
          
          FrameStyle->RGBColor[
           0.904982070649271, 0.595727473868925, 0.0308079652094301],
          StripOnInput->False], 9], InsetBox[
         FrameBox["4",
          Background->RGBColor[1, 1, 0.8],
          
          FrameStyle->RGBColor[
           0.904982070649271, 0.595727473868925, 0.0308079652094301],
          StripOnInput->False], 10], InsetBox[
         FrameBox["5",
          Background->RGBColor[1, 1, 0.8],
          
          FrameStyle->RGBColor[
           0.904982070649271, 0.595727473868925, 0.0308079652094301],
          StripOnInput->False], 11], InsetBox[
         FrameBox["6",
          Background->RGBColor[1, 1, 0.8],
          
          FrameStyle->RGBColor[
           0.904982070649271, 0.595727473868925, 0.0308079652094301],
          StripOnInput->False], 12], InsetBox[
         FrameBox["13",
          Background->RGBColor[1, 1, 0.8],
          
          FrameStyle->RGBColor[
           0.904982070649271, 0.595727473868925, 0.0308079652094301],
          StripOnInput->False], 13]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{2.5204017052454, 0.0475667629182976}, {
       2.71048552807284, 1.10946721384445}, {2.19056735780271, 
       2.11208475685359}, {1.20651991492417, 1.6071153596889}, {
       0.4650206714862, 1.99552304602094}, {0., 0.934279107694042}, {
       0.640207391529389, 0.762153597698539}, {0.705102208648647, 0.}, {
       1.40890983979502, 0.0471333378864375}, {1.89042461310716, 
       0.235582073071872}, {2.20302987010773, 1.45439754859347}, {
       1.50780526551756, 2.3889321027749}, {1.84499003033791, 
       0.885128543209283}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], "\[InvisibleSpace]", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{2.5204017052454, 0.0475667629182976}, {
      2.71048552807284, 1.10946721384445}, {2.19056735780271, 
      2.11208475685359}, {1.20651991492417, 1.6071153596889}, {
      0.4650206714862, 1.99552304602094}, {0., 0.934279107694042}, {
      0.640207391529389, 0.762153597698539}, {0.705102208648647, 0.}, {
      1.40890983979502, 0.0471333378864375}, {1.89042461310716, 
      0.235582073071872}, {2.20302987010773, 1.45439754859347}, {
      1.50780526551756, 2.3889321027749}, {1.84499003033791, 
      0.885128543209283}}, {
       {RGBColor[0.647058823529412, 0.121965362020294, 0.], 
        Arrowheads[{{0.0301638519883368, 0.8}}], ArrowBox[{1, 2}], 
        ArrowBox[{2, 3}], ArrowBox[{2, 13}], ArrowBox[{3, 4}], 
        ArrowBox[{4, 13}], ArrowBox[{4, 7}], ArrowBox[{5, 4}], 
        ArrowBox[{5, 6}], ArrowBox[{6, 7}], ArrowBox[{6, 8}], 
        ArrowBox[{7, 9}], ArrowBox[{8, 9}], ArrowBox[{8, 10}], 
        ArrowBox[{9, 13}], ArrowBox[{9, 1}], ArrowBox[{10, 1}], 
        ArrowBox[{10, 11}], ArrowBox[{11, 2}], ArrowBox[{11, 12}], 
        ArrowBox[{12, 3}], ArrowBox[{12, 5}]}, 
       {RGBColor[1., 0.905455100328069, 0.421469443808652], EdgeForm[RGBColor[
        0.447959105821317, 0.084443427176318, 0.]], 
        TagBox[
         TooltipBox[DiskBox[1, 0.032174],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[DiskBox[2, 0.032174],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[DiskBox[3, 0.032174],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[DiskBox[4, 0.032174],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[DiskBox[5, 0.032174],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[DiskBox[6, 0.032174],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[DiskBox[7, 0.032174],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[DiskBox[8, 0.032174],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[DiskBox[9, 0.032174],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[DiskBox[10, 0.032174],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[DiskBox[11, 0.032174],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[DiskBox[12, 0.032174],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[DiskBox[13, 0.032174],
          "13"],
         Annotation[#, 13, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{2.5204017052454, 0.0475667629182976}, {
       2.71048552807284, 1.10946721384445}, {2.19056735780271, 
       2.11208475685359}, {1.20651991492417, 1.6071153596889}, {
       0.4650206714862, 1.99552304602094}, {0., 0.934279107694042}, {
       0.640207391529389, 0.762153597698539}, {0.705102208648647, 0.}, {
       1.40890983979502, 0.0471333378864375}, {1.89042461310716, 
       0.235582073071872}, {2.20302987010773, 1.45439754859347}, {
       1.50780526551756, 2.3889321027749}, {1.84499003033791, 
       0.885128543209283}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}],
  Row[{
    Graphics[
     Annotation[
      GraphicsComplex[{{2.5204017052454, 0.0475667629182976}, {
       2.71048552807284, 1.10946721384445}, {2.19056735780271, 
       2.11208475685359}, {1.20651991492417, 1.6071153596889}, {
       0.4650206714862, 1.99552304602094}, {0., 0.934279107694042}, {
       0.640207391529389, 0.762153597698539}, {0.705102208648647, 0.}, {
       1.40890983979502, 0.0471333378864375}, {1.89042461310716, 
       0.235582073071872}, {2.20302987010773, 1.45439754859347}, {
       1.50780526551756, 2.3889321027749}, {1.84499003033791, 
       0.885128543209283}}, {{
         RGBColor[0.647058823529412, 0.121965362020294, 0.], 
         Line[{1, 2}], 
         Line[{2, 3}], 
         Line[{2, 13}], 
         Line[{3, 4}], 
         Line[{4, 13}], 
         Line[{4, 7}], 
         Line[{5, 4}], 
         Line[{5, 6}], 
         Line[{6, 7}], 
         Line[{6, 8}], 
         Line[{7, 9}], 
         Line[{8, 9}], 
         Line[{8, 10}], 
         Line[{9, 13}], 
         Line[{9, 1}], 
         Line[{10, 1}], 
         Line[{10, 11}], 
         Line[{11, 2}], 
         Line[{11, 12}], 
         Line[{12, 3}], 
         Line[{12, 5}]}, {
         Text[
          Framed[
          10, {"Background" -> RGBColor[1, 1, 0.8], "FrameStyle" -> 
            RGBColor[
             0.904982070649271, 0.595727473868925, 0.0308079652094301]}], 1], 
         
         Text[
          Framed[
          11, {"Background" -> RGBColor[1, 1, 0.8], "FrameStyle" -> 
            RGBColor[
             0.904982070649271, 0.595727473868925, 0.0308079652094301]}], 2], 
         
         Text[
          Framed[
          12, {"Background" -> RGBColor[1, 1, 0.8], "FrameStyle" -> 
            RGBColor[
             0.904982070649271, 0.595727473868925, 0.0308079652094301]}], 3], 
         
         Text[
          Framed[
          7, {"Background" -> RGBColor[1, 1, 0.8], "FrameStyle" -> 
            RGBColor[
             0.904982070649271, 0.595727473868925, 0.0308079652094301]}], 4], 
         
         Text[
          Framed[
          1, {"Background" -> RGBColor[1, 1, 0.8], "FrameStyle" -> 
            RGBColor[
             0.904982070649271, 0.595727473868925, 0.0308079652094301]}], 5], 
         
         Text[
          Framed[
          2, {"Background" -> RGBColor[1, 1, 0.8], "FrameStyle" -> 
            RGBColor[
             0.904982070649271, 0.595727473868925, 0.0308079652094301]}], 6], 
         
         Text[
          Framed[
          8, {"Background" -> RGBColor[1, 1, 0.8], "FrameStyle" -> 
            RGBColor[
             0.904982070649271, 0.595727473868925, 0.0308079652094301]}], 7], 
         
         Text[
          Framed[
          3, {"Background" -> RGBColor[1, 1, 0.8], "FrameStyle" -> 
            RGBColor[
             0.904982070649271, 0.595727473868925, 0.0308079652094301]}], 8], 
         
         Text[
          Framed[
          9, {"Background" -> RGBColor[1, 1, 0.8], "FrameStyle" -> 
            RGBColor[
             0.904982070649271, 0.595727473868925, 0.0308079652094301]}], 9], 
         
         Text[
          Framed[
          4, {"Background" -> RGBColor[1, 1, 0.8], "FrameStyle" -> 
            RGBColor[
             0.904982070649271, 0.595727473868925, 0.0308079652094301]}], 10],
          
         Text[
          Framed[
          5, {"Background" -> RGBColor[1, 1, 0.8], "FrameStyle" -> 
            RGBColor[
             0.904982070649271, 0.595727473868925, 0.0308079652094301]}], 11],
          
         Text[
          Framed[
          6, {"Background" -> RGBColor[1, 1, 0.8], "FrameStyle" -> 
            RGBColor[
             0.904982070649271, 0.595727473868925, 0.0308079652094301]}], 12],
          
         Text[
          Framed[
          13, {"Background" -> RGBColor[1, 1, 0.8], "FrameStyle" -> 
            RGBColor[
             0.904982070649271, 0.595727473868925, 0.0308079652094301]}], 
          13]}}], VertexCoordinateRules -> {{2.5204017052454, 
       0.0475667629182976}, {2.71048552807284, 1.10946721384445}, {
       2.19056735780271, 2.11208475685359}, {1.20651991492417, 
       1.6071153596889}, {0.4650206714862, 1.99552304602094}, {0., 
       0.934279107694042}, {0.640207391529389, 0.762153597698539}, {
       0.705102208648647, 0.}, {1.40890983979502, 0.0471333378864375}, {
       1.89042461310716, 0.235582073071872}, {2.20302987010773, 
       1.45439754859347}, {1.50780526551756, 2.3889321027749}, {
       1.84499003033791, 0.885128543209283}}], FrameTicks -> None, PlotRange -> 
     All, PlotRangePadding -> Scaled[0.1], AspectRatio -> Automatic], 
    Graphics[
     Annotation[
      GraphicsComplex[{{2.5204017052454, 0.0475667629182976}, {
       2.71048552807284, 1.10946721384445}, {2.19056735780271, 
       2.11208475685359}, {1.20651991492417, 1.6071153596889}, {
       0.4650206714862, 1.99552304602094}, {0., 0.934279107694042}, {
       0.640207391529389, 0.762153597698539}, {0.705102208648647, 0.}, {
       1.40890983979502, 0.0471333378864375}, {1.89042461310716, 
       0.235582073071872}, {2.20302987010773, 1.45439754859347}, {
       1.50780526551756, 2.3889321027749}, {1.84499003033791, 
       0.885128543209283}}, {{
         RGBColor[0.647058823529412, 0.121965362020294, 0.], 
         Arrowheads[{{0.0301638519883368, 0.8}}], 
         Arrow[{1, 2}], 
         Arrow[{2, 3}], 
         Arrow[{2, 13}], 
         Arrow[{3, 4}], 
         Arrow[{4, 13}], 
         Arrow[{4, 7}], 
         Arrow[{5, 4}], 
         Arrow[{5, 6}], 
         Arrow[{6, 7}], 
         Arrow[{6, 8}], 
         Arrow[{7, 9}], 
         Arrow[{8, 9}], 
         Arrow[{8, 10}], 
         Arrow[{9, 13}], 
         Arrow[{9, 1}], 
         Arrow[{10, 1}], 
         Arrow[{10, 11}], 
         Arrow[{11, 2}], 
         Arrow[{11, 12}], 
         Arrow[{12, 3}], 
         Arrow[{12, 5}]}, {
         EdgeForm[
          RGBColor[0.447959105821317, 0.084443427176318, 0.]], 
         RGBColor[1., 0.905455100328069, 0.421469443808652], 
         Tooltip[
          Disk[1, 0.0321740785445149], 10], 
         Tooltip[
          Disk[2, 0.0321740785445149], 11], 
         Tooltip[
          Disk[3, 0.0321740785445149], 12], 
         Tooltip[
          Disk[4, 0.0321740785445149], 7], 
         Tooltip[
          Disk[5, 0.0321740785445149], 1], 
         Tooltip[
          Disk[6, 0.0321740785445149], 2], 
         Tooltip[
          Disk[7, 0.0321740785445149], 8], 
         Tooltip[
          Disk[8, 0.0321740785445149], 3], 
         Tooltip[
          Disk[9, 0.0321740785445149], 9], 
         Tooltip[
          Disk[10, 0.0321740785445149], 4], 
         Tooltip[
          Disk[11, 0.0321740785445149], 5], 
         Tooltip[
          Disk[12, 0.0321740785445149], 6], 
         Tooltip[
          Disk[13, 0.0321740785445149], 13]}}], 
      VertexCoordinateRules -> {{2.5204017052454, 0.0475667629182976}, {
       2.71048552807284, 1.10946721384445}, {2.19056735780271, 
       2.11208475685359}, {1.20651991492417, 1.6071153596889}, {
       0.4650206714862, 1.99552304602094}, {0., 0.934279107694042}, {
       0.640207391529389, 0.762153597698539}, {0.705102208648647, 0.}, {
       1.40890983979502, 0.0471333378864375}, {1.89042461310716, 
       0.235582073071872}, {2.20302987010773, 1.45439754859347}, {
       1.50780526551756, 2.3889321027749}, {1.84499003033791, 
       0.885128543209283}}], FrameTicks -> None, PlotRange -> All, 
     PlotRangePadding -> Scaled[0.1], AspectRatio -> Automatic]}]]], "Output",\

 ImageSize->{364, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->601358520]
}, Open  ]],

Cell["\<\
The relationship between vertices and coordinates is given by the following:\
\>", "Notes",
 CellID->564073450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"Rule", "[", 
   RowBox[{
    RowBox[{"VertexList", "[", "g", "]"}], ",", "coords"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1247042406],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"10", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2.5204017052453995`", ",", "0.047566762918297645`"}], "}"}]}], 
   ",", 
   RowBox[{"11", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2.710485528072843`", ",", "1.109467213844454`"}], "}"}]}], ",", 
   
   RowBox[{"12", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2.19056735780271`", ",", "2.112084756853589`"}], "}"}]}], ",", 
   RowBox[{"7", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.2065199149241677`", ",", "1.6071153596889034`"}], "}"}]}], 
   ",", 
   RowBox[{"1", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.4650206714861995`", ",", "1.995523046020941`"}], "}"}]}], ",",
    
   RowBox[{"2", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.`", ",", "0.934279107694042`"}], "}"}]}], ",", 
   RowBox[{"8", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.6402073915293885`", ",", "0.7621535976985391`"}], "}"}]}], 
   ",", 
   RowBox[{"3", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.7051022086486474`", ",", "0.`"}], "}"}]}], ",", 
   RowBox[{"9", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.408909839795017`", ",", "0.047133337886437476`"}], "}"}]}], 
   ",", 
   RowBox[{"4", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.8904246131071645`", ",", "0.23558207307187184`"}], "}"}]}], 
   ",", 
   RowBox[{"5", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2.203029870107729`", ",", "1.4543975485934673`"}], "}"}]}], ",",
    
   RowBox[{"6", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.50780526551756`", ",", "2.3889321027749038`"}], "}"}]}], ",", 
   
   RowBox[{"13", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.8449900303379148`", ",", "0.885128543209283`"}], "}"}]}]}], 
  "}"}]], "Output",
 ImageSize->{493, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->784038527]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell["\<\
This shows a drawing of a small graph, and the coordinates associated with \
the drawing:\
\>", "ExampleText",
 CellID->863329075],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->1502879501],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"5", "\[Rule]", "4"}], ",", 
     RowBox[{"6", "\[Rule]", "2"}], ",", 
     RowBox[{"6", "\[Rule]", "3"}], ",", 
     RowBox[{"6", "\[Rule]", "5"}], ",", 
     RowBox[{"7", "\[Rule]", "1"}], ",", 
     RowBox[{"7", "\[Rule]", "3"}], ",", 
     RowBox[{"7", "\[Rule]", "4"}], ",", 
     RowBox[{"7", "\[Rule]", "6"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1977973748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->690125725],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.036501778392792, 0.}, {1.1690731639707779`, 
    0.001212502969759166}, {2.1591171605888846`, 1.0132185606387485`}, {
    3.212678181911226, 1.2938098576292074`}, {1.6059139978132668`, 
    1.7039138434713532`}, {1.0523468691746776`, 1.0148265846091196`}, {0., 
    1.2966250642465846`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {3, 4}, {3, 5}, {3, 1}, {6, 7}, {6, 5}, {6, 2}, {6, 
       3}}]}, {InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.036501778392792, 0.}, {1.1690731639707779`, 
     0.001212502969759166}, {2.1591171605888846`, 1.0132185606387485`}, {
     3.212678181911226, 1.2938098576292074`}, {1.6059139978132668`, 
     1.7039138434713532`}, {1.0523468691746776`, 1.0148265846091196`}, {0., 
     1.2966250642465846`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->470563516]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coord", "=", 
  RowBox[{"GraphCoordinates", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->593343161],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2.036501778392792`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1690731639707779`", ",", "0.001212502969759166`"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"2.1591171605888846`", ",", "1.0132185606387485`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.212678181911226`", ",", "1.2938098576292074`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.6059139978132668`", ",", "1.7039138434713532`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.0523468691746776`", ",", "1.0148265846091196`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "1.2966250642465846`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{510, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->778524839]
}, Open  ]],

Cell["\<\
This shows the relationship between vertex labels and their coordinates:\
\>", "ExampleText",
 CellID->488465475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"VertexList", "[", "g", "]"}], "->", "coord"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1404644165],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"5", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2.036501778392792`", ",", "0.`"}], "}"}]}], ",", 
   RowBox[{"4", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.1690731639707779`", ",", "0.001212502969759166`"}], "}"}]}], 
   ",", 
   RowBox[{"6", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2.1591171605888846`", ",", "1.0132185606387485`"}], "}"}]}], 
   ",", 
   RowBox[{"2", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"3.212678181911226`", ",", "1.2938098576292074`"}], "}"}]}], ",",
    
   RowBox[{"3", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.6059139978132668`", ",", "1.7039138434713532`"}], "}"}]}], 
   ",", 
   RowBox[{"7", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.0523468691746776`", ",", "1.0148265846091196`"}], "}"}]}], 
   ",", 
   RowBox[{"1", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.`", ",", "1.2966250642465846`"}], "}"}]}]}], "}"}]], "Output",\

 ImageSize->{444, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->479693197]
}, Open  ]],

Cell["\<\
The coordinates can be reused to create the drawing without recomputing:\
\>", "ExampleText",
 CellID->1759645250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", "coord"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->699172915],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.036501778392792, 0.}, {1.1690731639707779`, 
    0.001212502969759166}, {2.1591171605888846`, 1.0132185606387485`}, {
    3.212678181911226, 1.2938098576292074`}, {1.6059139978132668`, 
    1.7039138434713532`}, {1.0523468691746776`, 1.0148265846091196`}, {0., 
    1.2966250642465846`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {3, 4}, {3, 5}, {3, 1}, {6, 7}, {6, 5}, {6, 2}, {6, 
       3}}]}, {InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.036501778392792, 0.}, {1.1690731639707779`, 
     0.001212502969759166}, {2.1591171605888846`, 1.0132185606387485`}, {
     3.212678181911226, 1.2938098576292074`}, {1.6059139978132668`, 
     1.7039138434713532`}, {1.0523468691746776`, 1.0148265846091196`}, {0., 
     1.2966250642465846`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{191., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{195, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1342189820]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[TextData[{
 "This shows the ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " of a directed graph:"
}], "ExampleText",
 CellID->1420315704],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->49060918],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "3"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1327739138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1081758619],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxliHsw1AkAx42ux9DJFZVnq2wPU9E7wrejWsPlXXeKvCaKiJn2RGEPeUw1
HQpTrvMoUl0pXTrkZ09zLItssc52bBvWPv1+i7Ve6+7+7O4z853PfD9WYed9
T+vq6Oh4/bN//R8Ofn5JfO7/96PdboIv46oR32SXHBe3AJVPQyTTgQ1GtGpe
+UqLT/WMWI+l7UjXOZx26c95OPmVsw518bCBtVlvNW8OguxAwzWsPmyWFt9q
LJsFN8UrwqJgAPnOZdZMjxlkmTqzH2WLEJa8v9aeq8G7Y/HPRZphFFYEH11O
nwIjnp1Zc0cCu7o1YvmxSXwvrp0+nCdDhO9EKN11AlcVaauCPRVwZLvF7bce
R2b6+vfaLiWeLTFeuXGaQo1/+095+iT+WB/AULJJFD4ds5bkklDb2NDWzysR
45uyoDtL4ufXuX3mp+TY55SwTXiEQtb8aC23QoLx8/1PWEwKT6S2jTv4IyiX
VqYPZVIwvhIh8xj7hMWlq5qzMiiUWRjOHTT8iL5Mn4yRBAqX9EICYl5+gHlx
aItOKIWOhGszASV88ISu13pBwSH9voAxwMO0v4YXaUQhO+D4dIyQi1xNyp0X
AyTejTrUez5+g9vt/OGGuyQenqGmww/WwahT9znLn8QB0nnmFPkAnMHR+D33
S1DPEwlOL1pAbfa03+DKGsgNdksKlfNwvJ81GkFrQv6L8U0F7Dnk9Zuu3aVs
QXWzVVHI5VnY7TxpHpX4Fq6OjfZTljPwtdpGpxf24BtLzvITVRpUO6RXuHsL
wD3r8lWO2RToxHbvGJ4QbEsbRgZzEivUQTlR7kPY6sR64lE7jimB9ZZw2gj6
m4393etVMF67PTqqUYySdTclDTUUzjxM9GJZS5DsPRtbXkKCzFvae89XipHH
Ba2zi8bwSzdfy3eTQTd8WX7RUzlKIqQck6VyeDZ7OFkckoLjg31R1+XgdIS0
5LDF2Jjfe4QjkIOZxtgxsGkYv9lUa/aq5PD5uJBkmiDC5Ou+RFItx56rBhHJ
xYPwUgVO7TRUYJ3xy65bRf1oaXGM1zopEBKi3pki6kGg80WxL0uBqXNdN/Ym
dcPg+IoTdnwF2php3GSiDQMGupwCFyX8bxae276xGdwz3rszf1fCOLphYd77
FfjhM3e0x8dQdzrApNGkEvrfrdjgs5KE4jLX3Fk3CNykuUf10RTCig64tSYV
4Dw3ePZipwoqq8YrIWZ5uJUa0GlkOYEe+60deaNXCJVefm05JiFo+9G93vYp
wZQVDcnM1DhpG2DWxmoiRvT19VxK1bAtzY71a2sj1gov7Jl4o4bUfriuQsoj
9r29G0XPUOPCkotBl4L7CJqWHbtsaBIqjjVV7PcXsdj9Wz0mNYHqs0Hsqmoh
sfpViI+QGMcaz9Qjz0xFhCYuzKQjUoXeZJqRoE1EVNo6VL3/gsKyqredi2tE
RGcnf5EwYgwL55r6TXs+ErvmW6NOWShQlphjKnYREjJteKhZoAziuS38E/Yf
CM/msyY0hhS03EPhNAs+ce0HA/q9CQl0PX/dbHC7mwDx+uvD0VIwdtezKlxa
iZ7IysuppTLQ14kfbrneQMhp7QVxKQrstdE+q931gEi94T/XKxjDIGubb4NH
MPE3lIJ+Uw==
    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03384563758389261, 0.7}}], 
      ArrowBox[{1, 2}], 
      ArrowBox[{1, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
       21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 3}], 
      ArrowBox[{1, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45,
        46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 3}], ArrowBox[{2, 3}], 
      ArrowBox[{3, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71,
        72, 73, 74, 75, 76, 77, 78, 79, 3}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3]}}],
   Annotation[#, VertexCoordinateRules -> {{0., 2.}, {0., 1.}, {1., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{123, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->209866893]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["GraphCoordinates"], "InlineFormula"],
 " only returns the position of the vertices:"
}], "ExampleText",
 CellID->461662465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coord", "=", 
  RowBox[{"GraphCoordinates", "[", 
   RowBox[{"g", ",", 
    RowBox[{"Method", "\[Rule]", "\"\<LayeredDigraphDrawing\>\""}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->10859885],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "2.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1386463026]
}, Open  ]],

Cell["\<\
The curved edges between vertices 1 and 3 are not reproduced:\
\>", "ExampleText",
 CellID->2024933293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", "coord"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->813684022],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{130, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->691319412]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphCoordinates3D",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/GraphCoordinates3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VertexList",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/VertexList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->899694816]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GraphCoordinates - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 8.4447674}", "context" -> 
    "GraphUtilities`", 
    "keywords" -> {
     "graph drawing graph plot graph embedding graph layout graph \
visualization network layout draw a graph"}, "index" -> True, "label" -> 
    "Graph Utilities Package Symbol", "language" -> "en", "paclet" -> 
    "GraphUtilities Package", "status" -> "None", "summary" -> 
    "GraphCoordinates[g, options] calculates a visually appealing 2D layout \
of the vertices of the graph g and returns the coordinates of the vertices.", 
    "synonyms" -> {}, "title" -> "GraphCoordinates", "type" -> "Symbol", 
    "uri" -> "GraphUtilities/ref/GraphCoordinates"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4489, 144, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->462235767]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 50606, 1442}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1987, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2610, 78, 59, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2672, 81, 618, 18, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3327, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3805, 121, 382, 7, 70, "Notes",
 CellID->996693321],
Cell[4190, 130, 262, 9, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[4489, 144, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->462235767],
Cell[CellGroupData[{
Cell[4874, 158, 148, 5, 70, "ExampleSection",
 CellID->209143349],
Cell[5025, 165, 139, 4, 70, "Input",
 CellID->169314463],
Cell[5167, 171, 56, 1, 70, "Notes",
 CellID->300553277],
Cell[5226, 174, 1035, 27, 70, "Input",
 CellID->1262698933],
Cell[CellGroupData[{
Cell[6286, 205, 105, 3, 28, "Input",
 CellID->964060317],
Cell[6394, 210, 3392, 88, 180, "Output",
 CellID->1557591525]
}, Open  ]],
Cell[9801, 301, 113, 3, 70, "Notes",
 CellID->1556303008],
Cell[CellGroupData[{
Cell[9939, 308, 141, 4, 70, "Input",
 CellID->1350283272],
Cell[10083, 314, 1395, 37, 88, "Output",
 CellID->422193698]
}, Open  ]],
Cell[11493, 354, 132, 4, 70, "Notes",
 CellID->2044539646],
Cell[CellGroupData[{
Cell[11650, 362, 511, 14, 70, "Input",
 CellID->893076608],
Cell[12164, 378, 15922, 400, 70, "Output",
 CellID->601358520]
}, Open  ]],
Cell[28101, 781, 121, 3, 70, "Notes",
 CellID->564073450],
Cell[CellGroupData[{
Cell[28247, 788, 205, 7, 70, "Input",
 CellID->1247042406],
Cell[28455, 797, 1839, 56, 105, "Output",
 CellID->784038527]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30343, 859, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[30584, 868, 140, 4, 70, "ExampleText",
 CellID->863329075],
Cell[30727, 874, 140, 4, 70, "Input",
 CellID->1502879501],
Cell[30870, 880, 476, 14, 70, "Input",
 CellID->1977973748],
Cell[CellGroupData[{
Cell[31371, 898, 174, 5, 70, "Input",
 CellID->690125725],
Cell[31548, 905, 2140, 52, 117, "Output",
 CellID->470563516]
}, Open  ]],
Cell[CellGroupData[{
Cell[33725, 962, 139, 4, 70, "Input",
 CellID->593343161],
Cell[33867, 968, 821, 22, 54, "Output",
 CellID->778524839]
}, Open  ]],
Cell[34703, 993, 123, 3, 70, "ExampleText",
 CellID->488465475],
Cell[CellGroupData[{
Cell[34851, 1000, 169, 5, 70, "Input",
 CellID->1404644165],
Cell[35023, 1007, 1063, 34, 71, "Output",
 CellID->479693197]
}, Open  ]],
Cell[36101, 1044, 124, 3, 70, "ExampleText",
 CellID->1759645250],
Cell[CellGroupData[{
Cell[36250, 1051, 238, 6, 70, "Input",
 CellID->699172915],
Cell[36491, 1059, 2174, 53, 123, "Output",
 CellID->1342189820]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38714, 1118, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[38948, 1127, 235, 8, 70, "ExampleText",
 CellID->1420315704],
Cell[39186, 1137, 138, 4, 70, "Input",
 CellID->49060918],
Cell[39327, 1143, 350, 11, 70, "Input",
 CellID->1327739138],
Cell[CellGroupData[{
Cell[39702, 1158, 182, 5, 70, "Input",
 CellID->1081758619],
Cell[39887, 1165, 3038, 61, 237, "Output",
 CellID->209866893]
}, Open  ]],
Cell[42940, 1229, 154, 4, 70, "ExampleText",
 CellID->461662465],
Cell[CellGroupData[{
Cell[43119, 1237, 230, 7, 70, "Input",
 CellID->10859885],
Cell[43352, 1246, 374, 13, 36, "Output",
 CellID->1386463026]
}, Open  ]],
Cell[43741, 1262, 113, 3, 70, "ExampleText",
 CellID->2024933293],
Cell[CellGroupData[{
Cell[43879, 1269, 245, 6, 70, "Input",
 CellID->813684022],
Cell[44127, 1277, 3267, 58, 70, "Output",
 Evaluatable->False,
 CellID->691319412]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47455, 1342, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[47774, 1353, 509, 17, 70, "SeeAlso",
 CellID->899694816]
}, Open  ]],
Cell[CellGroupData[{
Cell[48320, 1375, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[48641, 1386, 167, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[48845, 1394, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[49166, 1405, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[49355, 1412, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

