(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33395,       1125]
NotebookOptionsPosition[     27297,        910]
NotebookOutlinePosition[     28734,        952]
CellTagsIndexPosition[     28625,        946]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ClosenessCentrality" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/ClosenessCentrality"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"ClosenessCentrality\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GraphDistance", "ObjectName",
 CellID->24123],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GraphDistance", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the distance from vertex ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " to vertex ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     " in the graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4547]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["GraphDistance"], "InlineFormula"],
 " returns the graph distance from one vertex to another. ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 " is returned if no path exists from ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 ". By default every edge is assumed to have an edge weight of 1."
}], "Notes",
 CellID->1878198478],

Cell["The following options can be used:", "Notes",
 CellID->146861874],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Weighted",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/Weighted"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
specifies whether edge weight is to be used in calculating distance\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->281743273]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->351151398],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->91024474],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->777723757],

Cell["This defines a simple directed graph:", "ExampleText",
 CellID->26962],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "4"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->41],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphPlot", "[", 
   RowBox[{"g", ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
    RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1526141805],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{3.235535709550261, 0.7344718758388544}, {
    2.288198371954813, 0.36756003570982987`}, {3.233584231063214, 
    0.0003506907880122534}, {0.945823179327763, 0.3676721160128335}, {
    0.000653005661036099, 0.}, {0., 0.7350705382052367}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028032205582227264`, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{2, 3}], ArrowBox[{2, 4}], ArrowBox[{3, 1}], 
      ArrowBox[{4, 5}], ArrowBox[{5, 6}], ArrowBox[{6, 4}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{3.235535709550261, 0.7344718758388544}, {
     2.288198371954813, 0.36756003570982987`}, {3.233584231063214, 
     0.0003506907880122534}, {0.945823179327763, 0.3676721160128335}, {
     0.000653005661036099, 0.}, {0., 0.7350705382052367}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageMargins->0.,
  ImageSize->{310., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{314, 76},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1889237541]
}, Open  ]],

Cell["This calculates the distance from vertex 1 to vertex 5:", "ExampleText",
 CellID->9961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphDistance", "[", 
  RowBox[{"g", ",", "1", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->491],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->32391]
}, Open  ]],

Cell["There is no path from vertex 4 to vertex 1:", "ExampleText",
 CellID->11942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphDistance", "[", 
  RowBox[{"g", ",", "4", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->4827],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->153]
}, Open  ]],

Cell["This defines a simple directed graph with edge weights:", "ExampleText",
 CellID->1298501147],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "5"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "4"}], "}"}], "\[Rule]", 
        RowBox[{"-", "2."}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->2089000660],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Arrow", "[", 
         RowBox[{"#", ",", "0.1"}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"g", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"First", "[", "#2", "]"}], ",", 
             RowBox[{"Last", "[", "#2", "]"}]}], "]"}], "]"}], ",", 
          RowBox[{"LineScaledCoordinate", "[", "#1", "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1575166210],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{{
       ArrowBox[{{1.2893252649071054`, 1.5485600106322983`}, {
        1.617753747939871, 0.6043445040754697}}, 0.1], 
       InsetBox["1.`", {1.4535395064234882`, 1.076452257353884},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{1.2893252649071054`, 1.5485600106322983`}, {
        0.2886834314367773, 1.5275030724879717`}}, 0.1], 
       InsetBox["1.`", {0.7890043481719413, 1.538031541560135},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{1.617753747939871, 0.6043445040754697}, {0.8211445524089258,
         0.}}, 0.1], 
       InsetBox["1.`", {1.2194491501743983`, 0.30217225203773485`},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0., 0.5703652293375701}, {0.8211445524089258, 0.}}, 0.1], 
       InsetBox["1.`", {0.4105722762044629, 0.28518261466878503`},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0.2886834314367773, 1.5275030724879717`}, {0., 
        0.5703652293375701}}, 0.1], InsetBox[
        RowBox[{"-", "2.`"}], {0.14434171571838866`, 1.0489341509127708`},
        Background->GrayLevel[1]]}}, 
     GraphicsComplexBox[{{1.2893252649071054`, 1.5485600106322983`}, {
      1.617753747939871, 0.6043445040754697}, {0.8211445524089258, 0.}, {0., 
      0.5703652293375701}, {0.2886834314367773, 
      1.5275030724879717`}}, {InsetBox[
        FrameBox["1",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 1], InsetBox[
        FrameBox["2",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 2], InsetBox[
        FrameBox["3",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 3], InsetBox[
        FrameBox["4",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 4], InsetBox[
        FrameBox["5",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 5]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{1.2893252649071054`, 1.5485600106322983`}, {
     1.617753747939871, 0.6043445040754697}, {0.8211445524089258, 0.}, {0., 
     0.5703652293375701}, {0.2886834314367773, 1.5275030724879717`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1892520116]
}, Open  ]],

Cell["\<\
This shows that the distance from vertex 1 to 3 is 2 if unit edge weights are \
assumed:\
\>", "ExampleText",
 CellID->293357397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphDistance", "[", 
  RowBox[{"g", ",", "1", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1035748563],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->1343388655]
}, Open  ]],

Cell["\<\
But the distance becomes 0 if edge weights are taken into account:\
\>", "ExampleText",
 CellID->2017642325],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphDistance", "[", 
  RowBox[{"g", ",", "1", ",", "3", ",", 
   RowBox[{"Weighted", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->764582277],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->182380023]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10205],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->104982009],

Cell[TextData[{
 "This generates a random directed graph with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " nodes and degree ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->8723],

Cell[BoxData[
 RowBox[{
  RowBox[{"randomGraph", "[", 
   RowBox[{"n_", ",", "d_"}], "]"}], ":=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"Floor", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], "+", 
       FractionBox["d", "n"]}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "n"}], "}"}]}], "]"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14310],

Cell["\<\
Average distance between vertices 1 & 100, of 200 random directed graphs of \
100 vertices and degree 2:\
\>", "ExampleText",
 CellTags->"b:0.4",
 CellID->512290192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"DeleteCases", "[", 
    RowBox[{
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"GraphDistance", "[", 
        RowBox[{
         RowBox[{"randomGraph", "[", 
          RowBox[{"100", ",", "2"}], "]"}], ",", "1", ",", "100"}], "]"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"{", "200", "}"}]}], "]"}], ",", "\[Infinity]"}], "]"}], "]"}],
   "//", "N"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7616],

Cell[BoxData["5.371428571428571`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1269323559]
}, Open  ]],

Cell["\<\
The average distance decreases with an increase in the degree:\
\>", "ExampleText",
 CellID->27529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"degree", ",", 
       RowBox[{"Mean", "[", 
        RowBox[{"DeleteCases", "[", 
         RowBox[{
          RowBox[{"Table", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"GraphDistance", "[", 
             RowBox[{
              RowBox[{"randomGraph", "[", 
               RowBox[{"100", ",", "degree"}], "]"}], ",", "1", ",", "100"}], 
             "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", "200", "}"}]}], "]"}], ",", "\[Infinity]"}], "]"}], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"degree", ",", "2", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<degree\>\"", ",", "\"\<mean distance\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->32609],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{2., 5.67741935483871}, {3., 4.287356321839081}, {4., 
     3.4536082474226806`}, {5., 2.95959595959596}, {6., 2.864321608040201}, {
     7., 2.613065326633166}, {8., 2.45}, {9., 2.265}, {10., 2.26}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"degree\"", TraditionalForm], 
    FormBox["\"mean distance\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  ImageSize->{304., Automatic},
  PlotRange->{{0, 10.}, {0, 5.67741935483871}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{308, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->235525899]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7987],

Cell["This defines a small directed graph:", "ExampleText",
 CellID->881223312],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->351938248],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "5"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", "1."}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "4"}], "}"}], "\[Rule]", 
        RowBox[{"-", "2."}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1060781549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Arrow", "[", 
         RowBox[{"#", ",", "0.1"}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"g", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"First", "[", "#2", "]"}], ",", 
             RowBox[{"Last", "[", "#2", "]"}]}], "]"}], "]"}], ",", 
          RowBox[{"LineScaledCoordinate", "[", "#1", "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->285926919],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{{
       ArrowBox[{{1.289325264907402, 1.548560010632156}, {1.6177537479398811`,
         0.6043445040752278}}, 0.1], 
       InsetBox["1.`", {1.4535395064236416`, 1.0764522573536919`},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{1.289325264907402, 1.548560010632156}, {
        0.28868343143706776`, 1.527503072488133}}, 0.1], 
       InsetBox["1.`", {0.7890043481722349, 1.5380315415601444`},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{1.6177537479398811`, 0.6043445040752278}, {
        0.8211445524087523, 0.}}, 0.1], 
       InsetBox["1.`", {1.2194491501743168`, 0.3021722520376139},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0., 0.5703652293378192}, {0.8211445524087523, 0.}}, 0.1], 
       InsetBox["1.`", {0.41057227620437614`, 0.2851826146689096},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0.28868343143706776`, 1.527503072488133}, {0., 
        0.5703652293378192}}, 0.1], InsetBox[
        RowBox[{"-", "2.`"}], {0.14434171571853388`, 1.0489341509129761`},
        Background->GrayLevel[1]]}}, 
     GraphicsComplexBox[{{1.289325264907402, 1.548560010632156}, {
      1.6177537479398811`, 0.6043445040752278}, {0.8211445524087523, 0.}, {0.,
       0.5703652293378192}, {0.28868343143706776`, 
      1.527503072488133}}, {InsetBox[
        FrameBox["1",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 1], InsetBox[
        FrameBox["2",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 2], InsetBox[
        FrameBox["3",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 3], InsetBox[
        FrameBox["4",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 4], InsetBox[
        FrameBox["5",
         Background->RGBColor[1, 1, 0.8],
         FrameStyle->RGBColor[0.94, 0.85, 0.36],
         StripOnInput->False], 5]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{1.289325264907402, 1.548560010632156}, {
     1.6177537479398811`, 0.6043445040752278}, {0.8211445524087523, 0.}, {0., 
     0.5703652293378192}, {0.28868343143706776`, 1.527503072488133}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->714137357]
}, Open  ]],

Cell["\<\
This shows that the distance between vertices 1 and 3 is 2, assuming a unit \
edge weight:\
\>", "ExampleText",
 CellID->312175542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphDistance", "[", 
  RowBox[{"g", ",", " ", "1", ",", " ", "3"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1041041527],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->139909932]
}, Open  ]],

Cell["\<\
This shows that when edge weights are taking into account, the distance \
between vertices 1 and 3 is 0:\
\>", "ExampleText",
 CellID->1986249575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphDistance", "[", 
  RowBox[{"g", ",", "1", ",", "3", ",", 
   RowBox[{"Weighted", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1568753058],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1909460220]
}, Open  ]],

Cell["\<\
This shows shortest path when edge weights are taking into account:\
\>", "ExampleText",
 CellID->893982927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{"g", ",", " ", "1", ",", " ", "3"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->481408665],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "5", ",", "4", ",", "3"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1428138794]
}, Open  ]],

Cell["This shows shortest path when edge weights are ignored:", "ExampleText",
 CellID->2129440045],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{"g", ",", " ", "1", ",", " ", "3", ",", 
   RowBox[{"Weighted", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->892515739],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1815907589]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22127],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ClosenessCentrality",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/ClosenessCentrality"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->215849882]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4481],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->6687]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->397099769],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GraphDistance - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 9.1791612}", "context" -> 
    "GraphUtilities`", 
    "keywords" -> {"graph geodesic graph distance shortest path"}, "index" -> 
    True, "label" -> "Graph Utilities Package Symbol", "language" -> "en", 
    "paclet" -> "GraphUtilities Package", "status" -> "None", "summary" -> 
    "GraphDistance[g, i, j] gives the distance from vertex i to vertex j in \
the graph g.", "synonyms" -> {}, "title" -> "GraphDistance", "type" -> 
    "Symbol", "uri" -> "GraphUtilities/ref/GraphDistance"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4979, 166, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->351151398]},
 "b:0.4"->{
  Cell[15838, 521, 175, 5, 70, "ExampleText",
   CellTags->"b:0.4",
   CellID->512290192]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28378, 935},
 {"b:0.4", 28510, 939}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1860, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2483, 76, 51, 1, 70, "ObjectName",
 CellID->24123],
Cell[2537, 79, 725, 24, 70, "Usage",
 CellID->4547]
}, Open  ]],
Cell[CellGroupData[{
Cell[3299, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3777, 125, 510, 15, 70, "Notes",
 CellID->1878198478],
Cell[4290, 142, 71, 1, 70, "Notes",
 CellID->146861874],
Cell[4364, 145, 578, 16, 70, "3ColumnTableMod",
 CellID->281743273]
}, Closed]],
Cell[CellGroupData[{
Cell[4979, 166, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->351151398],
Cell[CellGroupData[{
Cell[5364, 180, 147, 5, 70, "ExampleSection",
 CellID->91024474],
Cell[5514, 187, 139, 4, 70, "Input",
 CellID->777723757],
Cell[5656, 193, 76, 1, 70, "ExampleText",
 CellID->26962],
Cell[5735, 196, 426, 13, 70, "Input",
 CellID->41],
Cell[CellGroupData[{
Cell[6186, 213, 272, 8, 47, "Input",
 CellID->1526141805],
Cell[6461, 223, 2026, 48, 97, "Output",
 CellID->1889237541]
}, Open  ]],
Cell[8502, 274, 93, 1, 70, "ExampleText",
 CellID->9961],
Cell[CellGroupData[{
Cell[8620, 279, 136, 4, 70, "Input",
 CellID->491],
Cell[8759, 285, 154, 5, 36, "Output",
 CellID->32391]
}, Open  ]],
Cell[8928, 293, 82, 1, 70, "ExampleText",
 CellID->11942],
Cell[CellGroupData[{
Cell[9035, 298, 137, 4, 70, "Input",
 CellID->4827],
Cell[9175, 304, 162, 5, 36, "Output",
 CellID->153]
}, Open  ]],
Cell[9352, 312, 99, 1, 70, "ExampleText",
 CellID->1298501147],
Cell[9454, 315, 805, 26, 70, "Input",
 CellID->2089000660],
Cell[CellGroupData[{
Cell[10284, 345, 783, 22, 70, "Input",
 CellID->1575166210],
Cell[11070, 369, 2654, 59, 193, "Output",
 CellID->1892520116]
}, Open  ]],
Cell[13739, 431, 139, 4, 70, "ExampleText",
 CellID->293357397],
Cell[CellGroupData[{
Cell[13903, 439, 143, 4, 70, "Input",
 CellID->1035748563],
Cell[14049, 445, 159, 5, 36, "Output",
 CellID->1343388655]
}, Open  ]],
Cell[14223, 453, 118, 3, 70, "ExampleText",
 CellID->2017642325],
Cell[CellGroupData[{
Cell[14366, 460, 192, 5, 70, "Input",
 CellID->764582277],
Cell[14561, 467, 160, 5, 36, "Output",
 CellID->182380023]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14770, 478, 223, 7, 70, "ExampleSection",
 CellID->10205],
Cell[14996, 487, 139, 4, 70, "Input",
 CellID->104982009],
Cell[15138, 493, 240, 9, 70, "ExampleText",
 CellID->8723],
Cell[15381, 504, 454, 15, 70, "Input",
 CellID->14310],
Cell[15838, 521, 175, 5, 70, "ExampleText",
 CellTags->"b:0.4",
 CellID->512290192],
Cell[CellGroupData[{
Cell[16038, 530, 506, 15, 70, "Input",
 CellID->7616],
Cell[16547, 547, 176, 5, 36, "Output",
 CellID->1269323559]
}, Open  ]],
Cell[16738, 555, 109, 3, 70, "ExampleText",
 CellID->27529],
Cell[CellGroupData[{
Cell[16872, 562, 1022, 29, 70, "Input",
 CellID->32609],
Cell[17897, 593, 799, 22, 204, "Output",
 CellID->235525899]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18745, 621, 225, 7, 70, "ExampleSection",
 CellID->7987],
Cell[18973, 630, 79, 1, 70, "ExampleText",
 CellID->881223312],
Cell[19055, 633, 139, 4, 70, "Input",
 CellID->351938248],
Cell[19197, 639, 805, 26, 70, "Input",
 CellID->1060781549],
Cell[CellGroupData[{
Cell[20027, 669, 782, 22, 70, "Input",
 CellID->285926919],
Cell[20812, 693, 2647, 59, 193, "Output",
 CellID->714137357]
}, Open  ]],
Cell[23474, 755, 141, 4, 70, "ExampleText",
 CellID->312175542],
Cell[CellGroupData[{
Cell[23640, 763, 153, 4, 70, "Input",
 CellID->1041041527],
Cell[23796, 769, 158, 5, 36, "Output",
 CellID->139909932]
}, Open  ]],
Cell[23969, 777, 156, 4, 70, "ExampleText",
 CellID->1986249575],
Cell[CellGroupData[{
Cell[24150, 785, 193, 5, 70, "Input",
 CellID->1568753058],
Cell[24346, 792, 161, 5, 36, "Output",
 CellID->1909460220]
}, Open  ]],
Cell[24522, 800, 118, 3, 70, "ExampleText",
 CellID->893982927],
Cell[CellGroupData[{
Cell[24665, 807, 148, 4, 70, "Input",
 CellID->481408665],
Cell[24816, 813, 224, 7, 36, "Output",
 CellID->1428138794]
}, Open  ]],
Cell[25055, 823, 99, 1, 70, "ExampleText",
 CellID->2129440045],
Cell[CellGroupData[{
Cell[25179, 828, 199, 5, 70, "Input",
 CellID->892515739],
Cell[25381, 835, 214, 7, 36, "Output",
 CellID->1815907589]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25656, 849, 311, 9, 70, "SeeAlsoSection",
 CellID->22127],
Cell[25970, 860, 237, 6, 70, "SeeAlso",
 CellID->215849882]
}, Open  ]],
Cell[CellGroupData[{
Cell[26244, 871, 313, 9, 70, "TutorialsSection",
 CellID->4481],
Cell[26560, 882, 162, 3, 70, "Tutorials",
 CellID->6687]
}, Open  ]],
Cell[CellGroupData[{
Cell[26759, 890, 319, 9, 70, "MoreAboutSection",
 CellID->397099769],
Cell[27081, 901, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[27270, 908, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

