(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35685,        936]
NotebookOptionsPosition[     32396,        834]
NotebookOutlinePosition[     34075,        877]
CellTagsIndexPosition[     33990,        872]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/GraphPlot3D"], "GraphPlot" :> 
          Documentation`HelpLookup["paclet:ref/GraphPlot"], 
          "LayeredGraphPlot" :> 
          Documentation`HelpLookup["paclet:ref/LayeredGraphPlot"], "TreePlot" :> 
          Documentation`HelpLookup["paclet:ref/TreePlot"], 
          "EdgeRenderingFunction" :> 
          Documentation`HelpLookup["paclet:ref/EdgeRenderingFunction"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"GraphPlot3D\"\>", 
       2->"\<\"GraphPlot\"\>", 3->"\<\"LayeredGraphPlot\"\>", 
       4->"\<\"TreePlot\"\>", 
       5->"\<\"EdgeRenderingFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LineScaledCoordinate", "ObjectName", "GraphToSparseArray",
 CellID->31079],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LineScaledCoordinate", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["2", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["k", "TI"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["k", "TI"]]}], "}"}]}], "}"}], ",", " ", 
        StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the coordinate of a point in the polyline ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["1", "TR"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["2", "TR"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["k", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["k", "TI"]]}], "}"}]}], "}"}]], "InlineFormula"],
     ", at a scaled distance of ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " from point ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["1", "TR"]]}], "}"}]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"LineScaledCoordinate", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["2", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["k", "TI"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["k", "TI"]]}], "}"}]}], "}"}], "]"}], " "}]], 
      "InlineFormula"],
     "\[LineSeparator]is the same as ",
     Cell[BoxData[
      RowBox[{"LineScaledCoordinate", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["2", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["k", "TI"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["k", "TI"]]}], "}"}]}], "}"}], ",", " ", "0.5"}], 
       "]"}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->2703]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["LineScaledCoordinate"], "InlineFormula"],
 " works for both 2 and 3 dimensions."
}], "Notes",
 CellID->146861874]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->12000540],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->416263423],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->12622998],

Cell["\<\
This displays the vertices that form the edges at a point 60% of the way down \
the arrow:\
\>", "ExampleText",
 CellID->682788706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Arrow", "[", "#1", "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", 
          RowBox[{"LineScaledCoordinate", "[", 
           RowBox[{"#1", ",", "0.6"}], "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->986285025],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{{ArrowBox[{{0., 1.}, {1., 0.}}], InsetBox[
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}], {0.6, 0.4},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0., 1.}, {-0.0257464374963667, 
        1.10298574998547}, {-0.0321573767579265, 
        1.13068035128038}, {-0.0375953616122661, 
        1.1585823118535}, {-0.0420537323679511, 
        1.1866574612441}, {-0.0455270290293531, 
        1.21487141689378}, {-0.0480109979832962, 
        1.2431896262534}, {-0.0495025972082948, 1.27157740909835}, {-0.05, 
        1.3}, {-0.05, 1.7}, {-0.0495025972082948, 
        1.72842259090165}, {-0.0480109979832961, 
        1.7568103737466}, {-0.045527029029353, 
        1.78512858310622}, {-0.0420537323679511, 
        1.8133425387559}, {-0.037595361612266, 
        1.8414176881465}, {-0.0321573767579263, 
        1.86931964871962}, {-0.0257464374963666, 1.89701425001453}, {0., 
        2.}}], InsetBox[
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], {-0.05, 1.601},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0., 1.}, {0.00171051787877904, 0.995679724998559}, {
        0.0212083738092637, 0.914209093644666}, {0.0170829760381494, 
        0.83053943813971}, {-0.0103347715726101, 
        0.751382017293394}, {-0.0588456535597213, 
        0.683086157331604}, {-0.124558544973074, 
        0.631129963656692}, {-0.202202523890647, 
        0.599680914435207}, {-0.285549659357232, 
        0.591261581409205}, {-0.36791456234155, 
        0.606547290927309}, {-0.442690630038464, 
        0.64431195508409}, {-0.503879970619004, 
        0.701526417927034}, {-0.546574502430955, 
        0.773601428245772}, {-0.56734963801761, 
        0.854755749760058}, {-0.564538975014968, 
        0.938479882079083}, {-0.538367960590508, 
        1.01805819673253}, {-0.490935808014024, 
        1.08710760702001}, {-0.426047115857374, 
        1.14008956422515}, {-0.348906695880071, 
        1.17275431226969}, {-0.265702087878143, 
        1.18248176652728}, {-0.183107248557767, 
        1.16849167443575}, {-0.107747224235671, 
        1.13190620063452}, {-0.0456667467095275, 
        1.07565991658647}, {-0.00184537695868389, 1.00426441454153}, {0., 
        1.}}], InsetBox[
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], {-0.55901, 0.95528},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0., 2.}, {0.048359966512659, 1.95164003348734}, {
        0.104550977161747, 1.89544902283825}, {0.168573031947265, 
        1.83142696805274}, {0.240426130869211, 1.75957386913079}, {
        0.320110273927587, 1.67988972607241}, {0.407625461122392, 
        1.59237453887761}, {0.502971692453625, 1.49702830754637}, {
        0.606148967921289, 1.39385103207871}, {0.717157287525381, 
        1.28284271247462}, {0.776519338291659, 1.2185423901034}, {
        0.828897618379551, 1.1513492952007}, {0.874292127789058, 
        1.0812634277665}, {0.912702866520179, 1.00828478780081}, {
        0.944129834572915, 0.932413375303628}, {0.968573031947265, 
        0.853649190274958}, {0.986032458643229, 0.771992232714796}, {
        0.996508114660807, 0.687442502623143}, {1., 0.6}, {1., 
        0.51358024691358}, {1., 0.432098765432099}, {1., 0.355555555555556}, {
        1., 0.283950617283951}, {1., 0.217283950617284}, {1., 
        0.155555555555556}, {1., 0.0987654320987654}, {1., 
        0.0469135802469136}, {1., 0.}}], InsetBox[
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], {0.94, 0.94239},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0., 2.}, {0.0257464374963667, 1.89701425001453}, {
        0.0321573767579265, 1.86931964871962}, {0.0375953616122661, 
        1.8414176881465}, {0.0420537323679511, 1.8133425387559}, {
        0.0455270290293531, 1.78512858310622}, {0.0480109979832962, 
        1.7568103737466}, {0.0495025972082948, 1.72842259090165}, {0.05, 
        1.7}, {0.05, 1.3}, {0.0495025972082948, 1.27157740909835}, {
        0.0480109979832961, 1.2431896262534}, {0.045527029029353, 
        1.21487141689378}, {0.0420537323679511, 1.1866574612441}, {
        0.037595361612266, 1.1585823118535}, {0.0321573767579263, 
        1.13068035128038}, {0.0257464374963666, 1.10298574998547}, {0., 1.}}],
        InsetBox[
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], {0.05, 1.399},
        Background->GrayLevel[1]]}}, GraphicsComplexBox[CompressedData["
1:eJxt1AtQVFUABuDFAlESgkF5hQwIgkYPgV1GAn5eg9DwUGAJSRAUghEJwYIC
0qx4yUNo5R0kIQJOhRqkgM6JJYSMRxkuxaOFXUBeu8AFsXgZ1GGdms6cO3f+
M3fuPWfm/p/+sSiv0E0sFou7dq3f/z1m8J8Fu/9f38gz4NsZmjoHFBElJ/6x
7opZuFixPpbGXiJGV2sOOGkwyHHgyH2DcnLcxKw4M41BhOi4tmpqBanIrk/N
WGYgfyel8JBnJcmPvbtJ99QcXFOOfj9ysYoImyw7tYfnkORonBrmV00uZ13J
DPabx6XC9VFNfmpfH0+zhfn6WMJH9Pmg6MMxpZVLcKTvM7Jt2zeis4yl2/98
72Ta/hXRhWUE0v0cjXKOO/3MCs7R/Zb1dITExK6ATc/zO/fgrcaxFeTS8/7R
aFPyov8q4vQ8895WOAJrDfmG4v5pJMlfEVbczEWrzkCkub0EnL5iXfMzOdhk
VBzdypvAPON9IXRvEllJELl5KY2Bv6SV8Kz+1yR3wOHDnr4RaDVplqiKCVFr
fynO0mwYgrryupahH4ivTvTmvFfF0L+mrh7jfJ/UqkeHl0yKcLPaNmk8vYfE
etsNPAgXI+t6troSt59E2s9oW5QOozUoQNymN0g4vW0pD2NGMZVX0JX2wRDR
S/doe6NpDKQvN7LBWEROm403mPhPIp4TtLX2eREpff+VBQVFKTROrEZ7Wg0R
V3vnkMeuMyhtWpA/EyEk4l0c5l7ILHaHva73plMf2dKwLavThkGTw9bvEn0E
JEMlX6GomcFrBfE+jnI/k9QSNitmkoH0qo5U+VQreVTwrrfhDQYH67zf8cpt
JPEC3a9cX2AQWOlIyoIryc5v2aYP2bPIWJqKULMOJGZDKtlxqjMo2mbJLudX
gXfAd3Ri/xPsrPnSu7e5AcrsFn++9yribxdu7+C1ILrNLSDZfQUmTH62y91O
NMpJJBzjZbglhnfUJHZDMljxXPfgIobDDLTTdvRi81tx9QHxf2J6wFrDT3MQ
ijnB87/MPYautWXSp6FizAaH3OG4LyDBg9Uzx4yC/+tZ9eTkefjxuNvx2xhC
zxt67D47h65PuG4+yRMQZqrZSCIYDBmwEs0XJ/Gy2HWo120WWZHcy/0WEvic
v2c1rT8DQQi3xZMjxecKe3g+AgluKbKEGatSOHzmqaN5aBLsw9xZXuY0ch4o
Ku+pHYO7L3c5RDyNjBs+ESlPRmQ9/Pv3NxfLcun19B5EDcpyh0r6xXOVfbK8
42TT2hTIstZ7DWyY3pfl6rAp0aOuH2WZZzu+NptlWTguWL7mUi/Li3vb05Tl
qzY8wALtB/UA/bQ/1AOU0n5RD3CE9o96gBO0n9QDGND+Ug8QQPtN+499tP8b
uYP6QD1AGfWDeoB+6gv1ALnUH+oBvqA+UQ8QRP2iHmAX9Y16gC3Uv78A0454
4A==
      "], {{}, 
       {RGBColor[0., 0., 0.7], 
        TagBox[
         TooltipBox[DiskBox[1, 0.012516],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[DiskBox[2, 0.012516],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[DiskBox[3, 0.012516],
          "3"],
         Annotation[#, 3, "Tooltip"]& ]}}]},
    ContentSelectable->True],
   Annotation[#, VertexCoordinateRules -> {{0., 1.}, {0., 2.}, {1., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{289.382883024565, Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{293, 371},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2130886862]
}, Open  ]],

Cell[TextData[{
 "This adds edge labels in ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->613356923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "2"}], ",", "\"\<Edge 12\>\""}], "}"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "5"}], ",", "\"\<Edge 15\>\""}], "}"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"RGBColor", "[", 
         RowBox[{"0.5", ",", "0", ",", "0"}], "]"}], ",", 
        RowBox[{"Line", "[", "#1", "]"}], ",", "Black", ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"#3", "=!=", " ", "None"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{"#3", ",", 
            RowBox[{"LineScaledCoordinate", "[", 
             RowBox[{"#1", ",", "0.5"}], "]"}], ",", 
            RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], ",", 
          RowBox[{"{", "}"}]}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1751868322],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsGroup3DBox[{{{
       {RGBColor[0.5, 0, 0], 
        Line3DBox[{{0., 0.5258999070429866, 0.3615916580888974}, {
         1.2489078088843701`, 0.5255467015764722, 0.3620722620527624}}]}, 
       {GrayLevel[0], Text3DBox[
         FormBox["\<\"Edge 12\"\>", TraditionalForm], {0.6244539044421851, 
         0.5257233043097294, 0.3618319600708299},
         Background->GrayLevel[1]]}}, {
       {RGBColor[0.5, 0, 0], 
        Line3DBox[{{0., 0.5258999070429866, 0.3615916580888974}, {
         0.6246093616342041, 1.1018346147779203`, 0.08722338092960641}}]}, 
       {GrayLevel[0]}}, {
       {RGBColor[0.5, 0, 0], 
        Line3DBox[{{0., 0.5258999070429866, 0.3615916580888974}, {
         0.624254498361977, 0., 0.}}]}, 
       {GrayLevel[0]}}, {
       {RGBColor[0.5, 0, 0], 
        Line3DBox[{{0., 0.5258999070429866, 0.3615916580888974}, {
         0.6239350024552749, 0.4752835519667111, 0.9966146808021568}}]}, 
       {GrayLevel[0], Text3DBox[
         FormBox["\<\"Edge 15\"\>", TraditionalForm], {0.31196750122763744`, 
         0.5005917295048489, 0.6791031694455272},
         Background->GrayLevel[1]]}}, {
       {RGBColor[0.5, 0, 0], 
        Line3DBox[{{1.2489078088843701`, 0.5255467015764722, 
         0.3620722620527624}, {0.6246093616342041, 1.1018346147779203`, 
         0.08722338092960641}}]}, 
       {GrayLevel[0]}}, {
       {RGBColor[0.5, 0, 0], 
        Line3DBox[{{1.2489078088843701`, 0.5255467015764722, 
         0.3620722620527624}, {0.624254498361977, 0., 0.}}]}, 
       {GrayLevel[0]}}, {
       {RGBColor[0.5, 0, 0], 
        Line3DBox[{{1.2489078088843701`, 0.5255467015764722, 
         0.3620722620527624}, {0.6239350024552749, 0.4752835519667111, 
         0.9966146808021568}}]}, 
       {GrayLevel[0]}}, {
       {RGBColor[0.5, 0, 0], 
        Line3DBox[{{0.6246093616342041, 1.1018346147779203`, 
         0.08722338092960641}, {0.624254498361977, 0., 0.}}]}, 
       {GrayLevel[0]}}, {
       {RGBColor[0.5, 0, 0], 
        Line3DBox[{{0.6246093616342041, 1.1018346147779203`, 
         0.08722338092960641}, {0.6239350024552749, 0.4752835519667111, 
         0.9966146808021568}}]}, 
       {GrayLevel[0]}}, {
       {RGBColor[0.5, 0, 0], 
        Line3DBox[{{0.624254498361977, 0., 0.}, {0.6239350024552749, 
         0.4752835519667111, 0.9966146808021568}}]}, 
       {GrayLevel[0]}}}, 
     GraphicsComplex3DBox[{{0., 0.5258999070429866, 0.3615916580888974}, {
      1.2489078088843701`, 0.5255467015764722, 0.3620722620527624}, {
      0.6246093616342041, 1.1018346147779203`, 0.08722338092960641}, {
      0.624254498361977, 0., 0.}, {0.6239350024552749, 0.4752835519667111, 
      0.9966146808021568}}, {Text3DBox[
        FormBox[
         FrameBox["1",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], TraditionalForm], 1], Text3DBox[
        FormBox[
         FrameBox["2",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], TraditionalForm], 2], Text3DBox[
        FormBox[
         FrameBox["3",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], TraditionalForm], 3], Text3DBox[
        FormBox[
         FrameBox["4",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], TraditionalForm], 4], Text3DBox[
        FormBox[
         FrameBox["5",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], TraditionalForm], 5]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.5258999070429866, 0.3615916580888974}, {
     1.2489078088843701`, 0.5255467015764722, 0.3620722620527624}, {
     0.6246093616342041, 1.1018346147779203`, 0.08722338092960641}, {
     0.624254498361977, 0., 0.}, {0.6239350024552749, 0.4752835519667111, 
     0.9966146808021568}}]& ],
  AspectRatio->Automatic,
  ImageSize->{304., Automatic},
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{308, 303},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->167979641,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23910],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LayeredGraphPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LayeredGraphPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TreePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TreePlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EdgeRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeRenderingFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12707]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18957],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->24801]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->668538794],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LineScaledCoordinate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 14.9918100}", "context" -> 
    "GraphUtilities`", 
    "keywords" -> {
     "graph drawing graph plot graph embedding graph layout graph \
visualization network layout draw a graph"}, "index" -> True, "label" -> 
    "Graph Utilities Package Symbol", "language" -> "en", "paclet" -> 
    "GraphUtilities Package", "status" -> "None", "summary" -> 
    "LineScaledCoordinate[{{x_1, y_1}, {x_2, y_2}, ..., {x_k, y_k}}, r] gives \
the coordinate of a point in the polyline {{x_1, y_1}, {x_2, y_2}, ..., {x_k, \
y_k}}, at a scaled distance of r from point {x_1, y_1}. \
LineScaledCoordinate[{{x_1, y_1}, {x_2, y_2}, ..., {x_k, y_k}}] is the same \
as LineScaledCoordinate[{{x_1, y_1}, {x_2, y_2}, ..., {x_k, y_k}}, 0.5].", 
    "synonyms" -> {}, "title" -> "LineScaledCoordinate", "type" -> "Symbol", 
    "uri" -> "GraphUtilities/ref/LineScaledCoordinate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8302, 265, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->12000540]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33848, 865}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2302, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2925, 83, 80, 1, 70, "ObjectName",
 CellID->31079],
Cell[3008, 86, 4598, 148, 70, "Usage",
 CellID->2703]
}, Open  ]],
Cell[CellGroupData[{
Cell[7643, 239, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8121, 256, 144, 4, 70, "Notes",
 CellID->146861874]
}, Closed]],
Cell[CellGroupData[{
Cell[8302, 265, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->12000540],
Cell[CellGroupData[{
Cell[8686, 279, 148, 5, 70, "ExampleSection",
 CellID->416263423],
Cell[8837, 286, 138, 4, 70, "Input",
 CellID->12622998],
Cell[8978, 292, 141, 4, 70, "ExampleText",
 CellID->682788706],
Cell[CellGroupData[{
Cell[9144, 300, 788, 23, 47, "Input",
 CellID->986285025],
Cell[9935, 325, 6711, 133, 392, "Output",
 CellID->2130886862]
}, Open  ]],
Cell[16661, 461, 214, 8, 70, "ExampleText",
 CellID->613356923],
Cell[CellGroupData[{
Cell[16900, 473, 1444, 39, 70, "Input",
 CellID->1751868322],
Cell[18347, 514, 11346, 214, 324, 4189, 92, "CachedBoxData", "BoxData", \
"Output",
 CellID->167979641]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29754, 735, 311, 9, 70, "SeeAlsoSection",
 CellID->23910],
Cell[30068, 746, 1236, 44, 70, "SeeAlso",
 CellID->12707]
}, Open  ]],
Cell[CellGroupData[{
Cell[31341, 795, 314, 9, 70, "TutorialsSection",
 CellID->18957],
Cell[31658, 806, 163, 3, 70, "Tutorials",
 CellID->24801]
}, Open  ]],
Cell[CellGroupData[{
Cell[31858, 814, 319, 9, 70, "MoreAboutSection",
 CellID->668538794],
Cell[32180, 825, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[32369, 832, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

