(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25089,        719]
NotebookOptionsPosition[     21575,        604]
NotebookOutlinePosition[     22981,        642]
CellTagsIndexPosition[     22896,        637]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PageRanks" :> 
          Documentation`HelpLookup["paclet:GraphUtilities/ref/PageRanks"], 
          "PageRankVector" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/PageRankVector"], "LinkRanks" :> 
          Documentation`HelpLookup["paclet:GraphUtilities/ref/LinkRanks"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"PageRanks\"\>", 
       2->"\<\"PageRankVector\"\>", 
       3->"\<\"LinkRanks\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LinkRankMatrix", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LinkRankMatrix", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns the link rank of the graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     ", in the form of a sparse matrix. The link rank of an edge ",
     Cell[BoxData[
      RowBox[{
       StyleBox["u", "TI"], "->", 
       StyleBox["v", "TI"]}]], "InlineFormula"],
     " is defined as the ",
     Cell[BoxData[
      ButtonBox["PageRanks",
       BaseStyle->"Link",
       ButtonData->"paclet:GraphUtilities/ref/PageRanks"]], "InlineFormula"],
     " of ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", divided by the outer-degree of ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given:", "Notes",
 CellID->1667494846],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Tolerance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Tolerance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "tolerance used for convergence check", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TeleportProbability",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/TeleportProbability"], "0.15", 
    Cell["probability of visiting random nodes", "TableText"]},
   {" ", 
    ButtonBox["RemoveSinks",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/RemoveSinks"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], 
    StyleBox[
     RowBox[{
     "whether", " ", "to", " ", "remove", " ", "sinks", " ", "by", " ", 
      "linking", " ", "them", " ", "with", " ", "every", " ", "node"}],
     FontFamily->"Verdana",
     FontSize->10]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->24411],

Cell[TextData[{
 "The link rank of a link from vertex ",
 Cell[BoxData[
  FormBox[
   StyleBox["i", "TI"], TraditionalForm]]],
 " to vertex ",
 Cell[BoxData[
  FormBox[
   StyleBox["j", "TI"], TraditionalForm]]],
 " is defined as page rank of ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 ", as given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PageRanks",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/PageRanks"], "[", 
   StyleBox["g", "TI"], "]"}]], "InlineFormula"],
 ", divided by the outdegree of ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->875],

Cell["\<\
The link rank reflects the probability that a random surfer follows that \
link.\
\>", "Notes",
 CellID->1752],

Cell[TextData[{
 Cell[BoxData["LinkRankMatrix"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["PageRanks",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/PageRanks"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->18443]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->801594591],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->186544606],

Cell["This shows a small network of web pages:", "ExampleText",
 CellID->1919210435],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->58575148],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<home\>\"", "\[Rule]", "\"\<contact\>\""}], ",", 
     RowBox[{"\"\<home\>\"", "\[Rule]", "\"\<links\>\""}], ",", 
     RowBox[{"\"\<home\>\"", "\[Rule]", "\"\<work\>\""}], ",", 
     RowBox[{"\"\<links\>\"", "\[Rule]", "\"\<friend site\>\""}], ",", 
     RowBox[{"\"\<friend site\>\"", "\[Rule]", "\"\<home\>\""}], ",", 
     RowBox[{"\"\<work\>\"", "\[Rule]", "\"\<home\>\""}], ",", 
     RowBox[{"\"\<contact\>\"", "\[Rule]", "\"\<home\>\""}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->447035564],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJw9Un0w1AkA3RZL6janOBLG5lh3ade50+ajd3VUiJywV7l8VNcpRtpL42M6
KU3l6EREcardtKeIbB+cfFRce1dTFypdwiKXtX6/Xfb3+zlxbubm3sybN/Pe
X+/Nc4hNDN3JZrFYfrP8Vx2zPvr2kpsGisZ6mcv9v3DbLG3T4PAkPPLjeo1a
GLD+Q9Ju2dtLPVoUn2AnePZO/u+zPhcr/be7413IxsjTl19it2dHR59+DFNm
C+ySjEcRtMxWaO5JQF9iEFIzMArugqu5x9IJZNv+/Ed8owZRvj2CplYCteOC
61F5Y+Bv3WVWPp8EFb+5aamQgLD6GWfRFhImhtmVZAGBwm3dSnYlCUfvKwaT
egJst6dToTMkFqlr59lFkFhgK+jS3dLDYM7Iq4E0PcqY5cbZZhSWWg61cJ7r
4ZDg0xK0h4L0B/FPc90oZFWMn7R/QGGNYk3uk6MUvvZJmKtyoXGSHJF/8YJC
VV/ys5QcGlL+Ouu1fBoN7jYt93Sz+UbzD5olNC7KdtVdjGRgmFbMFDfQOCIO
PxMoJfCotCPI6PYbJAaGqXSzfQS7AmIn+W8gnZ2RI5ntV8R1uJ43hJKg5v7t
XSQe7JBS23SDCMocSVR7aHHj4Z7jguBBLLNSmGYWaCGvfr/8qwsD2JBuEWk8
pgUTvMnGjFAh/PAbdvRaHWL2Le7NWaHCMU7vhuNTFDqsV3ZGP3kCrqxtqDiE
Rv2w9kJk2GOI21ut1p+nMX6ZFVpe9BDRRclFqRoaqhQvbfxeJaxKFgqsRQyq
5PNFSz5th8iZVM4/yEDinPe0RnUXXd2/pqOZQZwhr3VFRjNeNRQePjfN4H5O
70SaRT0sPJxK13EmkR8Hx357GtNOEvGldganHf3mramh4OOrogVZDAJVpP+A
LwU1t1bMrGJwi6p68bZbD0eaf8BqgsbirFFdskSPJdJbGdIKGiaaBmM5Vw/F
uOIXRQSNUUVJdfmVCfjzGk/sZNN4Z1RQkR40AW+PmJp763Xgkls7Fc4EqjbH
ZLiSWnTfbOl3LhqDy1Bo2+5CLZ4re5x5gxq0VZ6lzoi0OJdiEnBqpQajFksP
dj4jZ/9zw7yqYBRlSdbXVn1H4sWpGXe5Xo0f7fe36d4jYegXJ1JEqSG/yn+6
SEbAWrNFMufxCCr2t5q0hjFYPiNs4sVcQ8Ohu43WahqCukyb1L46HHV2neQc
paF2jfmw7uxt5H0vviPn0Yhsr90bnnsHrwKWuTm0UqCbvJKGX7Zgpi62MHsH
BYFIaumbfQ+vQ9h+HFMKmvpSl2/C2tHlLyy7WqvHBtdDlokeSkjbVoQdmSKh
FNp5pfzZC1v+l/WSyyTE/qvD/i7pQ6dR+LH7YhIH8j3zVkf147fPzs/NNyXh
/frjOK6LCgvdDfeNNxMIyL9ZxKNV0MmculhpBJ5LuoQ+vw8gQhvs+EhEoMT7
E4WNbBClPLZX//gY3lVOO6VmDuEffMIu0Q==
    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03590271334768575, 0.7}}], 
      ArrowBox[{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
        2}], ArrowBox[{1, 3}], 
      ArrowBox[{1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
        37, 4}], 
      ArrowBox[{2, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52,
        53, 1}], ArrowBox[{3, 5}], 
      ArrowBox[{4, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68,
        69, 1}], ArrowBox[{5, 1}]}, {InsetBox[
       FrameBox["\<\"home\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"contact\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"links\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["\<\"work\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["\<\"friend site\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.9435607943052315, 0.8053177105811559}, {
     1.681859327408388, 1.609624744997928}, {0., 1.1793584028115698`}, {
     1.6797432192039763`, 0.}, {0.00029583503268515443`, 
     0.43216451658851424`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{250., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{254, 239},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->766933316]
}, Open  ]],

Cell["This calculates the link ranks:", "ExampleText",
 CellID->229166973],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lm", "=", 
  RowBox[{"LinkRankMatrix", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->887137233],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "7", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 7, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1472119142]
}, Open  ]],

Cell["This replots the network with link rank information:", "ExampleText",
 CellID->1491429241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"RGBColor", "[", 
         RowBox[{"0.5", ",", "0.", ",", "0."}], "]"}], ",", 
        RowBox[{"Arrowheads", "[", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"0.03", ",", "0.8"}], "}"}], "}"}], "]"}], ",", 
        RowBox[{"Arrow", "[", "#1", "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"lm", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"First", "[", "#4", "]"}], ",", 
             RowBox[{"Last", "[", "#4", "]"}]}], "]"}], "]"}], ",", 
          RowBox[{"LineScaledCoordinate", "[", 
           RowBox[{"#1", ",", ".6"}], "]"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->792825671],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{266, 255},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->414196512]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageRanks",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/PageRanks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageRankVector",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/PageRankVector"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkRanks",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/LinkRanks"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->334150849]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LinkRankMatrix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 15.3199434}", "context" -> 
    "GraphUtilities`", "keywords" -> {"PageRank page ranks link ranks"}, 
    "index" -> True, "label" -> "Graph Utilities Package Symbol", "language" -> 
    "en", "paclet" -> "GraphUtilities Package", "status" -> "None", "summary" -> 
    "LinkRankMatrix[g] returns the link rank of the graph g, in the form of a \
sparse matrix. The link rank of an edge u -> v is defined as the PageRanks of \
u, divided by the outer-degree of u.", "synonyms" -> {}, "title" -> 
    "LinkRankMatrix", "type" -> "Symbol", "uri" -> 
    "GraphUtilities/ref/LinkRankMatrix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6684, 220, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->801594591]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22753, 630}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2095, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2718, 80, 57, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2778, 83, 1025, 31, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3840, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4318, 136, 73, 1, 70, "Notes",
 CellID->1667494846],
Cell[4394, 139, 1226, 33, 70, "3ColumnTableMod",
 CellID->24411],
Cell[5623, 174, 632, 24, 70, "Notes",
 CellID->875],
Cell[6258, 200, 120, 4, 70, "Notes",
 CellID->1752],
Cell[6381, 206, 266, 9, 70, "Notes",
 CellID->18443]
}, Closed]],
Cell[CellGroupData[{
Cell[6684, 220, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->801594591],
Cell[CellGroupData[{
Cell[7069, 234, 148, 5, 70, "ExampleSection",
 CellID->186544606],
Cell[7220, 241, 84, 1, 70, "ExampleText",
 CellID->1919210435],
Cell[7307, 244, 138, 4, 70, "Input",
 CellID->58575148],
Cell[7448, 250, 607, 14, 70, "Input",
 CellID->3584],
Cell[CellGroupData[{
Cell[8080, 268, 229, 6, 28, "Input",
 CellID->447035564],
Cell[8312, 276, 3514, 74, 260, "Output",
 CellID->766933316]
}, Open  ]],
Cell[11841, 353, 74, 1, 70, "ExampleText",
 CellID->229166973],
Cell[CellGroupData[{
Cell[11940, 358, 134, 4, 70, "Input",
 CellID->887137233],
Cell[12077, 364, 530, 19, 36, "Output",
 CellID->1472119142]
}, Open  ]],
Cell[12622, 386, 96, 1, 70, "ExampleText",
 CellID->1491429241],
Cell[CellGroupData[{
Cell[12743, 391, 1086, 29, 83, "Input",
 CellID->792825671],
Cell[13832, 422, 5503, 94, 276, "Output",
 Evaluatable->False,
 CellID->414196512]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19396, 523, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[19715, 534, 761, 26, 70, "SeeAlso",
 CellID->334150849]
}, Open  ]],
Cell[CellGroupData[{
Cell[20513, 565, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[20834, 576, 167, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[21038, 584, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[21359, 595, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[21548, 602, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

