(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13543,        467]
NotebookOptionsPosition[     10560,        369]
NotebookOutlinePosition[     11830,        405]
CellTagsIndexPosition[     11745,        400]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PageRanks" :> 
          Documentation`HelpLookup["paclet:GraphUtilities/ref/PageRanks"], 
          "PageRankVector" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/PageRankVector"], "LinkRankMatrix" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/LinkRankMatrix"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"PageRanks\"\>", 2->"\<\"PageRankVector\"\>", 
       3->"\<\"LinkRankMatrix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LinkRanks", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LinkRanks", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the link ranks of the directed graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " as a rule list."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given:", "Notes",
 CellID->1667494846],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Tolerance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Tolerance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "tolerance used for convergence check", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TeleportProbability",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/TeleportProbability"], "0.15", 
    Cell["probability of visiting random nodes", "TableText"]},
   {" ", 
    ButtonBox["RemoveSinks",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/RemoveSinks"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], 
    StyleBox[
     RowBox[{
     "whether", " ", "to", " ", "remove", " ", "sinks", " ", "by", " ", 
      "linking", " ", "them", " ", "with", " ", "every", " ", "node"}],
     FontFamily->"Verdana",
     FontSize->10]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->24411],

Cell[TextData[{
 "The link rank of a link from vertex ",
 Cell[BoxData[
  FormBox[
   StyleBox["i", "TI"], TraditionalForm]]],
 " to vertex ",
 Cell[BoxData[
  FormBox[
   StyleBox["j", "TI"], TraditionalForm]]],
 " is defined as page rank of ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 ", as given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PageRanks",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/PageRanks"], "[", 
   StyleBox["g", "TI"], "]"}]], "InlineFormula"],
 ", divided by the outdegree of ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->875],

Cell["\<\
The link rank reflects the probability that a random surfer follows that \
link.\
\>", "Notes",
 CellID->1752],

Cell[TextData[{
 Cell[BoxData["LinkRanks"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["PageRanks",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/PageRanks"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->18443]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->150676539],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->921305974],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->130445075],

Cell["This defines a small directed graph:", "ExampleText",
 CellID->1313609786],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<home\>\"", "\[Rule]", "\"\<contact\>\""}], ",", 
     RowBox[{"\"\<home\>\"", "\[Rule]", "\"\<links\>\""}], ",", 
     RowBox[{"\"\<home\>\"", "\[Rule]", "\"\<work\>\""}], ",", 
     RowBox[{"\"\<links\>\"", "\[Rule]", "\"\<friend site\>\""}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1638991598],

Cell["This calculates the link ranks:", "ExampleText",
 CellID->1154876590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"LinkRanks", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->924118928],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"home\"\>", ",", "\<\"contact\"\>"}], "}"}], "\[Rule]", 
    "0.04802497792501675`"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"home\"\>", ",", "\<\"links\"\>"}], "}"}], "\[Rule]", 
    "0.04802497792501675`"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"home\"\>", ",", "\<\"work\"\>"}], "}"}], "\[Rule]", 
    "0.04802497792501675`"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\<\"links\"\>", ",", "\<\"friend site\"\>"}], "}"}], "\[Rule]", 
    "0.1848961429766947`"}]}], "}"}]], "Output",
 ImageSize->{392, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->977860532]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageRanks",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/PageRanks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageRankVector",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/PageRankVector"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkRankMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/LinkRankMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1060954151]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->538287948],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LinkRanks - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 15.7105784}", "context" -> 
    "GraphUtilities`", "keywords" -> {"PageRank page ranks link ranks"}, 
    "index" -> True, "label" -> "Graph Utilities Package Symbol", "language" -> 
    "en", "paclet" -> "GraphUtilities Package", "status" -> "None", "summary" -> 
    "LinkRanks[g] gives the link ranks of the directed graph g as a rule \
list.", "synonyms" -> {}, "title" -> "LinkRanks", "type" -> "Symbol", "uri" -> 
    "GraphUtilities/ref/LinkRanks"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6159, 204, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->150676539]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11602, 393}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2113, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2736, 80, 52, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2791, 83, 492, 15, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3320, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3798, 120, 73, 1, 70, "Notes",
 CellID->1667494846],
Cell[3874, 123, 1226, 33, 70, "3ColumnTableMod",
 CellID->24411],
Cell[5103, 158, 632, 24, 70, "Notes",
 CellID->875],
Cell[5738, 184, 120, 4, 70, "Notes",
 CellID->1752],
Cell[5861, 190, 261, 9, 70, "Notes",
 CellID->18443]
}, Closed]],
Cell[CellGroupData[{
Cell[6159, 204, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->150676539],
Cell[CellGroupData[{
Cell[6544, 218, 148, 5, 70, "ExampleSection",
 CellID->921305974],
Cell[6695, 225, 139, 4, 70, "Input",
 CellID->130445075],
Cell[6837, 231, 80, 1, 70, "ExampleText",
 CellID->1313609786],
Cell[6920, 234, 411, 11, 70, "Input",
 CellID->1638991598],
Cell[7334, 247, 75, 1, 70, "ExampleText",
 CellID->1154876590],
Cell[CellGroupData[{
Cell[7434, 252, 128, 4, 70, "Input",
 CellID->924118928],
Cell[7565, 258, 743, 23, 54, "Output",
 CellID->977860532]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8369, 288, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[8688, 299, 772, 26, 70, "SeeAlso",
 CellID->1060954151]
}, Open  ]],
Cell[CellGroupData[{
Cell[9497, 330, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[9818, 341, 167, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[10022, 349, 319, 9, 70, "MoreAboutSection",
 CellID->538287948],
Cell[10344, 360, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[10533, 367, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

