(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24467,        861]
NotebookOptionsPosition[     20035,        708]
NotebookOutlinePosition[     21430,        747]
CellTagsIndexPosition[     21345,        742]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StrongComponents" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/StrongComponents"], 
          "MaximalIndependentEdgeSet" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/MaximalIndependentEdgeSet"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StrongComponents\"\>", 
       2->"\<\"MaximalIndependentEdgeSet\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MaximalBipartiteMatching", "ObjectName",
 CellID->25879],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MaximalBipartiteMatching", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the maximal matching of the bipartite graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31672]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["MaximalBipartiteMatching"], "InlineFormula"],
 " gives a maximal set of non-adjacent edges between the two vertex sets of \
the bipartite graph."
}], "Notes",
 CellID->18678],

Cell[TextData[{
 "The bipartite graph represented by an ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], "\[Times]", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " matrix consists of the row and column vertex sets ",
 Cell[BoxData[
  RowBox[{"R", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     StyleBox["m", "TI"]}], "}"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     StyleBox["n", "TI"]}], "}"}]}]], "InlineFormula"],
 ", with a vertex ",
 Cell[BoxData[
  RowBox[{
   StyleBox["i", "TI"], "\[Element]", "R"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   StyleBox["j", "TI"], "\[Element]", 
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"]}]], "InlineFormula"],
 " connected if the matrix element ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["g", "TI"], 
    StyleBox["ij", "TI"]], "\[NotEqual]", "0"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->21545],

Cell[TextData[{
 "The bipartite graph represented by a rule list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["j", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["2", "TR"]], "->", 
     SubscriptBox[
      StyleBox["j", "TI"], 
      StyleBox["2", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " consists of vertex sets ",
 Cell[BoxData[
  RowBox[{"R", "=", 
   RowBox[{
    ButtonBox["Union",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Union"], "[", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "=", 
   RowBox[{
    ButtonBox["Union",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Union"], "[", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]}]], "InlineFormula"],
 ", with a vertex ",
 Cell[BoxData[
  RowBox[{
   StyleBox["i", "TI"], "\[Element]", "R"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   StyleBox["j", "TI"], "\[Element]", 
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"]}]], "InlineFormula"],
 " connected if the rule ",
 Cell[BoxData[
  RowBox[{
   StyleBox["i", "TI"], "->", 
   StyleBox["j", "TI"]}]], "InlineFormula"],
 " is included in the rule list."
}], "Notes",
 CellID->28712],

Cell[TextData[{
 Cell[BoxData["MaximalBipartiteMatching"], "InlineFormula"],
 " returns a list of index pairs ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["1", "TR"]]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["k", "TI"]], ",", 
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["k", "TI"]]}], "}"}]}], "}"}]], "InlineFormula"],
 " where the number of pairs ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " is not larger than either vertex set."
}], "Notes",
 CellID->17546]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->48878886],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->717793460],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->47145560],

Cell["A bipartite graph describing acceptable drinks for 4 people:", \
"ExampleText",
 CellID->13985],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Tom", "\[Rule]", "Coke"}], ",", 
     RowBox[{"Tom", "\[Rule]", "Coffee"}], ",", 
     RowBox[{"Rob", "\[Rule]", "Coke"}], ",", 
     RowBox[{"Rob", "\[Rule]", "Tea"}], ",", 
     RowBox[{"Adam", "\[Rule]", "Tea"}], ",", 
     RowBox[{"Adam", "\[Rule]", "Juice"}], ",", 
     RowBox[{"Anton", "\[Rule]", "Juice"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28289],

Cell["\<\
The drinks each person should have, if no two person is to have the same \
drink:\
\>", "ExampleText",
 CellID->28323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MaximalBipartiteMatching", "[", "g", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25508],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Rob", ",", "Coke"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Tom", ",", "Coffee"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Adam", ",", "Tea"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Anton", ",", "Juice"}], "}"}]}], "}"}]], "Output",
 ImageSize->{384, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->355994591]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->618],

Cell[TextData[{
 "This defines a random ",
 Cell[BoxData[
  RowBox[{"30", "\[Times]", "40"}]], "InlineFormula"],
 " sparse matrix with approximately 4% of the elements nonzero:"
}], "ExampleText",
 CellID->24472],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->321333761],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"Floor", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], "+", ".04"}], ",", 
      RowBox[{"{", 
       RowBox[{"30", ",", "40"}], "}"}]}], "]"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27152],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "41", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 41, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"30", ",", "40"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1642132468]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", "m", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14423],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWl9rE0EQ32STGGktEQQLts0VLUKV+iAoWGgRoYLgi2DBBx/SUGkfarX2
tY/9DFL64oOfo19t3bmbS/Zmd7O711y8OxLITubuN392dvZmLncfB+dHhyeD
8+PhIHp/NvhxdDz8Fe2dnslDvMEYu5Hf62Umfwv5K/7eCCGpPvbkyCVgDWlT
0qakfUlbhIfzHPl1kAaASD9w9H6sMx756FysW8GiVhWxCkM74UejhuorvOm8
285STv/cCJdvKxhP1h5NEZG9nD65LK7imjQ1TWsmyQyiKJ/8MsHsdV6fIPKs
oyKmHc/Es54Y75SmslMiwsN5351k27X35PiXJRRHxVPqeUT4DcI/cfBU38J/
tKpGrk0QfwivYnki7VhjymsaDfJwwW0A9bYA7IWkrd9v46ziZC5mzTgFZt6x
LWIn1d/PIoUth+MjtuMTIpSxQ3GapvBYqfwntPUhfFUmZI1Vq5Y9NONtkub9
EYZ+huifFUO/Q/SXiqGXEf0qaJXKL7WL6K8VQ9Mr7xxVlZULQ98mBur9iasX
ULFYSDsJUUevfuCuWk2JAkPtCa+pLzGCe6LY2gosteXfj4RWb9es3FXcp4v3
smpdDYtdpfOydRFd1L+N9HPWjsjeA5j7CaMO597IJ3WFaF4xdFmvv2VFrWB0
dxRaB6m0K91H+rAmUq8RfVgx9ANELyD9jvROzaUvg1Z3Mjq5iU8/ts4moyNT
YTijPU5472Hz0KfnCLeWxv4NUuC7km4VZh1Ym9XneL5Vk7kWZd2nH/omxnkE
9FFWr/Dph4w6nHtsllJPEf0CaQ8pjWr5pMvar0A3C3l5gLPZrIlUWeOdZs2i
pBwp8Cc1l95F9GMx/letDlIRRuNiCmj4g2RUD21SWgcS901a90Tv7myWad3q
eGmz9ar+2oBNtQwt856VL/m1wWiqxoU8m9OqeVeYcmx2TyPHT0Rtz03n7zz4
y83feZiOT/N3Hm77zgNr/AO6N3Lj\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{190, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->178022835]
}, Open  ]],

Cell["This finds rows and columns that are matched:", "ExampleText",
 CellID->2131107523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"matched", " ", "=", " ", 
  RowBox[{"MaximalBipartiteMatching", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->529102339],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"27", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"29", ",", "22"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "27"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", "33"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "34"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "35"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "40"}], "}"}]}], "}"}]], "Output",
 ImageSize->{444, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->928369000]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"matched", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "1"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->2131973120],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "6", ",", "4", ",", "10", ",", "26", ",", "15", ",", "2", ",", "12", ",", 
   "8", ",", "14", ",", "20", ",", "1", ",", "22", ",", "27", ",", "19", ",", 
   "29", ",", "3", ",", "30", ",", "9", ",", "11", ",", "18"}], 
  "}"}]], "Output",
 ImageSize->{462, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->296433625]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c", "=", 
  RowBox[{"matched", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1769261241],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "5", ",", "6", ",", "7", ",", "8", ",", "9", ",", "10", ",", "11",
    ",", "12", ",", "14", ",", "15", ",", "17", ",", "18", ",", "19", ",", 
   "22", ",", "27", ",", "33", ",", "34", ",", "35", ",", "40"}], 
  "}"}]], "Output",
 ImageSize->{469, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->216653915]
}, Open  ]],

Cell["This finds unmatched rows and columns:", "ExampleText",
 CellID->802143656],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r2", "=", 
   RowBox[{"Complement", "[", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"Dimensions", "[", "m", "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", "r"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c2", " ", "=", " ", 
   RowBox[{"Complement", "[", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"Dimensions", "[", "m", "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "c"}], "]"}]}], 
  ";"}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->1421463279],

Cell["\<\
This orders the matrix by permuting matched rows and columns to the principal \
diagonal block first:\
\>", "ExampleText",
 CellID->892932029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"m", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"Join", "[", 
      RowBox[{"r", ",", "r2"}], "]"}], ",", 
     RowBox[{"Join", "[", 
      RowBox[{"c", ",", "c2"}], "]"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->347416693],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWUtrGzEQlr1+pBgTN4cm8atxacEH33rIIZCQHFIwNfRQSksPxZgWp9AH
iX3vfyg00N+R/6dIu6O1dlaytGuvvWvWYI1n9c1D0kgza43Gs+nXH+PZzWR8
8uZ2/Ht6M7k7uf51yx45BULIA/v+PSLsN2W/3O8DpYzKbYO1DutqAS0yWmS0
w2gJ8bzfAf45l+YAKj78acPV+ZS3jt/n6pawoDWEKHu834ZQHYlX9beNduox
/TNrNvnWhPkkZX+IgNyP6ZPJYgvWpBjS1FZJBhBJ+WSeR73XcX3iM08qMmLd
8+l51oD+NlCxU7qIj7KTwvtVbnk0/ycEorqO/MX+dxH/AvE9Qz/WV3OtyiMp
b9gD2bbjeWNYQ8z/wxoV8vwoLXAay4J7jt5fknlkSzAkot6hJepFkdB/R4NR
FZZwn+iexxiBWtO2ZmtZHPZB63dj/OA9pJOsrQGNYy9H5ahso16xxmHx/3Pr
6LTO0CoouRrHJxyWkLGQRioekVur7PjE58MKFOewXX7h7DX1Tssh8CWl5Gr5
RNh4i56vP8/Ht2RTm2L+Cqy9WzrbGntSXaHLmBr9NFjJqnNmQNYY69HQp4B2
gL7fEakz6p1uH7eOFjVMDejnHZF6DegvGUNz5ABWcJIaiQGM4VvG0EnW80mi
11kreYlWfHQVRUBHIAM4BNcW0d8pezD6Z1R9Ntm8W9pXGtjaB2pfcaR5bNu3
Kt7XhXWcxW2s2tQjSjsR6xKTr+q9FE+qCaswpItcxflO6qWrNJhd53RRz+yy
9AGg/2QMvQ+r+wloP3VSYj1e0ih1T/qlRLyJTM7r7GrkfZY96RKsvpi1C+DP
E5Dmf1r4mdpWS6haqbq6qkgHPhe4nhGKhGOEwfmvotXseq3QeKgZkV5Tcj5u
RnPSt0Bqr3i7sTupUCWyR0XsL+7nlt/l5ffw+T18fg+/2nxu8h6eFB4B3VmX
qA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->354157753]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11448],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StrongComponents",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/StrongComponents"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaximalIndependentEdgeSet",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/MaximalIndependentEdgeSet"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14828]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19555],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->15918]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->137532770],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MaximalBipartiteMatching - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 15.9449594}", "context" -> 
    "GraphUtilities`", 
    "keywords" -> {
     "bipartite matching maximal bipartite matching maximum transversal block \
triangular ordering"}, "index" -> True, "label" -> 
    "Graph Utilities Package Symbol", "language" -> "en", "paclet" -> 
    "GraphUtilities Package", "status" -> "None", "summary" -> 
    "MaximalBipartiteMatching[g] gives the maximal matching of the bipartite \
graph g.", "synonyms" -> {}, "title" -> "MaximalBipartiteMatching", "type" -> 
    "Symbol", "uri" -> "GraphUtilities/ref/MaximalBipartiteMatching"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7880, 278, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->48878886]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21203, 735}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2037, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2660, 79, 62, 1, 70, "ObjectName",
 CellID->25879],
Cell[2725, 82, 494, 15, 70, "Usage",
 CellID->31672]
}, Open  ]],
Cell[CellGroupData[{
Cell[3256, 102, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3734, 119, 205, 5, 70, "Notes",
 CellID->18678],
Cell[3942, 126, 1160, 42, 70, "Notes",
 CellID->21545],
Cell[5105, 170, 1939, 73, 70, "Notes",
 CellID->28712],
Cell[7047, 245, 796, 28, 70, "Notes",
 CellID->17546]
}, Closed]],
Cell[CellGroupData[{
Cell[7880, 278, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->48878886],
Cell[CellGroupData[{
Cell[8264, 292, 148, 5, 70, "ExampleSection",
 CellID->717793460],
Cell[8415, 299, 138, 4, 70, "Input",
 CellID->47145560],
Cell[8556, 305, 101, 2, 70, "ExampleText",
 CellID->13985],
Cell[8660, 309, 470, 13, 70, "Input",
 CellID->28289],
Cell[9133, 324, 128, 4, 70, "ExampleText",
 CellID->28323],
Cell[CellGroupData[{
Cell[9286, 332, 116, 3, 70, "Input",
 CellID->25508],
Cell[9405, 337, 445, 15, 36, "Output",
 CellID->355994591]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9899, 358, 221, 7, 70, "ExampleSection",
 CellID->618],
Cell[10123, 367, 212, 6, 70, "ExampleText",
 CellID->24472],
Cell[10338, 375, 139, 4, 70, "Input",
 CellID->321333761],
Cell[CellGroupData[{
Cell[10502, 383, 367, 12, 70, "Input",
 CellID->27152],
Cell[10872, 397, 484, 17, 36, "Output",
 CellID->1642132468]
}, Open  ]],
Cell[CellGroupData[{
Cell[11393, 419, 102, 3, 70, "Input",
 CellID->14423],
Cell[11498, 424, 1217, 24, 70, "Output",
 Evaluatable->False,
 CellID->178022835]
}, Open  ]],
Cell[12730, 451, 89, 1, 70, "ExampleText",
 CellID->2131107523],
Cell[CellGroupData[{
Cell[12844, 456, 159, 4, 70, "Input",
 CellID->529102339],
Cell[13006, 462, 1391, 47, 71, "Output",
 CellID->928369000]
}, Open  ]],
Cell[CellGroupData[{
Cell[14434, 514, 178, 6, 70, "Input",
 CellID->2131973120],
Cell[14615, 522, 411, 11, 36, "Output",
 CellID->296433625]
}, Open  ]],
Cell[CellGroupData[{
Cell[15063, 538, 178, 6, 70, "Input",
 CellID->1769261241],
Cell[15244, 546, 412, 11, 36, "Output",
 CellID->216653915]
}, Open  ]],
Cell[15671, 560, 81, 1, 70, "ExampleText",
 CellID->802143656],
Cell[15755, 563, 599, 20, 70, "Input",
 CellID->1421463279],
Cell[16357, 585, 152, 4, 70, "ExampleText",
 CellID->892932029],
Cell[CellGroupData[{
Cell[16534, 593, 307, 10, 70, "Input",
 CellID->347416693],
Cell[16844, 605, 1193, 24, 70, "Output",
 Evaluatable->False,
 CellID->354157753]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18098, 636, 311, 9, 70, "SeeAlsoSection",
 CellID->11448],
Cell[18412, 647, 531, 17, 70, "SeeAlso",
 CellID->14828]
}, Open  ]],
Cell[CellGroupData[{
Cell[18980, 669, 314, 9, 70, "TutorialsSection",
 CellID->19555],
Cell[19297, 680, 163, 3, 70, "Tutorials",
 CellID->15918]
}, Open  ]],
Cell[CellGroupData[{
Cell[19497, 688, 319, 9, 70, "MoreAboutSection",
 CellID->137532770],
Cell[19819, 699, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[20008, 706, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

