(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     65815,       1558]
NotebookOptionsPosition[     60652,       1377]
NotebookOutlinePosition[     62050,       1416]
CellTagsIndexPosition[     61964,       1411]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CommunityStructurePartition" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/CommunityStructurePartition"], 
          "CommunityStructureAssignment" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/CommunityStructureAssignment"], 
          "StrongComponents" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/StrongComponents"], "WeakComponents" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/WeakComponents"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"CommunityStructurePartition\"\>", 
       2->"\<\"CommunityStructureAssignment\"\>", 
       3->"\<\"StrongComponents\"\>", 
       4->"\<\"WeakComponents\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MinCut", "ObjectName",
 CellID->12221],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MinCut", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]partitions the undirected graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " into ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " parts where the number of edge cuts is approximately minimized."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29947]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["MinCut"], "InlineFormula"],
 " treats the input as an undirected graph, and tries to find a partition of \
the vertices into ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " parts so that each part has roughly the same number of vertices, and so \
that the number of edges between these parts (known as the edge separator) is \
minimized."
}], "Notes",
 CellID->23986]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->118161645],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->85657781],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->57757045],

Cell["This defines a small graph:", "ExampleText",
 CellID->24464],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "4"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->41],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->32911816],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{3.2335880821486436`, 0.7350254756623481}, {
    2.288887234548954, 0.3671446790670904}, {3.234670952176549, 
    0.0004843158707158457}, {0.9463943774352315, 0.3677084059948408}, {0., 
    0.}, {0.00022260209708480083`, 0.7350803294414563}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {2, 4}, {3, 1}, {4, 5}, {5, 6}, {6, 4}}]}, {
      InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{3.2335880821486436`, 0.7350254756623481}, {
     2.288887234548954, 0.3671446790670904}, {3.234670952176549, 
     0.0004843158707158457}, {0.9463943774352315, 0.3677084059948408}, {0., 
     0.}, {0.00022260209708480083`, 0.7350803294414563}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1474918042]
}, Open  ]],

Cell["\<\
This partitions the vertices into two parts with the minimum number of edge \
cuts:\
\>", "ExampleText",
 CellID->28145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c", "=", 
  RowBox[{"MinCut", "[", 
   RowBox[{"g", ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->23281],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->602770498]
}, Open  ]],

Cell["\<\
This plots the graph with partitions, with one part colored red and the other \
colored green:\
\>", "ExampleText",
 CellID->9961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"MemberQ", "[", 
           RowBox[{
            RowBox[{
            "c", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
            "#2"}], "]"}], ",", "Red", ",", "Green"}], "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#1", ",", ".05"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->2995],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyVVk1IVFEUvvpy0pFqcJSGTHpFC2kRJhEuBAXBLDRmUw1FMIOYoxCJzUJG
YoJChVq0MKZFMC2KF1RMhORGkHBh4mIKCRdCj3AxCxcuIly0uH33Z673OlpX
mXm+Oe/e73znnO+ed/oSqeTAnURqqD/hXhxNjCSH+u+53XdHYXIqCCEz+J6N
ENxT3PHvDKX4v9c1zK6OR70YjeVojkzx39TzaCxGcznxnNSxa1WBFhgk/+Rp
nkxwKy0USkZC83mxVlwDGZpROy59PrOxuvqI4+PmR3s7o1fJLg5NJin/IyHN
X5EW1e7Xb8dJ5XRzM3GWs9mtzU224D5f9Wdrq5DLvWhrw9OldBpgHBGsdEQR
JxCvjoe/rS/AL9sLHjPJ5JNI5EM87s/PkzS3ri8uKivuxVqHFovILvV9mZN6
bn3qupu+LxawiAWbl52deLAwOfmrWExxOyiDOCiCqIigim96AEjBs25X1ABn
hB9zY2Ng9C4WW0WOR7h1bXYWv6dCIbBFJKTaCrGG713xvDfRKBCBiwdkuORn
PpPB2lc9PVhBaq0Q+aoAQkXAYi9SgEQMlDzBAjuQmadDVpiHSxGiBmApI4yb
VUP0WCEq/F/EkFmH5y0tog43SnalItgRTJ0ValgotVAwFHOtpCPBXlobrBAb
NB2Bj9JRVMuy0JHI8lEr1EiZjljmejUdCS2wLB+zQmzUqruto27Tj9RRkxVi
U5mOsBcRdmoZEVISGTlhheqyS7WKUShJNbwL/Knqd3pDwJZTVh7EKqGssahL
HNaynIfedSgeH9LKLgeXBwdVn/zU2CjER07v28Pl6Xrp4cryecOD39GhPHwN
BmU17Ty4mhJER/m+tiD9oO/Lva3sEkQnVH5+z83t0ONJ+1oznei1Fj2Udeks
zfrUJ7w6rPPSbJZ1Xsc8V2DJzpWdDnS9wqrrVXYFdfrx8/g+TtXOftRrWoWU
LE9VQ4nPjm4U3eMM2J3+sJk3o0ups4r3AauBXZcKaWdVr/5Njol3lOooLMt2
vVT1fKMbxc2uoDwdscKsNWOUOrtdpiN0cMs3U/UelRjWlISXi1JS0Ao1sKtm
RsqsbEqxe887Gh+QUXxSGn99Ttl9HlHzYevH2mcbj+XcBBbGezltZhn1Y1mW
c5PnrQDUnCVr9Fly4v0tsAAXUViSYSsOAEHoYCmRkDNdPi+5aVOiMWP2fTkH
EmLGREg/u7r2M2MyTnKm1TocJkkjF9vdSc7KqjuJ+P49b5OKvw3zllw=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->549571826]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28111],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->758789538],

Cell["\<\
This defines a block diagonal matrix with two blocks and an additional two \
off-diagonal elements:\
\>", "ExampleText",
 CellID->22929],

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"ArrayFlatten", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"SparseArray", "[", 
         RowBox[{
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"10", ",", "10"}], "}"}], ",", "1"}], "]"}], ",", 
        RowBox[{"SparseArray", "[", 
         RowBox[{
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"10", ",", "10"}], "}"}], ",", "0"}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"SparseArray", "[", 
         RowBox[{
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"10", ",", "10"}], "}"}], ",", "0"}], "]"}], ",", 
        RowBox[{"SparseArray", "[", 
         RowBox[{
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"10", ",", "10"}], "}"}], ",", "1"}], "]"}]}], "}"}]}], 
     "\[IndentingNewLine]", "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"m", "\[LeftDoubleBracket]", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "\[RightDoubleBracket]"}], "=", 
   RowBox[{
    RowBox[{"m", "\[LeftDoubleBracket]", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "\[RightDoubleBracket]"}], "=", "1"}]}],
   ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->21538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", "m", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->16118],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1OwzAMzpa2G0IgDTFgcOEpuADiBiceYpqQ4IBAwIkDz8GB5+M1ip2k
q+MkXcpPKSiVFsfrZ39pEztJczl/ur66nT/dLOaHFw/z++ubxePh+d0D/CUH
QohX+L3tCaiXUFO/17IE6ZYTKCUAto2cGTkEOQS5a3SRKbi5dkDJCGqibm5h
ieBSXQpFdfQlslrX9hQxZbpkOrZS5Fpflo6XzY5aM13poauWUI/xb2Tb9N5+
HH+NMHazT7NSfRbHnlN2YUamKKhdUx9Myno8o9wzUrL/MyN32H09wkNRtAHl
i9DSlKQFq3rzoKXOe3/9F1lpFsgZ4pnpFCt1ZxW05/z9R/X3BbBAcQT1E5DK
yxobGbRU1pgSByjVf8OqKUuD1owc63izGamNL05QR5Xy2Pk293hozxH7TD5f
NltM3K1kDPZBgFPWb6SKyjyeo7TjWTvjMXMceCP+CEvohE7o/43WKaa6Kgif
6SwfVs5x18468/Bs6Z1XIlrp8+OZ73rDhGrFYL+XLM6/k9Eb+yI8U5d0HlD3
nBVm0cazY20ejsxa1dqSP2l49NAVqWLpUWQkdEIndP/QdlYN7c2aZyx7l9Z+
x3QMxZkPs2Kn1DcmNVsBw6mpZ3/wGb6DKWbvtfTdYs8VapM77hMyIROyP0iM
ftmUBYgFVsfKaszuxOQnPsvlHXjieZ/PntoS9wftMuF4aUe9ZSF7Z0+xpuSo
dPcRTdkdsaMfGwkJmZDdIzGGZFMMOGtaHQEj5k167PELcuFZX/PVVdGhxyoj
VZ6av5102bKveQzl0CEWqIPE6pTpB1xn3vF8TzKM//uKzsm/d2ZXnxuGThfT
Sf1XW5NO6j/LSvW/fVIvBh+v7CCm\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{152, 156},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->483970576]
}, Open  ]],

Cell[TextData[{
 "This randomly permutes the rows of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->16541],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"m", "\[LeftDoubleBracket]", 
      RowBox[{"#", ",", "#"}], "\[RightDoubleBracket]"}], "&"}], "@", 
    RowBox[{"Ordering", "[", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"1", ",", 
       RowBox[{"{", "20", "}"}]}], "]"}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->4833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", "p", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->31115],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWlFu2zAMVazYaZC2SJas6f56mu1rhwiCAe1HsaItdo5+7Iy7hkZKckJL
sutYjqMgNGDRlKlHRqIoWtHPzfvjr+fN+9N28/DjdfPy+LR9e/j++xWq5EgI
8QH333sBzwqe9P2hFFC/nEMpQWBp6drSDGgG9KvlxViL22sFzJhILfRLXaKw
0pdu6/HjPW/aU4mlw0uH/4JFbvhd6aHcDmTN8lOEoSxZEb59jyzt6N2307+X
sO3WnbVSft1Oe061C+uZoqDtmsZgbm2+c6hUez/PrJtn1sPpe+PhdbPoBso/
wlBbEgtci1YO/+1A3sWbnVArjQK5I4F9Pvu3FddAc6CF5ZHeAcU+LYC6yBRT
mkEt6AiHx9nlD9I+dbyLlloCw+oIqa7LSjN3DULWINvWClmGWA+1qpnO/NCc
i+qFmggT7oN0LGkTBaKsqR3pGnus0woSP+jcAFgxhwJn0DXQ3OqaWYqxaQH0
qqpbVSOSUXLTFbcxfjBSHFJueUYaCilFL2AkPyvpugowWgyaWX7KqxSJytcq
65L/hWhWp6a1XPWYI4T0BDK2TyzplK9Fax3w93u5RF8Zexid+ID39Vb0qdlD
t65I8rDyu84ds+4+T78W9dukIwCjMdqp0FLMRRipv5ytIPX9+RejtkOt5l1d
9+KCurwcr7or124X7Aj5hUhrT+4c++EyreGduUtBivEkRuPMj5EYaQgklJYx
qxBBxEdd5705xn9x+Jgnou3QrM7Njg0ySkbvinlZwdUOm2JG7UN5+11TTSeq
hz0up2cRb6LOac25HLRUYhgjMVKfSDgTpBPHDkL09i1MBJs42mRX/Ia1rkhA
k14NW2gI9XMqv+E4mkIrPGrIsEAeKD5iPJ46MjOiPZSZYP1toH4RkG/KFE53
enB/grHunCOfGY61hs8Md9VK+fM+MyxG/wHMROXv\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{144, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->31098871]
}, Open  ]],

Cell["\<\
This reorders the matrix into block diagonal form, with the number of \
off-diagonal elements minimized:\
\>", "ExampleText",
 CellID->22704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"order", "=", 
  RowBox[{"MinCut", "[", 
   RowBox[{"p", ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->9930],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "6", ",", "7", ",", "9", ",", "12", ",", 
     "17", ",", "18", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "4", ",", "5", ",", "8", ",", "10", ",", "11", ",", "13", ",", "14", ",", 
     "15", ",", "16", ",", "20"}], "}"}]}], "}"}]], "Output",
 ImageSize->{476, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1936798094]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"p", "\[LeftDoubleBracket]", 
   RowBox[{
    RowBox[{"Flatten", "[", "order", "]"}], ",", 
    RowBox[{"Flatten", "[", "order", "]"}]}], "\[RightDoubleBracket]"}], 
  "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->22386],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWktu2zAQpU1JdlA0gIskTmovgt6gB0iCbtJVD2EYAeJF0CLJuouew4uc
LtdQZ/iRRkNSppzAv1CASY31Zh4pcoYcSb9mz/d3D7PnxXx2+fNx9ud+MX+6
vP39CH/JnhBiCb+XcwHnJZyp37IsoXbLEZQSACemnpi6D3Uf6nMji0zBzTEG
ISOokbr4BUsEl+oQZ0y+wCKrZa3fpiGZfIpFruWqdKwcb6g1ZystbKolYyLH
35ETM3rTOP4aYfS+rs1K5Ukce07ZhZmZoqB6bWMwMm0ek7ZjLct6nvfNNKc4
e13P8JAXfYbyn9C1KVfNYiJPO8rc3qctstIokDPEXyZTrNSDVdCR848fl6+g
uH6dawtHbFbQUmliOOxhrf7r22ZUCp3YOM6x1GSjOj7/QBlFy9GMsblHu7v9
mL747DSZYvyslS14zwN8sr4T1gP57ArYL5t+qw1x3wjdCb8nJXRCJ3RC12gd
jOxhIfERyt1R6zjFY6h31SHydygKYCgCrfXZ86yIO8eIImdq3q8sjsdZF/gY
RfXHu7oYBmdfWqzD4FgxnSXroN2Z8p577TstttqKbYc8KaETOqH3Hd2MzaF8
sH09bGaGa2RqYPmHD7MiS9s1JhSR4cacZ3vYh/dgisoBre2u+R/o4VM3XDe/
sWuB+f+hNfj4JWRCHhIS44psiy8004DTodIasisxkY+vn/kGLPEVhfdSa2L+
0C3GDis9iuf5SaXv5DhHqh6U/rwmtG4gdtBxfBMyIQ8Did5W7QpXeqmsfGXA
8Dx6BHdpRC6Clrx71ijN92vDti2F4qfEZ1coQ42np0yecpnpe9/DBWLx9t48
1m8/Q+9I0/cGb21N+t5gXVYq7/f3BqL3HzV3BlI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{156, 160},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->441535993]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14259],

Cell["\<\
An irregular mesh over a three-dimensional structure gives the graph shown \
here:\
\>", "ExampleText",
 CellID->435327744],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->1587875066],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{
   "Import", "[", "\"\<LinearAlgebraExamples/Data/can__229.psa\>\"", "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->608617422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", "g", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->822409829],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{344, 272},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->151008740]
}, Open  ]],

Cell["This partitions the graph into four parts:", "ExampleText",
 CellID->2033419264],

Cell[BoxData[
 RowBox[{
  RowBox[{"i", "=", "1"}], ";", 
  RowBox[{"parts", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Thread", "[", 
        RowBox[{"#", "\[Rule]", 
         RowBox[{"i", "++"}]}], "]"}], "&"}], ",", 
      RowBox[{"MinCut", "[", 
       RowBox[{"g", ",", "4"}], "]"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1545819298],

Cell["\<\
This plots the partitioned graph, coloring nodes according to the part to \
which they belong:\
\>", "ExampleText",
 CellID->1524689422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{"g", ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "0.025", "]"}]}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", 
         RowBox[{"0.75", "/", 
          RowBox[{"(", 
           RowBox[{"#2", "/.", "parts"}], ")"}]}], "]"}], ",", 
        RowBox[{"Point", "[", "#", "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1478046344],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{445, 352},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->105776575]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7139],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CommunityStructurePartition",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/CommunityStructurePartition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CommunityStructureAssignment",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/CommunityStructureAssignment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StrongComponents",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/StrongComponents"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WeakComponents",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/WeakComponents"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9304]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20843],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->27149]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->886155679],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MinCut - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 22.7263830}", "context" -> 
    "GraphUtilities`", 
    "keywords" -> {
     "graph partitioning edge separator mesh partitioning load balancing \
static load balancing domain decomposition"}, "index" -> True, "label" -> 
    "Graph Utilities Package Symbol", "language" -> "en", "paclet" -> 
    "GraphUtilities Package", "status" -> "None", "summary" -> 
    "MinCut[g, k] partitions the undirected graph g into k parts where the \
number of edge cuts is approximately minimized.", "synonyms" -> {}, "title" -> 
    "MinCut", "type" -> "Symbol", "uri" -> "GraphUtilities/ref/MinCut"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4686, 146, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->118161645]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 61821, 1404}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2396, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3019, 86, 44, 1, 70, "ObjectName",
 CellID->12221],
Cell[3066, 89, 655, 20, 70, "Usage",
 CellID->29947]
}, Open  ]],
Cell[CellGroupData[{
Cell[3758, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4236, 131, 413, 10, 70, "Notes",
 CellID->23986]
}, Closed]],
Cell[CellGroupData[{
Cell[4686, 146, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->118161645],
Cell[CellGroupData[{
Cell[5071, 160, 147, 5, 70, "ExampleSection",
 CellID->85657781],
Cell[5221, 167, 138, 4, 70, "Input",
 CellID->57757045],
Cell[5362, 173, 66, 1, 70, "ExampleText",
 CellID->24464],
Cell[5431, 176, 426, 13, 70, "Input",
 CellID->41],
Cell[CellGroupData[{
Cell[5882, 193, 173, 5, 28, "Input",
 CellID->32911816],
Cell[6058, 200, 1879, 46, 74, "Output",
 CellID->1474918042]
}, Open  ]],
Cell[7952, 249, 130, 4, 70, "ExampleText",
 CellID->28145],
Cell[CellGroupData[{
Cell[8107, 257, 145, 5, 70, "Input",
 CellID->23281],
Cell[8255, 264, 322, 11, 36, "Output",
 CellID->602770498]
}, Open  ]],
Cell[8592, 278, 140, 4, 70, "ExampleText",
 CellID->9961],
Cell[CellGroupData[{
Cell[8757, 286, 608, 19, 47, "Input",
 CellID->2995],
Cell[9368, 307, 1488, 28, 67, "Output",
 Evaluatable->False,
 CellID->549571826]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10905, 341, 216, 7, 70, "ExampleSection",
 CellID->28111],
Cell[11124, 350, 139, 4, 70, "Input",
 CellID->758789538],
Cell[11266, 356, 146, 4, 70, "ExampleText",
 CellID->22929],
Cell[11415, 362, 1417, 43, 70, "Input",
 CellID->21538],
Cell[CellGroupData[{
Cell[12857, 409, 102, 3, 70, "Input",
 CellID->16118],
Cell[12962, 414, 1095, 22, 70, "Output",
 Evaluatable->False,
 CellID->483970576]
}, Open  ]],
Cell[14072, 439, 152, 6, 70, "ExampleText",
 CellID->16541],
Cell[14227, 447, 379, 12, 70, "Input",
 CellID->4833],
Cell[CellGroupData[{
Cell[14631, 463, 102, 3, 70, "Input",
 CellID->31115],
Cell[14736, 468, 1167, 23, 70, "Output",
 Evaluatable->False,
 CellID->31098871]
}, Open  ]],
Cell[15918, 494, 151, 4, 70, "ExampleText",
 CellID->22704],
Cell[CellGroupData[{
Cell[16094, 502, 148, 5, 70, "Input",
 CellID->9930],
Cell[16245, 509, 496, 15, 36, "Output",
 CellID->1936798094]
}, Open  ]],
Cell[CellGroupData[{
Cell[16778, 529, 276, 8, 70, "Input",
 CellID->22386],
Cell[17057, 539, 1107, 22, 70, "Output",
 Evaluatable->False,
 CellID->441535993]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18213, 567, 223, 7, 70, "ExampleSection",
 CellID->14259],
Cell[18439, 576, 133, 4, 70, "ExampleText",
 CellID->435327744],
Cell[18575, 582, 140, 4, 70, "Input",
 CellID->1587875066],
Cell[18718, 588, 197, 7, 70, "Input",
 CellID->608617422],
Cell[CellGroupData[{
Cell[18940, 599, 107, 3, 70, "Input",
 CellID->822409829],
Cell[19050, 604, 13925, 232, 70, "Output",
 Evaluatable->False,
 CellID->151008740]
}, Open  ]],
Cell[32990, 839, 86, 1, 70, "ExampleText",
 CellID->2033419264],
Cell[33079, 842, 427, 14, 70, "Input",
 CellID->1545819298],
Cell[33509, 858, 146, 4, 70, "ExampleText",
 CellID->1524689422],
Cell[CellGroupData[{
Cell[33680, 866, 553, 17, 70, "Input",
 CellID->1478046344],
Cell[34236, 885, 23844, 395, 70, "Output",
 Evaluatable->False,
 CellID->105776575]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58141, 1287, 310, 9, 70, "SeeAlsoSection",
 CellID->7139],
Cell[58454, 1298, 1106, 35, 70, "SeeAlso",
 CellID->9304]
}, Open  ]],
Cell[CellGroupData[{
Cell[59597, 1338, 314, 9, 70, "TutorialsSection",
 CellID->20843],
Cell[59914, 1349, 163, 3, 70, "Tutorials",
 CellID->27149]
}, Open  ]],
Cell[CellGroupData[{
Cell[60114, 1357, 319, 9, 70, "MoreAboutSection",
 CellID->886155679],
Cell[60436, 1368, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[60625, 1375, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

