(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39063,       1297]
NotebookOptionsPosition[     31934,       1051]
NotebookOutlinePosition[     33487,       1093]
CellTagsIndexPosition[     33401,       1088]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MinCut" :> 
          Documentation`HelpLookup["paclet:GraphUtilities/ref/MinCut"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"MinCut\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MinimumBandwidthOrdering", "ObjectName",
 CellID->21357],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MinimumBandwidthOrdering", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]attempts to find a vertex ordering that minimizes the \
bandwidth of the undirected graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MinimumBandwidthOrdering", "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]attempts to find row and column permutations that \
minimize the bandwidth of the matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->15372]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For a graph ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["V", "TI"], ",", 
    StyleBox["E", "TI"]}], "}"}]], "InlineFormula"],
 " with vertex ordering ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ", the bandwidth of the graph is defined as"
}], "Notes",
 CellID->73304195],

Cell[TextData[Cell[BoxData[
 RowBox[{
  SubscriptBox["Max", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["u", "TI"], ",", " ", 
      StyleBox["v", "TI"]}], "}"}], "\[Element]", 
    ButtonBox["E",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/E"]}]], " ", "|", 
  RowBox[{
   RowBox[{
    StyleBox["f", "TI"], "[", 
    StyleBox["u", "TI"], "]"}], "-", 
   RowBox[{
    StyleBox["f", "TI"], "[", 
    StyleBox["v", "TI"], "]"}]}], "|"}]], "InlineFormula"]], "Notes",
 CellID->2079441987],

Cell[TextData[{
 "For a matrix ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], "=", 
   RowBox[{"(", 
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["ij", "TI"]], ")"}]}]], "InlineFormula"],
 ", the bandwidth is defined as"
}], "Notes",
 CellID->9908418],

Cell[TextData[Cell[BoxData[
 RowBox[{
  SubscriptBox["Max", 
   RowBox[{
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["ij", "TI"]], " ", "\[NotEqual]", " ", "0"}]], " ", "|", 
  RowBox[{
   StyleBox["i", "TI"], " ", "-", " ", 
   StyleBox["j", "TI"]}], "|"}]], "InlineFormula"]], "Notes",
 CellID->622328966],

Cell["For a symmetric matrix, the envelope size is defined as ", "Notes",
 CellID->852769207],

Cell[TextData[Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Sum]", 
   StyleBox["i", "TI"]], " ", 
  RowBox[{"Max", 
   RowBox[{"(", 
    RowBox[{"0", ",", " ", 
     RowBox[{
      RowBox[{
       SubscriptBox["Max", 
        RowBox[{
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["ij", "TI"]], "\[NotEqual]", "0", " "}]], 
       StyleBox["i", "TI"]}], "-", 
      StyleBox["j", "TI"]}]}], ")"}]}]}]], "InlineFormula"]], "Notes",
 CellID->2060496198],

Cell["\<\
which is the sum of the distance from the first element in each row to the \
diagonal position.\
\>", "Notes",
 CellID->200570946],

Cell[TextData[{
 Cell[BoxData["MinimumBandwidthOrdering"], "InlineFormula"],
 " treats input graphs as undirected."
}], "Notes",
 CellID->1217078083],

Cell["The following options can be given:", "Notes",
 CellID->23374],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "method to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RefinementMethod",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/RefinementMethod"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "method used to improve ordering", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RecursionMethod",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/RecursionMethod"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "recursion method to use", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->3801]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->499517470],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->178504799],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->652588188],

Cell["This defines a small graph:", "ExampleText",
 CellID->24350],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", "\[Rule]", "c"}], ",", 
     RowBox[{"c", "\[Rule]", "d"}], ",", 
     RowBox[{"c", "\[Rule]", "e"}], ",", 
     RowBox[{"d", "\[Rule]", "f"}], ",", 
     RowBox[{"e", "\[Rule]", "f"}], ",", 
     RowBox[{"a", "\[Rule]", "b"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4596],

Cell[TextData[{
 "This numbers the vertices using ordering from ",
 Cell[BoxData[
  ButtonBox["VertexList",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/VertexList"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1788945258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"order", " ", "=", " ", 
  RowBox[{"Thread", "[", 
   RowBox[{
    RowBox[{"VertexList", "[", "g", "]"}], "\[Rule]", 
    RowBox[{"Range", "[", "6", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->828951749],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"b", "\[Rule]", "1"}], ",", 
   RowBox[{"c", "\[Rule]", "2"}], ",", 
   RowBox[{"d", "\[Rule]", "3"}], ",", 
   RowBox[{"e", "\[Rule]", "4"}], ",", 
   RowBox[{"f", "\[Rule]", "5"}], ",", 
   RowBox[{"a", "\[Rule]", "6"}]}], "}"}]], "Output",
 ImageSize->{254, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->884110759]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"g", "/.", "order"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1045789575],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWFtIlEEUHp3dLXB7soegh6QILIqkG3ajIKiIhHrzoQcti62ITCP2KYMI
K+gGUhHdiCjpgkZREdLS1YcMH3qQaM3MSk1p3XXdrd10++bMf/P33/Zfsc0W
Heaf851zvnP+mX/mTFHpPs+23aX7dmwtzVtbUVru2bG1Mm/NngoM8SzGsnIZ
Y0VTGPoJ9Ohf/CbjX3Zlb4Vo+dCvvv62ynDHYZYjGh7uOBRuPyBELw2owdiT
UKsnPlDPckTDY8HrodY9VqgPuxKJJpYjGvm8dzyhHISijDTpz39HKxuNA0pO
22jVB1rmsqXF0WSPHv31ZXGbz5dO1E7Iv7fsvLJqVe3GjYG2NvacdJeTbn9n
p1RnboGdoPFpqas7lZf3qLwcCPaUNJaJ1vH+4cNzBQVSyW2KIZsQjSdP1uTn
+6qq4tGojzSXiNYVDQTqS0qurVunOTXrc9IHDsrw/vrs2SekX0hCeIbd5suX
pR8+FPOF/GXhDq9YB16sg0/7Qx92C5GT7MDNfY8HKlBsIDuLVfsaD664bRr8
+VgsEzetlaF4H62/hMg7NHpaWgBHBjubmx+TpUUmRtMIhzeD3NwuLkaaHxFu
wQiP02nk7Y0b0ER6IXpAyPlksaOxERaExZkUCFKIdCIXz6ur0Wf3CVtANvDc
4PVeKCyEt3zVD0ZgGObvEXKewSpMsDmEgwJIYgiE7xJu7nCLCJg0HQgYYYM5
OnWEnGOyuMAwKxAkIrxDuNkjLMrsIzaEgxcMsrcIOYssAqBYXKJqAoRYEP9N
wlGMHAjggJYzWLxlpBEmMWNrCUffSh7puhLtvYM/liOaidHe+oT6gzYogRic
rFQzgtWBQWTEIVdVvDfSfVHT59Ge2lioUYgWkhwPGNLlAENFiCRP+DP6F3yU
OZVLLHPVtRv0l0V7awSqhk2IdB8P+ndJoIwUmWariSN62iKWK+BH4FJ/e4Wm
zcOfqwa+nNA5DnypwpAuB/hHoEHnGPRvh0NdDiqDsR4LjsYvtkuuV2MO19BS
MX4yfvZdjXRVy/VN/fM6KwgwpO8A9PxMZwVncKHL6TkVKweevzVvkQlbb/gO
ZZyJeP72pkSs1g1yJgQCkgTLMAvlq1pEcklBl/9tFmJ35Bb7nJnN8D03OSuu
2HOmYDd8x0zF0mnaMXkKtty056dibX0OSc6ezhQOHa96GOs4rHlB/urI0oMY
XigaO3Hc3DRDQPMJn/k4rPH//n0kO+X9C/7c9mrgJuvmc7DV2rXKztjxt2aU
Kg6Hkn2Nf5LvsYpz2fj26LjkbIf7/c/2rfG5r+sVia0TUcZ2OeOpjWunNqUC
snO+zMzZDUFEuo4JgJtQ2ilY1lp/PE27ZKxxX6T7qO4n2nPadA6+jiFjLo6a
zsFnMG6Qdx1TGEiedk//9usJuxWK/ZrHbhVlvy5Lp9qzX0ParUpH1sFT1Xlr
qnPNlfcUdZaYKuuRFT6q8+D7kkl97zZjFbXuVN55turZVOGP/m4h/XsMy3uo
JLckSe+s/ngPk+zsa41OdeYZS630bp9Gd4s2Ombp5Wx83VYO/XoW8peJqe6m
+d7/0avM9xeEEl15g8uyfgPiHsTD\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{275, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->18933429]
}, Open  ]],

Cell["\<\
This finds the bandwidth of the graph with the above ordering:\
\>", "ExampleText",
 CellID->23199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"Subtract", "@@", "#"}], "]"}], "&"}], ",", 
    RowBox[{"g", "/.", "order"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->19668],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->2135769999]
}, Open  ]],

Cell["\<\
This finds a vertex ordering that attempts to minimize the bandwidth:\
\>", "ExampleText",
 CellID->1932703233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"neworder", "=", 
  RowBox[{"Thread", "[", 
   RowBox[{
    RowBox[{"MinimumBandwidthOrdering", "[", "g", "]"}], "\[Rule]", 
    RowBox[{"Range", "[", "6", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->24021],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "1"}], ",", 
   RowBox[{"b", "\[Rule]", "2"}], ",", 
   RowBox[{"c", "\[Rule]", "3"}], ",", 
   RowBox[{"e", "\[Rule]", "4"}], ",", 
   RowBox[{"d", "\[Rule]", "5"}], ",", 
   RowBox[{"f", "\[Rule]", "6"}]}], "}"}]], "Output",
 ImageSize->{254, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->2043319526]
}, Open  ]],

Cell["\<\
This renumbers the vertices using the minimum bandwidth ordering:\
\>", "ExampleText",
 CellID->3728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"g", "/.", "neworder"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1807493739],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWF1IXEcUHnd2TcHNk3kI9KHSEDAlpZKkxfSHCoVEQgTz5kMftLFlTQix
Rso+1UIpVqFJCxJDSGIIJZH8oKWhCSIuTWJ8iMGHPEhw1abWqlG67rruml11
+82Z++fde9dr0I1ZdJg75zvnfOfcmTtzpqyq3vfliar6mqNVBQfrqmp9NUdP
FRw4WYchnsNYTj5jrGw7Qz+FHv2L3zb8y67sfSJavrw4Ozd6Kjr2A8sTDY+O
fR999q0Q9RpQS4meyLAvOd/J8kTDE+GrkeGTVqiR46lUP8sTjXz+ejOh3ISi
jPTrzxuj5ULjhpLHMVr1gZblOtLiaFwvj/63t2I0EFhL1B7I/xs8drmkpL28
PDQ6yu6T7sekOzcxIdWZV2C3aHwGOzp+Lii4W1sLBPuTND4SrXvozp1zRUVS
yWuKwUWIvjNnWgoLAw0NyXg8QJr7RZsbD4U6Kyt/LS3VnJr1OekDB2V4f9Ta
2kP6xSSEZ9gdaGuTfvhyIhAJVkfH/GId+LEO/v4mMnJCiDxkB25u+3xQgWI3
2flAta/x4Irb/qUXXWKZeGmtLCdnaf2lRN6hMT04CDgyODEw0EWW3jcxeotw
eDPIzc2KCqT5LuH2pnl8m0aeXLsGTaQXoj8IuYcsjvX1wYKwuJMCQQqRTuTi
fmMj+uw2YYvIBp67/f4LxcXwVqj6wQgMw/zvhHzPYBUm2G7CQQEkMQTCvxHu
3ZUWETBpuhEwwgZzdDoIudtkca9hViBIRHiLcO+kWZTZR2wIBy8YZG8QchdZ
BECxuF/VBAixIP7rhKMYORDAAS1nsHjLSCNMYsa2E46+lTw2eTk+cwt/LE80
b8RnOlPqD9qgBGJw8qmaEawODCIjbrmqkjOxqYuaPo9PtycifUK0j+R4wJAu
BxgqQiR5wp/Rv+CjzKl8Ypmvrt1wsDo+0yJQLWxLbOqncPC4BMpIkWn2GXFE
T1vEcgUshC7NPavTtHn0n4b58dM6x/nxBgzpcoAXQt06x3DwKzjU5aCylJi2
4Gj8YufK9WrM4QFaKsZPxovZK7HJRrm+qX9eZwUBhvQdgJ7v6azgDC50OT2v
xsqN5+cDX8iEHTJ8h7LORDw/f1wpVuthORNCIUmCZZmF8lUtI7mkoMs3moXd
PmdmI3ZRruHsWa3cm+3ZccWexxFL2sPd+o6Zvveb+XpMeyxfhTc3nRJW4299
csliHA9//PA7DO8TjSEOa16QXz+yQ0ALCZ/9OFbOM/v3YB3vRrwH7mDWW1t/
1ey5SWu914Ld213vONzKnND423yP1W/FanNn5RzL/O3Rca/ZvrU593W9InF0
IsraLmc8tXHt1KZUQE7Ol9k5uyGI2GSzAHgJpZ2CZa2V8TSdK2NNBmJTTbqf
+PQvpnPwVQwZc9FkOgefxbhBPtmsMJA8nZ7+ndcTTisU5zWP0yrKeV22lmrP
eQ3ptCpNr4PfVOetqc41V97b1VliqqzTK3xU5+Ghyq2zTz/HKho+prxzl+rZ
VOG//N3C2u8xLO+hbG5JbO+sMt7D2J0CrNHWu+hm0lr7nVWmU4T93ZXL4ry3
We4hM6GWF+9FgtViqntpvs/95Vfm+wNCia68wWU5/wMZf8TD\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{275, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->158109831]
}, Open  ]],

Cell[TextData[{
 "This finds the bandwidth using the vertex ordering given by ",
 Cell[BoxData["MinimumBandwidthOrdering"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->27938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"Subtract", "@@", "#"}], "]"}], "&"}], ",", 
    RowBox[{"g", "/.", "neworder"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1064753963],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->1210508484]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4041],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->758789538],

Cell["This defines a rectangular matrix:", "ExampleText",
 CellID->24221],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"(", GridBox[{
      {"0", "0", "0", "0", "0", "0", "1", "2"},
      {"0", "0", "2", "1", "0", "0", "3", "2"},
      {"0", "2", "1", "2", "0", "0", "0", "3"},
      {"0", "1", "2", "3", "0", "2", "0", "0"},
      {"0", "0", "0", "2", "0", "0", "2", "1"},
      {"0", "2", "3", "0", "2", "1", "0", "0"}
     }], ")"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10383],

Cell["\<\
This finds the row and column ordering that attempts to minimize the \
bandwidth of the matrix:\
\>", "ExampleText",
 CellID->1828500338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"r", ",", "c"}], "}"}], "=", 
  RowBox[{"MinimumBandwidthOrdering", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->18588],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6", ",", "4", ",", "3", ",", "2", ",", "5", ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
    "5", ",", "6", ",", "2", ",", "3", ",", "4", ",", "8", ",", "7", ",", 
     "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{290, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1574512160]
}, Open  ]],

Cell["\<\
Plots of the matrix before and after the ordering show a decrease in \
bandwidth:\
\>", "ExampleText",
 CellID->13030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MatrixPlot", "[", "m", "]"}], ",", 
   RowBox[{"MatrixPlot", "[", 
    RowBox[{"m", "\[LeftDoubleBracket]", 
     RowBox[{"r", ",", "c"}], "\[RightDoubleBracket]"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->8909],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXF1u1DAQTjbbdvu3P+2CoAXEGxVvSOUJeIUnVHGE1QqpRSBQqXhG9BxI
leAMHIEDcAiuEew4bpzxjD1Od8tm60q7sRPPfJ8njv1lNs3rydnx2w+Ts5Pp
5OGr08mn45Pp54cvP56KXVmaJOm3JEm+30lEORel4iP/zsVHFTmlPfGdCdOh
2HbFdlDWd+XRTPvMk365f0dsO2I7AsdH5f7Dhv52wPFhuf9BwXIfOarrCWEN
2UH0pFvVE8tiaLU4nDsH2GJgtbiPRgM7FxCpizBswgBGYXbY/hZ47zE7OEIT
YgS6e6/H4NO5IUJPg9w16rHWGN+Rsc0IFPdZbYrk7zF+Dm1GVGR848325L+S
Z4duY1HX8F5ezXudkiUWwSHRzpxvm/jRZ6w+z8qmnFVD9uqnsLontj90jK1R
ssGJ1hyPQ/y718zP1x7i92MU5xbFC08v3oP6E5bXsfga//6a7v6dVuU/v949
9qBNxdeuaDsWbW9HpIi0UEi9XK0JKyGI1RpXWg8ILxa+ZblZsFirHxOFbjM+
otABlpte3w6WiL+eg7FsRjE9KI93LMtt0pfJbEzab7Q4hlno2DPayWKf8OEa
+dnluOuBI0ERWzHHsihbq5U3RpaHrWK7nqtrI4iN0a6T169KLw/EVo2pZZzx
IlI7kZ6V3h8ZKJkH5choK7cRKSJxkKiViYPoWpV86NXKBO904ArKYoL1zeHT
yw7Ue0vAVFYxhmrR1H/wPGL8ZBXy0poN2is+lPYmI8bW3Wh8CO3t00Akm2D9
g7IK1ECc0eTTP77R49ZAyzC/RaR2IhUKS1gUyqlUXLLsU1vP80ptaduIGBHb
jbgO9sJrjssAqgu4ukO/HIbQ53pLGUsl3E1AdgthaGa3ZPttYIcxuJWrdVbb
qPW2W+7VCkx9ozkiKlKrVTttb0YIU3RkhBBfmmHhw4p1J3dkVCnGbGVH8rQ8
rGLnt+VsffVFun6g6sR7BGeEec6aEGu2jOB9BIzpYjDUo3WxmEG77ZkxhKMS
3gOHMOyAeZTLDGKmBTMVPDWnbjVk1eQqkHe9qahKFik/RoZWl3pf5jt9Gv8A
2Ekb2AM8NqxxNSdGVxjpkVFkxGFUW/0zSn0weGUJnWvlcMzYygNdzZswBnVf
ppPVC099WXukdbipYS/vURDm9ZxultvaVVpj/PTdjbap3wGw7uoYkQxVpZxI
4nd1vpz9Ip175rMC1zBTqHw5+QvoHOZQz2+uETEiBiFKS62Pi2y1sJR1H6Jm
aurqFxExIrYa0cxtNkGGec5QFlXO08ydJKGM1i7bKevSB8x4shkS/hRTn9bh
xi5U63Diydc6WudhTJv98o/xk9kILCvKe26CG8lQDcaJJK3B3E+BOjlf8QlT
kjfjSVPqSQsm39yd5WYwy80nLm7C3BoRlxPxS15lZlGU2pjX3LRKfRMxIsa1
YchZP0NWEgvLykf2TUs/smXP00quPrP0UVBM+E8kyKrJra6IYDQxZrJaFIS1
dDAC3I6IM8N7SmJR4xY5hnOklJn7GrXUWOA1Smuxts51EaM5xgXm13E8/u82
djz+B/z/jaJ8R8N+uVXvaJANzoNK8Q1BykV8QxCPQXxDUHxDUHxDkHPuvgFv
CErSf68a8Lo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->261517577]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21248],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Method",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->18762],

Cell[TextData[{
 "This finds orderings of a matrix using the methods ",
 Cell[BoxData["\"\<RCMD\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Sloan\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->20537],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->328255158],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "1", "1", "0", "1", "0", "0", "1", "1", "1"},
      {"1", "1", "1", "0", "1", "0", "0", "1", "0", "1"},
      {"1", "1", "2", "2", "0", "0", "1", "1", "0", "0"},
      {"0", "0", "2", "1", "1", "2", "0", "0", "0", "1"},
      {"1", "1", "0", "1", "1", "0", "1", "0", "1", "1"},
      {"0", "0", "0", "2", "0", "1", "0", "0", "0", "1"},
      {"0", "0", "1", "0", "1", "0", "1", "0", "0", "1"},
      {"1", "1", "1", "0", "0", "0", "0", "2", "0", "0"},
      {"1", "0", "0", "0", "1", "0", "0", "0", "2", "0"},
      {"1", "1", "0", "1", "1", "1", "1", "0", "0", "1"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{
      "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
       "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\[NoBreak]", 
    ")"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6359],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"r1", ",", "c1"}], "}"}], "=", 
   RowBox[{"MinimumBandwidthOrdering", "[", 
    RowBox[{"m", ",", 
     RowBox[{"Method", "\[Rule]", "\"\<RCMD\>\""}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"r2", ",", "c2"}], "}"}], "=", 
   RowBox[{"MinimumBandwidthOrdering", "[", 
    RowBox[{"m", ",", 
     RowBox[{"Method", "\[Rule]", "\"\<Sloan\>\""}]}], "]"}]}], 
  ";"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->21548],

Cell[TextData[{
 "The maximum bandwidth given by ",
 Cell[BoxData["\"\<RCMD\>\""], "InlineFormula"],
 " is smaller; envelope size given by ",
 Cell[BoxData["\"\<Sloan\>\""], "InlineFormula"],
 " is smaller:"
}], "ExampleText",
 CellID->6483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MatrixPlot", "[", 
    RowBox[{"m", "[", 
     RowBox[{"[", 
      RowBox[{"r1", ",", "c1"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"MatrixPlot", "[", 
    RowBox[{"m", "[", 
     RowBox[{"[", 
      RowBox[{"r2", ",", "c2"}], "]"}], "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->27624],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 186},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->351999521]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10943],

Cell["\<\
One of the applications of minimum bandwidth ordering is in optimizing cache \
performance of numerical calculations. For example, in multiplying a sparse \
matrix with a vector, if the matrix is preordered to minimize the bandwidth, \
then elements of the vector will not be accessed randomly, thus improving \
cache performance. Because ordering itself takes time, this improvement in \
cache performance would be beneficial only if the matrix-vector product \
operation is to be performed repeatedly many times.\
\>", "ExampleText",
 CellID->1186433259],

Cell["\<\
This generates a banded matrix, and then randomly permutes it:\
\>", "ExampleText",
 CellID->617122973],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->657766648],

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", "200000"}], ";", 
  RowBox[{"a", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", 
        RowBox[{"Random", "[", "]"}]}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], "]"}], "\[Rule]", 
        RowBox[{"Random", "[", "]"}]}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}], "]"}], "\[Rule]", 
        RowBox[{"Random", "[", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "n"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->484997384],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{"Ordering", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"1", ",", 
      RowBox[{"{", "n", "}"}]}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"q", "=", 
   RowBox[{"Ordering", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"1", ",", 
      RowBox[{"{", "n", "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"a", "[", 
    RowBox[{"[", 
     RowBox[{"p", ",", "q"}], "]"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1268113918],

Cell["This performs a matrix-vector product 50 times:", "ExampleText",
 CellID->43315634],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "n", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"bx", "=", 
       RowBox[{"b", ".", "x"}]}], ";"}], ",", 
     RowBox[{"{", "50", "}"}]}], "]"}], ";"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->1209087470],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.292332000000007`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1209737354]
}, Open  ]],

Cell["\<\
This permutes the matrix to minimize the bandwidth, and permutes the vector \
correspondingly:\
\>", "ExampleText",
 CellID->1131529567],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"r", ",", "c"}], "}"}], "=", 
   RowBox[{"MinimumBandwidthOrdering", "[", "b", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"aa", "=", 
   RowBox[{"b", "[", 
    RowBox[{"[", 
     RowBox[{"r", ",", "c"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"xx", "=", 
   RowBox[{"x", "[", 
    RowBox[{"[", "c", "]"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->1045269098],

Cell["\<\
This shows that the matrix-vector product now takes less time:\
\>", "ExampleText",
 CellID->689341299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"aax", "=", 
      RowBox[{"aa", ".", "xx"}]}], ",", 
     RowBox[{"{", "50", "}"}]}], "]"}], ";"}], "//", "Timing"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1397158291],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.0600660000000066`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->764357589]
}, Open  ]],

Cell["\<\
This checks that the answer is the same, subject to a permutation:\
\>", "ExampleText",
 CellID->1637778318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"aax", "\[Equal]", 
  RowBox[{"bx", "[", 
   RowBox[{"[", "r", "]"}], "]"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1240548019],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->164468256]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20520],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["MinCut",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/MinCut"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->2510]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10803],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->17784]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->2074824892],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MinimumBandwidthOrdering - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 23.5545292}", "context" -> 
    "GraphUtilities`", 
    "keywords" -> {
     "matrix bandwidth matrix profile RCM reverse Cuthill McKee ordering \
Sloan algorithm"}, "index" -> True, "label" -> 
    "Graph Utilities Package Symbol", "language" -> "en", "paclet" -> 
    "GraphUtilities Package", "status" -> "None", "summary" -> 
    "MinimumBandwidthOrdering[g] attempts to find a vertex ordering that \
minimizes the bandwidth of the undirected graph g. \
MinimumBandwidthOrdering[m] attempts to find row and column permutations that \
minimize the bandwidth of the matrix m.", "synonyms" -> {}, "title" -> 
    "MinimumBandwidthOrdering", "type" -> "Symbol", "uri" -> 
    "GraphUtilities/ref/MinimumBandwidthOrdering"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7445, 257, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->499517470]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33258, 1081}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1810, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2433, 75, 62, 1, 70, "ObjectName",
 CellID->21357],
Cell[2498, 78, 883, 26, 70, "Usage",
 CellID->15372]
}, Open  ]],
Cell[CellGroupData[{
Cell[3418, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3896, 126, 321, 12, 70, "Notes",
 CellID->73304195],
Cell[4220, 140, 510, 18, 70, "Notes",
 CellID->2079441987],
Cell[4733, 160, 271, 11, 70, "Notes",
 CellID->9908418],
Cell[5007, 173, 322, 10, 70, "Notes",
 CellID->622328966],
Cell[5332, 185, 93, 1, 70, "Notes",
 CellID->852769207],
Cell[5428, 188, 476, 16, 70, "Notes",
 CellID->2060496198],
Cell[5907, 206, 140, 4, 70, "Notes",
 CellID->200570946],
Cell[6050, 212, 149, 4, 70, "Notes",
 CellID->1217078083],
Cell[6202, 218, 68, 1, 70, "Notes",
 CellID->23374],
Cell[6273, 221, 1135, 31, 70, "3ColumnTableMod",
 CellID->3801]
}, Closed]],
Cell[CellGroupData[{
Cell[7445, 257, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->499517470],
Cell[CellGroupData[{
Cell[7830, 271, 148, 5, 70, "ExampleSection",
 CellID->178504799],
Cell[7981, 278, 139, 4, 70, "Input",
 CellID->652588188],
Cell[8123, 284, 66, 1, 70, "ExampleText",
 CellID->24350],
Cell[8192, 287, 386, 12, 70, "Input",
 CellID->4596],
Cell[8581, 301, 249, 8, 70, "ExampleText",
 CellID->1788945258],
Cell[CellGroupData[{
Cell[8855, 313, 242, 7, 70, "Input",
 CellID->828951749],
Cell[9100, 322, 424, 13, 36, "Output",
 CellID->884110759]
}, Open  ]],
Cell[CellGroupData[{
Cell[9561, 340, 204, 6, 28, "Input",
 CellID->1045789575],
Cell[9768, 348, 1825, 34, 98, "Output",
 Evaluatable->False,
 CellID->18933429]
}, Open  ]],
Cell[11608, 385, 109, 3, 70, "ExampleText",
 CellID->23199],
Cell[CellGroupData[{
Cell[11742, 392, 267, 9, 70, "Input",
 CellID->19668],
Cell[12012, 403, 159, 5, 36, "Output",
 CellID->2135769999]
}, Open  ]],
Cell[12186, 411, 121, 3, 70, "ExampleText",
 CellID->1932703233],
Cell[CellGroupData[{
Cell[12332, 418, 245, 7, 70, "Input",
 CellID->24021],
Cell[12580, 427, 425, 13, 36, "Output",
 CellID->2043319526]
}, Open  ]],
Cell[13020, 443, 111, 3, 70, "ExampleText",
 CellID->3728],
Cell[CellGroupData[{
Cell[13156, 450, 207, 6, 28, "Input",
 CellID->1807493739],
Cell[13366, 458, 1846, 34, 98, "Output",
 Evaluatable->False,
 CellID->158109831]
}, Open  ]],
Cell[15227, 495, 181, 5, 70, "ExampleText",
 CellID->27938],
Cell[CellGroupData[{
Cell[15433, 504, 275, 9, 70, "Input",
 CellID->1064753963],
Cell[15711, 515, 159, 5, 36, "Output",
 CellID->1210508484]
}, Open  ]],
Cell[15885, 523, 120, 3, 70, "ExampleDelimiter",
 CellID->4041],
Cell[16008, 528, 139, 4, 70, "Input",
 CellID->758789538],
Cell[16150, 534, 73, 1, 70, "ExampleText",
 CellID->24221],
Cell[16226, 537, 431, 12, 70, "Input",
 CellID->10383],
Cell[16660, 551, 147, 4, 70, "ExampleText",
 CellID->1828500338],
Cell[CellGroupData[{
Cell[16832, 559, 186, 6, 70, "Input",
 CellID->18588],
Cell[17021, 567, 418, 14, 36, "Output",
 CellID->1574512160]
}, Open  ]],
Cell[17454, 584, 128, 4, 70, "ExampleText",
 CellID->13030],
Cell[CellGroupData[{
Cell[17607, 592, 284, 9, 28, "Input",
 CellID->8909],
Cell[17894, 603, 1872, 35, 178, "Output",
 Evaluatable->False,
 CellID->261517577]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19815, 644, 218, 7, 70, "ExampleSection",
 CellID->21248],
Cell[CellGroupData[{
Cell[20058, 655, 223, 7, 70, "ExampleSubsection",
 CellID->18762],
Cell[20284, 664, 220, 7, 70, "ExampleText",
 CellID->20537],
Cell[20507, 673, 139, 4, 70, "Input",
 CellID->328255158],
Cell[20649, 679, 1034, 23, 70, "Input",
 CellID->6359],
Cell[21686, 704, 515, 17, 70, "Input",
 CellID->21548],
Cell[22204, 723, 241, 7, 70, "ExampleText",
 CellID->6483],
Cell[CellGroupData[{
Cell[22470, 734, 357, 12, 70, "Input",
 CellID->27624],
Cell[22830, 748, 2429, 44, 70, "Output",
 Evaluatable->False,
 CellID->351999521]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[25320, 799, 223, 7, 70, "ExampleSection",
 CellID->10943],
Cell[25546, 808, 566, 9, 70, "ExampleText",
 CellID->1186433259],
Cell[26115, 819, 113, 3, 70, "ExampleText",
 CellID->617122973],
Cell[26231, 824, 139, 4, 70, "Input",
 CellID->657766648],
Cell[26373, 830, 826, 26, 70, "Input",
 CellID->484997384],
Cell[27202, 858, 571, 20, 70, "Input",
 CellID->1268113918],
Cell[27776, 880, 89, 1, 70, "ExampleText",
 CellID->43315634],
Cell[CellGroupData[{
Cell[27890, 885, 421, 15, 70, "Input",
 CellID->1209087470],
Cell[28314, 902, 225, 7, 36, "Output",
 CellID->1209737354]
}, Open  ]],
Cell[28554, 912, 146, 4, 70, "ExampleText",
 CellID->1131529567],
Cell[28703, 918, 452, 16, 70, "Input",
 CellID->1045269098],
Cell[29158, 936, 113, 3, 70, "ExampleText",
 CellID->689341299],
Cell[CellGroupData[{
Cell[29296, 943, 259, 9, 70, "Input",
 CellID->1397158291],
Cell[29558, 954, 225, 7, 36, "Output",
 CellID->764357589]
}, Open  ]],
Cell[29798, 964, 118, 3, 70, "ExampleText",
 CellID->1637778318],
Cell[CellGroupData[{
Cell[29941, 971, 155, 5, 70, "Input",
 CellID->1240548019],
Cell[30099, 978, 161, 5, 36, "Output",
 CellID->164468256]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30321, 990, 311, 9, 70, "SeeAlsoSection",
 CellID->20520],
Cell[30635, 1001, 206, 6, 70, "SeeAlso",
 CellID->2510]
}, Open  ]],
Cell[CellGroupData[{
Cell[30878, 1012, 314, 9, 70, "TutorialsSection",
 CellID->10803],
Cell[31195, 1023, 163, 3, 70, "Tutorials",
 CellID->17784]
}, Open  ]],
Cell[CellGroupData[{
Cell[31395, 1031, 320, 9, 70, "MoreAboutSection",
 CellID->2074824892],
Cell[31718, 1042, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[31907, 1049, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

