(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21722,        639]
NotebookOptionsPosition[     18474,        531]
NotebookOutlinePosition[     19733,        567]
CellTagsIndexPosition[     19648,        562]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PageRanks" :> 
          Documentation`HelpLookup["paclet:GraphUtilities/ref/PageRanks"], 
          "LinkRanks" :> 
          Documentation`HelpLookup["paclet:GraphUtilities/ref/LinkRanks"], 
          "LinkRankMatrix" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/LinkRankMatrix"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"PageRanks\"\>", 2->"\<\"LinkRanks\"\>", 
       3->"\<\"LinkRankMatrix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PageRankVector", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PageRankVector", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns the page rank of the graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given:", "Notes",
 CellID->1067943069],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Tolerance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Tolerance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the tolerance that should be allowed in computing results", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TeleportProbability",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/TeleportProbability"], "0.15", 
    Cell["\<\
the probability that an internet user may choose to visit a vertex at random \
instead of choosing an out-link\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RemoveSinks",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/RemoveSinks"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether sinks (a sink is a vertex with no outer links) are removed by linking \
with all vertices\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->423733410],

Cell[TextData[{
 Cell[BoxData["PageRankVector"], "InlineFormula"],
 " calculates the page rank of nodes in a directed graph and returns them as \
a vector. The ordering of the vector is the same as that of ",
 Cell[BoxData[
  ButtonBox["VertexList",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/VertexList"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->673919908]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->112021882],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->58531436],

Cell["This shows a small network of web pages:", "ExampleText",
 CellID->1919210435],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->58575148],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<home\>\"", "\[Rule]", "\"\<contact\>\""}], ",", 
     RowBox[{"\"\<home\>\"", "\[Rule]", "\"\<links\>\""}], ",", 
     RowBox[{"\"\<home\>\"", "\[Rule]", "\"\<work\>\""}], ",", 
     RowBox[{"\"\<links\>\"", "\[Rule]", "\"\<friend site\>\""}], ",", 
     RowBox[{"\"\<friend site\>\"", "\[Rule]", "\"\<home\>\""}], ",", 
     RowBox[{"\"\<work\>\"", "\[Rule]", "\"\<home\>\""}], ",", 
     RowBox[{"\"\<contact\>\"", "\[Rule]", "\"\<home\>\""}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->447035564],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJw9Un0w1AkA3RZL6janOBLG5lh3ade50+ajd3VUiJywV7l8VNcpRtpL42M6
KU3l6EREcardtKeIbB+cfFRce1dTFypdwiKXtX6/Xfb3+zlxbubm3sybN/Pe
X+/Nc4hNDN3JZrFYfrP8Vx2zPvr2kpsGisZ6mcv9v3DbLG3T4PAkPPLjeo1a
GLD+Q9Ju2dtLPVoUn2AnePZO/u+zPhcr/be7413IxsjTl19it2dHR59+DFNm
C+ySjEcRtMxWaO5JQF9iEFIzMArugqu5x9IJZNv+/Ed8owZRvj2CplYCteOC
61F5Y+Bv3WVWPp8EFb+5aamQgLD6GWfRFhImhtmVZAGBwm3dSnYlCUfvKwaT
egJst6dToTMkFqlr59lFkFhgK+jS3dLDYM7Iq4E0PcqY5cbZZhSWWg61cJ7r
4ZDg0xK0h4L0B/FPc90oZFWMn7R/QGGNYk3uk6MUvvZJmKtyoXGSHJF/8YJC
VV/ys5QcGlL+Ouu1fBoN7jYt93Sz+UbzD5olNC7KdtVdjGRgmFbMFDfQOCIO
PxMoJfCotCPI6PYbJAaGqXSzfQS7AmIn+W8gnZ2RI5ntV8R1uJ43hJKg5v7t
XSQe7JBS23SDCMocSVR7aHHj4Z7jguBBLLNSmGYWaCGvfr/8qwsD2JBuEWk8
pgUTvMnGjFAh/PAbdvRaHWL2Le7NWaHCMU7vhuNTFDqsV3ZGP3kCrqxtqDiE
Rv2w9kJk2GOI21ut1p+nMX6ZFVpe9BDRRclFqRoaqhQvbfxeJaxKFgqsRQyq
5PNFSz5th8iZVM4/yEDinPe0RnUXXd2/pqOZQZwhr3VFRjNeNRQePjfN4H5O
70SaRT0sPJxK13EmkR8Hx357GtNOEvGldganHf3mramh4OOrogVZDAJVpP+A
LwU1t1bMrGJwi6p68bZbD0eaf8BqgsbirFFdskSPJdJbGdIKGiaaBmM5Vw/F
uOIXRQSNUUVJdfmVCfjzGk/sZNN4Z1RQkR40AW+PmJp763Xgkls7Fc4EqjbH
ZLiSWnTfbOl3LhqDy1Bo2+5CLZ4re5x5gxq0VZ6lzoi0OJdiEnBqpQajFksP
dj4jZ/9zw7yqYBRlSdbXVn1H4sWpGXe5Xo0f7fe36d4jYegXJ1JEqSG/yn+6
SEbAWrNFMufxCCr2t5q0hjFYPiNs4sVcQ8Ohu43WahqCukyb1L46HHV2neQc
paF2jfmw7uxt5H0vviPn0Yhsr90bnnsHrwKWuTm0UqCbvJKGX7Zgpi62MHsH
BYFIaumbfQ+vQ9h+HFMKmvpSl2/C2tHlLyy7WqvHBtdDlokeSkjbVoQdmSKh
FNp5pfzZC1v+l/WSyyTE/qvD/i7pQ6dR+LH7YhIH8j3zVkf147fPzs/NNyXh
/frjOK6LCgvdDfeNNxMIyL9ZxKNV0MmculhpBJ5LuoQ+vw8gQhvs+EhEoMT7
E4WNbBClPLZX//gY3lVOO6VmDuEffMIu0Q==
    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03590271334768575, 0.7}}], 
      ArrowBox[{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
        2}], ArrowBox[{1, 3}], 
      ArrowBox[{1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
        37, 4}], 
      ArrowBox[{2, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52,
        53, 1}], ArrowBox[{3, 5}], 
      ArrowBox[{4, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68,
        69, 1}], ArrowBox[{5, 1}]}, {InsetBox[
       FrameBox["\<\"home\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"contact\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"links\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["\<\"work\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["\<\"friend site\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.9435607943052315, 0.8053177105811559}, {
     1.681859327408388, 1.609624744997928}, {0., 1.1793584028115698`}, {
     1.6797432192039763`, 0.}, {0.00029583503268515443`, 
     0.43216451658851424`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{250., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{254, 239},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->766933316]
}, Open  ]],

Cell["This calculates the page ranks:", "ExampleText",
 CellID->229166973],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pr", "=", 
  RowBox[{"PageRankVector", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->887137233],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.4086886646564918`", ",", "0.14579518488549334`", ",", 
   "0.14579518488549334`", ",", "0.14579518488549334`", ",", 
   "0.15392578068702797`"}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{343, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1929871105]
}, Open  ]],

Cell["This replots the network with page rank information:", "ExampleText",
 CellID->1491429241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Framed", "[", 
         RowBox[{
          RowBox[{"#2", "<>", "\"\<\\n\>\"", "<>", 
           RowBox[{"ToString", "[", 
            RowBox[{"pr", "[", 
             RowBox[{"[", "#3", "]"}], "]"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Background", "\[Rule]", 
             RowBox[{"RGBColor", "[", 
              RowBox[{"1", ",", "1", ",", "0.8"}], "]"}]}], ",", 
            RowBox[{"FrameStyle", "\[Rule]", 
             RowBox[{"RGBColor", "[", 
              RowBox[{"0.94", ",", "0.85", ",", "0.36"}], "]"}]}]}], "}"}]}], 
         "]"}], ",", "#1"}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->792825671],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{GraphicsComplexBox[CompressedData["
1:eJw9Un0w1AkA3RZL6janOBLG5lh3ade50+ajd3VUiJywV7l8VNcpRtpL42M6
KU3l6EREcardtKeIbB+cfFRce1dTFypdwiKXtX6/Xfb3+zlxbubm3sybN/Pe
X+/Nc4hNDN3JZrFYfrP8Vx2zPvr2kpsGisZ6mcv9v3DbLG3T4PAkPPLjeo1a
GLD+Q9Ju2dtLPVoUn2AnePZO/u+zPhcr/be7413IxsjTl19it2dHR59+DFNm
C+ySjEcRtMxWaO5JQF9iEFIzMArugqu5x9IJZNv+/Ed8owZRvj2CplYCteOC
61F5Y+Bv3WVWPp8EFb+5aamQgLD6GWfRFhImhtmVZAGBwm3dSnYlCUfvKwaT
egJst6dToTMkFqlr59lFkFhgK+jS3dLDYM7Iq4E0PcqY5cbZZhSWWg61cJ7r
4ZDg0xK0h4L0B/FPc90oZFWMn7R/QGGNYk3uk6MUvvZJmKtyoXGSHJF/8YJC
VV/ys5QcGlL+Ouu1fBoN7jYt93Sz+UbzD5olNC7KdtVdjGRgmFbMFDfQOCIO
PxMoJfCotCPI6PYbJAaGqXSzfQS7AmIn+W8gnZ2RI5ntV8R1uJ43hJKg5v7t
XSQe7JBS23SDCMocSVR7aHHj4Z7jguBBLLNSmGYWaCGvfr/8qwsD2JBuEWk8
pgUTvMnGjFAh/PAbdvRaHWL2Le7NWaHCMU7vhuNTFDqsV3ZGP3kCrqxtqDiE
Rv2w9kJk2GOI21ut1p+nMX6ZFVpe9BDRRclFqRoaqhQvbfxeJaxKFgqsRQyq
5PNFSz5th8iZVM4/yEDinPe0RnUXXd2/pqOZQZwhr3VFRjNeNRQePjfN4H5O
70SaRT0sPJxK13EmkR8Hx357GtNOEvGldganHf3mramh4OOrogVZDAJVpP+A
LwU1t1bMrGJwi6p68bZbD0eaf8BqgsbirFFdskSPJdJbGdIKGiaaBmM5Vw/F
uOIXRQSNUUVJdfmVCfjzGk/sZNN4Z1RQkR40AW+PmJp763Xgkls7Fc4EqjbH
ZLiSWnTfbOl3LhqDy1Bo2+5CLZ4re5x5gxq0VZ6lzoi0OJdiEnBqpQajFksP
dj4jZ/9zw7yqYBRlSdbXVn1H4sWpGXe5Xo0f7fe36d4jYegXJ1JEqSG/yn+6
SEbAWrNFMufxCCr2t5q0hjFYPiNs4sVcQ8Ohu43WahqCukyb1L46HHV2neQc
paF2jfmw7uxt5H0vviPn0Yhsr90bnnsHrwKWuTm0UqCbvJKGX7Zgpi62MHsH
BYFIaumbfQ+vQ9h+HFMKmvpSl2/C2tHlLyy7WqvHBtdDlokeSkjbVoQdmSKh
FNp5pfzZC1v+l/WSyyTE/qvD/i7pQ6dR+LH7YhIH8j3zVkf147fPzs/NNyXh
/frjOK6LCgvdDfeNNxMIyL9ZxKNV0MmculhpBJ5LuoQ+vw8gQhvs+EhEoMT7
E4WNbBClPLZX//gY3lVOO6VmDuEffMIu0Q==
      "], 
      {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03590271334768575, 0.7}}], 
       ArrowBox[{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
        21, 2}], ArrowBox[{1, 3}], 
       ArrowBox[{1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
        36, 37, 4}], 
       ArrowBox[{2, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
        52, 53, 1}], ArrowBox[{3, 5}], 
       ArrowBox[{4, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 
        68, 69, 1}], ArrowBox[{5, 1}]}], {InsetBox[
       FrameBox["\<\"home\\n0.408689\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], {0.9435607943052315, 0.8053177105811559}], 
      InsetBox[
       FrameBox["\<\"contact\\n0.145795\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], {1.681859327408388, 1.609624744997928}], 
      InsetBox[
       FrameBox["\<\"links\\n0.145795\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], {0., 1.1793584028115698`}], InsetBox[
       FrameBox["\<\"work\\n0.145795\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], {1.6797432192039763`, 0.}], InsetBox[
       FrameBox["\<\"friend site\\n0.153926\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->
         False], {0.00029583503268515443`, 0.43216451658851424`}]}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0.9435607943052315, 0.8053177105811559}, {
     1.681859327408388, 1.609624744997928}, {0., 1.1793584028115698`}, {
     1.6797432192039763`, 0.}, {0.00029583503268515443`, 
     0.43216451658851424`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{253., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{257, 242},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1392175673]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageRanks",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/PageRanks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkRanks",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/LinkRanks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkRankMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/LinkRankMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2039608292]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PageRankVector - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 24.2576722}", "context" -> 
    "GraphUtilities`", "keywords" -> {"PageRank page ranks"}, "index" -> True,
     "label" -> "Graph Utilities Package Symbol", "language" -> "en", 
    "paclet" -> "GraphUtilities Package", "status" -> "None", "summary" -> 
    "PageRankVector[g] returns the page rank of the graph g.", 
    "synonyms" -> {}, "title" -> "PageRankVector", "type" -> "Symbol", "uri" -> 
    "GraphUtilities/ref/PageRankVector"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5542, 174, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->112021882]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19505, 555}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2097, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2720, 80, 57, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2780, 83, 474, 15, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3291, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3769, 120, 73, 1, 70, "Notes",
 CellID->1067943069],
Cell[3845, 123, 1272, 34, 70, "3ColumnTableMod",
 CellID->423733410],
Cell[5120, 159, 385, 10, 70, "Notes",
 CellID->673919908]
}, Closed]],
Cell[CellGroupData[{
Cell[5542, 174, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->112021882],
Cell[CellGroupData[{
Cell[5927, 188, 147, 5, 70, "ExampleSection",
 CellID->58531436],
Cell[6077, 195, 84, 1, 70, "ExampleText",
 CellID->1919210435],
Cell[6164, 198, 138, 4, 70, "Input",
 CellID->58575148],
Cell[6305, 204, 607, 14, 70, "Input",
 CellID->3584],
Cell[CellGroupData[{
Cell[6937, 222, 229, 6, 28, "Input",
 CellID->447035564],
Cell[7169, 230, 3514, 74, 260, "Output",
 CellID->766933316]
}, Open  ]],
Cell[10698, 307, 74, 1, 70, "ExampleText",
 CellID->229166973],
Cell[CellGroupData[{
Cell[10797, 312, 134, 4, 70, "Input",
 CellID->887137233],
Cell[10934, 318, 390, 12, 36, "Output",
 CellID->1929871105]
}, Open  ]],
Cell[11339, 333, 96, 1, 70, "ExampleText",
 CellID->1491429241],
Cell[CellGroupData[{
Cell[11460, 338, 948, 25, 70, "Input",
 CellID->792825671],
Cell[12411, 365, 3822, 78, 263, "Output",
 CellID->1392175673]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16294, 450, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[16613, 461, 762, 26, 70, "SeeAlso",
 CellID->2039608292]
}, Open  ]],
Cell[CellGroupData[{
Cell[17412, 492, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[17733, 503, 167, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[17937, 511, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[18258, 522, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[18447, 529, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

