(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     45540,       1328]
NotebookOptionsPosition[     39495,       1116]
NotebookOutlinePosition[     40831,       1153]
CellTagsIndexPosition[     40745,       1148]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ClosenessCentrality" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/ClosenessCentrality"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"ClosenessCentrality\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PseudoDiameter", "ObjectName",
 CellID->31817],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PseudoDiameter", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the pseudo diameter of the undirected graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     ", and the two vertices that achieve this diameter."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5785]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A graph geodesic is a shortest path between two vertices of a graph. The \
graph diameter is the longest possible length of all graph geodesics of the \
graph. ",
 Cell[BoxData["PseudoDiameter"], "InlineFormula"],
 " finds an approximate graph diameter. It works by starting from a vertex ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 ", and finds a vertex ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " that is farthest away from ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 ". This process is repeated by treating ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " as the new starting vertex, and ends when the graph distance no longer \
increases. A vertex from the last level set that has the smallest degree is \
chosen as the final starting vertex ",
 Cell[BoxData["u"], "InlineFormula"],
 ", and a traversal is done to see if the graph distance can be increased. \
This graph distance is taken to be the pseudo diameter."
}], "Notes",
 CellID->52933267],

Cell["\<\
If the graph is disconnected, then the diameter and vertices for each \
connected component are returned.\
\>", "Notes",
 CellID->2861],

Cell["The following option can be given:", "Notes",
 CellID->17366],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Aggressive",
     BaseStyle->"Link",
     ButtonData->"paclet:GraphUtilities/ref/Aggressive"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to make extra effort in finding the optimal graph diameter\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->29660]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->326192333],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->421654808],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->181657746],

Cell["The pseudo diameter of the graph of a square is 2:", "ExampleText",
 CellID->9514],

Cell[BoxData[
 RowBox[{
  RowBox[{"square", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"pseudodiameter", ",", "vertices"}], "}"}], "}"}], "=", 
  RowBox[{"PseudoDiameter", "[", "square", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->18935],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"2", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}], "}"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1661678734]
}, Open  ]],

Cell["\<\
A plot showing the graph with the two vertices of the pseudo diameter \
highlighted in red:\
\>", "ExampleText",
 CellID->20600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"square", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"MemberQ", "[", 
           RowBox[{"vertices", ",", "#2"}], "]"}], ",", "Red", ",", "Green"}],
          "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#", ",", ".05"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->6617],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{1.0286626995857617`, 0.026062774776559994`}, {
      0.029269575939381676`, 0.}, {0., 0.9993848418507059}, {
      0.9999385632238776, 1.0258160108581333`}}, 
      {RGBColor[0.5, 0., 0.], LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 1}}]}], {
      {RGBColor[1, 0, 0], 
       DiskBox[{1.0286626995857617`, 0.026062774776559994`}, 0.05]}, 
      {RGBColor[0, 1, 0], DiskBox[{0.029269575939381676`, 0.}, 0.05]}, 
      {RGBColor[1, 0, 0], DiskBox[{0., 0.9993848418507059}, 0.05]}, 
      {RGBColor[0, 1, 0], 
       DiskBox[{0.9999385632238776, 1.0258160108581333`}, 0.05]}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{1.0286626995857617`, 0.026062774776559994`}, {
     0.029269575939381676`, 0.}, {0., 0.9993848418507059}, {
     0.9999385632238776, 1.0258160108581333`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1768771463]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14989],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->90808125],

Cell["Here is a matrix representation of the graph of a torus:", "ExampleText",
 CellID->17807],

Cell[BoxData[
 RowBox[{
  RowBox[{"torus", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"10", "i"}], "+", "j", "+", "1"}], ",", 
            RowBox[{
             RowBox[{"10", 
              RowBox[{"Mod", "[", 
               RowBox[{
                RowBox[{"i", "+", "1"}], ",", "5"}], "]"}]}], "+", "j", "+", 
             "1"}]}], "}"}], "\[Rule]", "1"}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"10", "i"}], "+", "j", "+", "1"}], ",", 
            RowBox[{
             RowBox[{"10", 
              RowBox[{"Mod", "[", 
               RowBox[{
                RowBox[{"i", "-", "1"}], ",", "5"}], "]"}]}], "+", "j", "+", 
             "1"}]}], "}"}], "\[Rule]", "1"}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"10", "i"}], "+", "j", "+", "1"}], ",", 
            RowBox[{
             RowBox[{"10", "i"}], "+", 
             RowBox[{"Mod", "[", 
              RowBox[{
               RowBox[{"j", "+", "1"}], ",", "10"}], "]"}], "+", "1"}]}], 
           "}"}], "\[Rule]", "1"}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"10", "i"}], "+", "j", "+", "1"}], ",", 
            RowBox[{
             RowBox[{"10", "i"}], "+", 
             RowBox[{"Mod", "[", 
              RowBox[{
               RowBox[{"j", "-", "1"}], ",", "10"}], "]"}], "+", "1"}]}], 
           "}"}], "\[Rule]", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0", ",", "9"}], "}"}]}], "]"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19668],

Cell["The pseudo-diameter of this torus is 7:", "ExampleText",
 CellID->14310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"pseudodiameter", ",", "vertices"}], "}"}], "}"}], "=", 
  RowBox[{"PseudoDiameter", "[", "torus", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20485],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"7", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "26"}], "}"}]}], "}"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1341190873]
}, Open  ]],

Cell["\<\
This finds the graph geodesic between vertices 1 and 26, highlighting the \
graph geodesic in red:\
\>", "ExampleText",
 CellID->2421],

Cell[BoxData[
 RowBox[{
  RowBox[{"path", "=", 
   RowBox[{"GraphPath", "[", 
    RowBox[{"torus", ",", "1", ",", "26"}], "]"}]}], ";", 
  RowBox[{"edges", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Drop", "[", 
       RowBox[{"path", ",", 
        RowBox[{"-", "1"}]}], "]"}], ",", 
      RowBox[{"Drop", "[", 
       RowBox[{"path", ",", "1"}], "]"}]}], "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->599761383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"torus", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"MemberQ", "[", 
           RowBox[{"vertices", ",", "#2"}], "]"}], ",", "Red", ",", "Green"}],
          "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#1", ",", ".08"}], "]"}]}], "}"}], "&"}], ")"}]}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"MemberQ", "[", 
          RowBox[{"edges", ",", "#2"}], "]"}], "||", 
         RowBox[{"MemberQ", "[", 
          RowBox[{"edges", ",", 
           RowBox[{"Reverse", "[", "#2", "]"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
          RowBox[{"Line", "[", "#", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Black", ",", 
          RowBox[{"Line", "[", "#", "]"}]}], "}"}]}], "]"}], "&"}], ")"}]}]}],
   "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->3728],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{229, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->309938416]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24897],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->92657749],

Cell["A graph with disconnected components:", "ExampleText",
 CellID->20580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}], ",", 
    RowBox[{"4", "\[Rule]", "5"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19796],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "2"}], ",", 
   RowBox[{"2", "\[Rule]", "3"}], ",", 
   RowBox[{"4", "\[Rule]", "5"}]}], "}"}]], "Output",
 ImageSize->{131, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1917520557]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["PseudoDiameter"], "InlineFormula"],
 " returns a list with pseudo-diameters and vertices for each component:"
}], "ExampleText",
 CellID->14798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PseudoDiameter", "[", "g", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15281],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1562743651]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4217],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->1945668000],

Cell["This shows a a small directed graph:", "ExampleText",
 CellID->1414025651],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "6"}], ",", 
     RowBox[{"4", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2077925721],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", " ", "True"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->807651903],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.1493322121100826`, 0.00024224688259011362`}, {
    1.9450835562462694`, 0.8705665189068674}, {1.074095746585374, 
    0.4054020904812563}, {0., 0.}, {0.20349925371016586`, 
    0.8704676975181331}, {1.0743632004180812`, 1.3355245671965388`}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03297778087607705, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], ArrowBox[{2, 3}], ArrowBox[{4, 5}], 
      ArrowBox[{4, 3}], ArrowBox[{5, 3}], ArrowBox[{6, 5}], ArrowBox[{6, 2}], 
      ArrowBox[{6, 3}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.1493322121100826`, 
     0.00024224688259011362`}, {1.9450835562462694`, 0.8705665189068674}, {
     1.074095746585374, 0.4054020904812563}, {0., 0.}, {0.20349925371016586`, 
     0.8704676975181331}, {1.0743632004180812`, 1.3355245671965388`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->785097463]
}, Open  ]],

Cell["This finds the pseudo diameter of the directed graph:", "ExampleText",
 CellID->1539214091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PseudoDiameter", "[", "g", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->93500167],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"2", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4"}], "}"}]}], "}"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1104143021]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphDistance"]], "InlineFormula"],
 " & ",
 Cell[BoxData[
  ButtonBox["GraphPath",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphPath"]], "InlineFormula"],
 " find that there is no path from 4 to 1 in the directed graph:"
}], "ExampleText",
 CellID->29314],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphDistance", "[", 
  RowBox[{"g", ",", "1", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->9503],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->31789336]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{"g", ",", "1", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->621272336],

Cell[BoxData[
 RowBox[{"{", "4", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->2056295250]
}, Open  ]],

Cell[TextData[{
 "This turns ",
 Cell[BoxData["g"], "InlineFormula"],
 " into an undirected graph:"
}], "ExampleText",
 CellID->1569763445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ug", " ", "=", " ", 
  RowBox[{
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", 
        RowBox[{"Reverse", "[", "#", "]"}]}], "}"}], "&"}], ",", "g"}], "]"}],
    "//", "Flatten"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->811768068],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "5"}], ",", 
   RowBox[{"5", "\[Rule]", "1"}], ",", 
   RowBox[{"1", "\[Rule]", "6"}], ",", 
   RowBox[{"6", "\[Rule]", "1"}], ",", 
   RowBox[{"2", "\[Rule]", "4"}], ",", 
   RowBox[{"4", "\[Rule]", "2"}], ",", 
   RowBox[{"2", "\[Rule]", "6"}], ",", 
   RowBox[{"6", "\[Rule]", "2"}], ",", 
   RowBox[{"3", "\[Rule]", "4"}], ",", 
   RowBox[{"4", "\[Rule]", "3"}], ",", 
   RowBox[{"3", "\[Rule]", "5"}], ",", 
   RowBox[{"5", "\[Rule]", "3"}], ",", 
   RowBox[{"3", "\[Rule]", "6"}], ",", 
   RowBox[{"6", "\[Rule]", "3"}], ",", 
   RowBox[{"4", "\[Rule]", "6"}], ",", 
   RowBox[{"6", "\[Rule]", "4"}], ",", 
   RowBox[{"5", "\[Rule]", "6"}], ",", 
   RowBox[{"6", "\[Rule]", "5"}]}], "}"}]], "Output",
 ImageSize->{419, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1436564230]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphDistance"]], "InlineFormula"],
 " & ",
 Cell[BoxData[
  ButtonBox["GraphPath",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphPath"]], "InlineFormula"],
 " now find a path of length 2:"
}], "ExampleText",
 CellID->129076802],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphDistance", "[", 
  RowBox[{"ug", ",", "1", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->745510237],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->1927852606]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPath", "[", 
  RowBox[{"ug", ",", "1", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1969963497],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "6", ",", "4"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->273104842]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14685],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ClosenessCentrality",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/ClosenessCentrality"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->1562590230]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15931],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->22136]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->931699566],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PseudoDiameter - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 24.5858056}", "context" -> 
    "GraphUtilities`", "keywords" -> {"graph diameter graph geodesic"}, 
    "index" -> True, "label" -> "Graph Utilities Package Symbol", "language" -> 
    "en", "paclet" -> "GraphUtilities Package", "status" -> "None", "summary" -> 
    "PseudoDiameter[g] gives the pseudo diameter of the undirected graph g, \
and the two vertices that achieve this diameter.", "synonyms" -> {}, "title" -> 
    "PseudoDiameter", "type" -> "Symbol", "uri" -> 
    "GraphUtilities/ref/PseudoDiameter"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5457, 172, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->326192333]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 40602, 1141}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1860, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2483, 76, 52, 1, 70, "ObjectName",
 CellID->31817],
Cell[2538, 79, 532, 15, 70, "Usage",
 CellID->5785]
}, Open  ]],
Cell[CellGroupData[{
Cell[3107, 99, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3585, 116, 1037, 24, 70, "Notes",
 CellID->52933267],
Cell[4625, 142, 145, 4, 70, "Notes",
 CellID->2861],
Cell[4773, 148, 67, 1, 70, "Notes",
 CellID->17366],
Cell[4843, 151, 577, 16, 70, "3ColumnTableMod",
 CellID->29660]
}, Closed]],
Cell[CellGroupData[{
Cell[5457, 172, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->326192333],
Cell[CellGroupData[{
Cell[5842, 186, 148, 5, 70, "ExampleSection",
 CellID->421654808],
Cell[5993, 193, 139, 4, 70, "Input",
 CellID->181657746],
Cell[6135, 199, 88, 1, 70, "ExampleText",
 CellID->9514],
Cell[6226, 202, 308, 10, 70, "Input",
 CellID->22813],
Cell[CellGroupData[{
Cell[6559, 216, 226, 7, 28, "Input",
 CellID->18935],
Cell[6788, 225, 279, 10, 36, "Output",
 CellID->1661678734]
}, Open  ]],
Cell[7082, 238, 138, 4, 70, "ExampleText",
 CellID->20600],
Cell[CellGroupData[{
Cell[7245, 246, 526, 17, 70, "Input",
 CellID->6617],
Cell[7774, 265, 1131, 26, 201, "Output",
 CellID->1768771463]
}, Open  ]],
Cell[8920, 294, 121, 3, 70, "ExampleDelimiter",
 CellID->14989],
Cell[9044, 299, 138, 4, 70, "Input",
 CellID->90808125],
Cell[9185, 305, 95, 1, 70, "ExampleText",
 CellID->17807],
Cell[9283, 308, 1959, 59, 70, "Input",
 CellID->19668],
Cell[11245, 369, 78, 1, 70, "ExampleText",
 CellID->14310],
Cell[CellGroupData[{
Cell[11348, 374, 225, 7, 70, "Input",
 CellID->20485],
Cell[11576, 383, 280, 10, 36, "Output",
 CellID->1341190873]
}, Open  ]],
Cell[11871, 396, 144, 4, 70, "ExampleText",
 CellID->2421],
Cell[12018, 402, 471, 15, 70, "Input",
 CellID->599761383],
Cell[CellGroupData[{
Cell[12514, 421, 1189, 35, 83, "Input",
 CellID->3728],
Cell[13706, 458, 14836, 247, 244, "Output",
 Evaluatable->False,
 CellID->309938416]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28591, 711, 216, 7, 70, "ExampleSection",
 CellID->24897],
Cell[28810, 720, 138, 4, 70, "Input",
 CellID->92657749],
Cell[28951, 726, 76, 1, 70, "ExampleText",
 CellID->20580],
Cell[CellGroupData[{
Cell[29052, 731, 238, 8, 70, "Input",
 CellID->19796],
Cell[29293, 741, 305, 10, 36, "Output",
 CellID->1917520557]
}, Open  ]],
Cell[29613, 754, 175, 4, 70, "ExampleText",
 CellID->14798],
Cell[CellGroupData[{
Cell[29813, 762, 106, 3, 70, "Input",
 CellID->15281],
Cell[29922, 767, 409, 15, 36, "Output",
 CellID->1562743651]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30380, 788, 225, 7, 70, "ExampleSection",
 CellID->4217],
Cell[30608, 797, 140, 4, 70, "Input",
 CellID->1945668000],
Cell[30751, 803, 80, 1, 70, "ExampleText",
 CellID->1414025651],
Cell[30834, 806, 518, 15, 70, "Input",
 CellID->2077925721],
Cell[CellGroupData[{
Cell[31377, 825, 234, 6, 70, "Input",
 CellID->807651903],
Cell[31614, 833, 2029, 47, 133, "Output",
 CellID->785097463]
}, Open  ]],
Cell[33658, 883, 97, 1, 70, "ExampleText",
 CellID->1539214091],
Cell[CellGroupData[{
Cell[33780, 888, 109, 3, 70, "Input",
 CellID->93500167],
Cell[33892, 893, 279, 10, 36, "Output",
 CellID->1104143021]
}, Open  ]],
Cell[34186, 906, 404, 12, 70, "ExampleText",
 CellID->29314],
Cell[CellGroupData[{
Cell[34615, 922, 137, 4, 70, "Input",
 CellID->9503],
Cell[34755, 928, 167, 5, 36, "Output",
 CellID->31789336]
}, Open  ]],
Cell[CellGroupData[{
Cell[34959, 938, 138, 4, 70, "Input",
 CellID->621272336],
Cell[35100, 944, 181, 6, 36, "Output",
 CellID->2056295250]
}, Open  ]],
Cell[35296, 953, 139, 5, 70, "ExampleText",
 CellID->1569763445],
Cell[CellGroupData[{
Cell[35460, 962, 309, 11, 70, "Input",
 CellID->811768068],
Cell[35772, 975, 905, 25, 54, "Output",
 CellID->1436564230]
}, Open  ]],
Cell[36692, 1003, 375, 12, 70, "ExampleText",
 CellID->129076802],
Cell[CellGroupData[{
Cell[37092, 1019, 143, 4, 70, "Input",
 CellID->745510237],
Cell[37238, 1025, 159, 5, 36, "Output",
 CellID->1927852606]
}, Open  ]],
Cell[CellGroupData[{
Cell[37434, 1035, 140, 4, 70, "Input",
 CellID->1969963497],
Cell[37577, 1041, 213, 7, 36, "Output",
 CellID->273104842]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37851, 1055, 311, 9, 70, "SeeAlsoSection",
 CellID->14685],
Cell[38165, 1066, 238, 6, 70, "SeeAlso",
 CellID->1562590230]
}, Open  ]],
Cell[CellGroupData[{
Cell[38440, 1077, 314, 9, 70, "TutorialsSection",
 CellID->15931],
Cell[38757, 1088, 163, 3, 70, "Tutorials",
 CellID->22136]
}, Open  ]],
Cell[CellGroupData[{
Cell[38957, 1096, 319, 9, 70, "MoreAboutSection",
 CellID->931699566],
Cell[39279, 1107, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[39468, 1114, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

