(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9616,        314]
NotebookOptionsPosition[      7518,        250]
NotebookOutlinePosition[      8751,        281]
CellTagsIndexPosition[      8708,        278]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PageRanks" :> 
          Documentation`HelpLookup["paclet:GraphUtilities/ref/PageRanks"], 
          "PageRankVector" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/PageRankVector"], "LinkRanks" :> 
          Documentation`HelpLookup["paclet:GraphUtilities/ref/LinkRanks"], 
          "LinkRankMatrix" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/LinkRankMatrix"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"PageRanks\"\>", 2->"\<\"PageRankVector\"\>", 
       3->"\<\"LinkRanks\"\>", 
       4->"\<\"LinkRankMatrix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TeleportProbability", "ObjectName",
 CellID->16145],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["TeleportProbability"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["PageRanks",
       BaseStyle->"Link",
       ButtonData->"paclet:GraphUtilities/ref/PageRanks"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["PageRankVector",
       BaseStyle->"Link",
       ButtonData->"paclet:GraphUtilities/ref/PageRankVector"]], 
      "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["LinkRanks",
       BaseStyle->"Link",
       ButtonData->"paclet:GraphUtilities/ref/LinkRanks"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["LinkRankMatrix",
       BaseStyle->"Link",
       ButtonData->"paclet:GraphUtilities/ref/LinkRankMatrix"]], 
      "InlineFormula"],
     "  that specifies the probability that an internet user may choose to \
visit a vertex at random instead of choosing an out-link."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18740]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Possible values are positive numbers less than 1. The default value is 0.15.\
\>", "Notes",
 CellID->27754],

Cell[TextData[{
 "A smaller value makes the ",
 Cell[BoxData[
  ButtonBox["PageRanks",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/PageRanks"]], "InlineFormula"],
 " a more accurate reflection of a normal internet user's behavior, but also \
makes the iterative process converge more slowly."
}], "Notes",
 CellID->30554]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22890],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageRanks",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/PageRanks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageRankVector",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/PageRankVector"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkRanks",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/LinkRanks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkRankMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:GraphUtilities/ref/LinkRankMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30183]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3206],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->12283]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->169491534],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TeleportProbability - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 30.8047148}", "context" -> 
    "GraphUtilities`", "keywords" -> {"xxxx"}, "index" -> True, "label" -> 
    "Graph Utilities Package Symbol", "language" -> "en", "paclet" -> 
    "GraphUtilities Package", "status" -> "None", "summary" -> 
    "TeleportProbability is an option to PageRanks, PageRankVector, \
LinkRanks, and LinkRankMatrix that specifies the probability that an internet \
user may choose to visit a vertex at random instead of choosing an out-link.",
     "synonyms" -> {}, "title" -> "TeleportProbability", "type" -> "Symbol", 
    "uri" -> "GraphUtilities/ref/TeleportProbability"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2247, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2870, 83, 57, 1, 70, "ObjectName",
 CellID->16145],
Cell[2930, 86, 1141, 33, 70, "Usage",
 CellID->18740]
}, Open  ]],
Cell[CellGroupData[{
Cell[4108, 124, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4586, 141, 117, 3, 70, "Notes",
 CellID->27754],
Cell[4706, 146, 341, 9, 70, "Notes",
 CellID->30554]
}, Closed]],
Cell[CellGroupData[{
Cell[5084, 160, 311, 9, 70, "SeeAlsoSection",
 CellID->22890],
Cell[5398, 171, 1029, 35, 70, "SeeAlso",
 CellID->30183]
}, Open  ]],
Cell[CellGroupData[{
Cell[6464, 211, 313, 9, 70, "TutorialsSection",
 CellID->3206],
Cell[6780, 222, 163, 3, 70, "Tutorials",
 CellID->12283]
}, Open  ]],
Cell[CellGroupData[{
Cell[6980, 230, 319, 9, 70, "MoreAboutSection",
 CellID->169491534],
Cell[7302, 241, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[7491, 248, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

