(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18051,        652]
NotebookOptionsPosition[     13917,        508]
NotebookOutlinePosition[     15156,        544]
CellTagsIndexPosition[     15071,        539]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EdgeList" :> 
          Documentation`HelpLookup["paclet:GraphUtilities/ref/EdgeList"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"EdgeList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["VertexList", "ObjectName",
 CellID->30853],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VertexList", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of all vertices in the graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23309]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["VertexList"], "InlineFormula"],
 " returns a list of vertices of the graph ",
 StyleBox["g", "TI"],
 "."
}], "Notes",
 CellID->31934],

Cell["\<\
For graphs specified using a rule list, the list of vertices are returned in \
the order in which they first appear.\
\>", "Notes",
 CellID->942392630],

Cell[TextData[{
 "Functions such as ",
 Cell[BoxData[
  ButtonBox["GraphCoordinates",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphCoordinates"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PageRankVector",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/PageRankVector"]], 
  "InlineFormula"],
 " return information on vertices in the order given by ",
 Cell[BoxData["VertexList"], "InlineFormula"],
 "."
}], "Notes",
 CellID->15205]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->146048295],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->567405925],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->66747447],

Cell["The list of vertices of a simple graph:", "ExampleText",
 CellID->27529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VertexList", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"4", "\[Rule]", "3"}], ",", 
    RowBox[{"a", "\[Rule]", "b"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1708667343],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "4", ",", "3", ",", "a", ",", "b"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->226492559]
}, Open  ]],

Cell["\<\
The list of vertices of a graph specified by an adjacency matrix consists of \
consecutive integers:\
\>", "ExampleText",
 CellID->1886575290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VertexList", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->143106645],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2048338064]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23733],

Cell[TextData[{
 "This defines a simple web graph, and calculates the ",
 Cell[BoxData[
  ButtonBox["GraphCoordinates",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphCoordinates"]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->425094228],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->602866867],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<Home Page\>\"", "\[Rule]", "\"\<Contact\>\""}], ",", 
     RowBox[{"\"\<Home Page\>\"", "\[Rule]", "\"\<Links\>\""}], ",", 
     RowBox[{"\"\<Links\>\"", "\[Rule]", "\"\<Friend Page\>\""}], ",", 
     RowBox[{"\"\<Friend Page\>\"", "\[Rule]", "\"\<Home Page\>\""}]}], 
    "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1759281949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coord", "=", 
  RowBox[{"GraphCoordinates", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1854376424],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.1142268386912457`", ",", "0.4233810846544842`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.42348585375836806`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.031436775540847`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.031366776560996`", ",", "0.8469863348158673`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{496, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1021070959]
}, Open  ]],

Cell["\<\
This shows the relationship between the vertex list and the coordinates:\
\>", "ExampleText",
 CellID->410705247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"crules", "=", 
  RowBox[{"Thread", "[", 
   RowBox[{
    RowBox[{"VertexList", "[", "g", "]"}], "->", "coord"}], "]"}]}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->187304895],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"Home Page\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1.1142268386912457`", ",", "0.4233810846544842`"}], "}"}]}], 
   ",", 
   RowBox[{"\<\"Contact\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.`", ",", "0.42348585375836806`"}], "}"}]}], ",", 
   RowBox[{"\<\"Links\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2.031436775540847`", ",", "0.`"}], "}"}]}], ",", 
   RowBox[{"\<\"Friend Page\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2.031366776560996`", ",", "0.8469863348158673`"}], "}"}]}]}], 
  "}"}]], "Output",
 ImageSize->{399, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1584001455]
}, Open  ]],

Cell["This draw the web graph using the coordinate information:", \
"ExampleText",
 CellID->681995046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", "crules"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->945400205],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.1142268386912457`, 0.4233810846544842}, {0., 
    0.42348585375836806`}, {2.031436775540847, 0.}, {2.031366776560996, 
    0.8469863348158673}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03365815515882304, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], ArrowBox[{3, 4}], 
      ArrowBox[{4, 1}]}, {InsetBox[
       FrameBox["\<\"Home Page\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"Contact\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"Links\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["\<\"Friend Page\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.1142268386912457`, 0.4233810846544842}, {0., 
     0.42348585375836806`}, {2.031436775540847, 0.}, {2.031366776560996, 
     0.8469863348158673}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{322., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{326, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1637605112]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2633],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GraphUtilities`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->650256223],

Cell[TextData[{
 "Ordering given by ",
 Cell[BoxData["VertexList"], "InlineFormula"],
 " may not be the same as the lexicographical ordering of vertex labels:"
}], "ExampleText",
 CellID->1361548903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VertexList", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"2", "\[Rule]", "1"}], ",", 
    RowBox[{"3", "\[Rule]", "2"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->569941009],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1046532994]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27970],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["EdgeList",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/EdgeList"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->6807]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16593],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->17784]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->921287214],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VertexList - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 31.4922324}", "context" -> 
    "GraphUtilities`", "keywords" -> {"vertices"}, "index" -> True, "label" -> 
    "Graph Utilities Package Symbol", "language" -> "en", "paclet" -> 
    "GraphUtilities Package", "status" -> "None", "summary" -> 
    "VertexList[g] gives a list of all vertices in the graph g.", 
    "synonyms" -> {}, "title" -> "VertexList", "type" -> "Symbol", "uri" -> 
    "GraphUtilities/ref/VertexList"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4335, 151, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->146048295]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14928, 532}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1816, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2439, 75, 48, 1, 70, "ObjectName",
 CellID->30853],
Cell[2490, 78, 472, 15, 70, "Usage",
 CellID->23309]
}, Open  ]],
Cell[CellGroupData[{
Cell[2999, 98, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3477, 115, 164, 6, 70, "Notes",
 CellID->31934],
Cell[3644, 123, 161, 4, 70, "Notes",
 CellID->942392630],
Cell[3808, 129, 490, 17, 70, "Notes",
 CellID->15205]
}, Closed]],
Cell[CellGroupData[{
Cell[4335, 151, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->146048295],
Cell[CellGroupData[{
Cell[4720, 165, 148, 5, 70, "ExampleSection",
 CellID->567405925],
Cell[4871, 172, 138, 4, 70, "Input",
 CellID->66747447],
Cell[5012, 178, 78, 1, 70, "ExampleText",
 CellID->27529],
Cell[CellGroupData[{
Cell[5115, 183, 257, 8, 28, "Input",
 CellID->1708667343],
Cell[5375, 193, 247, 8, 36, "Output",
 CellID->226492559]
}, Open  ]],
Cell[5637, 204, 152, 4, 70, "ExampleText",
 CellID->1886575290],
Cell[CellGroupData[{
Cell[5814, 212, 255, 9, 70, "Input",
 CellID->143106645],
Cell[6072, 223, 204, 7, 36, "Output",
 CellID->2048338064]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6325, 236, 233, 7, 70, "ExampleSection",
 CellID->23733],
Cell[6561, 245, 269, 9, 70, "ExampleText",
 CellID->425094228],
Cell[6833, 256, 139, 4, 70, "Input",
 CellID->602866867],
Cell[6975, 262, 435, 11, 70, "Input",
 CellID->1759281949],
Cell[CellGroupData[{
Cell[7435, 277, 140, 4, 70, "Input",
 CellID->1854376424],
Cell[7578, 283, 535, 16, 36, "Output",
 CellID->1021070959]
}, Open  ]],
Cell[8128, 302, 123, 3, 70, "ExampleText",
 CellID->410705247],
Cell[CellGroupData[{
Cell[8276, 309, 200, 7, 70, "Input",
 CellID->187304895],
Cell[8479, 318, 727, 21, 54, "Output",
 CellID->1584001455]
}, Open  ]],
Cell[9221, 342, 102, 2, 70, "ExampleText",
 CellID->681995046],
Cell[CellGroupData[{
Cell[9348, 348, 294, 7, 70, "Input",
 CellID->945400205],
Cell[9645, 357, 1520, 37, 156, "Output",
 CellID->1637605112]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11214, 400, 225, 7, 70, "ExampleSection",
 CellID->2633],
Cell[11442, 409, 139, 4, 70, "Input",
 CellID->650256223],
Cell[11584, 415, 199, 5, 70, "ExampleText",
 CellID->1361548903],
Cell[CellGroupData[{
Cell[11808, 424, 215, 7, 70, "Input",
 CellID->569941009],
Cell[12026, 433, 214, 7, 36, "Output",
 CellID->1046532994]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12301, 447, 311, 9, 70, "SeeAlsoSection",
 CellID->27970],
Cell[12615, 458, 210, 6, 70, "SeeAlso",
 CellID->6807]
}, Open  ]],
Cell[CellGroupData[{
Cell[12862, 469, 314, 9, 70, "TutorialsSection",
 CellID->16593],
Cell[13179, 480, 163, 3, 70, "Tutorials",
 CellID->17784]
}, Open  ]],
Cell[CellGroupData[{
Cell[13379, 488, 319, 9, 70, "MoreAboutSection",
 CellID->921287214],
Cell[13701, 499, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[13890, 506, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

