(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9109,        309]
NotebookOptionsPosition[      7088,        245]
NotebookOutlinePosition[      8177,        274]
CellTagsIndexPosition[      8134,        271]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GRAPH UTILITIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/tutorial/GraphUtilities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MaximalIndependentEdgeSet" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/ref/MaximalIndependentEdgeSet"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MaximalIndependentEdgeSet\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Utilities Package" :> 
          Documentation`HelpLookup[
           "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Graph Utilities Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Weighted", "ObjectName",
 CellID->22416],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Weighted"], "InlineFormula"],
     "\[LineSeparator]is an option to functions in the Graph Utilities \
Package that specifies how to treat edges with higher weight."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29229]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["MaximalIndependentEdgeSet",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/MaximalIndependentEdgeSet"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData["Weighted"], "InlineFormula"],
 " specifies whether edges with higher weights are preferred during \
matching."
}], "Notes",
 CellID->1382975314],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["CommunityStructureAssignment",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/CommunityStructureAssignment"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CommunityStructurePartition",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/CommunityStructurePartition"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["CommunityModularity",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/CommunityModularity"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData["Weighted"], "InlineFormula"],
 " specifies whether vertices linked by edges with higher weights are \
preferably kept in the same community."
}], "Notes",
 CellID->1552087893],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["ShortestPath",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/ShortestPath"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GraphDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphDistance"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GraphDistanceMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphDistanceMatrix"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ClosenessCentrality",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/ClosenessCentrality"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData["Weighted"], "InlineFormula"],
 " specifies whether edge weight is to be used in calculating distance."
}], "Notes",
 CellID->457357542]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31746],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["MaximalIndependentEdgeSet",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/MaximalIndependentEdgeSet"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->2341]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16688],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->"paclet:GraphUtilities/tutorial/GraphUtilities"]], "Tutorials",
 CellID->13865]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->516442018],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Weighted - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 31.9297436}", "context" -> 
    "GraphUtilities`", "keywords" -> {}, "index" -> True, "label" -> 
    "Graph Utilities Package Symbol", "language" -> "en", "paclet" -> 
    "GraphUtilities Package", "status" -> "None", "summary" -> 
    "Weighted is an option to functions in the Graph Utilities Package that \
specifies how to treat edges with higher weight.", "synonyms" -> {}, "title" -> 
    "Weighted", "type" -> "Symbol", "uri" -> "GraphUtilities/ref/Weighted"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1878, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2501, 76, 46, 1, 70, "ObjectName",
 CellID->22416],
Cell[2550, 79, 409, 11, 70, "Usage",
 CellID->29229]
}, Open  ]],
Cell[CellGroupData[{
Cell[2996, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3474, 112, 362, 12, 70, "Notes",
 CellID->1382975314],
Cell[3839, 126, 750, 24, 70, "Notes",
 CellID->1552087893],
Cell[4592, 152, 809, 27, 70, "Notes",
 CellID->457357542]
}, Closed]],
Cell[CellGroupData[{
Cell[5438, 184, 311, 9, 70, "SeeAlsoSection",
 CellID->31746],
Cell[5752, 195, 244, 6, 70, "SeeAlso",
 CellID->2341]
}, Open  ]],
Cell[CellGroupData[{
Cell[6033, 206, 314, 9, 70, "TutorialsSection",
 CellID->16688],
Cell[6350, 217, 163, 3, 70, "Tutorials",
 CellID->13865]
}, Open  ]],
Cell[CellGroupData[{
Cell[6550, 225, 319, 9, 70, "MoreAboutSection",
 CellID->516442018],
Cell[6872, 236, 174, 4, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[7061, 243, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

