(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22306,        782]
NotebookOptionsPosition[     18172,        645]
NotebookOutlinePosition[     19650,        684]
CellTagsIndexPosition[     19565,        679]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HIERARCHICAL CLUSTERING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hierarchical Clustering Package" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Hierarchical Clustering Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DirectAgglomerate" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/DirectAgglomerate"], "Cluster" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/Cluster"], "DendrogramPlot" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/DendrogramPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DirectAgglomerate\"\>", 
       2->"\<\"Cluster\"\>", 3->"\<\"DendrogramPlot\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Agglomerate", "ObjectName",
 CellID->25760],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Agglomerate", "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["e", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["e", "TI"], 
          StyleBox["2", "TR"]], ",", "\[Ellipsis]"}], "}"}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]gives an hierarchical clustering of the elements ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["2", "TR"]], ",", "\[Ellipsis]"}]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Agglomerate", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["1", "TR"]], "->", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["1", "TR"]]}], ",", 
         RowBox[{
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["2", "TR"]], "->", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["2", "TR"]]}], ",", "\[Ellipsis]"}], "}"}], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]represents ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " in each cluster. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Agglomerate", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["e", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TI"]}], "}"}], "->", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " in each cluster."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->18588]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Agglomerate"], "InlineFormula"],
 " gives a ",
 Cell[BoxData[
  ButtonBox["Cluster",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Cluster"]], 
  "InlineFormula"],
 " object."
}], "Notes",
 CellID->15574],

Cell[TextData[{
 "The cluster hierarchy may be viewed using ",
 Cell[BoxData[
  ButtonBox["DendrogramPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/DendrogramPlot"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->403750047],

Cell[TextData[{
 "The data elements ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be numeric lists, matrices, or tensors, lists of Boolean elements, or \
strings with each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " having the same dimensions."
}], "Notes",
 CellID->27506],

Cell["The following options can be given:", "Notes",
 CellID->13030],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DistanceFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DistanceFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the distance or dissimilarity measure to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Linkage",
     BaseStyle->"Link",
     ButtonData->"paclet:HierarchicalClustering/ref/Linkage"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the clustering linkage algorithm to use", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->16413],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DistanceFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DistanceFunction"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData["Agglomerate"], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["SquaredEuclideanDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SquaredEuclideanDistance"]], "InlineFormula"],
 " for numeric data, ",
 Cell[BoxData[
  ButtonBox["JaccardDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JaccardDissimilarity"]], "InlineFormula"],
 " for Boolean data, and ",
 Cell[BoxData[
  ButtonBox["EditDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EditDistance"]], "InlineFormula"],
 " for string data."
}], "Notes",
 CellID->900],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["DistanceFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DistanceFunction"]], "InlineFormula"],
 " can be any distance or dissimilarity function or a pure function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " defining a distance between two values."
}], "Notes",
 CellID->32591],

Cell[TextData[{
 Cell[BoxData["Linkage"], "InlineFormula"],
 " defines the intercluster dissimilarity, given the dissimilarities between \
member elements."
}], "Notes",
 CellID->6483],

Cell[TextData[{
 "Possible settings for the ",
 Cell[BoxData[
  ButtonBox["Linkage",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Linkage"]], 
  "InlineFormula"],
 " option include:"
}], "Notes",
 CellID->27595],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Single\>\"", Cell[
    "smallest intercluster dissimilarity", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Average\>\"", Cell[
    "average intercluster dissimilarity", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Complete\>\"", Cell[
    "largest intercluster dissimilarity", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Weighted\>\"", Cell[
    "weighted average intercluster dissimilarity", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Centroid\>\"", Cell[
    "distance from cluster centroids", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Median\>\"", Cell[
    "distance from cluster medians", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Ward\>\"", Cell[
    "Ward's minimum variance dissimilarity", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["f", "TI"], Cell["a pure function", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->16941],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " defines a distance from a cluster ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " to the new cluster formed by fusing clusters ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->21724],

Cell[TextData[{
 "The arguments supplied to ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["d", "TI"], 
    StyleBox["ik", "TI"]], ",", 
   SubscriptBox[
    StyleBox["d", "TI"], 
    StyleBox["jk", "TI"]], ",", 
   SubscriptBox[
    StyleBox["d", "TI"], 
    StyleBox["ij", "TI"]], ",", 
   SubscriptBox[
    StyleBox["n", "TI"], 
    StyleBox["i", "TI"]], ",", 
   SubscriptBox[
    StyleBox["n", "TI"], 
    StyleBox["j", "TI"]], ","}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " is the distance between clusters and ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is the number of elements in a cluster."
}], "Notes",
 CellID->25939219]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->620331128],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->33879144],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->109312950],

Cell["Obtain a cluster hierarchy from a list of numbers:", "ExampleText",
 CellID->27638432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Agglomerate", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->121000328],

Cell[BoxData[
 RowBox[{"Cluster", "[", 
  RowBox[{
   RowBox[{"Cluster", "[", 
    RowBox[{
     RowBox[{"Cluster", "[", 
      RowBox[{"1", ",", "2", ",", "1", ",", "1", ",", "1"}], "]"}], ",", "4", 
     ",", "4", ",", "2", ",", "1"}], "]"}], ",", 
   RowBox[{"Cluster", "[", 
    RowBox[{"8", ",", "10", ",", "4", ",", "1", ",", "1"}], "]"}], ",", "16", 
   ",", "3", ",", "2"}], "]"}]], "Output",
 ImageSize->{568, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16629200]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17371],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DistanceFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1757724783],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->140281085],

Cell[TextData[{
 "Cluster hierarchy using ",
 Cell[BoxData[
  ButtonBox["ManhattanDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ManhattanDistance"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->141103965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Agglomerate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"DistanceFunction", "->", "ManhattanDistance"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->146762761],

Cell[BoxData[
 RowBox[{"Cluster", "[", 
  RowBox[{
   RowBox[{"Cluster", "[", 
    RowBox[{
     RowBox[{"Cluster", "[", 
      RowBox[{"1", ",", "2", ",", "1", ",", "1", ",", "1"}], "]"}], ",", "4", 
     ",", "2", ",", "2", ",", "1"}], "]"}], ",", 
   RowBox[{"Cluster", "[", 
    RowBox[{"8", ",", "10", ",", "2", ",", "1", ",", "1"}], "]"}], ",", "4", 
   ",", "3", ",", "2"}], "]"}]], "Output",
 ImageSize->{561, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->533478353]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Linkage",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->50733708],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->218558777],

Cell["Cluster hierarchy using Ward's linkage:", "ExampleText",
 CellID->158038108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Agglomerate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"Linkage", "\[Rule]", "\"\<Ward\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23591188],

Cell[BoxData[
 RowBox[{"Cluster", "[", 
  RowBox[{
   RowBox[{"Cluster", "[", 
    RowBox[{
     RowBox[{"Cluster", "[", 
      RowBox[{"1", ",", "2", ",", 
       FractionBox["1", "2"], ",", "1", ",", "1"}], "]"}], ",", "4", ",", 
     FractionBox["25", "6"], ",", "2", ",", "1"}], "]"}], ",", 
   RowBox[{"Cluster", "[", 
    RowBox[{"8", ",", "10", ",", "2", ",", "1", ",", "1"}], "]"}], ",", 
   FractionBox["160", "3"], ",", "3", ",", "2"}], "]"}]], "Output",
 ImageSize->{361, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->112549142]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2695],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DirectAgglomerate",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/DirectAgglomerate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cluster",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/Cluster"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DendrogramPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/DendrogramPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21624]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7285],

Cell[TextData[ButtonBox["Hierarchical Clustering Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]], \
"Tutorials",
 CellID->12550]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Agglomerate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 41.0862280}", "context" -> 
    "HierarchicalClustering`", "keywords" -> {}, "index" -> True, "label" -> 
    "Hierarchical Clustering Package Symbol", "language" -> "en", "paclet" -> 
    "HierarchicalClustering Package", "status" -> "None", "summary" -> 
    "Agglomerate[{e_1, e_2, ...}] gives an hierarchical clustering of the \
elements e_1, e_2, .... Agglomerate[{e_1 -> v_1, e_2 -> v_2, ...}] represents \
e_i with v_i in each cluster. Agglomerate[{e_1, e_2, ...} -> {v_1, v_2, ...}] \
represents e_i with v_i in each cluster.", "synonyms" -> {}, "title" -> 
    "Agglomerate", "type" -> "Symbol", "uri" -> 
    "HierarchicalClustering/ref/Agglomerate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11759, 399, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->620331128]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19421, 672}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1578, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2201, 66, 49, 1, 70, "ObjectName",
 CellID->25760],
Cell[2253, 69, 2826, 95, 70, "Usage",
 CellID->18588]
}, Open  ]],
Cell[CellGroupData[{
Cell[5116, 169, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5594, 186, 261, 10, 70, "Notes",
 CellID->15574],
Cell[5858, 198, 257, 9, 70, "Notes",
 CellID->403750047],
Cell[6118, 209, 399, 14, 70, "Notes",
 CellID->27506],
Cell[6520, 225, 68, 1, 70, "Notes",
 CellID->13030],
Cell[6591, 228, 880, 23, 70, "3ColumnTableMod",
 CellID->16413],
Cell[7474, 253, 880, 29, 70, "Notes",
 CellID->900],
Cell[8357, 284, 372, 11, 70, "Notes",
 CellID->32591],
Cell[8732, 297, 184, 5, 70, "Notes",
 CellID->6483],
Cell[8919, 304, 238, 9, 70, "Notes",
 CellID->27595],
Cell[9160, 315, 1267, 25, 70, "2ColumnTableMod",
 CellID->16941],
Cell[10430, 342, 396, 15, 70, "Notes",
 CellID->21724],
Cell[10829, 359, 893, 35, 70, "Notes",
 CellID->25939219]
}, Closed]],
Cell[CellGroupData[{
Cell[11759, 399, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->620331128],
Cell[CellGroupData[{
Cell[12144, 413, 147, 5, 70, "ExampleSection",
 CellID->33879144],
Cell[12294, 420, 147, 4, 70, "Input",
 CellID->109312950],
Cell[12444, 426, 92, 1, 70, "ExampleText",
 CellID->27638432],
Cell[CellGroupData[{
Cell[12561, 431, 188, 6, 28, "Input",
 CellID->121000328],
Cell[12752, 439, 530, 15, 36, "Output",
 CellID->16629200]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13331, 460, 218, 7, 70, "ExampleSection",
 CellID->17371],
Cell[CellGroupData[{
Cell[13574, 471, 238, 7, 70, "ExampleSubsection",
 CellID->1757724783],
Cell[13815, 480, 147, 4, 70, "Input",
 CellID->140281085],
Cell[13965, 486, 225, 8, 70, "ExampleText",
 CellID->141103965],
Cell[CellGroupData[{
Cell[14215, 498, 268, 8, 70, "Input",
 CellID->146762761],
Cell[14486, 508, 530, 15, 36, "Output",
 CellID->533478353]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15065, 529, 227, 7, 70, "ExampleSubsection",
 CellID->50733708],
Cell[15295, 538, 147, 4, 70, "Input",
 CellID->218558777],
Cell[15445, 544, 82, 1, 70, "ExampleText",
 CellID->158038108],
Cell[CellGroupData[{
Cell[15552, 549, 256, 7, 70, "Input",
 CellID->23591188],
Cell[15811, 558, 595, 16, 81, "Output",
 CellID->112549142]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16479, 582, 310, 9, 70, "SeeAlsoSection",
 CellID->2695],
Cell[16792, 593, 793, 26, 70, "SeeAlso",
 CellID->21624]
}, Open  ]],
Cell[CellGroupData[{
Cell[17622, 624, 313, 9, 70, "TutorialsSection",
 CellID->7285],
Cell[17938, 635, 192, 5, 70, "Tutorials",
 CellID->12550]
}, Open  ]],
Cell[18145, 643, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

