(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10252,        360]
NotebookOptionsPosition[      7678,        278]
NotebookOutlinePosition[      8973,        314]
CellTagsIndexPosition[      8889,        309]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HIERARCHICAL CLUSTERING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hierarchical Clustering Package" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Hierarchical Clustering Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ClusterSplit" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/ClusterSplit"], "Cluster" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/Cluster"], "Agglomerate" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/Agglomerate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ClusterSplit\"\>", 
       2->"\<\"Cluster\"\>", 3->"\<\"Agglomerate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ClusterFlatten", "ObjectName"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ClusterFlatten", "[", 
       StyleBox["c", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a flat list of the data elements contained in \
the cluster ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ClusterFlatten", "[", 
   StyleBox["c", "TI"], "]"}]], "InlineFormula"],
 " gives the elements of ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " sorted by a depth first traversal of the cluster hierarchy."
}], "Notes"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ClusterFlatten", "[", 
   StyleBox["c", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ClusterSplit",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/ClusterSplit"], "[", 
   RowBox[{
    StyleBox["c", "TI"], ",", 
    RowBox[{
     ButtonBox["Length",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Length"], "[", 
     StyleBox["c", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->204680214]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->562235910],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->561886139],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->41563977],

Cell["Flatten a hierarchical cluster:", "ExampleText",
 CellID->141748602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cl", "=", 
  RowBox[{"Agglomerate", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->434809347],

Cell[BoxData[
 RowBox[{"Cluster", "[", 
  RowBox[{
   RowBox[{"Cluster", "[", 
    RowBox[{
     RowBox[{"Cluster", "[", 
      RowBox[{"1", ",", "2", ",", "1", ",", "1", ",", "1"}], "]"}], ",", "4", 
     ",", "4", ",", "2", ",", "1"}], "]"}], ",", 
   RowBox[{"Cluster", "[", 
    RowBox[{"8", ",", "10", ",", "4", ",", "1", ",", "1"}], "]"}], ",", "16", 
   ",", "3", ",", "2"}], "]"}]], "Output",
 ImageSize->{568, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->605796263]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClusterFlatten", "[", "cl", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->437641742],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "4", ",", "8", ",", "10"}], "}"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->262410348]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClusterSplit",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/ClusterSplit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cluster",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/Cluster"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Agglomerate",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/Agglomerate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->368680447]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection"],

Cell[TextData[ButtonBox["Hierarchical Clustering Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]], \
"Tutorials"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ClusterFlatten - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 41.3206090}", "context" -> 
    "HierarchicalClustering`", "keywords" -> {}, "index" -> True, "label" -> 
    "Hierarchical Clustering Package Symbol", "language" -> "en", "paclet" -> 
    "HierarchicalClustering Package", "status" -> "None", "summary" -> 
    "ClusterFlatten[c] gives a flat list of the data elements contained in \
the cluster c.", "synonyms" -> {}, "title" -> "ClusterFlatten", "type" -> 
    "Symbol", "uri" -> "HierarchicalClustering/ref/ClusterFlatten"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4063, 138, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->562235910]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8746, 302}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1546, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2169, 65, 36, 0, 70, "ObjectName"],
Cell[2208, 67, 485, 15, 70, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2730, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3208, 104, 276, 8, 70, "Notes"],
Cell[3487, 114, 539, 19, 70, "Notes",
 CellID->204680214]
}, Closed]],
Cell[CellGroupData[{
Cell[4063, 138, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->562235910],
Cell[CellGroupData[{
Cell[4448, 152, 148, 5, 70, "ExampleSection",
 CellID->561886139],
Cell[4599, 159, 146, 4, 70, "Input",
 CellID->41563977],
Cell[4748, 165, 74, 1, 70, "ExampleText",
 CellID->141748602],
Cell[CellGroupData[{
Cell[4847, 170, 215, 7, 28, "Input",
 CellID->434809347],
Cell[5065, 179, 531, 15, 36, "Output",
 CellID->605796263]
}, Open  ]],
Cell[CellGroupData[{
Cell[5633, 199, 111, 3, 28, "Input",
 CellID->437641742],
Cell[5747, 204, 235, 7, 36, "Output",
 CellID->262410348]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6043, 218, 295, 8, 70, "SeeAlsoSection"],
Cell[6341, 228, 781, 26, 70, "SeeAlso",
 CellID->368680447]
}, Open  ]],
Cell[CellGroupData[{
Cell[7159, 259, 298, 8, 70, "TutorialsSection"],
Cell[7460, 269, 176, 4, 70, "Tutorials"]
}, Open  ]],
Cell[7651, 276, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

