(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10793,        384]
NotebookOptionsPosition[      8191,        300]
NotebookOutlinePosition[      9455,        336]
CellTagsIndexPosition[      9371,        331]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HIERARCHICAL CLUSTERING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hierarchical Clustering Package" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Hierarchical Clustering Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ClusterFlatten" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/ClusterFlatten"], "Cluster" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/Cluster"], "Agglomerate" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/Agglomerate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ClusterFlatten\"\>", 
       2->"\<\"Cluster\"\>", 3->"\<\"Agglomerate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ClusterSplit", "ObjectName"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ClusterSplit", "[", 
       RowBox[{
        StyleBox["c", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]splits the cluster ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " into ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " clusters."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["ClusterSplit"], "InlineFormula"],
 " subdivides ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " by repeatedly splitting the cluster with the largest fusion level."
}], "Notes",
 CellID->70126611],

Cell[TextData[{
 Cell[BoxData["ClusterSplit"], "InlineFormula"],
 " returns a list of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  ButtonBox["Cluster",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Cluster"]], 
  "InlineFormula"],
 " objects or data elements."
}], "Notes",
 CellID->89844520],

Cell[TextData[{
 "The number ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " can be any positive integer less than or equal to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Length",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Length"], "[", 
   StyleBox["c", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->687518320],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->590939516],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->220130736],

Cell["\<\
Split a cluster into two sub\[Hyphen]clusters:\
\>", "ExampleText",
 CellID->141748602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cl", "=", 
  RowBox[{"Agglomerate", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->434809347],

Cell[BoxData[
 RowBox[{"Cluster", "[", 
  RowBox[{
   RowBox[{"Cluster", "[", 
    RowBox[{
     RowBox[{"Cluster", "[", 
      RowBox[{"1", ",", "2", ",", "1", ",", "1", ",", "1"}], "]"}], ",", "4", 
     ",", "4", ",", "2", ",", "1"}], "]"}], ",", 
   RowBox[{"Cluster", "[", 
    RowBox[{"8", ",", "10", ",", "4", ",", "1", ",", "1"}], "]"}], ",", "16", 
   ",", "3", ",", "2"}], "]"}]], "Output",
 ImageSize->{568, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->337478805]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClusterSplit", "[", 
  RowBox[{"cl", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->437641742],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cluster", "[", 
    RowBox[{
     RowBox[{"Cluster", "[", 
      RowBox[{"1", ",", "2", ",", "1", ",", "1", ",", "1"}], "]"}], ",", "4", 
     ",", "4", ",", "2", ",", "1"}], "]"}], ",", 
   RowBox[{"Cluster", "[", 
    RowBox[{"8", ",", "10", ",", "4", ",", "1", ",", "1"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{458, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->102011312]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection"],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClusterFlatten",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/ClusterFlatten"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cluster",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/Cluster"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Agglomerate",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/Agglomerate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->368680447]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection"],

Cell[TextData[ButtonBox["Hierarchical Clustering Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]], \
"Tutorials"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ClusterSplit - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 41.6956186}", "context" -> 
    "HierarchicalClustering`", "keywords" -> {}, "index" -> True, "label" -> 
    "Hierarchical Clustering Package Symbol", "language" -> "en", "paclet" -> 
    "HierarchicalClustering Package", "status" -> "None", "summary" -> 
    "ClusterSplit[c, n] splits the cluster c into n clusters.", 
    "synonyms" -> {}, "title" -> "ClusterSplit", "type" -> "Symbol", "uri" -> 
    "HierarchicalClustering/ref/ClusterSplit"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4274, 149, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->687518320]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9228, 324}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1552, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2175, 65, 34, 0, 70, "ObjectName"],
Cell[2212, 67, 579, 19, 70, "Usage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2828, 91, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3306, 108, 241, 7, 70, "Notes",
 CellID->70126611],
Cell[3550, 117, 356, 13, 70, "Notes",
 CellID->89844520],
Cell[3909, 132, 328, 12, 70, "Notes"]
}, Closed]],
Cell[CellGroupData[{
Cell[4274, 149, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->687518320],
Cell[CellGroupData[{
Cell[4659, 163, 148, 5, 70, "ExampleSection",
 CellID->590939516],
Cell[4810, 170, 147, 4, 70, "Input",
 CellID->220130736],
Cell[4960, 176, 97, 3, 70, "ExampleText",
 CellID->141748602],
Cell[CellGroupData[{
Cell[5082, 183, 215, 7, 28, "Input",
 CellID->434809347],
Cell[5300, 192, 531, 15, 36, "Output",
 CellID->337478805]
}, Open  ]],
Cell[CellGroupData[{
Cell[5868, 212, 132, 4, 28, "Input",
 CellID->437641742],
Cell[6003, 218, 488, 15, 36, "Output",
 CellID->102011312]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6552, 240, 295, 8, 70, "SeeAlsoSection"],
Cell[6850, 250, 785, 26, 70, "SeeAlso",
 CellID->368680447]
}, Open  ]],
Cell[CellGroupData[{
Cell[7672, 281, 298, 8, 70, "TutorialsSection"],
Cell[7973, 291, 176, 4, 70, "Tutorials"]
}, Open  ]],
Cell[8164, 298, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

