(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29129,       1020]
NotebookOptionsPosition[     23107,        812]
NotebookOutlinePosition[     24474,        849]
CellTagsIndexPosition[     24389,        844]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HIERARCHICAL CLUSTERING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hierarchical Clustering Package" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Hierarchical Clustering Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Agglomerate" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/Agglomerate"], 
          "DirectAgglomerate" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/DirectAgglomerate"], "Cluster" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/Cluster"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Agglomerate\"\>", 2->"\<\"DirectAgglomerate\"\>",
        3->"\<\"Cluster\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DendrogramPlot", "ObjectName",
 CellID->48572156],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DendrogramPlot", "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]constructs a dendrogram from the hierarchical \
clustering of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DendrogramPlot", "[", 
       StyleBox["c", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]constructs a dendrogram from the ",
     Cell[BoxData[
      ButtonBox["Cluster",
       BaseStyle->"Link",
       ButtonData->"paclet:HierarchicalClustering/ref/Cluster"]], 
      "InlineFormula"],
     " object ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->460318472]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["DendrogramPlot"], "InlineFormula"],
 " gives a graphic representation of hierarchical clusters."
}], "Notes",
 CellID->650803564],

Cell[TextData[{
 "When given a list of data, ",
 Cell[BoxData["DendrogramPlot"], "InlineFormula"],
 " generates a cluster hierarchy using ",
 Cell[BoxData[
  ButtonBox["Agglomerate",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Agglomerate"]], 
  "InlineFormula"],
 ", and plots the resulting ",
 Cell[BoxData[
  ButtonBox["Cluster",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Cluster"]], 
  "InlineFormula"],
 " object."
}], "Notes",
 CellID->319436704],

Cell["\<\
Connections of lines represent fusion of clusters, and lengths represent the \
degree of dissimilarity between clusters.\
\>", "Notes",
 CellID->408148749],

Cell["The following options can be given:", "Notes",
 CellID->148168512],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DistanceFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DistanceFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the distance or dissimilarity measure to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["HighlightLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:HierarchicalClustering/ref/HighlightLevel"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "level at which to highlight the clusters", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["HighlightStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:HierarchicalClustering/ref/HighlightStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "graphics directives specifying highlight style", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LeafLabels",
     BaseStyle->"Link",
     ButtonData->"paclet:HierarchicalClustering/ref/LeafLabels"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "a list of leaf labels", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Linkage",
     BaseStyle->"Link",
     ButtonData->"paclet:HierarchicalClustering/ref/Linkage"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the clustering linkage algorithm to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Orientation",
     BaseStyle->"Link",
     ButtonData->"paclet:HierarchicalClustering/ref/Orientation"], 
    ButtonBox["Top",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Top"], Cell[
    "orientation of the dendrogram", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "graphics directives specifying dendrogram style", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TruncateDendrogram",
     BaseStyle->"Link",
     ButtonData->"paclet:HierarchicalClustering/ref/TruncateDendrogram"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "level at which to truncate the dendrogram", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->706972834],

Cell[TextData[{
 "The options ",
 Cell[BoxData[
  ButtonBox["DistanceFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DistanceFunction"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Linkage",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Linkage"]], 
  "InlineFormula"],
 " are the same as for ",
 Cell[BoxData[
  ButtonBox["Agglomerate",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Agglomerate"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->860001874]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2309954],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->39633344],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->30320763],

Cell["Create a dendrogram of numeric data:", "ExampleText",
 CellID->708580166],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->197015159],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[
    0, 1, 0]}, {{}, {LineBox[{{1, 0}, {1, 1}, {2, 1}, {2, 0}}], 
     LineBox[{{1.5, 1}, {1.5, 4}, {3, 4}, {3, 0}}], 
     LineBox[{{4, 0}, {4, 4}, {5, 4}, {5, 0}}], 
     LineBox[{{2.25, 4}, {2.25, 16}, {4.5, 16}, {4.5, 4}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  PlotRange->All]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->574906410]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->45881645],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DistanceFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1757724783],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->465651455],

Cell[TextData[{
 "Dendrogram using ",
 Cell[BoxData[
  ButtonBox["ManhattanDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ManhattanDistance"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->141103965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"DistanceFunction", "->", "ManhattanDistance"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->146762761],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[
    0, 1, 0]}, {{}, {LineBox[{{1, 0}, {1, 1}, {2, 1}, {2, 0}}], 
     LineBox[{{1.5, 1}, {1.5, 2}, {3, 2}, {3, 0}}], 
     LineBox[{{4, 0}, {4, 2}, {5, 2}, {5, 0}}], 
     LineBox[{{2.25, 2}, {2.25, 4}, {4.5, 4}, {4.5, 2}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  PlotRange->All]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->142041329]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "HighlightLevel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->18864919],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->23750532],

Cell["Dendrogram highlighting the top 2 clusters:", "ExampleText",
 CellID->241812403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"HighlightLevel", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->318263060],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 1, 0], RectangleBox[{1, 0}], RectangleBox[{1.5, 0}, {3, 4}], 
    RectangleBox[{4, 0}, {5, 4}]}, {{}, {
     LineBox[{{1, 0}, {1, 1}, {2, 1}, {2, 0}}], 
     LineBox[{{1.5, 1}, {1.5, 4}, {3, 4}, {3, 0}}], 
     LineBox[{{4, 0}, {4, 4}, {5, 4}, {5, 0}}], 
     LineBox[{{2.25, 4}, {2.25, 16}, {4.5, 16}, {4.5, 4}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  PlotRange->All]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->262990787]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "HighlightStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->282520274],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->108364076],

Cell[TextData[{
 "Dendrogram highlighting the ",
 "top 2 clusters",
 " in ",
 Cell[BoxData[
  ButtonBox["Blue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blue"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->255838559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"HighlightLevel", "\[Rule]", "2"}], ",", 
   RowBox[{"HighlightStyle", "\[Rule]", "Blue"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->81248909],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 0, 1], RectangleBox[{1, 0}], RectangleBox[{1.5, 0}, {3, 4}], 
    RectangleBox[{4, 0}, {5, 4}]}, {{}, {
     LineBox[{{1, 0}, {1, 1}, {2, 1}, {2, 0}}], 
     LineBox[{{1.5, 1}, {1.5, 4}, {3, 4}, {3, 0}}], 
     LineBox[{{4, 0}, {4, 4}, {5, 4}, {5, 0}}], 
     LineBox[{{2.25, 4}, {2.25, 16}, {4.5, 16}, {4.5, 4}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  PlotRange->All]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->545780020]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "LeafLabels",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->300452330],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->181985268],

Cell["\<\
Dendrogram labelling leaves with the associated data elements:\
\>", "ExampleText",
 CellID->386130532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"LeafLabels", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"#", "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->311966421],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[
    0, 1, 0]}, {{}, {LineBox[{{1, 0}, {1, 1}, {2, 1}, {2, 0}}], 
     LineBox[{{1.5, 1}, {1.5, 4}, {3, 4}, {3, 0}}], 
     LineBox[{{4, 0}, {4, 4}, {5, 4}, {5, 0}}], 
     LineBox[{{2.25, 4}, {2.25, 16}, {4.5, 16}, {4.5, 4}}]}}, {
    InsetBox["1", Offset[{0., -4.}, {1, 0}], {0, 1}], 
    InsetBox["2", Offset[{0., -4.}, {2, 0}], {0, 1}], 
    InsetBox["4", Offset[{0., -4.}, {3, 0}], {0, 1}], 
    InsetBox["8", Offset[{0., -4.}, {4, 0}], {0, 1}], 
    InsetBox["10", Offset[{0., -4.}, {5, 0}], {0, 1}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  PlotRange->All]], "Output",
 ImageSize->{184, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->177563390]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Linkage",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->50733708],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->359174381],

Cell["Dendrogram using Ward's linkage:", "ExampleText",
 CellID->158038108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"Linkage", "\[Rule]", "\"\<Ward\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23591188],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmDFPg0AUxx+9pXPbRB1q2NSVzSZVJ51M+AQNpDHQwdjUDmyMfAxGpqZL
k6YTH4GRkY/QkRHfvaM5VEKMbuZdco/3f/zuf5DHcjy7a//l1V0v5q75tHKX
/mL+bj6+rbAkDADY4VyeA+YVZjR3VYXXZhQyirIsj8ejTK9/pFFgqU33Gq5x
HNu2naYpDGUQm80mpQED0kEQ+L6vXaIoCsNQaxRYatPNXfI8f6ABQxlEv9+f
TCZa7/f7igZcYeihyc2XK/nABbmZplkUhUynv6bpSXFvjDCUQXieF9KAAWl1
U79Jt1uWZfVq5Yad/KTVIokanW73VJffgaLP/kInSSKbOKZOHg6HurNKO45T
v99dhws2v+7cmDo1Go0sy5LpJentdluvmra63FIVUdxTpjOmmGKKKaaYYoop
pphiiimm/h+ljpgwO52IWyh9blaUPk8q6vvfEDA+ALfosmc=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->510975286]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Orientation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->41433157],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->500548745],

Cell["Dendrogram oriented from the left:", "ExampleText",
 CellID->868762795],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"Orientation", "\[Rule]", "Left"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->64197187],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[
    0, 1, 0]}, {{}, {LineBox[{{0, 1}, {-1, 1}, {-1, 2}, {0, 2}}], 
     LineBox[{{-1, 1.5}, {-4, 1.5}, {-4, 3}, {0, 3}}], 
     LineBox[{{0, 4}, {-4, 4}, {-4, 5}, {0, 5}}], 
     LineBox[{{-4, 2.25}, {-16, 2.25}, {-16, 4.5}, {-4, 4.5}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  PlotRange->All]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->525622060]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->31432370],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->10673145],

Cell[TextData[{
 "Dendrogram with lines drawn in ",
 Cell[BoxData[
  ButtonBox["Blue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blue"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->547574229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->68835696],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 1, 0]}, 
   {RGBColor[0, 0, 1], LineBox[{{1, 0}, {1, 1}, {2, 1}, {2, 0}}], 
    LineBox[{{1.5, 1}, {1.5, 4}, {3, 4}, {3, 0}}], 
    LineBox[{{4, 0}, {4, 4}, {5, 4}, {5, 0}}], 
    LineBox[{{2.25, 4}, {2.25, 16}, {4.5, 16}, {4.5, 4}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  PlotRange->All]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->45150590]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TruncateDendrogram",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->323868350],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->500185057],

Cell["Dendrogram truncated such that four leaves remain:", "ExampleText",
 CellID->139967422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"TruncateDendrogram", "\[Rule]", "4"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->377401347],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[
    0, 1, 0]}, {{}, {LineBox[{{1, 0}, {1, 4}, {2, 4}, {2, 0}}], 
     LineBox[{{3, 0}, {3, 4}, {4, 4}, {4, 0}}], 
     LineBox[{{1.5, 4}, {1.5, 16}, {3.5, 16}, {3.5, 4}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  PlotRange->All]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->332403372]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->310715699],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Agglomerate",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/Agglomerate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DirectAgglomerate",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/DirectAgglomerate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cluster",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/Cluster"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->90763710]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->34181153],

Cell[TextData[ButtonBox["Hierarchical Clustering Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]], \
"Tutorials",
 CellID->347014563]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DendrogramPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 41.9143742}", "context" -> 
    "HierarchicalClustering`", "keywords" -> {}, "index" -> True, "label" -> 
    "Hierarchical Clustering Package Symbol", "language" -> "en", "paclet" -> 
    "HierarchicalClustering Package", "status" -> "None", "summary" -> 
    "DendrogramPlot[list] constructs a dendrogram from the hierarchical \
clustering of list. DendrogramPlot[c] constructs a dendrogram from the \
Cluster object c.", "synonyms" -> {}, "title" -> "DendrogramPlot", "type" -> 
    "Symbol", "uri" -> "HierarchicalClustering/ref/DendrogramPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8053, 256, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->2309954]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24248, 837}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1572, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2195, 66, 55, 1, 70, "ObjectName",
 CellID->48572156],
Cell[2253, 69, 971, 31, 70, "Usage",
 CellID->460318472]
}, Open  ]],
Cell[CellGroupData[{
Cell[3261, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3739, 122, 160, 4, 70, "Notes",
 CellID->650803564],
Cell[3902, 128, 510, 17, 70, "Notes",
 CellID->319436704],
Cell[4415, 147, 165, 4, 70, "Notes",
 CellID->408148749],
Cell[4583, 153, 72, 1, 70, "Notes",
 CellID->148168512],
Cell[4658, 156, 2820, 73, 70, "3ColumnTableMod",
 CellID->706972834],
Cell[7481, 231, 535, 20, 70, "Notes",
 CellID->860001874]
}, Closed]],
Cell[CellGroupData[{
Cell[8053, 256, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2309954],
Cell[CellGroupData[{
Cell[8436, 270, 147, 5, 70, "ExampleSection",
 CellID->39633344],
Cell[8586, 277, 146, 4, 70, "Input",
 CellID->30320763],
Cell[8735, 283, 79, 1, 70, "ExampleText",
 CellID->708580166],
Cell[CellGroupData[{
Cell[8839, 288, 191, 6, 28, "Input",
 CellID->197015159],
Cell[9033, 296, 498, 13, 133, "Output",
 CellID->574906410]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9580, 315, 221, 7, 70, "ExampleSection",
 CellID->45881645],
Cell[CellGroupData[{
Cell[9826, 326, 238, 7, 70, "ExampleSubsection",
 CellID->1757724783],
Cell[10067, 335, 147, 4, 70, "Input",
 CellID->465651455],
Cell[10217, 341, 218, 8, 70, "ExampleText",
 CellID->141103965],
Cell[CellGroupData[{
Cell[10460, 353, 271, 8, 70, "Input",
 CellID->146762761],
Cell[10734, 363, 496, 13, 133, "Output",
 CellID->142041329]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11279, 382, 234, 7, 70, "ExampleSubsection",
 CellID->18864919],
Cell[11516, 391, 146, 4, 70, "Input",
 CellID->23750532],
Cell[11665, 397, 86, 1, 70, "ExampleText",
 CellID->241812403],
Cell[CellGroupData[{
Cell[11776, 402, 256, 7, 70, "Input",
 CellID->318263060],
Cell[12035, 411, 588, 14, 133, "Output",
 CellID->262990787]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12672, 431, 235, 7, 70, "ExampleSubsection",
 CellID->282520274],
Cell[12910, 440, 147, 4, 70, "Input",
 CellID->108364076],
Cell[13060, 446, 231, 10, 70, "ExampleText",
 CellID->255838559],
Cell[CellGroupData[{
Cell[13316, 460, 311, 8, 70, "Input",
 CellID->81248909],
Cell[13630, 470, 588, 14, 133, "Output",
 CellID->545780020]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14267, 490, 231, 7, 70, "ExampleSubsection",
 CellID->300452330],
Cell[14501, 499, 147, 4, 70, "Input",
 CellID->181985268],
Cell[14651, 505, 113, 3, 70, "ExampleText",
 CellID->386130532],
Cell[CellGroupData[{
Cell[14789, 512, 298, 9, 70, "Input",
 CellID->311966421],
Cell[15090, 523, 772, 18, 144, "Output",
 CellID->177563390]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15911, 547, 227, 7, 70, "ExampleSubsection",
 CellID->50733708],
Cell[16141, 556, 147, 4, 70, "Input",
 CellID->359174381],
Cell[16291, 562, 75, 1, 70, "ExampleText",
 CellID->158038108],
Cell[CellGroupData[{
Cell[16391, 567, 259, 7, 70, "Input",
 CellID->23591188],
Cell[16653, 576, 688, 15, 70, "Output",
 Evaluatable->False,
 CellID->510975286]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17390, 597, 231, 7, 70, "ExampleSubsection",
 CellID->41433157],
Cell[17624, 606, 147, 4, 70, "Input",
 CellID->500548745],
Cell[17774, 612, 77, 1, 70, "ExampleText",
 CellID->868762795],
Cell[CellGroupData[{
Cell[17876, 617, 255, 7, 70, "Input",
 CellID->64197187],
Cell[18134, 626, 509, 13, 133, "Output",
 CellID->525622060]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18692, 645, 229, 7, 70, "ExampleSubsection",
 CellID->31432370],
Cell[18924, 654, 146, 4, 70, "Input",
 CellID->10673145],
Cell[19073, 660, 206, 8, 70, "ExampleText",
 CellID->547574229],
Cell[CellGroupData[{
Cell[19304, 672, 253, 7, 70, "Input",
 CellID->68835696],
Cell[19560, 681, 506, 13, 133, "Output",
 CellID->45150590]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20115, 700, 239, 7, 70, "ExampleSubsection",
 CellID->323868350],
Cell[20357, 709, 147, 4, 70, "Input",
 CellID->500185057],
Cell[20507, 715, 93, 1, 70, "ExampleText",
 CellID->139967422],
Cell[CellGroupData[{
Cell[20625, 720, 260, 7, 70, "Input",
 CellID->377401347],
Cell[20888, 729, 443, 12, 133, "Output",
 CellID->332403372]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21404, 749, 315, 9, 70, "SeeAlsoSection",
 CellID->310715699],
Cell[21722, 760, 790, 26, 70, "SeeAlso",
 CellID->90763710]
}, Open  ]],
Cell[CellGroupData[{
Cell[22549, 791, 317, 9, 70, "TutorialsSection",
 CellID->34181153],
Cell[22869, 802, 196, 5, 70, "Tutorials",
 CellID->347014563]
}, Open  ]],
Cell[23080, 810, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

