(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18393,        649]
NotebookOptionsPosition[     14636,        525]
NotebookOutlinePosition[     16079,        563]
CellTagsIndexPosition[     15994,        558]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HIERARCHICAL CLUSTERING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hierarchical Clustering Package" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Hierarchical Clustering Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Agglomerate" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/Agglomerate"], "Cluster" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/Cluster"], "DendrogramPlot" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/DendrogramPlot"], 
          "DistanceMatrix" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/DistanceMatrix"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Agglomerate\"\>", 
       2->"\<\"Cluster\"\>", 3->"\<\"DendrogramPlot\"\>", 
       4->"\<\"DistanceMatrix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DirectAgglomerate", "ObjectName",
 CellID->20888],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DirectAgglomerate", "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs a cluster hierarchy based on the distance or \
dissimilarity matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DirectAgglomerate", "[", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]associates the elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " with the rows of the matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " in the cluster hierarchy."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->24767]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"DirectAgglomerate", "[", "m", "]"}]], "InlineFormula"],
 " labels each element by its row position in the matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23655],

Cell[TextData[{
 Cell[BoxData["DirectAgglomerate"], "InlineFormula"],
 " gives a ",
 Cell[BoxData[
  ButtonBox["Cluster",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Cluster"]], 
  "InlineFormula"],
 " object."
}], "Notes",
 CellID->15574],

Cell[TextData[{
 "The cluster hierarchy may be viewed using ",
 Cell[BoxData[
  ButtonBox["DendrogramPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/DendrogramPlot"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->403750047],

Cell[TextData[{
 "The distance matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " can be any symmetric matrix."
}], "Notes",
 CellID->12052],

Cell[TextData[{
 "The method used to determine intercluster dissimilarity can be specified \
using the ",
 Cell[BoxData[
  ButtonBox["Linkage",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Linkage"]], 
  "InlineFormula"],
 " option."
}], "Notes",
 CellID->27350],

Cell[TextData[{
 "Possible settings for the ",
 Cell[BoxData[
  ButtonBox["Linkage",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/Linkage"]], 
  "InlineFormula"],
 " option include:"
}], "Notes",
 CellID->1150],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Single\>\"", Cell[
    "smallest intercluster dissimilarity", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Average\>\"", Cell[
    "average intercluster dissimilarity", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Complete\>\"", Cell[
    "largest intercluster dissimilarity", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Weighted\>\"", Cell[
    "weighted average intercluster dissimilarity", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Centroid\>\"", Cell[
    "distance from cluster centroids", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Median\>\"", Cell[
    "distance from cluster medians", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Ward\>\"", Cell[
    "Ward's minimum variance dissimilarity", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["f", "TI"], Cell["a pure function", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->16941],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " defines a distance from a cluster ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " to the new cluster formed by fusing clusters ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->21724],

Cell[TextData[{
 "The arguments supplied to ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["d", "TI"], 
    StyleBox["ik", "TI"]], ",", 
   SubscriptBox[
    StyleBox["d", "TI"], 
    StyleBox["jk", "TI"]], ",", 
   SubscriptBox[
    StyleBox["d", "TI"], 
    StyleBox["ij", "TI"]], ",", 
   SubscriptBox[
    StyleBox["n", "TI"], 
    StyleBox["i", "TI"]], ",", 
   SubscriptBox[
    StyleBox["n", "TI"], 
    StyleBox["j", "TI"]], ","}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " is the distance between clusters and ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is the number of elements in a cluster."
}], "Notes",
 CellID->25939219]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->323805225],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->29089801],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->116822795],

Cell["Obtain a cluster hierarchy from a distance matrix:", "ExampleText",
 CellID->27638432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirectAgglomerate", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"1", "/", "3"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", "1", ",", 
      RowBox[{"1", "/", "4"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "/", "3"}], ",", 
      RowBox[{"1", "/", "4"}], ",", "1"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->121000328],

Cell[BoxData[
 RowBox[{"Cluster", "[", 
  RowBox[{"1", ",", 
   RowBox[{"Cluster", "[", 
    RowBox[{"2", ",", "3", ",", 
     FractionBox["1", "4"], ",", "1", ",", "1"}], "]"}], ",", 
   FractionBox["1", "3"], ",", "1", ",", "2"}], "]"}]], "Output",
 ImageSize->{291, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->286717670]
}, Open  ]],

Cell["Use labels to represent the rows:", "ExampleText",
 CellID->218506389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirectAgglomerate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"1", "/", "2"}], ",", 
       RowBox[{"1", "/", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "1", ",", 
       RowBox[{"1", "/", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "3"}], ",", 
       RowBox[{"1", "/", "4"}], ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\"\<a\>\"", ",", "\"\<b\>\"", ",", "\"\<c\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->178660403],

Cell[BoxData[
 RowBox[{"Cluster", "[", 
  RowBox[{"\<\"a\"\>", ",", 
   RowBox[{"Cluster", "[", 
    RowBox[{"\<\"b\"\>", ",", "\<\"c\"\>", ",", 
     FractionBox["1", "4"], ",", "1", ",", "1"}], "]"}], ",", 
   FractionBox["1", "3"], ",", "1", ",", "2"}], "]"}]], "Output",
 ImageSize->{291, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->387447357]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9853],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Linkage",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1757724783],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->315517706],

Cell["Cluster hierarchy using Ward's linkage:", "ExampleText",
 CellID->141103965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirectAgglomerate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"1", "/", "2"}], ",", 
       RowBox[{"1", "/", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "1", ",", 
       RowBox[{"1", "/", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "3"}], ",", 
       RowBox[{"1", "/", "4"}], ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"Linkage", "\[Rule]", "\"\<Ward\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->146762761],

Cell[BoxData[
 RowBox[{"Cluster", "[", 
  RowBox[{"1", ",", 
   RowBox[{"Cluster", "[", 
    RowBox[{"2", ",", "3", ",", 
     FractionBox["1", "4"], ",", "1", ",", "1"}], "]"}], ",", 
   FractionBox["17", "36"], ",", "1", ",", "2"}], "]"}]], "Output",
 ImageSize->{298, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->801936625]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->748],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Agglomerate",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/Agglomerate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cluster",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/Cluster"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DendrogramPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/DendrogramPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DistanceMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/DistanceMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27067]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7949],

Cell[TextData[ButtonBox["Hierarchical Clustering Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]], \
"Tutorials",
 CellID->12843]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DirectAgglomerate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 42.1956314}", "context" -> 
    "HierarchicalClustering`", "keywords" -> {}, "index" -> True, "label" -> 
    "Hierarchical Clustering Package Symbol", "language" -> "en", "paclet" -> 
    "HierarchicalClustering Package", "status" -> "None", "summary" -> 
    "DirectAgglomerate[m] constructs a cluster hierarchy based on the \
distance or dissimilarity matrix m. DirectAgglomerate[m, list] associates the \
elements of list with the rows of the matrix m in the cluster hierarchy.", 
    "synonyms" -> {}, "title" -> "DirectAgglomerate", "type" -> "Symbol", 
    "uri" -> "HierarchicalClustering/ref/DirectAgglomerate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7975, 272, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->323805225]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15851, 551}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1721, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2344, 69, 55, 1, 70, "ObjectName",
 CellID->20888],
Cell[2402, 72, 984, 30, 70, "Usage",
 CellID->24767]
}, Open  ]],
Cell[CellGroupData[{
Cell[3423, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3901, 124, 248, 8, 70, "Notes",
 CellID->23655],
Cell[4152, 134, 267, 10, 70, "Notes",
 CellID->15574],
Cell[4422, 146, 257, 9, 70, "Notes",
 CellID->403750047],
Cell[4682, 157, 159, 6, 70, "Notes",
 CellID->12052],
Cell[4844, 165, 289, 10, 70, "Notes",
 CellID->27350],
Cell[5136, 177, 237, 9, 70, "Notes",
 CellID->1150],
Cell[5376, 188, 1267, 25, 70, "2ColumnTableMod",
 CellID->16941],
Cell[6646, 215, 396, 15, 70, "Notes",
 CellID->21724],
Cell[7045, 232, 893, 35, 70, "Notes",
 CellID->25939219]
}, Closed]],
Cell[CellGroupData[{
Cell[7975, 272, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->323805225],
Cell[CellGroupData[{
Cell[8360, 286, 147, 5, 70, "ExampleSection",
 CellID->29089801],
Cell[8510, 293, 147, 4, 70, "Input",
 CellID->116822795],
Cell[8660, 299, 92, 1, 70, "ExampleText",
 CellID->27638432],
Cell[CellGroupData[{
Cell[8777, 304, 515, 17, 28, "Input",
 CellID->121000328],
Cell[9295, 323, 381, 11, 51, "Output",
 CellID->286717670]
}, Open  ]],
Cell[9691, 337, 76, 1, 70, "ExampleText",
 CellID->218506389],
Cell[CellGroupData[{
Cell[9792, 342, 638, 21, 70, "Input",
 CellID->178660403],
Cell[10433, 365, 405, 11, 51, "Output",
 CellID->387447357]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10887, 382, 217, 7, 70, "ExampleSection",
 CellID->9853],
Cell[CellGroupData[{
Cell[11129, 393, 229, 7, 70, "ExampleSubsection",
 CellID->1757724783],
Cell[11361, 402, 147, 4, 70, "Input",
 CellID->315517706],
Cell[11511, 408, 82, 1, 70, "ExampleText",
 CellID->141103965],
Cell[CellGroupData[{
Cell[11618, 413, 599, 19, 70, "Input",
 CellID->146762761],
Cell[12220, 434, 383, 11, 51, "Output",
 CellID->801936625]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12676, 453, 309, 9, 70, "SeeAlsoSection",
 CellID->748],
Cell[12988, 464, 1061, 35, 70, "SeeAlso",
 CellID->27067]
}, Open  ]],
Cell[CellGroupData[{
Cell[14086, 504, 313, 9, 70, "TutorialsSection",
 CellID->7949],
Cell[14402, 515, 192, 5, 70, "Tutorials",
 CellID->12843]
}, Open  ]],
Cell[14609, 523, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

