(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9116,        323]
NotebookOptionsPosition[      6577,        241]
NotebookOutlinePosition[      7872,        277]
CellTagsIndexPosition[      7788,        272]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HIERARCHICAL CLUSTERING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hierarchical Clustering Package" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Hierarchical Clustering Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TruncateDendrogram" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/TruncateDendrogram"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"TruncateDendrogram\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Orientation", "ObjectName",
 CellID->444774462],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Orientation"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["DendrogramPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:HierarchicalClustering/ref/DendrogramPlot"]], 
      "InlineFormula"],
     " that specifies the orientation of the dendrogram."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->98875155]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The value of ",
 Cell[BoxData["Orientation"], "InlineFormula"],
 " specifies the location of the last fusion of clusters."
}], "Notes",
 CellID->167643488],

Cell[TextData[{
 "Valid settings are ",
 Cell[BoxData[
  ButtonBox["Top",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Top"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Bottom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bottom"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->164441461]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->571809089],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->82163650],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->168572096],

Cell["Dendrogram oriented from the left:", "ExampleText",
 CellID->868762795],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"Orientation", "\[Rule]", "Left"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->64197187],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[
    0, 1, 0]}, {{}, {LineBox[{{0, 1}, {-1, 1}, {-1, 2}, {0, 2}}], 
     LineBox[{{-1, 1.5}, {-4, 1.5}, {-4, 3}, {0, 3}}], 
     LineBox[{{0, 4}, {-4, 4}, {-4, 5}, {0, 5}}], 
     LineBox[{{-4, 2.25}, {-16, 2.25}, {-16, 4.5}, {-4, 4.5}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  PlotRange->All]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->525622060]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->160170759],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["TruncateDendrogram",
   BaseStyle->"Link",
   ButtonData->"paclet:HierarchicalClustering/ref/TruncateDendrogram"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->52709989]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18836906],

Cell[TextData[ButtonBox["Hierarchical Clustering Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]], \
"Tutorials",
 CellID->34133738]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Orientation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 47.1645086}", "context" -> 
    "HierarchicalClustering`", "keywords" -> {}, "index" -> True, "label" -> 
    "Hierarchical Clustering Package Symbol", "language" -> "en", "paclet" -> 
    "HierarchicalClustering Package", "status" -> "None", "summary" -> 
    "Orientation is an option for DendrogramPlot that specifies the \
orientation of the dendrogram.", "synonyms" -> {}, "title" -> "Orientation", 
    "type" -> "Symbol", "uri" -> "HierarchicalClustering/ref/Orientation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3808, 137, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->571809089]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7645, 265}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1294, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1917, 61, 53, 1, 70, "ObjectName",
 CellID->444774462],
Cell[1973, 64, 557, 16, 70, "Usage",
 CellID->98875155]
}, Open  ]],
Cell[CellGroupData[{
Cell[2567, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3045, 102, 173, 5, 70, "Notes",
 CellID->167643488],
Cell[3221, 109, 550, 23, 70, "Notes",
 CellID->164441461]
}, Closed]],
Cell[CellGroupData[{
Cell[3808, 137, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->571809089],
Cell[CellGroupData[{
Cell[4193, 151, 147, 5, 70, "ExampleSection",
 CellID->82163650],
Cell[4343, 158, 147, 4, 70, "Input",
 CellID->168572096],
Cell[4493, 164, 77, 1, 70, "ExampleText",
 CellID->868762795],
Cell[CellGroupData[{
Cell[4595, 169, 255, 7, 28, "Input",
 CellID->64197187],
Cell[4853, 178, 509, 13, 133, "Output",
 CellID->525622060]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5423, 198, 315, 9, 70, "SeeAlsoSection",
 CellID->160170759],
Cell[5741, 209, 242, 6, 70, "SeeAlso",
 CellID->52709989]
}, Open  ]],
Cell[CellGroupData[{
Cell[6020, 220, 317, 9, 70, "TutorialsSection",
 CellID->18836906],
Cell[6340, 231, 195, 5, 70, "Tutorials",
 CellID->34133738]
}, Open  ]],
Cell[6550, 239, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

