(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10516,        364]
NotebookOptionsPosition[      7861,        279]
NotebookOutlinePosition[      9209,        316]
CellTagsIndexPosition[      9125,        311]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HIERARCHICAL CLUSTERING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hierarchical Clustering Package" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Hierarchical Clustering Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LeafLabels" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/LeafLabels"], "HighlightLevel" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/HighlightLevel"], "Orientation" :> 
          Documentation`HelpLookup[
           "paclet:HierarchicalClustering/ref/Orientation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LeafLabels\"\>", 
       2->"\<\"HighlightLevel\"\>", 
       3->"\<\"Orientation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TruncateDendrogram", "ObjectName",
 CellID->314360991],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["TruncateDendrogram"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["DendrogramPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:HierarchicalClustering/ref/DendrogramPlot"]], 
      "InlineFormula"],
     " that specifies the fusion levels at which to truncate the dendrogram."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->706151534]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings are ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 ", positive integers or a list of two positive integers. The integers should \
be no larger than the number of clusters. With the default setting ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 ", no truncation is performed."
}], "Notes",
 CellID->69578666],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{"TruncateDendrogram", "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " truncates clusters with the smallest fusion levels so that ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " leaves remain. "
}], "Notes",
 CellID->382266718],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{"TruncateDendrogram", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"]}], "}"}]}]], "InlineFormula"],
 " will display only the ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " through ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " fusion levels."
}], "Notes",
 CellID->386006146]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->788821055],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->35103433],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HierarchicalClustering`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->412042261],

Cell["Dendrogram truncated such that four leaves remain:", "ExampleText",
 CellID->139967422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DendrogramPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "10", ",", "4", ",", "8"}], "}"}], ",", 
   RowBox[{"TruncateDendrogram", "\[Rule]", "4"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->377401347],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[
    0, 1, 0]}, {{}, {LineBox[{{1, 0}, {1, 4}, {2, 4}, {2, 0}}], 
     LineBox[{{3, 0}, {3, 4}, {4, 4}, {4, 0}}], 
     LineBox[{{1.5, 4}, {1.5, 16}, {3.5, 16}, {3.5, 4}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  PlotRange->All]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->332403372]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->109675052],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LeafLabels",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/LeafLabels"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HighlightLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/HighlightLevel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Orientation",
    BaseStyle->"Link",
    ButtonData->"paclet:HierarchicalClustering/ref/Orientation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->63662288]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->269116304],

Cell[TextData[ButtonBox["Hierarchical Clustering Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HierarchicalClustering/tutorial/HierarchicalClustering"]], \
"Tutorials",
 CellID->24046362]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TruncateDendrogram - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 47.3520134}", "context" -> 
    "HierarchicalClustering`", "keywords" -> {}, "index" -> True, "label" -> 
    "Hierarchical Clustering Package Symbol", "language" -> "en", "paclet" -> 
    "HierarchicalClustering Package", "status" -> "None", "summary" -> 
    "TruncateDendrogram is an option for DendrogramPlot that specifies the \
fusion levels at which to truncate the dendrogram.", "synonyms" -> {}, 
    "title" -> "TruncateDendrogram", "type" -> "Symbol", "uri" -> 
    "HierarchicalClustering/ref/TruncateDendrogram"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4588, 156, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->788821055]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8982, 304}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1569, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2192, 66, 60, 1, 70, "ObjectName",
 CellID->314360991],
Cell[2255, 69, 585, 16, 70, "Usage",
 CellID->706151534]
}, Open  ]],
Cell[CellGroupData[{
Cell[2877, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3355, 107, 472, 14, 70, "Notes",
 CellID->69578666],
Cell[3830, 123, 306, 10, 70, "Notes",
 CellID->382266718],
Cell[4139, 135, 412, 16, 70, "Notes",
 CellID->386006146]
}, Closed]],
Cell[CellGroupData[{
Cell[4588, 156, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->788821055],
Cell[CellGroupData[{
Cell[4973, 170, 147, 5, 70, "ExampleSection",
 CellID->35103433],
Cell[5123, 177, 147, 4, 70, "Input",
 CellID->412042261],
Cell[5273, 183, 93, 1, 70, "ExampleText",
 CellID->139967422],
Cell[CellGroupData[{
Cell[5391, 188, 260, 7, 28, "Input",
 CellID->377401347],
Cell[5654, 197, 443, 12, 133, "Output",
 CellID->332403372]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6158, 216, 315, 9, 70, "SeeAlsoSection",
 CellID->109675052],
Cell[6476, 227, 790, 26, 70, "SeeAlso",
 CellID->63662288]
}, Open  ]],
Cell[CellGroupData[{
Cell[7303, 258, 318, 9, 70, "TutorialsSection",
 CellID->269116304],
Cell[7624, 269, 195, 5, 70, "Tutorials",
 CellID->24046362]
}, Open  ]],
Cell[7834, 277, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

