(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12218,        387]
NotebookOptionsPosition[     10139,        327]
NotebookOutlinePosition[     11494,        360]
CellTagsIndexPosition[     11451,        357]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HISTOGRAMS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Histogram" :> 
         Documentation`HelpLookup["paclet:Histograms/ref/Histogram"], 
         "Graphics3D" :> 
         Documentation`HelpLookup["paclet:ref/Graphics3D"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Histogram\"\>", 
      2->"\<\"Graphics3D\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Histogram3D", "ObjectName",
 CellID->25274],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Histogram3D", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a three dimensional bar graph representing a \
histogram of the bivariate data ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["1", "TR"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["2", "TR"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TI"]}], "}"}]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Histogram3D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["f", "TI"], 
             StyleBox["11", "TR"]], ",", 
            SubscriptBox[
             StyleBox["f", "TI"], 
             StyleBox["12", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"], ",", 
            SubscriptBox[
             StyleBox["f", "TI"], 
             StyleBox[
              RowBox[{"1", "l"}], "TI"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["f", "TI"], 
             StyleBox["k1", "TI"]], ",", 
            SubscriptBox[
             StyleBox["f", "TI"], 
             StyleBox["k2", "TI"]], ",", 
            StyleBox["\[Ellipsis]", "TR"], ",", 
            SubscriptBox[
             StyleBox["f", "TI"], 
             StyleBox["kl", "TI"]]}], "}"}]}], "}"}], ",", 
        RowBox[{
         ButtonBox["FrequencyData",
          BaseStyle->"Link",
          ButtonData->"paclet:Histograms/ref/FrequencyData"], "->", 
         ButtonBox["True",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a histogram of the bivariate data, where ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["ij", "TI"]]], "InlineFormula"],
     " is the frequency with which the original data falls in the category ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"]}], "}"}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->19622]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The cross\[Dash]sectional area of each solid bar is proportional to the area \
of the rectangular region defining the respective category.\
\>", "Notes",
 CellID->11453],

Cell["\<\
The volume of the bar is proportional to the frequency with which the data \
fall in its category.\
\>", "Notes",
 CellID->21650],

Cell[TextData[{
 "Histogram range and categories may be specified using the options ",
 Cell[BoxData[
  ButtonBox["HistogramRange",
   BaseStyle->"Link",
   ButtonData->"paclet:Histograms/ref/HistogramRange"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["HistogramCategories",
   BaseStyle->"Link",
   ButtonData->"paclet:Histograms/ref/HistogramCategories"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->24500],

Cell["The following options can be give:", "Notes",
 CellID->26008],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ApproximateIntervals",
     BaseStyle->"Link",
     ButtonData->"paclet:Histograms/ref/ApproximateIntervals"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
whether to adjust the interval boundaries to be simple numbers\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrequencyData",
     BaseStyle->"Link",
     ButtonData->"paclet:Histograms/ref/FrequencyData"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether input represents the original data or frequencies in categories\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["HistogramCategories",
     BaseStyle->"Link",
     ButtonData->"paclet:Histograms/ref/HistogramCategories"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specifies categories in the histogram", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["HistogramRange",
     BaseStyle->"Link",
     ButtonData->"paclet:Histograms/ref/HistogramRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "lower and upper limits of points in histogram", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["HistogramScale",
     BaseStyle->"Link",
     ButtonData->"paclet:Histograms/ref/HistogramScale"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "scaling of the bar heights", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarEdges",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarEdges"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether the edges of the bars are drawn", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarEdgeStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarEdgeStyle"], 
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", "0", "]"}], Cell[
    "style of the edges of bars", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BarStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:BarCharts/ref/BarStyle"], 
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", "1", "]"}], Cell[
    "style of the faces of bars", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Ticks",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Ticks"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specifies tick marks for axes", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True, True}}}},
 CellID->4224]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13876],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Histogram",
    BaseStyle->"Link",
    ButtonData->"paclet:Histograms/ref/Histogram"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Graphics3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics3D"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1499162012]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Histogram3D - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 54.5709482}", "context" -> "Histograms`",
     "keywords" -> {}, "index" -> True, "label" -> 
    "Histograms Package Symbol", "language" -> "en", "paclet" -> 
    "Histograms Package", "status" -> "None", "summary" -> 
    "Histogram3D[{{x_1, y_1}, {x_2, y_2}, ...}] generates a three dimensional \
bar graph representing a histogram of the bivariate data {{x_1, y_1}, {x_2, \
y_2}, ...}. Histogram3D[{{f_11, f_12, ..., f 1 l}, ..., {f_k1, f_k2, ..., \
f_kl}}, FrequencyData -> True] generates a histogram of the bivariate data, \
where f_ij is the frequency with which the original data falls in the \
category {i, j}.", "synonyms" -> {}, "title" -> "Histogram3D", "type" -> 
    "Symbol", "uri" -> "Histograms/ref/Histogram3D"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 689, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1312, 44, 49, 1, 70, "ObjectName",
 CellID->25274],
Cell[1364, 47, 3381, 104, 70, "Usage",
 CellID->19622]
}, Open  ]],
Cell[CellGroupData[{
Cell[4782, 156, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5260, 173, 179, 4, 70, "Notes",
 CellID->11453],
Cell[5442, 179, 139, 4, 70, "Notes",
 CellID->21650],
Cell[5584, 185, 427, 14, 70, "Notes",
 CellID->24500],
Cell[6014, 201, 67, 1, 70, "Notes",
 CellID->26008],
Cell[6084, 204, 3189, 85, 70, "3ColumnTableMod",
 CellID->4224]
}, Closed]],
Cell[CellGroupData[{
Cell[9310, 294, 311, 9, 70, "SeeAlsoSection",
 CellID->13876],
Cell[9624, 305, 473, 17, 70, "SeeAlso",
 CellID->1499162012]
}, Open  ]],
Cell[10112, 325, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

