(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6336,        221]
NotebookOptionsPosition[      4527,        164]
NotebookOutlinePosition[      5619,        194]
CellTagsIndexPosition[      5576,        191]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HISTOGRAMS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Histogram" :> 
         Documentation`HelpLookup["paclet:Histograms/ref/Histogram"], 
         "Histogram3D" :> 
         Documentation`HelpLookup["paclet:Histograms/ref/Histogram3D"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Histogram\"\>", 
      2->"\<\"Histogram3D\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HistogramScale", "ObjectName",
 CellID->20638],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["HistogramScale"], "InlineFormula"],
     " \[LineSeparator]is an option of histogram functions that specifies the \
way in which the bar heights are to be scaled."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->944]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"HistogramScale", " ", "->", " ", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " does not scale the bar heights when there are equally sized intervals."
}], "Notes",
 CellID->31966],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"HistogramScale", " ", "->", " ", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " scales the bar heights by the interval sizes when the intervals are not \
equally sized."
}], "Notes",
 CellID->1231264186],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"HistogramScale", " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " always scales the bar heights by the interval sizes regardless of whether \
the interval sizes are equal. "
}], "Notes",
 CellID->31074275],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"HistogramScale", " ", "->", " ", 
   StyleBox["k", "TI"]}]], "InlineFormula"],
 " scales bar heights so that the bar areas or bar volumes sum to the \
positive number k."
}], "Notes",
 CellID->426813704],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"HistogramScale", " ", "->", " ", "1"}]], "InlineFormula"],
 " gives a probability density plot."
}], "Notes",
 CellID->1126833424]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21922],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Histogram",
    BaseStyle->"Link",
    ButtonData->"paclet:Histograms/ref/Histogram"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Histogram3D",
    BaseStyle->"Link",
    ButtonData->"paclet:Histograms/ref/Histogram3D"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20896]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HistogramScale - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 55.2897166}", "context" -> "Histograms`",
     "keywords" -> {}, "index" -> True, "label" -> 
    "Histograms Package Symbol", "language" -> "en", "paclet" -> 
    "Histograms Package", "status" -> "None", "summary" -> 
    "HistogramScale is an option of histogram functions that specifies the \
way in which the bar heights are to be scaled.", "synonyms" -> {}, "title" -> 
    "HistogramScale", "type" -> "Symbol", "uri" -> 
    "Histograms/ref/HistogramScale"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 704, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1327, 44, 52, 1, 70, "ObjectName",
 CellID->20638],
Cell[1382, 47, 405, 11, 70, "Usage",
 CellID->944]
}, Open  ]],
Cell[CellGroupData[{
Cell[1824, 63, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2302, 80, 290, 8, 70, "Notes",
 CellID->31966],
Cell[2595, 90, 313, 9, 70, "Notes",
 CellID->1231264186],
Cell[2911, 101, 319, 9, 70, "Notes",
 CellID->31074275],
Cell[3233, 112, 245, 7, 70, "Notes",
 CellID->426813704],
Cell[3481, 121, 172, 5, 70, "Notes",
 CellID->1126833424]
}, Closed]],
Cell[CellGroupData[{
Cell[3690, 131, 311, 9, 70, "SeeAlsoSection",
 CellID->21922],
Cell[4004, 142, 481, 17, 70, "SeeAlso",
 CellID->20896]
}, Open  ]],
Cell[4500, 162, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

