(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9334,        322]
NotebookOptionsPosition[      6395,        235]
NotebookOutlinePosition[      7733,        269]
CellTagsIndexPosition[      7690,        266]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Hypothesis Testing Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell["Hypothesis Tests", "GuideFunctionsSubsection",
 CellID->218929667],

Cell[TextData[{
 Cell[TextData[ButtonBox["MeanTest",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/ref/MeanTest"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " test the mean of data"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["MeanDifferenceTest",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/ref/MeanDifferenceTest"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["VarianceTest",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/ref/VarianceTest"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["VarianceRatioTest",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/ref/VarianceRatioTest"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->408667159],

Cell["\t", "GuideDelimiterSubsection",
 CellID->35594646]
}, Open  ]],

Cell[CellGroupData[{

Cell["Confidence Intervals", "GuideFunctionsSubsection",
 CellID->19592319],

Cell[TextData[{
 Cell[TextData[ButtonBox["MeanCI",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/ref/MeanCI"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " confidence interval of mean"
}], "GuideText",
 CellID->343254065],

Cell[TextData[{
 Cell[TextData[ButtonBox["StudentTCI",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/ref/StudentTCI"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " confidence interval based on Student ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution"
}], "GuideText",
 CellID->302191167],

Cell[TextData[{
 Cell[TextData[ButtonBox["MeanDifferenceCI",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/ref/MeanDifferenceCI"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["VarianceCI",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/ref/VarianceCI"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["VarianceRatioCI",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/ref/VarianceRatioCI"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NormalCI",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/ref/NormalCI"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ChiSquareCI",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/ref/ChiSquareCI"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FRatioCI",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/ref/FRatioCI"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->8439080],

Cell["\t", "GuideDelimiterSubsection",
 CellID->685235335]
}, Open  ]],

Cell[CellGroupData[{

Cell["P\[Hyphen]Values", "GuideFunctionsSubsection",
 CellID->56980267],

Cell[TextData[{
 Cell[TextData[ButtonBox["NormalPValue",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/ref/NormalPValue"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " probability based on normal distribution"
}], "GuideText",
 CellID->141325929],

Cell[TextData[{
 Cell[TextData[ButtonBox["StudentTPValue",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/ref/StudentTPValue"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ChiSquarePValue",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/ref/ChiSquarePValue"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FRatioPValue",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/ref/FRatioPValue"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->25714839]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "GuideTutorial",
 CellID->110393948]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Analysis of Variance Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ANOVA/guide/AnalysisOfVariancePackage"]], "GuideMoreAbout",
 CellID->250590050],

Cell[TextData[ButtonBox["Linear Regression Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:LinearRegression/guide/LinearRegressionPackage"]], "GuideMoreAbout",\

 CellID->98196295],

Cell[TextData[ButtonBox["Nonlinear Regression Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NonlinearRegression/guide/NonlinearRegressionPackage"]], \
"GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Continuous Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ContinuousStatisticalDistributions"]], "GuideMoreAbout",
 CellID->84797929]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hypothesis Testing Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 55.4615960}", "context" -> 
    "HypothesisTesting`", 
    "keywords" -> {
     "confidence interval", "p\\[Hyphen]value", "significance test", "t test",
       "z test"}, "index" -> True, "label" -> 
    "Hypothesis Testing Package Guide", "language" -> "en", "paclet" -> 
    "HypothesisTesting Package", "status" -> "None", "summary" -> 
    "MeanTest -- test the mean of data, MeanCI -- confidence interval of \
mean, StudentTCI -- confidence interval based on Student t distribution, \
NormalPValue -- probability based on normal distribution", "synonyms" -> {}, 
    "title" -> "Hypothesis Testing Package", "type" -> "Guide", "uri" -> 
    "HypothesisTesting/guide/HypothesisTestingPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 68, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[690, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[771, 33, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->218929667],
Cell[846, 36, 266, 9, 70, "GuideText",
 CellID->203374175],
Cell[1115, 47, 713, 20, 70, "InlineGuideFunctionListing",
 CellID->408667159],
Cell[1831, 69, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->35594646]
}, Open  ]],
Cell[CellGroupData[{
Cell[1925, 75, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->19592319],
Cell[2003, 78, 265, 8, 70, "GuideText",
 CellID->343254065],
Cell[2271, 88, 361, 12, 70, "GuideText",
 CellID->302191167],
Cell[2635, 102, 1392, 41, 70, "InlineGuideFunctionListing",
 CellID->8439080],
Cell[4030, 145, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->685235335]
}, Open  ]],
Cell[CellGroupData[{
Cell[4125, 151, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->56980267],
Cell[4199, 154, 293, 9, 70, "GuideText",
 CellID->141325929],
Cell[4495, 165, 700, 20, 70, "InlineGuideFunctionListing",
 CellID->25714839]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5244, 191, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[5309, 194, 183, 4, 70, "GuideTutorial",
 CellID->110393948]
}, Open  ]],
Cell[CellGroupData[{
Cell[5529, 203, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[5594, 206, 179, 4, 70, "GuideMoreAbout",
 CellID->250590050],
Cell[5776, 212, 186, 5, 70, "GuideMoreAbout",
 CellID->98196295],
Cell[5965, 219, 196, 5, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[6164, 226, 189, 4, 70, "GuideMoreAbout",
 CellID->84797929]
}, Open  ]],
Cell[6368, 233, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

