(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13972,        511]
NotebookOptionsPosition[     10761,        403]
NotebookOutlinePosition[     12102,        441]
CellTagsIndexPosition[     12017,        436]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"VarianceCI" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/VarianceCI"],
           "VarianceTest" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/VarianceTest"], "ChiSquarePValue" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/ChiSquarePValue"], 
          "ChiSquareDistribution" :> 
          Documentation`HelpLookup["paclet:ref/ChiSquareDistribution"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"VarianceCI\"\>", 
       2->"\<\"VarianceTest\"\>", 3->"\<\"ChiSquarePValue\"\>", 
       4->"\<\"ChiSquareDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ChiSquareCI", "ObjectName",
 CellID->27065],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ChiSquareCI", "[", 
       RowBox[{
        StyleBox["var", "TI"], ",", 
        StyleBox["df", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a confidence interval based on a ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["\[Chi]", "TR"], "2"]], "InlineFormula"],
     " distribution with ",
     Cell[BoxData[
      StyleBox["df", "TI"]], "InlineFormula"],
     " degrees of freedom."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2513]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ChiSquareCI", "[", 
   RowBox[{
    StyleBox["var", "TI"], ",", " ", 
    StyleBox["df", "TI"]}], "]"}]], "InlineFormula"],
 " gives a confidence interval ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"min", ",", " ", "max"}], "}"}]], "InlineFormula"],
 "for a population variance estimated by ",
 Cell[BoxData[
  StyleBox["var", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->129549755],

Cell[TextData[{
 "For confidence level \[Alpha], ",
 Cell[BoxData[
  RowBox[{
   StyleBox["min", "TI"], "=", 
   RowBox[{
    StyleBox["var", "TI"], 
    StyleBox[" ", "TI"], 
    RowBox[{
     StyleBox["df", "TI"], "/", 
     SubscriptBox[
      StyleBox["q", "TI"], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         StyleBox["\[Alpha]", "TR"]}], ")"}], "/", "2"}]]}]}]}]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["max", "TI"], "=", 
    RowBox[{
     StyleBox["var", "TI"], 
     StyleBox[" ", "TI"], 
     RowBox[{
      StyleBox["df", "TI"], "/", 
      SubscriptBox[
       StyleBox["q", "TI"], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          StyleBox["\[Alpha]", "TR"]}], ")"}], "/", "2"}]]}]}]}], 
   TraditionalForm]], "InlineMath"],
 " where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["q", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["th", "TI"]]], "InlineFormula"],
 " quantile of a ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["\[Chi]", "TR"], "2"]], "InlineFormula"],
 " distribution with ",
 Cell[BoxData[
  StyleBox["df", "TI"]], "InlineFormula"],
 " degrees of freedom."
}], "Notes",
 CellID->381223639],

Cell[TextData[{
 Cell[BoxData["ChiSquareCI"], "InlineFormula"],
 " is the confidence interval for a population variance based on a sample \
variance ",
 Cell[BoxData[
  StyleBox["var", "TI"]], "InlineFormula"],
 " estimated from a sample of size ",
 Cell[BoxData[
  FormBox[
   RowBox[{"df", "+", "1"}], TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->198048243],

Cell["The following option can be given:", "Notes",
 CellID->21078],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ConfidenceLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/ConfidenceLevel"], "0.95", 
    Cell["probability associated with a confidence interval", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->16878]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->115641917],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->613241237],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->54500026],

Cell[TextData[{
 "A 95% confidence interval based on a ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["\[Chi]", "TR"], "2"]], "InlineFormula"],
 " distribution:"
}], "ExampleText",
 CellID->11420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChiSquareCI", "[", 
  RowBox[{"1", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->176484641],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.4882055078044728`", ",", "3.079791755836825`"}], "}"}]], "Output",\

 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->224308547]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6705],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ConfidenceLevel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1295379749],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->287585794],

Cell["A 99% confidence interval:", "ExampleText",
 CellID->493427760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChiSquareCI", "[", 
  RowBox[{"1", ",", "10", ",", 
   RowBox[{"ConfidenceLevel", "\[Rule]", ".99"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->129566985],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.39701162092427555`", ",", "4.638527697330017`"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->532206258]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->170],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["VarianceCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/VarianceCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VarianceTest",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/VarianceTest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChiSquarePValue",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/ChiSquarePValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChiSquareDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChiSquareDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29975]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14140],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->4611]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ChiSquareCI - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 55.6647262}", "context" -> 
    "HypothesisTesting`", 
    "keywords" -> {"confidence interval", "variance test"}, "index" -> True, 
    "label" -> "Hypothesis Testing Package Symbol", "language" -> "en", 
    "paclet" -> "HypothesisTesting Package", "status" -> "None", "summary" -> 
    "ChiSquareCI[var, df] gives a confidence interval based on a \\[Chi]^2 \
distribution with df degrees of freedom.", "synonyms" -> {}, "title" -> 
    "ChiSquareCI", "type" -> "Symbol", "uri" -> 
    "HypothesisTesting/ref/ChiSquareCI"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6279, 220, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->115641917]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11874, 429}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1689, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2312, 68, 49, 1, 70, "ObjectName",
 CellID->27065],
Cell[2364, 71, 673, 21, 70, "Usage",
 CellID->2513]
}, Open  ]],
Cell[CellGroupData[{
Cell[3074, 97, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3552, 114, 435, 15, 70, "Notes",
 CellID->129549755],
Cell[3990, 131, 1309, 53, 70, "Notes",
 CellID->381223639],
Cell[5302, 186, 375, 12, 70, "Notes",
 CellID->198048243],
Cell[5680, 200, 67, 1, 70, "Notes",
 CellID->21078],
Cell[5750, 203, 492, 12, 70, "3ColumnTableMod",
 CellID->16878]
}, Closed]],
Cell[CellGroupData[{
Cell[6279, 220, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->115641917],
Cell[CellGroupData[{
Cell[6664, 234, 148, 5, 70, "ExampleSection",
 CellID->613241237],
Cell[6815, 241, 141, 4, 70, "Input",
 CellID->54500026],
Cell[6959, 247, 197, 7, 70, "ExampleText",
 CellID->11420],
Cell[CellGroupData[{
Cell[7181, 258, 131, 4, 28, "Input",
 CellID->176484641],
Cell[7315, 264, 241, 8, 36, "Output",
 CellID->224308547]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7605, 278, 217, 7, 70, "ExampleSection",
 CellID->6705],
Cell[CellGroupData[{
Cell[7847, 289, 237, 7, 70, "ExampleSubsection",
 CellID->1295379749],
Cell[8087, 298, 142, 4, 70, "Input",
 CellID->287585794],
Cell[8232, 304, 69, 1, 70, "ExampleText",
 CellID->493427760],
Cell[CellGroupData[{
Cell[8326, 309, 187, 5, 70, "Input",
 CellID->129566985],
Cell[8516, 316, 243, 8, 36, "Output",
 CellID->532206258]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8832, 332, 309, 9, 70, "SeeAlsoSection",
 CellID->170],
Cell[9144, 343, 1047, 35, 70, "SeeAlso",
 CellID->29975]
}, Open  ]],
Cell[CellGroupData[{
Cell[10228, 383, 314, 9, 70, "TutorialsSection",
 CellID->14140],
Cell[10545, 394, 174, 4, 70, "Tutorials",
 CellID->4611]
}, Open  ]],
Cell[10734, 401, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

