(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12553,        459]
NotebookOptionsPosition[      9364,        352]
NotebookOutlinePosition[     10757,        391]
CellTagsIndexPosition[     10672,        386]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ChiSquareCI" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/ChiSquareCI"], 
          "ChiSquareDistribution" :> 
          Documentation`HelpLookup["paclet:ref/ChiSquareDistribution"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"ChiSquareCI\"\>", 
       2->"\<\"ChiSquareDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ChiSquarePValue", "ObjectName",
 CellID->25445],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ChiSquarePValue", "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["df", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the cumulative probability beyond ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " for the ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["\[Chi]", "TR"], "2"]], "InlineFormula"],
     " distribution with ",
     Cell[BoxData[
      StyleBox["df", "TI"]], "InlineFormula"],
     " degrees of freedom."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29003]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The one-sided ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]value is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CDF"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["ChiSquareDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ChiSquareDistribution"], "[", 
     StyleBox["df", "TI"], "]"}], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " if ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is less than the median of the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["\[Chi]", "TR"], "2"]], "InlineFormula"],
 " distribution with ",
 Cell[BoxData[
  StyleBox["df", "TI"]], "InlineFormula"],
 " degrees of freedom, and  ",
 Cell[BoxData[
  RowBox[{"1", "-", 
   RowBox[{
    ButtonBox["CDF",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CDF"], "[", 
    RowBox[{
     RowBox[{
      ButtonBox["ChiSquareDistribution",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ChiSquareDistribution"], "[", 
      StyleBox["df", "TI"], "]"}], ",", 
     StyleBox["x", "TI"]}], "]"}]}]], "InlineFormula"],
 " otherwise."
}], "Notes",
 CellID->15717],

Cell[TextData[{
 "The two-sided ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]value is twice the one-sided ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]value."
}], "Notes",
 CellID->521369599],

Cell["The following options can be given:", "Notes",
 CellID->8086],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TwoSided",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/TwoSided"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to perform a two-sided test", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->3734]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->6838926],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->249065790],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->157966313],

Cell[TextData[{
 "The p\[Hyphen]value for 10 in a ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["\[Chi]", "TR"], "2"]], "InlineFormula"],
 " distribution with 5 degrees of freedom:"
}], "ExampleText",
 CellID->11420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChiSquarePValue", "[", 
  RowBox[{"10", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13260],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.07523524614651218`"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29007700]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18614],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TwoSided",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1295379749],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->257249923],

Cell["A two\[Hyphen]sided p\[Hyphen]value:", "ExampleText",
 CellID->493427760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChiSquarePValue", "[", 
  RowBox[{"10", ",", "5", ",", 
   RowBox[{"TwoSided", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->129566985],

Cell[BoxData[
 RowBox[{"TwoSidedPValue", "\[Rule]", "0.15047049229302437`"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->225225510]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27201],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChiSquareCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/ChiSquareCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChiSquareDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChiSquareDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4855]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1452],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->5275]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ChiSquarePValue - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 59, 55.8991072}", "context" -> 
    "HypothesisTesting`", 
    "keywords" -> {
     "chi square statistic", "chi square test", "p\\[Hyphen]value"}, "index" -> 
    True, "label" -> "Hypothesis Testing Package Symbol", "language" -> "en", 
    "paclet" -> "HypothesisTesting Package", "status" -> "None", "summary" -> 
    "ChiSquarePValue[x, df] gives the cumulative probability beyond x for the \
\\[Chi]^2 distribution with df degrees of freedom.", "synonyms" -> {}, 
    "title" -> "ChiSquarePValue", "type" -> "Symbol", "uri" -> 
    "HypothesisTesting/ref/ChiSquarePValue"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5453, 191, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->6838926]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10531, 379}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1398, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2021, 63, 53, 1, 70, "ObjectName",
 CellID->25445],
Cell[2077, 66, 761, 24, 70, "Usage",
 CellID->29003]
}, Open  ]],
Cell[CellGroupData[{
Cell[2875, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3353, 112, 1203, 43, 70, "Notes",
 CellID->15717],
Cell[4559, 157, 243, 9, 70, "Notes",
 CellID->521369599],
Cell[4805, 168, 67, 1, 70, "Notes",
 CellID->8086],
Cell[4875, 171, 541, 15, 70, "3ColumnTableMod",
 CellID->3734]
}, Closed]],
Cell[CellGroupData[{
Cell[5453, 191, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->6838926],
Cell[CellGroupData[{
Cell[5836, 205, 148, 5, 70, "ExampleSection",
 CellID->249065790],
Cell[5987, 212, 142, 4, 70, "Input",
 CellID->157966313],
Cell[6132, 218, 218, 7, 70, "ExampleText",
 CellID->11420],
Cell[CellGroupData[{
Cell[6375, 229, 131, 4, 28, "Input",
 CellID->13260],
Cell[6509, 235, 218, 6, 36, "Output",
 CellID->29007700]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6776, 247, 218, 7, 70, "ExampleSection",
 CellID->18614],
Cell[CellGroupData[{
Cell[7019, 258, 230, 7, 70, "ExampleSubsection",
 CellID->1295379749],
Cell[7252, 267, 142, 4, 70, "Input",
 CellID->257249923],
Cell[7397, 273, 79, 1, 70, "ExampleText",
 CellID->493427760],
Cell[CellGroupData[{
Cell[7501, 278, 185, 5, 70, "Input",
 CellID->129566985],
Cell[7689, 285, 219, 6, 36, "Output",
 CellID->225225510]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7981, 299, 311, 9, 70, "SeeAlsoSection",
 CellID->27201],
Cell[8295, 310, 500, 17, 70, "SeeAlso",
 CellID->4855]
}, Open  ]],
Cell[CellGroupData[{
Cell[8832, 332, 313, 9, 70, "TutorialsSection",
 CellID->1452],
Cell[9148, 343, 174, 4, 70, "Tutorials",
 CellID->5275]
}, Open  ]],
Cell[9337, 350, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

