(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9035,        316]
NotebookOptionsPosition[      6371,        230]
NotebookOutlinePosition[      7733,        268]
CellTagsIndexPosition[      7649,        263]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"KnownVariance" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/KnownVariance"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"KnownVariance\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EqualVariances", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["EqualVariances"], "InlineFormula"],
     "\[LineSeparator]is an option to statistical confidence interval and \
hypothesis test functions of two samples that specifies that unknown \
population variances are equal."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["EqualVariances"], "InlineFormula"],
 " is an option for confidence interval and hypothesis test functions of two \
lists."
}], "Notes",
 CellID->451329350],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"EqualVariances", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", variances are estimated from the two samples independently if the \
variances are not specified as known."
}], "Notes",
 CellID->3554091],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"EqualVariances", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", a common pooled estimate of the variance is used for both populations if \
the variances are not specified as known."
}], "Notes",
 CellID->24464]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->34464842],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->446453623],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->431739895],

Cell["A test assuming equal variances:", "ExampleText",
 CellID->595116922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDifferenceTest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "10", ",", "6", ",", "8", ",", "5", ",", "8"}], "}"}], 
   ",", "0", ",", 
   RowBox[{"EqualVariances", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->634376418],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.009400844179249194`"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->355978457]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["KnownVariance",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/KnownVariance"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EqualVariances - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 2.5867784}", "context" -> 
    "HypothesisTesting`", "keywords" -> {}, "index" -> True, "label" -> 
    "Hypothesis Testing Package Symbol", "language" -> "en", "paclet" -> 
    "HypothesisTesting Package", "status" -> "None", "summary" -> 
    "EqualVariances is an option to statistical confidence interval and \
hypothesis test functions of two samples that specifies that unknown \
population variances are equal.", "synonyms" -> {}, "title" -> 
    "EqualVariances", "type" -> "Symbol", "uri" -> 
    "HypothesisTesting/ref/EqualVariances"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3805, 131, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->34464842]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7507, 256}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1248, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1871, 60, 57, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[1931, 63, 463, 12, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2431, 80, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2909, 97, 186, 5, 70, "Notes",
 CellID->451329350],
Cell[3098, 104, 340, 10, 70, "Notes",
 CellID->3554091],
Cell[3441, 116, 327, 10, 70, "Notes",
 CellID->24464]
}, Closed]],
Cell[CellGroupData[{
Cell[3805, 131, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->34464842],
Cell[CellGroupData[{
Cell[4189, 145, 148, 5, 70, "ExampleSection",
 CellID->446453623],
Cell[4340, 152, 142, 4, 70, "Input",
 CellID->431739895],
Cell[4485, 158, 75, 1, 70, "ExampleText",
 CellID->595116922],
Cell[CellGroupData[{
Cell[4585, 163, 376, 10, 28, "Input",
 CellID->634376418],
Cell[4964, 175, 220, 6, 36, "Output",
 CellID->355978457]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5245, 188, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[5564, 199, 228, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[5829, 210, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[6150, 221, 179, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[6344, 228, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

