(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12509,        457]
NotebookOptionsPosition[      9346,        351]
NotebookOutlinePosition[     10708,        389]
CellTagsIndexPosition[     10623,        384]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FRatioCI" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/FRatioCI"], 
          "FRatioDistribution" :> 
          Documentation`HelpLookup["paclet:ref/FRatioDistribution"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"FRatioCI\"\>", 
       2->"\<\"FRatioDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FRatioPValue", "ObjectName",
 CellID->4001],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FRatioPValue", "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the cumulative probability beyond ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " for the F-ratio distribution with ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " degrees of freedom."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13485]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The one-sided ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]value is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CDF"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["FRatioDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FRatioDistribution"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " if ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is less than the median of the F\[Hyphen]ratio distribution with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " degrees of freedom, and  ",
 Cell[BoxData[
  RowBox[{"1", "-", 
   RowBox[{
    ButtonBox["CDF",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CDF"], "[", 
    RowBox[{
     RowBox[{
      ButtonBox["FRatioDistribution",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FRatioDistribution"], "[", 
      RowBox[{
       StyleBox["n", "TI"], ",", 
       StyleBox["m", "TI"]}], "]"}], ",", 
     StyleBox["x", "TI"]}], "]"}]}]], "InlineFormula"],
 " otherwise."
}], "Notes",
 CellID->15717],

Cell[TextData[{
 "The two-sided ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]value is twice the one-sided ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]value."
}], "Notes",
 CellID->521369599],

Cell["The following options can be given:", "Notes",
 CellID->22946],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TwoSided",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/TwoSided"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to perform a two-sided test", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->26613]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->252090120],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->551736865],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->78281988],

Cell["\<\
The p\[Hyphen]value for 10 in an F\[Hyphen]ratio distribution with 2 and 5 \
degrees of freedom:\
\>", "ExampleText",
 CellID->11420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FRatioPValue", "[", 
  RowBox[{"10", ",", "2", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32652],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.01788854381999832`"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->346699137]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12197],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TwoSided",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1295379749],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->206174628],

Cell["A two\[Hyphen]sided p\[Hyphen]value:", "ExampleText",
 CellID->493427760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FRatioPValue", "[", 
  RowBox[{"10", ",", "2", ",", "5", ",", 
   RowBox[{"TwoSided", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->129566985],

Cell[BoxData[
 RowBox[{"TwoSidedPValue", "\[Rule]", "0.03577708763999664`"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->307300140]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31119],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FRatioCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/FRatioCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FRatioDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FRatioDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6219]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16696],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->12389]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FRatioPValue - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 2.9930388}", "context" -> 
    "HypothesisTesting`", 
    "keywords" -> {"f statistic", "f test", "p\\[Hyphen]value"}, "index" -> 
    True, "label" -> "Hypothesis Testing Package Symbol", "language" -> "en", 
    "paclet" -> "HypothesisTesting Package", "status" -> "None", "summary" -> 
    "FRatioPValue[x, n, m] gives the cumulative probability beyond x for the \
F-ratio distribution with n and m degrees of freedom.", "synonyms" -> {}, 
    "title" -> "FRatioPValue", "type" -> "Symbol", "uri" -> 
    "HypothesisTesting/ref/FRatioPValue"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5504, 193, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->252090120]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10480, 377}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1367, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1990, 62, 49, 1, 70, "ObjectName",
 CellID->4001],
Cell[2042, 65, 768, 24, 70, "Usage",
 CellID->13485]
}, Open  ]],
Cell[CellGroupData[{
Cell[2847, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3325, 111, 1280, 46, 70, "Notes",
 CellID->15717],
Cell[4608, 159, 243, 9, 70, "Notes",
 CellID->521369599],
Cell[4854, 170, 68, 1, 70, "Notes",
 CellID->22946],
Cell[4925, 173, 542, 15, 70, "3ColumnTableMod",
 CellID->26613]
}, Closed]],
Cell[CellGroupData[{
Cell[5504, 193, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->252090120],
Cell[CellGroupData[{
Cell[5889, 207, 148, 5, 70, "ExampleSection",
 CellID->551736865],
Cell[6040, 214, 141, 4, 70, "Input",
 CellID->78281988],
Cell[6184, 220, 143, 4, 70, "ExampleText",
 CellID->11420],
Cell[CellGroupData[{
Cell[6352, 228, 138, 4, 28, "Input",
 CellID->32652],
Cell[6493, 234, 219, 6, 36, "Output",
 CellID->346699137]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6761, 246, 218, 7, 70, "ExampleSection",
 CellID->12197],
Cell[CellGroupData[{
Cell[7004, 257, 230, 7, 70, "ExampleSubsection",
 CellID->1295379749],
Cell[7237, 266, 142, 4, 70, "Input",
 CellID->206174628],
Cell[7382, 272, 79, 1, 70, "ExampleText",
 CellID->493427760],
Cell[CellGroupData[{
Cell[7486, 277, 192, 5, 70, "Input",
 CellID->129566985],
Cell[7681, 284, 219, 6, 36, "Output",
 CellID->307300140]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7973, 298, 311, 9, 70, "SeeAlsoSection",
 CellID->31119],
Cell[8287, 309, 488, 17, 70, "SeeAlso",
 CellID->6219]
}, Open  ]],
Cell[CellGroupData[{
Cell[8812, 331, 314, 9, 70, "TutorialsSection",
 CellID->16696],
Cell[9129, 342, 175, 4, 70, "Tutorials",
 CellID->12389]
}, Open  ]],
Cell[9319, 349, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

