(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9221,        332]
NotebookOptionsPosition[      6592,        247]
NotebookOutlinePosition[      7924,        284]
CellTagsIndexPosition[      7840,        279]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EqualVariances" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/EqualVariances"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"EqualVariances\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["KnownVariance", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["KnownVariance"], "InlineFormula"],
     "\[LineSeparator]is an option to statistical confidence interval and \
hypothesis test functions that specifies the value of the population \
variance."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The value of ",
 Cell[BoxData["KnownVariance"], "InlineFormula"],
 " can be a positive number or ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6334],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  RowBox[{"KnownVariance", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 ", the population variance is estimated from the input data."
}], "Notes",
 CellID->126299017],

Cell[TextData[{
 "For confidence intervals and tests based on two samples, variances ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["var", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["var", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 " for the two populations can be given as ",
 Cell[BoxData[
  RowBox[{"KnownVariance", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["var", "TI"], 
      StyleBox["1", "TR"]], ",", " ", 
     SubscriptBox[
      StyleBox["var", "TI"], 
      StyleBox["2", "TR"]]}], "}"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->371644481]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->635388072],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->265603132],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->55384907],

Cell["A test assuming the population variance is 5:", "ExampleText",
 CellID->22410113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanTest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", "0", 
   ",", 
   RowBox[{"KnownVariance", "\[Rule]", "5"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5187626],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.0006871379379158485`"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3486311]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["EqualVariances",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/EqualVariances"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"KnownVariance - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 3.4149246}", "context" -> 
    "HypothesisTesting`", "keywords" -> {}, "index" -> True, "label" -> 
    "Hypothesis Testing Package Symbol", "language" -> "en", "paclet" -> 
    "HypothesisTesting Package", "status" -> "None", "summary" -> 
    "KnownVariance is an option to statistical confidence interval and \
hypothesis test functions that specifies the value of the population \
variance.", "synonyms" -> {}, "title" -> "KnownVariance", "type" -> "Symbol", 
    "uri" -> "HypothesisTesting/ref/KnownVariance"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4129, 150, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->635388072]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7697, 272}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1259, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1882, 61, 56, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[1941, 64, 440, 12, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2418, 81, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2896, 98, 261, 10, 70, "Notes",
 CellID->6334],
Cell[3160, 110, 270, 9, 70, "Notes",
 CellID->126299017],
Cell[3433, 121, 659, 24, 70, "Notes",
 CellID->371644481]
}, Closed]],
Cell[CellGroupData[{
Cell[4129, 150, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->635388072],
Cell[CellGroupData[{
Cell[4514, 164, 148, 5, 70, "ExampleSection",
 CellID->265603132],
Cell[4665, 171, 141, 4, 70, "Input",
 CellID->55384907],
Cell[4809, 177, 87, 1, 70, "ExampleText",
 CellID->22410113],
Cell[CellGroupData[{
Cell[4921, 182, 260, 8, 28, "Input",
 CellID->5187626],
Cell[5184, 192, 219, 6, 36, "Output",
 CellID->3486311]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5464, 205, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[5783, 216, 230, 6, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[6050, 227, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[6371, 238, 179, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[6565, 245, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

