(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18393,        669]
NotebookOptionsPosition[     14323,        530]
NotebookOutlinePosition[     15727,        569]
CellTagsIndexPosition[     15642,        564]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StudentTCI" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/StudentTCI"],
           "NormalCI" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/NormalCI"], 
          "MeanCI" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/MeanCI"], 
          "MeanDifferenceTest" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/MeanDifferenceTest"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StudentTCI\"\>", 
       2->"\<\"NormalCI\"\>", 3->"\<\"MeanCI\"\>", 
       4->"\<\"MeanDifferenceTest\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MeanDifferenceCI", "ObjectName",
 CellID->25680],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MeanDifferenceCI", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a confidence interval for the difference between \
the population means estimated from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "TI"], "1"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8976]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"MeanDifferenceCI", "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
 " gives a confidence interval ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["min", "TI"], ",", " ", 
    StyleBox["max", "TI"]}], "}"}]], "InlineFormula"],
 " centered at ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Mean",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mean"], "[", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["1", "TR"]], "]"}], "-", 
   RowBox[{
    ButtonBox["Mean",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mean"], "[", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["2", "TR"]], "]"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24199],

Cell[TextData[{
 Cell[BoxData["MeanDifferenceCI"], "InlineFormula"],
 " is based on a normal distribution if the population variances is assumed \
known."
}], "Notes",
 CellID->198048243],

Cell[TextData[{
 "If the variances for the two populations are assumed equal and unknown, the \
interval is based on Student's ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["1", "TR"]], "]"}], "+", 
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["2", "TR"]], "]"}], "-", "2"}]], "InlineFormula"],
 " degrees of freedom."
}], "Notes",
 CellID->619210961],

Cell["\<\
If the population variances are not assumed known and not assumed equal, \
Welch's approximation for the degrees of freedom is used.\
\>", "Notes",
 CellID->603557951],

Cell["The following options can be given:", "Notes",
 CellID->24808],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ConfidenceLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/ConfidenceLevel"], "0.95", 
    Cell["probability associated with a confidence interval", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["EqualVariances",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/EqualVariances"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether the unknown population variances are assumed equal", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["KnownVariance",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/KnownVariance"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "list of variances of each population", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->13559]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->33466598],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->550742721],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->797293939],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{"95", "%"}]], "InlineFormula"],
 " confidence interval for the difference in two population means:"
}], "ExampleText",
 CellID->19668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDifferenceCI", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "10", ",", "6", ",", "8", ",", "5", ",", "8"}], "}"}]}],
   "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24484],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "6.4671303042475525`"}], ",", 
   RowBox[{"-", "0.7995363624191145`"}]}], "}"}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->343088065]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19097],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ConfidenceLevel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->8880],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->56646988],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{"99", "%"}]], "InlineFormula"],
 " confidence interval:"
}], "ExampleText",
 CellID->770582629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDifferenceCI", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "10", ",", "6", ",", "8", ",", "5", ",", "8"}], "}"}], 
   ",", 
   RowBox[{"ConfidenceLevel", "\[Rule]", ".99"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->859789852],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "7.705653276013022`"}], ",", "0.43898660934635503`"}], 
  "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18238498]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "EqualVariances",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->23335],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->33941511],

Cell["A confidence interval assuming equal but unknown variances:", \
"ExampleText",
 CellID->10632550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDifferenceCI", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "10", ",", "6", ",", "8", ",", "5", ",", "8"}], "}"}], 
   ",", 
   RowBox[{"EqualVariances", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->579860044],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "6.507867894195696`"}], ",", 
   RowBox[{"-", "0.7587987724709699`"}]}], "}"}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26584761]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "KnownVariance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->23400],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->251257117],

Cell["A confidence interval assuming known variances:", "ExampleText",
 CellID->38561345],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDifferenceCI", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "10", ",", "6", ",", "8", ",", "5", ",", "8"}], "}"}], 
   ",", 
   RowBox[{"KnownVariance", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->626436705],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "5.064688648307059`"}], ",", 
   RowBox[{"-", "2.2019780183596076`"}]}], "}"}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->61979350]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22885],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StudentTCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/StudentTCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NormalCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/NormalCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/MeanCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanDifferenceTest",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/MeanDifferenceTest"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21962]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7905],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->10440]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MeanDifferenceCI - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 3.8836866}", "context" -> 
    "HypothesisTesting`", 
    "keywords" -> {"confidence interval", "t test", "two sample t test"}, 
    "index" -> True, "label" -> "Hypothesis Testing Package Symbol", 
    "language" -> "en", "paclet" -> "HypothesisTesting Package", "status" -> 
    "None", "summary" -> 
    "MeanDifferenceCI[list_1, list_2] gives a confidence interval for the \
difference between the population means estimated from list_1 and list_2.", 
    "synonyms" -> {}, "title" -> "MeanDifferenceCI", "type" -> "Symbol", 
    "uri" -> "HypothesisTesting/ref/MeanDifferenceCI"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6963, 234, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->33466598]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15500, 557}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1657, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2280, 68, 54, 1, 70, "ObjectName",
 CellID->25680],
Cell[2337, 71, 861, 28, 70, "Usage",
 CellID->8976]
}, Open  ]],
Cell[CellGroupData[{
Cell[3235, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3713, 121, 904, 35, 70, "Notes",
 CellID->24199],
Cell[4620, 158, 187, 5, 70, "Notes",
 CellID->198048243],
Cell[4810, 165, 704, 24, 70, "Notes",
 CellID->619210961],
Cell[5517, 191, 177, 4, 70, "Notes",
 CellID->603557951],
Cell[5697, 197, 68, 1, 70, "Notes",
 CellID->24808],
Cell[5768, 200, 1158, 29, 70, "3ColumnTableMod",
 CellID->13559]
}, Closed]],
Cell[CellGroupData[{
Cell[6963, 234, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->33466598],
Cell[CellGroupData[{
Cell[7347, 248, 148, 5, 70, "ExampleSection",
 CellID->550742721],
Cell[7498, 255, 142, 4, 70, "Input",
 CellID->797293939],
Cell[7643, 261, 184, 6, 70, "ExampleText",
 CellID->19668],
Cell[CellGroupData[{
Cell[7852, 271, 303, 9, 28, "Input",
 CellID->24484],
Cell[8158, 282, 278, 9, 36, "Output",
 CellID->343088065]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8485, 297, 218, 7, 70, "ExampleSection",
 CellID->19097],
Cell[CellGroupData[{
Cell[8728, 308, 231, 7, 70, "ExampleSubsection",
 CellID->8880],
Cell[8962, 317, 141, 4, 70, "Input",
 CellID->56646988],
Cell[9106, 323, 145, 6, 70, "ExampleText",
 CellID->770582629],
Cell[CellGroupData[{
Cell[9276, 333, 364, 10, 70, "Input",
 CellID->859789852],
Cell[9643, 345, 261, 9, 36, "Output",
 CellID->18238498]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9953, 360, 231, 7, 70, "ExampleSubsection",
 CellID->23335],
Cell[10187, 369, 141, 4, 70, "Input",
 CellID->33941511],
Cell[10331, 375, 103, 2, 70, "ExampleText",
 CellID->10632550],
Cell[CellGroupData[{
Cell[10459, 381, 364, 10, 70, "Input",
 CellID->579860044],
Cell[10826, 393, 276, 9, 36, "Output",
 CellID->26584761]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11151, 408, 230, 7, 70, "ExampleSubsection",
 CellID->23400],
Cell[11384, 417, 142, 4, 70, "Input",
 CellID->251257117],
Cell[11529, 423, 89, 1, 70, "ExampleText",
 CellID->38561345],
Cell[CellGroupData[{
Cell[11643, 428, 411, 12, 70, "Input",
 CellID->626436705],
Cell[12057, 442, 276, 9, 36, "Output",
 CellID->61979350]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12406, 459, 311, 9, 70, "SeeAlsoSection",
 CellID->22885],
Cell[12720, 470, 1033, 35, 70, "SeeAlso",
 CellID->21962]
}, Open  ]],
Cell[CellGroupData[{
Cell[13790, 510, 313, 9, 70, "TutorialsSection",
 CellID->7905],
Cell[14106, 521, 175, 4, 70, "Tutorials",
 CellID->10440]
}, Open  ]],
Cell[14296, 528, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

