(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23428,        834]
NotebookOptionsPosition[     18364,        658]
NotebookOutlinePosition[     19966,        704]
CellTagsIndexPosition[     19855,        698]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StudentTCI" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/StudentTCI"],
           "MeanCI" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/MeanCI"], 
          "MeanDifferenceCI" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/MeanDifferenceCI"], "MeanTest" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/MeanTest"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"StudentTCI\"\>", 2->"\<\"MeanCI\"\>", 
       3->"\<\"MeanDifferenceCI\"\>", 
       4->"\<\"MeanTest\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MeanDifferenceTest", "ObjectName",
 CellID->31375],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MeanDifferenceTest", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["\[CapitalDelta]\[Mu]", "TR"], 
         StyleBox["0", "TR"]]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]performs a test with null hypothesis ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        SubscriptBox[
         StyleBox["\[Mu]", "TR"], "1"], "-", 
        SubscriptBox["\[Mu]", "2"]}], "=", 
       SubscriptBox["\[CapitalDelta]\[Mu]", 
        StyleBox["0", "TR"]]}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21163]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"MeanDifferenceTest", "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["2", "TR"]], ",", " ", 
    SubscriptBox[
     StyleBox["\[CapitalDelta]\[Mu]", "TR"], 
     StyleBox["0", "TR"]]}], "]"}]], "InlineFormula"],
 " gives a ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]value for the test that the difference between the means ",
 Cell[BoxData[
  SubscriptBox["\[Mu]", "1"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox["\[Mu]", "2"]], "InlineFormula"],
 " of the populations from which ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 " were sampled is significantly different from ",
 Cell[BoxData[
  SubscriptBox["\[CapitalDelta]\[Mu]", "0"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24199],

Cell[TextData[{
 Cell[BoxData["MeanDifferenceTest"], "InlineFormula"],
 " is based on a normal distribution if the population variances are assumed \
known."
}], "Notes",
 CellID->86859086],

Cell[TextData[{
 "If the variances for the two populations are assumed equal and unknown, the \
test is based on Student's ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["1", "TR"]], "]"}], "+", 
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["2", "TR"]], "]"}], "-", "2"}]], "InlineFormula"],
 " degrees of freedom."
}], "Notes",
 CellID->619210961],

Cell["\<\
If the population variances are not assumed known and not assumed equal, \
Welch's approximation for the degrees of freedom is used.\
\>", "Notes",
 CellID->225001856],

Cell["The following options can be given:", "Notes",
 CellID->27930],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["EqualVariances",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/EqualVariances"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether the unknown population variances are assumed equal", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FullReport",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/FullReport"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to include detailed information about a test", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["KnownVariance",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/KnownVariance"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "variance of population", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SignificanceLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/SignificanceLevel"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "significance level of the test", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TwoSided",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/TwoSided"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to perform a two-sided test", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->24628]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->154088306],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->319982628],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->40673798],

Cell["A test of the difference of population means against 0:", "ExampleText",
 CellID->28864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDifferenceTest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "10", ",", "6", ",", "8", ",", "5", ",", "8"}], "}"}], 
   ",", "0"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24484],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.008799971730415707`"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->413660043]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7658],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "EqualVariances",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->12999],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->63196234],

Cell["A test assuming equal variances:", "ExampleText",
 CellID->595116922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDifferenceTest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "10", ",", "6", ",", "8", ",", "5", ",", "8"}], "}"}], 
   ",", "0", ",", 
   RowBox[{"EqualVariances", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->634376418],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.009400844179249194`"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->355978457]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FullReport",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->7478],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->31029182],

Cell["A full report for a mean difference test:", "ExampleText",
 CellID->238475917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDifferenceTest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "10", ",", "6", ",", "8", ",", "5", ",", "8"}], "}"}], 
   ",", "0", ",", 
   RowBox[{"FullReport", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->99892941],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FullReport", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         TagBox["\<\"MeanDiff\"\>",
          HoldForm], 
         TagBox["\<\"TestStat\"\>",
          HoldForm], 
         TagBox["\<\"Distribution\"\>",
          HoldForm]},
        {
         RowBox[{"-", "3.6333333333333333`"}], 
         RowBox[{"-", "2.9017700309542613`"}], 
         RowBox[{"StudentTDistribution", "[", 
          FractionBox["1990921", "221894"], "]"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {None, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, 
       TableHeadings -> {None, {"MeanDiff", "TestStat", "Distribution"}}]]]}],
    ",", 
   RowBox[{"OneSidedPValue", "\[Rule]", "0.008799971730415707`"}]}], 
  "}"}]], "Output",
 ImageSize->{434, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->195035317]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "KnownVariance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->29610],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->154493248],

Cell["A test assuming the population variances are 1 and 3:", "ExampleText",
 CellID->22410113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDifferenceTest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "10", ",", "6", ",", "8", ",", "5", ",", "8"}], "}"}], 
   ",", "0", ",", 
   RowBox[{"KnownVariance", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5187626],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "7.038268371071779`*^-6"}]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->666043503]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "SignificanceLevel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->30642],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->549958048],

Cell["A test at significance level .01:", "ExampleText",
 CellID->493427760],

Cell[CellGroupData[{

Cell["\<\
MeanDifferenceTest[{1,2,4,6,3},{4,10,6,8,5,8},0,SignificanceLevel->.01]\
\>", "Input",
 CellTags->"S5.96.1",
 CellLabel->"In[2]:=",
 CellID->482226228],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"OneSidedPValue", "\[Rule]", "0.008799971730415707`"}], ",", 
   RowBox[{"\<\"Reject null hypothesis at significance level\"\>", "\[Rule]", 
    "0.01`"}]}], "}"}]], "Output",
 ImageSize->{566, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S5.96.1",
 CellLabel->"Out[2]=",
 CellID->67197414]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TwoSided",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->29995],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->427078954],

Cell["\<\
A two\[Hyphen]sided mean difference test:\
\>", "ExampleText",
 CellID->384802285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDifferenceTest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "10", ",", "6", ",", "8", ",", "5", ",", "8"}], "}"}], 
   ",", "0", ",", 
   RowBox[{"TwoSided", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->357402744],

Cell[BoxData[
 RowBox[{"TwoSidedPValue", "\[Rule]", "0.017599943460831415`"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->49104688]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3771],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StudentTCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/StudentTCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/MeanCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanDifferenceCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/MeanDifferenceCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanTest",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/MeanTest"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12793]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21985],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->31990]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MeanDifferenceTest - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 4.1493184}", "context" -> 
    "HypothesisTesting`", "keywords" -> {"t test", "two sample t test"}, 
    "index" -> True, "label" -> "Hypothesis Testing Package Symbol", 
    "language" -> "en", "paclet" -> "HypothesisTesting Package", "status" -> 
    "None", "summary" -> 
    "MeanDifferenceTest[list_1, list_2, \\[CapitalDelta]\\[Mu]_0] performs a \
test with null hypothesis \\[Mu]_1 - \\[Mu]_2 = \\[CapitalDelta]\\[Mu]_0.", 
    "synonyms" -> {}, "title" -> "MeanDifferenceTest", "type" -> "Symbol", 
    "uri" -> "HypothesisTesting/ref/MeanDifferenceTest"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7888, 257, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->154088306]},
 "S5.96.1"->{
  Cell[14705, 515, 161, 5, 70, "Input",
   CellTags->"S5.96.1",
   CellID->482226228],
  Cell[14869, 522, 378, 11, 36, "Output",
   CellTags->"S5.96.1",
   CellID->67197414]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19522, 684},
 {"S5.96.1", 19656, 688}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1652, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2275, 68, 56, 1, 70, "ObjectName",
 CellID->31375],
Cell[2334, 71, 948, 30, 70, "Usage",
 CellID->21163]
}, Open  ]],
Cell[CellGroupData[{
Cell[3319, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3797, 123, 1063, 37, 70, "Notes",
 CellID->24199],
Cell[4863, 162, 189, 5, 70, "Notes",
 CellID->86859086],
Cell[5055, 169, 700, 24, 70, "Notes",
 CellID->619210961],
Cell[5758, 195, 177, 4, 70, "Notes",
 CellID->225001856],
Cell[5938, 201, 68, 1, 70, "Notes",
 CellID->27930],
Cell[6009, 204, 1842, 48, 70, "3ColumnTableMod",
 CellID->24628]
}, Closed]],
Cell[CellGroupData[{
Cell[7888, 257, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->154088306],
Cell[CellGroupData[{
Cell[8273, 271, 148, 5, 70, "ExampleSection",
 CellID->319982628],
Cell[8424, 278, 141, 4, 70, "Input",
 CellID->40673798],
Cell[8568, 284, 94, 1, 70, "ExampleText",
 CellID->28864],
Cell[CellGroupData[{
Cell[8687, 289, 316, 9, 28, "Input",
 CellID->24484],
Cell[9006, 300, 220, 6, 36, "Output",
 CellID->413660043]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9275, 312, 217, 7, 70, "ExampleSection",
 CellID->7658],
Cell[CellGroupData[{
Cell[9517, 323, 231, 7, 70, "ExampleSubsection",
 CellID->12999],
Cell[9751, 332, 141, 4, 70, "Input",
 CellID->63196234],
Cell[9895, 338, 75, 1, 70, "ExampleText",
 CellID->595116922],
Cell[CellGroupData[{
Cell[9995, 343, 376, 10, 70, "Input",
 CellID->634376418],
Cell[10374, 355, 220, 6, 36, "Output",
 CellID->355978457]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10643, 367, 226, 7, 70, "ExampleSubsection",
 CellID->7478],
Cell[10872, 376, 141, 4, 70, "Input",
 CellID->31029182],
Cell[11016, 382, 84, 1, 70, "ExampleText",
 CellID->238475917],
Cell[CellGroupData[{
Cell[11125, 387, 371, 10, 70, "Input",
 CellID->99892941],
Cell[11499, 399, 1482, 44, 81, "Output",
 CellID->195035317]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13030, 449, 230, 7, 70, "ExampleSubsection",
 CellID->29610],
Cell[13263, 458, 142, 4, 70, "Input",
 CellID->154493248],
Cell[13408, 464, 95, 1, 70, "ExampleText",
 CellID->22410113],
Cell[CellGroupData[{
Cell[13528, 469, 421, 12, 70, "Input",
 CellID->5187626],
Cell[13952, 483, 221, 6, 36, "Output",
 CellID->666043503]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14222, 495, 234, 7, 70, "ExampleSubsection",
 CellID->30642],
Cell[14459, 504, 142, 4, 70, "Input",
 CellID->549958048],
Cell[14604, 510, 76, 1, 70, "ExampleText",
 CellID->493427760],
Cell[CellGroupData[{
Cell[14705, 515, 161, 5, 70, "Input",
 CellTags->"S5.96.1",
 CellID->482226228],
Cell[14869, 522, 378, 11, 36, "Output",
 CellTags->"S5.96.1",
 CellID->67197414]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15296, 539, 225, 7, 70, "ExampleSubsection",
 CellID->29995],
Cell[15524, 548, 142, 4, 70, "Input",
 CellID->427078954],
Cell[15669, 554, 92, 3, 70, "ExampleText",
 CellID->384802285],
Cell[CellGroupData[{
Cell[15786, 561, 370, 10, 70, "Input",
 CellID->357402744],
Cell[16159, 573, 219, 6, 36, "Output",
 CellID->49104688]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16451, 587, 310, 9, 70, "SeeAlsoSection",
 CellID->3771],
Cell[16764, 598, 1029, 35, 70, "SeeAlso",
 CellID->12793]
}, Open  ]],
Cell[CellGroupData[{
Cell[17830, 638, 314, 9, 70, "TutorialsSection",
 CellID->21985],
Cell[18147, 649, 175, 4, 70, "Tutorials",
 CellID->31990]
}, Open  ]],
Cell[18337, 656, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

