(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13119,        467]
NotebookOptionsPosition[     10020,        362]
NotebookOutlinePosition[     11316,        399]
CellTagsIndexPosition[     11231,        394]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MeanCI" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/MeanCI"], 
          "MeanTest" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/MeanTest"], 
          "MeanDifferenceCI" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/MeanDifferenceCI"], "StudentTCI" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/StudentTCI"],
           "NormalPValue" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/NormalPValue"], "NormalDistribution" :> 
          Documentation`HelpLookup["paclet:ref/NormalDistribution"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"MeanCI\"\>", 2->"\<\"MeanTest\"\>",
        3->"\<\"MeanDifferenceCI\"\>", 4->"\<\"StudentTCI\"\>", 
       5->"\<\"NormalPValue\"\>", 
       6->"\<\"NormalDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NormalCI", "ObjectName",
 CellID->22640],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NormalCI", "[", 
       RowBox[{
        StyleBox["\[Mu]", "TR"], ",", 
        StyleBox["\[Sigma]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a confidence interval based on a normal \
distribution."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21979]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"NormalCI", "[", 
   RowBox[{"\[Mu]", ",", " ", "\[Sigma]"}], "]"}]], "InlineFormula"],
 " gives a confidence interval ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["min", "TI"], ",", " ", 
    StyleBox["max", "TI"]}], "}"}]], "InlineFormula"],
 " centered at ",
 Cell[BoxData[
  StyleBox["\[Mu]", "TR"]], "InlineFormula"],
 " based on a normal distribution with mean ",
 Cell[BoxData[
  StyleBox["\[Mu]", "TR"]], "InlineFormula"],
 " and standard deviation ",
 Cell[BoxData[
  StyleBox["\[Sigma]", "TR"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24199],

Cell[TextData[{
 Cell[BoxData["NormalCI"], "InlineFormula"],
 " is the confidence interval for a population mean based on a sample mean ",
 Cell[BoxData[
  StyleBox["\[Mu]", "TR"]], "InlineFormula"],
 " if the true population variance is known."
}], "Notes",
 CellID->198048243],

Cell["The following option can be given:", "Notes",
 CellID->24791],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ConfidenceLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/ConfidenceLevel"], "0.95", 
    Cell["probability associated with a confidence interval", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->18661]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->210831620],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->671453056],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->4389482],

Cell["A 95% confidence interval based on the normal distribution:", \
"ExampleText",
 CellID->11420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NormalCI", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->176484641],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2.9199279690801077`"}], ",", "4.919927969080108`"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->104133544]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24326],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ConfidenceLevel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1295379749],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->68465085],

Cell["A 99% confidence interval:", "ExampleText",
 CellID->493427760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NormalCI", "[", 
  RowBox[{"1", ",", "2", ",", 
   RowBox[{"ConfidenceLevel", "\[Rule]", ".99"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->129566985],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4.151658607097801`"}], ",", "6.151658607097801`"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->734081199]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32029],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/MeanCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanTest",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/MeanTest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanDifferenceCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/MeanDifferenceCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StudentTCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/StudentTCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NormalPValue",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/NormalPValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NormalDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NormalDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15987]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8681],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->3652]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NormalCI - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 10.6494848}", "context" -> 
    "HypothesisTesting`", "keywords" -> {"confidence interval", "z test"}, 
    "index" -> True, "label" -> "Hypothesis Testing Package Symbol", 
    "language" -> "en", "paclet" -> "HypothesisTesting Package", "status" -> 
    "None", "summary" -> 
    "NormalCI[\\[Mu], \\[Sigma]] gives a confidence interval based on a \
normal distribution.", "synonyms" -> {}, "title" -> "NormalCI", "type" -> 
    "Symbol", "uri" -> "HypothesisTesting/ref/NormalCI"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5088, 164, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->210831620]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11088, 387}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1925, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2548, 72, 46, 1, 70, "ObjectName",
 CellID->22640],
Cell[2597, 75, 480, 15, 70, "Usage",
 CellID->21979]
}, Open  ]],
Cell[CellGroupData[{
Cell[3114, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3592, 112, 613, 21, 70, "Notes",
 CellID->24199],
Cell[4208, 135, 278, 7, 70, "Notes",
 CellID->198048243],
Cell[4489, 144, 67, 1, 70, "Notes",
 CellID->24791],
Cell[4559, 147, 492, 12, 70, "3ColumnTableMod",
 CellID->18661]
}, Closed]],
Cell[CellGroupData[{
Cell[5088, 164, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->210831620],
Cell[CellGroupData[{
Cell[5473, 178, 148, 5, 70, "ExampleSection",
 CellID->671453056],
Cell[5624, 185, 140, 4, 70, "Input",
 CellID->4389482],
Cell[5767, 191, 100, 2, 70, "ExampleText",
 CellID->11420],
Cell[CellGroupData[{
Cell[5892, 197, 127, 4, 28, "Input",
 CellID->176484641],
Cell[6022, 203, 261, 9, 36, "Output",
 CellID->104133544]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6332, 218, 218, 7, 70, "ExampleSection",
 CellID->24326],
Cell[CellGroupData[{
Cell[6575, 229, 237, 7, 70, "ExampleSubsection",
 CellID->1295379749],
Cell[6815, 238, 141, 4, 70, "Input",
 CellID->68465085],
Cell[6959, 244, 69, 1, 70, "ExampleText",
 CellID->493427760],
Cell[CellGroupData[{
Cell[7053, 249, 183, 5, 70, "Input",
 CellID->129566985],
Cell[7239, 256, 260, 9, 36, "Output",
 CellID->734081199]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7572, 273, 311, 9, 70, "SeeAlsoSection",
 CellID->32029],
Cell[7886, 284, 1565, 53, 70, "SeeAlso",
 CellID->15987]
}, Open  ]],
Cell[CellGroupData[{
Cell[9488, 342, 313, 9, 70, "TutorialsSection",
 CellID->8681],
Cell[9804, 353, 174, 4, 70, "Tutorials",
 CellID->3652]
}, Open  ]],
Cell[9993, 360, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

