(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9499,        339]
NotebookOptionsPosition[      6553,        241]
NotebookOutlinePosition[      8185,        289]
CellTagsIndexPosition[      8076,        283]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ConfidenceLevel" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/ConfidenceLevel"], "TwoSided" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/TwoSided"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ConfidenceLevel\"\>", 
       2->"\<\"TwoSided\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SignificanceLevel", "ObjectName",
 CellID->24727],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["SignificanceLevel"], "InlineFormula"],
     "\[LineSeparator]is an option to hypothesis test functions that \
specifies the significance level for the test."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25868]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The significance level for a test is probability of rejecting the null \
hypothesis when it is in fact true.\
\>", "Notes",
 CellID->29555],

Cell[TextData[{
 "The value of ",
 Cell[BoxData["SignificanceLevel"], "InlineFormula"],
 " can be any number between 0 and 1 or ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ". The default setting is ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9135],

Cell[TextData[{
 "If ",
 Cell[BoxData["SignificanceLevel"], "InlineFormula"],
 " is a number, the output contains a statement of whether the hypothesis is \
accepted or rejected."
}], "Notes",
 CellID->53313425]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13144970],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->166155951],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->159521064],

Cell["A mean test at significance level .01:", "ExampleText",
 CellID->493427760],

Cell[CellGroupData[{

Cell["MeanTest[{1,2,4,6,3},0,SignificanceLevel->.01]", "Input",
 CellTags->"S5.96.1",
 CellLabel->"In[2]:=",
 CellID->482226228],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"OneSidedPValue", "\[Rule]", "0.010237937210455338`"}], ",", 
   RowBox[{"\<\"Fail to reject null hypothesis at significance level\"\>", 
    "\[Rule]", "0.01`"}]}], "}"}]], "Output",
 ImageSize->{426, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S5.96.1",
 CellLabel->"Out[2]=",
 CellID->14261893]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23396],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConfidenceLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/ConfidenceLevel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TwoSided",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/TwoSided"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29323]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7905],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->21289]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SignificanceLevel - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 11.2901262}", "context" -> 
    "HypothesisTesting`", 
    "keywords" -> {
     "significance level", "confidence level", "confidence interval", 
      "coverage probability"}, "index" -> True, "label" -> 
    "Hypothesis Testing Package Symbol", "language" -> "en", "paclet" -> 
    "HypothesisTesting Package", "status" -> "None", "summary" -> 
    "SignificanceLevel is an option to hypothesis test functions that \
specifies the significance level for the test.", "synonyms" -> {}, "title" -> 
    "SignificanceLevel", "type" -> "Symbol", "uri" -> 
    "HypothesisTesting/ref/SignificanceLevel"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3804, 133, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->13144970]},
 "S5.96.1"->{
  Cell[4590, 165, 128, 3, 28, "Input",
   CellTags->"S5.96.1",
   CellID->482226228],
  Cell[4721, 170, 386, 11, 54, "Output",
   CellTags->"S5.96.1",
   CellID->14261893]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7746, 269},
 {"S5.96.1", 7879, 273}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1389, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2012, 63, 55, 1, 70, "ObjectName",
 CellID->24727],
Cell[2070, 66, 401, 11, 70, "Usage",
 CellID->25868]
}, Open  ]],
Cell[CellGroupData[{
Cell[2508, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2986, 99, 149, 4, 70, "Notes",
 CellID->29555],
Cell[3138, 105, 415, 15, 70, "Notes",
 CellID->9135],
Cell[3556, 122, 211, 6, 70, "Notes",
 CellID->53313425]
}, Closed]],
Cell[CellGroupData[{
Cell[3804, 133, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13144970],
Cell[CellGroupData[{
Cell[4188, 147, 148, 5, 70, "ExampleSection",
 CellID->166155951],
Cell[4339, 154, 142, 4, 70, "Input",
 CellID->159521064],
Cell[4484, 160, 81, 1, 70, "ExampleText",
 CellID->493427760],
Cell[CellGroupData[{
Cell[4590, 165, 128, 3, 28, "Input",
 CellTags->"S5.96.1",
 CellID->482226228],
Cell[4721, 170, 386, 11, 54, "Output",
 CellTags->"S5.96.1",
 CellID->14261893]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5168, 188, 311, 9, 70, "SeeAlsoSection",
 CellID->23396],
Cell[5482, 199, 501, 17, 70, "SeeAlso",
 CellID->29323]
}, Open  ]],
Cell[CellGroupData[{
Cell[6020, 221, 313, 9, 70, "TutorialsSection",
 CellID->7905],
Cell[6336, 232, 175, 4, 70, "Tutorials",
 CellID->21289]
}, Open  ]],
Cell[6526, 239, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

