(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14080,        495]
NotebookOptionsPosition[     10931,        389]
NotebookOutlinePosition[     12274,        427]
CellTagsIndexPosition[     12189,        422]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MeanCI" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/MeanCI"], 
          "MeanTest" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/MeanTest"], 
          "MeanDifferenceCI" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/MeanDifferenceCI"], 
          "MeanDifferenceTest" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/MeanDifferenceTest"], "NormalCI" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/NormalCI"], 
          "StudentTPValue" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/StudentTPValue"], 
          "StudentTDistribution" :> 
          Documentation`HelpLookup["paclet:ref/StudentTDistribution"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"MeanCI\"\>", 
       2->"\<\"MeanTest\"\>", 3->"\<\"MeanDifferenceCI\"\>", 
       4->"\<\"MeanDifferenceTest\"\>", 5->"\<\"NormalCI\"\>", 
       6->"\<\"StudentTPValue\"\>", 
       7->"\<\"StudentTDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StudentTCI", "ObjectName",
 CellID->3134],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"StudentTCI", "[", 
       RowBox[{
        StyleBox["\[Mu]", "TR"], ",", 
        StyleBox["\[Sigma]", "TR"], ",", 
        StyleBox["df", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a confidence interval based on Student's ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " distribution with ",
     Cell[BoxData[
      StyleBox["df", "TI"]], "InlineFormula"],
     " degrees of freedom."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32671]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"StudentTCI", "[", 
   RowBox[{
    StyleBox["\[Mu]", "TR"], ",", " ", 
    StyleBox["\[Sigma]", "TR"], ",", " ", 
    StyleBox["df", "TI"]}], "]"}]], "InlineFormula"],
 " gives a confidence interval ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["min", "TI"], ",", " ", 
    StyleBox["max", "TI"]}], "}"}]], "InlineFormula"],
 " for the population mean based on the sample mean ",
 Cell[BoxData[
  StyleBox["\[Mu]", "TR"]], "InlineFormula"],
 " and sample standard deviation ",
 Cell[BoxData[
  StyleBox["\[Sigma]", "TR"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24199],

Cell[TextData[{
 Cell[BoxData["StudentTCI"], "InlineFormula"],
 " is the confidence interval for a population mean based on a mean \[Mu] and \
standard deviation \[Sigma] estimated from a sample of size ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["df", "TI"], "+", "1"}], TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->198048243],

Cell["The following option can be given:", "Notes",
 CellID->3545],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ConfidenceLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/ConfidenceLevel"], "0.95", 
    Cell["probability associated with a confidence interval", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->13597]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->331869198],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->25969233],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->412175652],

Cell[TextData[{
 "A 95% confidence interval based on Student's ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution with 10 degrees of freedom:"
}], "ExampleText",
 CellID->11420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StudentTCI", "[", 
  RowBox[{"1", ",", "2", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->176484641],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3.456277703972547`"}], ",", "5.456277703972547`"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5861665]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18610],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ConfidenceLevel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1295379749],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->162402018],

Cell["A 99% confidence interval:", "ExampleText",
 CellID->493427760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StudentTCI", "[", 
  RowBox[{"1", ",", "2", ",", "10", ",", 
   RowBox[{"ConfidenceLevel", "\[Rule]", ".99"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->129566985],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "5.338545345233912`"}], ",", "7.338545345233912`"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->339697039]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8563],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/MeanCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanTest",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/MeanTest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanDifferenceCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/MeanDifferenceCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanDifferenceTest",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/MeanDifferenceTest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NormalCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/NormalCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StudentTPValue",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/StudentTPValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StudentTDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StudentTDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21028]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14218],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->8838]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StudentTCI - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 11.5088818}", "context" -> 
    "HypothesisTesting`", "keywords" -> {"confidence interval", "t test"}, 
    "index" -> True, "label" -> "Hypothesis Testing Package Symbol", 
    "language" -> "en", "paclet" -> "HypothesisTesting Package", "status" -> 
    "None", "summary" -> 
    "StudentTCI[\\[Mu], \\[Sigma], df] gives a confidence interval based on \
Student's t distribution with df degrees of freedom.", "synonyms" -> {}, 
    "title" -> "StudentTCI", "type" -> "Symbol", "uri" -> 
    "HypothesisTesting/ref/StudentTCI"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5585, 178, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->331869198]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12046, 415}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2119, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2742, 77, 47, 1, 70, "ObjectName",
 CellID->3134],
Cell[2792, 80, 691, 21, 70, "Usage",
 CellID->32671]
}, Open  ]],
Cell[CellGroupData[{
Cell[3520, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3998, 123, 630, 21, 70, "Notes",
 CellID->24199],
Cell[4631, 146, 353, 10, 70, "Notes",
 CellID->198048243],
Cell[4987, 158, 66, 1, 70, "Notes",
 CellID->3545],
Cell[5056, 161, 492, 12, 70, "3ColumnTableMod",
 CellID->13597]
}, Closed]],
Cell[CellGroupData[{
Cell[5585, 178, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->331869198],
Cell[CellGroupData[{
Cell[5970, 192, 147, 5, 70, "ExampleSection",
 CellID->25969233],
Cell[6120, 199, 142, 4, 70, "Input",
 CellID->412175652],
Cell[6265, 205, 202, 6, 70, "ExampleText",
 CellID->11420],
Cell[CellGroupData[{
Cell[6492, 215, 140, 4, 28, "Input",
 CellID->176484641],
Cell[6635, 221, 258, 9, 36, "Output",
 CellID->5861665]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6942, 236, 218, 7, 70, "ExampleSection",
 CellID->18610],
Cell[CellGroupData[{
Cell[7185, 247, 237, 7, 70, "ExampleSubsection",
 CellID->1295379749],
Cell[7425, 256, 142, 4, 70, "Input",
 CellID->162402018],
Cell[7570, 262, 69, 1, 70, "ExampleText",
 CellID->493427760],
Cell[CellGroupData[{
Cell[7664, 267, 196, 5, 70, "Input",
 CellID->129566985],
Cell[7863, 274, 260, 9, 36, "Output",
 CellID->339697039]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8196, 291, 310, 9, 70, "SeeAlsoSection",
 CellID->8563],
Cell[8509, 302, 1852, 62, 70, "SeeAlso",
 CellID->21028]
}, Open  ]],
Cell[CellGroupData[{
Cell[10398, 369, 314, 9, 70, "TutorialsSection",
 CellID->14218],
Cell[10715, 380, 174, 4, 70, "Tutorials",
 CellID->8838]
}, Open  ]],
Cell[10904, 387, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

