(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8903,        322]
NotebookOptionsPosition[      6208,        232]
NotebookOutlinePosition[      7706,        276]
CellTagsIndexPosition[      7597,        270]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TwoSided" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/TwoSided"], 
          "OneSidedPValue" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/OneSidedPValue"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TwoSided\"\>", 
       2->"\<\"OneSidedPValue\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TwoSidedPValue", "ObjectName",
 CellID->4413],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["TwoSidedPValue"], "InlineFormula"],
     " \[LineSeparator]is an element in hypothesis test output for two\
\[Hyphen]sided tests."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28796]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In hypothesis test functions, if ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TwoSided",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/TwoSided"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]value ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " for the test is returned as the rule ",
 Cell[BoxData[
  RowBox[{"TwoSidedPValue", "->", 
   StyleBox["p", "TI"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->251368302]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->635664318],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->30881996],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->421234132],

Cell["\<\
The p\[Hyphen]value for a two\[Hyphen]sided test:\
\>", "ExampleText",
 CellID->11420],

Cell[CellGroupData[{

Cell["MeanTest[{1,2,4,6,3}, 0, TwoSided->True]", "Input",
 CellTags->"S5.96.1",
 CellLabel->"In[2]:=",
 CellID->8217],

Cell[BoxData[
 RowBox[{"TwoSidedPValue", "\[Rule]", "0.020475874420910676`"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S5.96.1",
 CellLabel->"Out[2]=",
 CellID->612102972]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27829],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TwoSided",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/TwoSided"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OneSidedPValue",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/OneSidedPValue"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9726],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->25065]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TwoSidedPValue - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 12.1182724}", "context" -> 
    "HypothesisTesting`", "keywords" -> {"two\\[Hyphen]sided test"}, "index" -> 
    True, "label" -> "Hypothesis Testing Package Symbol", "language" -> "en", 
    "paclet" -> "HypothesisTesting Package", "status" -> "None", "summary" -> 
    "TwoSidedPValue is an element in hypothesis test output for two-sided \
tests.", "synonyms" -> {}, "title" -> "TwoSidedPValue", "type" -> "Symbol", 
    "uri" -> "HypothesisTesting/ref/TwoSidedPValue"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3602, 126, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->635664318]},
 "S5.96.1"->{
  Cell[4403, 160, 117, 3, 28, "Input",
   CellTags->"S5.96.1",
   CellID->8217],
  Cell[4523, 165, 242, 7, 36, "Output",
   CellTags->"S5.96.1",
   CellID->612102972]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7271, 256},
 {"S5.96.1", 7405, 260}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1385, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2008, 63, 51, 1, 70, "ObjectName",
 CellID->4413],
Cell[2062, 66, 374, 11, 70, "Usage",
 CellID->28796]
}, Open  ]],
Cell[CellGroupData[{
Cell[2473, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2951, 99, 614, 22, 70, "Notes",
 CellID->251368302]
}, Closed]],
Cell[CellGroupData[{
Cell[3602, 126, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->635664318],
Cell[CellGroupData[{
Cell[3987, 140, 147, 5, 70, "ExampleSection",
 CellID->30881996],
Cell[4137, 147, 142, 4, 70, "Input",
 CellID->421234132],
Cell[4282, 153, 96, 3, 70, "ExampleText",
 CellID->11420],
Cell[CellGroupData[{
Cell[4403, 160, 117, 3, 28, "Input",
 CellTags->"S5.96.1",
 CellID->8217],
Cell[4523, 165, 242, 7, 36, "Output",
 CellTags->"S5.96.1",
 CellID->612102972]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4826, 179, 311, 9, 70, "SeeAlsoSection",
 CellID->27829],
Cell[5140, 190, 498, 17, 70, "SeeAlso",
 CellID->5256]
}, Open  ]],
Cell[CellGroupData[{
Cell[5675, 212, 313, 9, 70, "TutorialsSection",
 CellID->9726],
Cell[5991, 223, 175, 4, 70, "Tutorials",
 CellID->25065]
}, Open  ]],
Cell[6181, 230, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

