(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13882,        508]
NotebookOptionsPosition[     10505,        393]
NotebookOutlinePosition[     12034,        438]
CellTagsIndexPosition[     11923,        432]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ChiSquareCI" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/ChiSquareCI"], "VarianceTest" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/VarianceTest"], "VarianceRatioCI" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/VarianceRatioCI"], 
          "VarianceRatioTest" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/VarianceRatioTest"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ChiSquareCI\"\>", 
       2->"\<\"VarianceTest\"\>", 3->"\<\"VarianceRatioCI\"\>", 
       4->"\<\"VarianceRatioTest\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["VarianceCI", "ObjectName",
 CellID->29445],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VarianceCI", "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a confidence interval for the population variance \
estimated from ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18805]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"VarianceCI", "[", "list", "]"}]], "InlineFormula"],
 " gives a confidence interval ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["min", "TI"], ",", " ", 
    StyleBox["max", "TI"]}], "}"}]], "InlineFormula"],
 " for the population variance estimated from ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->129549755],

Cell[TextData[{
 "For confidence level \[Alpha], ",
 Cell[BoxData[
  RowBox[{
   StyleBox["min", "TI"], "=", 
   RowBox[{
    StyleBox["var", "TI"], " ", 
    RowBox[{
     StyleBox["df", "TI"], "/", 
     SubscriptBox[
      StyleBox["q", "TI"], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}], "/", "2"}]]}]}]}]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["max", "TI"], "=", 
    RowBox[{
     StyleBox["var", "TI"], " ", 
     RowBox[{
      StyleBox["df", "TI"], "/", 
      SubscriptBox[
       StyleBox["q", "TI"], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "\[Alpha]"}], ")"}], "/", "2"}]]}]}]}], 
   TraditionalForm]], "InlineMath"],
 " where ",
 Cell[BoxData[
  RowBox[{
   StyleBox["var", "TI"], "=", 
   RowBox[{
    ButtonBox["Variance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Variance"], "[", 
    StyleBox["list", "TI"], "]"}]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   StyleBox["df", "TI"], "=", 
   RowBox[{
    RowBox[{
     ButtonBox["Length",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Length"], "[", 
     StyleBox["list", "TI"], "]"}], "-", "1"}]}]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["q", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["th", "TI"]]], "InlineFormula"],
 " quantile of a ",
 Cell[BoxData[
  SuperscriptBox["\[Chi]", "2"]], "InlineFormula"],
 " distribution with ",
 Cell[BoxData[
  StyleBox["df", "TI"]], "InlineFormula"],
 " degrees of freedom."
}], "Notes",
 CellID->381223639],

Cell["The following option can be given:", "Notes",
 CellID->20489],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ConfidenceLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/ConfidenceLevel"], "0.95", 
    Cell["probability associated with a confidence interval", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->27338]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->317826771],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->29672536],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->566560083],

Cell["A 95% confidence interval for the population variance:", "ExampleText",
 CellID->11420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VarianceCI", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31920],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.3281539181123005`", ",", "30.552091333927883`"}], 
  "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->177435194]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9561],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ConfidenceLevel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->22104],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->100473541],

Cell["A 99% confidence interval:", "ExampleText",
 CellID->493427760],

Cell[CellGroupData[{

Cell["VarianceCI[{1,2,4,6,3},ConfidenceLevel->.99]", "Input",
 CellTags->"S5.96.1",
 CellLabel->"In[2]:=",
 CellID->482226228],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.9959449562381133`", ",", "71.50135183462206`"}], "}"}]], "Output",\

 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S5.96.1",
 CellLabel->"Out[2]=",
 CellID->986066506]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21630],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChiSquareCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/ChiSquareCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VarianceTest",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/VarianceTest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VarianceRatioCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/VarianceRatioCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VarianceRatioTest",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/VarianceRatioTest"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23224]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21963],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->28135]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VarianceCI - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 18.3996832}", "context" -> 
    "HypothesisTesting`", 
    "keywords" -> {"confidence interval", "variance test"}, "index" -> True, 
    "label" -> "Hypothesis Testing Package Symbol", "language" -> "en", 
    "paclet" -> "HypothesisTesting Package", "status" -> "None", "summary" -> 
    "VarianceCI[list] gives a confidence interval for the population variance \
estimated from list.", "synonyms" -> {}, "title" -> "VarianceCI", "type" -> 
    "Symbol", "uri" -> "HypothesisTesting/ref/VarianceCI"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6105, 215, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->317826771]},
 "S5.96.1"->{
  Cell[8096, 300, 126, 3, 70, "Input",
   CellTags->"S5.96.1",
   CellID->482226228],
  Cell[8225, 305, 263, 9, 36, "Output",
   CellTags->"S5.96.1",
   CellID->986066506]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11592, 418},
 {"S5.96.1", 11726, 422}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1710, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2333, 69, 48, 1, 70, "ObjectName",
 CellID->29445],
Cell[2384, 72, 509, 16, 70, "Usage",
 CellID->18805]
}, Open  ]],
Cell[CellGroupData[{
Cell[2930, 93, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3408, 110, 411, 14, 70, "Notes",
 CellID->129549755],
Cell[3822, 126, 1681, 67, 70, "Notes",
 CellID->381223639],
Cell[5506, 195, 67, 1, 70, "Notes",
 CellID->20489],
Cell[5576, 198, 492, 12, 70, "3ColumnTableMod",
 CellID->27338]
}, Closed]],
Cell[CellGroupData[{
Cell[6105, 215, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->317826771],
Cell[CellGroupData[{
Cell[6490, 229, 147, 5, 70, "ExampleSection",
 CellID->29672536],
Cell[6640, 236, 142, 4, 70, "Input",
 CellID->566560083],
Cell[6785, 242, 93, 1, 70, "ExampleText",
 CellID->11420],
Cell[CellGroupData[{
Cell[6903, 247, 182, 6, 28, "Input",
 CellID->31920],
Cell[7088, 255, 243, 8, 36, "Output",
 CellID->177435194]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7380, 269, 217, 7, 70, "ExampleSection",
 CellID->9561],
Cell[CellGroupData[{
Cell[7622, 280, 232, 7, 70, "ExampleSubsection",
 CellID->22104],
Cell[7857, 289, 142, 4, 70, "Input",
 CellID->100473541],
Cell[8002, 295, 69, 1, 70, "ExampleText",
 CellID->493427760],
Cell[CellGroupData[{
Cell[8096, 300, 126, 3, 70, "Input",
 CellTags->"S5.96.1",
 CellID->482226228],
Cell[8225, 305, 263, 9, 36, "Output",
 CellTags->"S5.96.1",
 CellID->986066506]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8561, 322, 311, 9, 70, "SeeAlsoSection",
 CellID->21630],
Cell[8875, 333, 1059, 35, 70, "SeeAlso",
 CellID->23224]
}, Open  ]],
Cell[CellGroupData[{
Cell[9971, 373, 314, 9, 70, "TutorialsSection",
 CellID->21963],
Cell[10288, 384, 175, 4, 70, "Tutorials",
 CellID->28135]
}, Open  ]],
Cell[10478, 391, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

