(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20122,        725]
NotebookOptionsPosition[     15837,        577]
NotebookOutlinePosition[     17408,        623]
CellTagsIndexPosition[     17297,        617]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypothesis Testing Package" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/tutorial/HypothesisTesting"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypothesis Testing Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"VarianceRatioCI" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/VarianceRatioCI"], "FRatioCI" :> 
          Documentation`HelpLookup["paclet:HypothesisTesting/ref/FRatioCI"], 
          "VarianceTest" :> 
          Documentation`HelpLookup[
           "paclet:HypothesisTesting/ref/VarianceTest"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"VarianceRatioCI\"\>", 2->"\<\"FRatioCI\"\>", 
       3->"\<\"VarianceTest\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["VarianceRatioTest", "ObjectName",
 CellID->16255],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VarianceRatioTest", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]performs a test with null hypothesis ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        SuperscriptBox[
         SubscriptBox[
          StyleBox["\[Sigma]", "TR"], 
          StyleBox["1", "TR"]], "2"], "/", 
        SuperscriptBox[
         SubscriptBox[
          StyleBox["\[Sigma]", "TR"], 
          StyleBox["2", "TR"]], "2"]}], "=", 
       StyleBox["r", "TI"]}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3396]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"VarianceRatioTest", "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["1", "TR"]], ",", 
    RowBox[{
     StyleBox["l", "TI"], 
     SubscriptBox[
      StyleBox["ist", "TI"], 
      StyleBox["2", "TR"]]}], ",", 
    StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
 " gives a ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "\[Hyphen]value for the test that the ratio of the variances ",
 Cell[BoxData[
  SuperscriptBox[
   SubscriptBox[
    StyleBox["\[Sigma]", "TR"], 
    StyleBox["1", "TR"]], "2"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SuperscriptBox[
   SubscriptBox[
    StyleBox["\[Sigma]", "TR"], 
    StyleBox["2", "TR"]], "2"]], "InlineFormula"],
 " of the populations from which ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 " were sampled is significantly different from ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24199],

Cell[TextData[{
 Cell[BoxData["VarianceRatioTest"], "InlineFormula"],
 " uses the test statistic ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     ButtonBox["Variance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Variance"], "[", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["1", "TR"]], "]"}], "/", 
    RowBox[{
     ButtonBox["Variance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Variance"], "[", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["2", "TR"]], "]"}]}], "/", 
   StyleBox["r", "TI"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->196747578],

Cell[TextData[{
 Cell[BoxData["VarianceRatioTest"], "InlineFormula"],
 " is based on an F-ratio distribution with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["1", "TR"]], "]"}], "-", "1"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["2", "TR"]], "]"}], "-", "1"}]], "InlineFormula"],
 " degrees of freedom."
}], "Notes",
 CellID->15830117],

Cell["The following options can be given:", "Notes",
 CellID->24813],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FullReport",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/FullReport"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to include detailed information about a test", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SignificanceLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/SignificanceLevel"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "significance level of the test", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TwoSided",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/TwoSided"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to perform a two-sided test", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->15546],

Cell[TextData[{
 "With the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FullReport",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/FullReport"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData["VarianceRatioTest"], "InlineFormula"],
 " also returns the ratio of sample variances, the test statistic, and the \
distribution used to generate the ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "-value."
}], "Notes",
 CellID->14278]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->143812813],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->344748402],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->686896819],

Cell["A test of the ratio of population variances against 2:", "ExampleText",
 CellID->28864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VarianceRatioTest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "10", ",", "6", ",", "8", ",", "5", ",", "8"}], "}"}], 
   ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24484],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.18000222301055965`"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->63907090]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30057],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FullReport",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->7478],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->66755478],

Cell["A full report for a variance ratio test:", "ExampleText",
 CellID->238475917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VarianceRatioTest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "10", ",", "6", ",", "8", ",", "5", ",", "8"}], "}"}], 
   ",", "2", ",", 
   RowBox[{"FullReport", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->99892941],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FullReport", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         TagBox["\<\"Ratio\"\>",
          HoldForm], 
         TagBox["\<\"TestStat\"\>",
          HoldForm], 
         TagBox["\<\"Distribution\"\>",
          HoldForm]},
        {"0.7449664429530202`", "0.3724832214765101`", 
         RowBox[{"FRatioDistribution", "[", 
          RowBox[{"4", ",", "5"}], "]"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.28], {
            Offset[0.7]}, 
           Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {None, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, 
       TableHeadings -> {None, {"Ratio", "TestStat", "Distribution"}}]]]}], 
   ",", 
   RowBox[{"OneSidedPValue", "\[Rule]", "0.18000222301055965`"}]}], 
  "}"}]], "Output",
 ImageSize->{401, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->743022911]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "SignificanceLevel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->30642],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->37098445],

Cell["A test at significance level .01:", "ExampleText",
 CellID->493427760],

Cell[CellGroupData[{

Cell["\<\
VarianceRatioTest[{1,2,4,6,3},{4,10,6,8,5,8},2,SignificanceLevel->.01]\
\>", "Input",
 CellTags->"S5.96.1",
 CellLabel->"In[2]:=",
 CellID->482226228],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"OneSidedPValue", "\[Rule]", "0.18000222301055965`"}], ",", 
   RowBox[{"\<\"Fail to reject null hypothesis at significance level\"\>", 
    "\[Rule]", "0.01`"}]}], "}"}]], "Output",
 ImageSize->{426, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S5.96.1",
 CellLabel->"Out[2]=",
 CellID->430009950]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TwoSided",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->29995],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<HypothesisTesting`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->811849944],

Cell["\<\
A two\[Hyphen]sided variance ratio test:\
\>", "ExampleText",
 CellID->384802285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VarianceRatioTest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "6", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "10", ",", "6", ",", "8", ",", "5", ",", "8"}], "}"}], 
   ",", "2", ",", 
   RowBox[{"TwoSided", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->357402744],

Cell[BoxData[
 RowBox[{"TwoSidedPValue", "\[Rule]", "0.3600044460211193`"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->164267836]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11397],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["VarianceRatioCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/VarianceRatioCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FRatioCI",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/FRatioCI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VarianceTest",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/VarianceTest"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15868]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4724],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/tutorial/HypothesisTesting"]], "Tutorials",
 CellID->31686]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VarianceRatioTest - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 18.8684452}", "context" -> 
    "HypothesisTesting`", 
    "keywords" -> {"variance test", "variance ratio test"}, "index" -> True, 
    "label" -> "Hypothesis Testing Package Symbol", "language" -> "en", 
    "paclet" -> "HypothesisTesting Package", "status" -> "None", "summary" -> 
    "VarianceRatioTest[list_1, list_2, r] performs a test with null \
hypothesis \\[Sigma]_1 2/\\[Sigma]_2 2 = r.", "synonyms" -> {}, "title" -> 
    "VarianceRatioTest", "type" -> "Symbol", "uri" -> 
    "HypothesisTesting/ref/VarianceRatioTest"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8005, 277, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->143812813]},
 "S5.96.1"->{
  Cell[12431, 443, 160, 5, 70, "Input",
   CellTags->"S5.96.1",
   CellID->482226228],
  Cell[12594, 450, 386, 11, 54, "Output",
   CellTags->"S5.96.1",
   CellID->430009950]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16963, 603},
 {"S5.96.1", 17097, 607}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1527, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2150, 65, 55, 1, 70, "ObjectName",
 CellID->16255],
Cell[2208, 68, 974, 32, 70, "Usage",
 CellID->3396]
}, Open  ]],
Cell[CellGroupData[{
Cell[3219, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3697, 122, 1146, 43, 70, "Notes",
 CellID->24199],
Cell[4846, 167, 630, 23, 70, "Notes",
 CellID->196747578],
Cell[5479, 192, 670, 24, 70, "Notes",
 CellID->15830117],
Cell[6152, 218, 68, 1, 70, "Notes",
 CellID->24813],
Cell[6223, 221, 1190, 31, 70, "3ColumnTableMod",
 CellID->15546],
Cell[7416, 254, 552, 18, 70, "Notes",
 CellID->14278]
}, Closed]],
Cell[CellGroupData[{
Cell[8005, 277, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->143812813],
Cell[CellGroupData[{
Cell[8390, 291, 148, 5, 70, "ExampleSection",
 CellID->344748402],
Cell[8541, 298, 142, 4, 70, "Input",
 CellID->686896819],
Cell[8686, 304, 93, 1, 70, "ExampleText",
 CellID->28864],
Cell[CellGroupData[{
Cell[8804, 309, 315, 9, 28, "Input",
 CellID->24484],
Cell[9122, 320, 218, 6, 36, "Output",
 CellID->63907090]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9389, 332, 218, 7, 70, "ExampleSection",
 CellID->30057],
Cell[CellGroupData[{
Cell[9632, 343, 226, 7, 70, "ExampleSubsection",
 CellID->7478],
Cell[9861, 352, 141, 4, 70, "Input",
 CellID->66755478],
Cell[10005, 358, 83, 1, 70, "ExampleText",
 CellID->238475917],
Cell[CellGroupData[{
Cell[10113, 363, 370, 10, 70, "Input",
 CellID->99892941],
Cell[10486, 375, 1414, 42, 72, "Output",
 CellID->743022911]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11949, 423, 234, 7, 70, "ExampleSubsection",
 CellID->30642],
Cell[12186, 432, 141, 4, 70, "Input",
 CellID->37098445],
Cell[12330, 438, 76, 1, 70, "ExampleText",
 CellID->493427760],
Cell[CellGroupData[{
Cell[12431, 443, 160, 5, 70, "Input",
 CellTags->"S5.96.1",
 CellID->482226228],
Cell[12594, 450, 386, 11, 54, "Output",
 CellTags->"S5.96.1",
 CellID->430009950]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13029, 467, 225, 7, 70, "ExampleSubsection",
 CellID->29995],
Cell[13257, 476, 142, 4, 70, "Input",
 CellID->811849944],
Cell[13402, 482, 91, 3, 70, "ExampleText",
 CellID->384802285],
Cell[CellGroupData[{
Cell[13518, 489, 369, 10, 70, "Input",
 CellID->357402744],
Cell[13890, 501, 218, 6, 36, "Output",
 CellID->164267836]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14181, 515, 311, 9, 70, "SeeAlsoSection",
 CellID->11397],
Cell[14495, 526, 772, 26, 70, "SeeAlso",
 CellID->15868]
}, Open  ]],
Cell[CellGroupData[{
Cell[15304, 557, 313, 9, 70, "TutorialsSection",
 CellID->4724],
Cell[15620, 568, 175, 4, 70, "Tutorials",
 CellID->31686]
}, Open  ]],
Cell[15810, 575, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

