(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     64809,       2161]
NotebookOptionsPosition[     54238,       1813]
NotebookOutlinePosition[     56496,       1862]
CellTagsIndexPosition[     56453,       1859]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["HYPOTHESIS TESTING PACKAGE TUTORIAL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ChiSquareCI" :> 
         Documentation`HelpLookup["paclet:HypothesisTesting/ref/ChiSquareCI"],
          "ChiSquarePValue" :> 
         Documentation`HelpLookup[
          "paclet:HypothesisTesting/ref/ChiSquarePValue"], "FRatioCI" :> 
         Documentation`HelpLookup["paclet:HypothesisTesting/ref/FRatioCI"], 
         "FRatioPValue" :> 
         Documentation`HelpLookup[
          "paclet:HypothesisTesting/ref/FRatioPValue"], "MeanCI" :> 
         Documentation`HelpLookup["paclet:HypothesisTesting/ref/MeanCI"], 
         "MeanDifferenceCI" :> 
         Documentation`HelpLookup[
          "paclet:HypothesisTesting/ref/MeanDifferenceCI"], 
         "MeanDifferenceTest" :> 
         Documentation`HelpLookup[
          "paclet:HypothesisTesting/ref/MeanDifferenceTest"], "MeanTest" :> 
         Documentation`HelpLookup["paclet:HypothesisTesting/ref/MeanTest"], 
         "NormalCI" :> 
         Documentation`HelpLookup["paclet:HypothesisTesting/ref/NormalCI"], 
         "NormalPValue" :> 
         Documentation`HelpLookup[
          "paclet:HypothesisTesting/ref/NormalPValue"], "StudentTCI" :> 
         Documentation`HelpLookup["paclet:HypothesisTesting/ref/StudentTCI"], 
         "StudentTPValue" :> 
         Documentation`HelpLookup[
          "paclet:HypothesisTesting/ref/StudentTPValue"], "VarianceCI" :> 
         Documentation`HelpLookup["paclet:HypothesisTesting/ref/VarianceCI"], 
         "VarianceRatioCI" :> 
         Documentation`HelpLookup[
          "paclet:HypothesisTesting/ref/VarianceRatioCI"], 
         "VarianceRatioTest" :> 
         Documentation`HelpLookup[
          "paclet:HypothesisTesting/ref/VarianceRatioTest"], "VarianceTest" :> 
         Documentation`HelpLookup[
          "paclet:HypothesisTesting/ref/VarianceTest"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"ChiSquareCI\"\>", 2->"\<\"ChiSquarePValue\"\>", 
      3->"\<\"FRatioCI\"\>", 4->"\<\"FRatioPValue\"\>", 5->"\<\"MeanCI\"\>", 
      6->"\<\"MeanDifferenceCI\"\>", 7->"\<\"MeanDifferenceTest\"\>", 
      8->"\<\"MeanTest\"\>", 9->"\<\"NormalCI\"\>", 
      10->"\<\"NormalPValue\"\>", 11->"\<\"StudentTCI\"\>", 
      12->"\<\"StudentTPValue\"\>", 13->"\<\"VarianceCI\"\>", 
      14->"\<\"VarianceRatioCI\"\>", 15->"\<\"VarianceRatioTest\"\>", 
      16->"\<\"VarianceTest\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Hypothesis Testing Package", "Title",
 CellID->30193],

Cell["\<\
This package contains functions for testing hypotheses for and computing \
confidence intervals from data. Tests and confidence intervals for means, \
differences of means, variances and ratios of variances are included along \
with p\[Hyphen]values and confidence intervals for distributions related to \
the normal distribution. \
\>", "Text",
 CellID->324111895],

Cell[CellGroupData[{

Cell["Hypothesis Tests", "Section",
 CellID->65111861],

Cell[TextData[{
 "The tests in this package are parametric tests. Given a null hypothesis \
value ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["\[Theta]", "TR"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 " for a parameter ",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 " and an estimate ",
 Cell[BoxData[
  OverscriptBox[
   StyleBox["\[Theta]", "TR"], "^"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 " obtained from data, hypothesis test functions give the probability of \
observing a value at least as extreme as ",
 Cell[BoxData[
  OverscriptBox[
   StyleBox["\[Theta]", "TR"], "^"]], "InlineFormula"],
 " if ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["\[Theta]", "TR"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 " is the true value of ",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 ". A sufficiently small probability, or p\[Hyphen]value, provides evidence \
that the true value of ",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 " is significantly different from ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["\[Theta]", "TR"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 "."
}], "Text",
 CellID->805085351],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeanTest",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/MeanTest"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MeanDifferenceTest",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/MeanDifferenceTest"]], 
  "InlineFormula"],
 " provide tests of means based on the Central Limit Theorem. "
}], "Text",
 CellID->38669791],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MeanTest",
      BaseStyle->"Link",
      ButtonData->"paclet:HypothesisTesting/ref/MeanTest"], "[", 
     StyleBox["list", "TI"], ",", 
     SubscriptBox[
      StyleBox["\[Mu]", "TI"], 
      StyleBox["0", "TR"]], "]"}], Cell[TextData[{
     "performs a test with null hypothesis",
     " ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[Mu]", "TR"], "=", 
       SubscriptBox[
        StyleBox["\[Mu]", "TR"], 
        StyleBox["0", "TR"]]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MeanDifferenceTest",
      BaseStyle->"Link",
      ButtonData->"paclet:HypothesisTesting/ref/MeanDifferenceTest"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["\[CapitalDelta]\[Mu]", "TI"], 
       StyleBox["0", "TR"]]}], "]"}], Cell[TextData[{
     "performs a test with null hypothesis ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        SubscriptBox[
         StyleBox["\[Mu]", "TR"], 
         StyleBox["1", "TR"]], "-", 
        SubscriptBox[
         StyleBox["\[Mu]", "TR"], 
         StyleBox["2", "TR"]]}], "=", 
       SubscriptBox[
        StyleBox["\[CapitalDelta]\[Mu]", "TR"], 
        StyleBox["0", "TR"]]}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->22389],

Cell["Hypothesis tests for means.", "Caption",
 CellID->17890],

Cell["This loads the package. ", "MathCaption",
 CellID->23560],

Cell[BoxData[
 RowBox[{"<<", "HypothesisTesting`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24754],

Cell["Here is a data set. ", "MathCaption",
 CellID->17299],

Cell[BoxData[
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"{", 
    RowBox[{
    "34", ",", "37", ",", "44", ",", "31", ",", "41", ",", "42", ",", "38", 
     ",", "45", ",", "42", ",", "38"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7809],

Cell["\<\
This tests whether the population mean is significantly different from 35. \
\>", "MathCaption",
 CellID->16503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanTest", "[", 
  RowBox[{"data1", ",", "35"}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->18954],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.0076023372531929985`"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->93201983]
}, Open  ]],

Cell[TextData[{
 "Assumptions about variances of the populations from which the data were \
sampled will effect the distribution of the test statistic. The ",
 Cell[BoxData[
  ButtonBox["KnownVariance",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/KnownVariance"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EqualVariances",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/EqualVariances"]], 
  "InlineFormula"],
 " options can be used to specify assumptions about population variances."
}], "Text",
 CellID->819706313],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["KnownVariance",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/KnownVariance"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "value of the known population variance", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->10713],

Cell[TextData[{
 "Option for ",
 Cell[BoxData[
  ButtonBox["MeanTest",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/MeanTest"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MeanDifferenceTest",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/MeanDifferenceTest"]], 
  "InlineFormula"],
 "."
}], "Caption",
 CellID->74019202],

Cell["\<\
Tests of the mean and of the difference of means are based on a normal \
distribution if the population variances are assumed known. \
\>", "Text",
 CellID->406018260],

Cell[TextData[{
 "Tests of the mean are based on ",
 "Student's ",
 Cell[BoxData[
  FormBox[
   StyleBox["t", "TI"], TraditionalForm]], "InlineFormula"],
 " distribution with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n", "TI"], "-", "1"}], TraditionalForm]], "InlineFormula"],
 " degrees of freedom when the population variance must be estimated from a \
list of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " elements",
 ". "
}], "Text",
 CellID->197757042],

Cell["\<\
This tests whether the population mean is significantly different from 35, \
assuming the population variance is 8. \
\>", "MathCaption",
 CellID->109679975],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanTest", "[", 
  RowBox[{"data1", ",", "35", ",", 
   RowBox[{"KnownVariance", "\[Rule]", "8"}]}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->303330159],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "1.3281984121595954`*^-6"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->364339515]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["EqualVariances",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/EqualVariances"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether the unknown population variances are assumed equal", 
     "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->31637940],

Cell[TextData[{
 "Option for ",
 Cell[BoxData[
  ButtonBox["MeanDifferenceTest",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/MeanDifferenceTest"]], 
  "InlineFormula"],
 "."
}], "Caption",
 CellID->23917160],

Cell[TextData[{
 "Tests of the difference of means are also based on Student's ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution if the variances are not known. If the variances are assumed \
equal, ",
 Cell[BoxData[
  ButtonBox["MeanDifferenceTest",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/MeanDifferenceTest"]], 
  "InlineFormula"],
 " is based on Student's ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["1", "TR"]], "]"}], "+", 
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["2", "TR"]], "]"}], "-", "2"}]], "InlineFormula"],
 " degrees of freedom. If the population variances are not assumed equal, \
Welch's approximation for the degrees of freedom is used."
}], "Text",
 CellID->20617408],

Cell["Here is a second data set. ", "MathCaption",
 CellID->23530],

Cell[BoxData[
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"{", 
    RowBox[{
    "39", ",", "40", ",", "34", ",", "45", ",", "44", ",", "38", ",", "42", 
     ",", "39", ",", "47", ",", "41"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->9047],

Cell[TextData[{
 "This tests whether the difference between the means of the two populations \
is significantly different from ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula"],
 ".  "
}], "MathCaption",
 CellID->15748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDifferenceTest", "[", 
  RowBox[{"data1", ",", "data2", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->20691],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.18471538367128854`"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->477823521]
}, Open  ]],

Cell["\<\
This tests the same hypothesis with the additional assumption that the \
population variances are the same.  \
\>", "MathCaption",
 CellID->367713153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDifferenceTest", "[", 
  RowBox[{"data1", ",", "data2", ",", "0", ",", 
   RowBox[{"EqualVariances", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->183599562],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.18456374583508617`"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->326999066]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["VarianceTest",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/VarianceTest"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["VarianceRatioTest",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/VarianceRatioTest"]], 
  "InlineFormula"],
 " provide tests of variances for normally distributed samples. "
}], "Text",
 CellID->20232],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["VarianceTest",
      BaseStyle->"Link",
      ButtonData->"paclet:HypothesisTesting/ref/VarianceTest"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      SuperscriptBox[
       SubscriptBox[
        StyleBox["\[Sigma]", "TI"], 
        StyleBox["0", "TR"]], "2"]}], "]"}], Cell[TextData[{
     "performs a test with null hypothesis ",
     Cell[BoxData[
      RowBox[{
       SuperscriptBox[
        StyleBox["\[Sigma]", "TR"], "2"], "=", 
       SuperscriptBox[
        SubscriptBox[
         StyleBox["\[Sigma]", "TR"], 
         StyleBox["0", "TR"]], "2"]}]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["VarianceRatioTest",
      BaseStyle->"Link",
      ButtonData->"paclet:HypothesisTesting/ref/VarianceRatioTest"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["r", "TI"]}], "]"}], Cell[TextData[{
     "performs a test with null hypothesis ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        SuperscriptBox[
         SubscriptBox[
          StyleBox["\[Sigma]", "TR"], 
          StyleBox["1", "TR"]], "2"], "/", 
        SuperscriptBox[
         SubscriptBox[
          StyleBox["\[Sigma]", "TR"], 
          StyleBox["2", "TR"]], "2"]}], "=", "r"}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->133135456],

Cell["Hypothesis tests for variances. ", "Caption",
 CellID->176],

Cell[TextData[{
 "The variance test statistic follows a ",
 Cell[BoxData[
  SuperscriptBox["\[Chi]", "2"]], "InlineFormula"],
 " distribution and the variance ratio test statistic follows an ",
 StyleBox["F",
  FontSlant->"Italic"],
 "\[Hyphen]ratio distribution."
}], "Text",
 CellID->96957417],

Cell["Here is another set of data. ", "MathCaption",
 CellID->6243],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
    "41.0", ",", "42.4", ",", "42.5", ",", "40.6", ",", "45.6", ",", "34.4"}],
     "}"}]}], ";"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->18021],

Cell[TextData[{
 "This tests whether the variance of the population from which these data \
were sampled is significantly different from ",
 Cell[BoxData[
  FormBox["8", TraditionalForm]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->18365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VarianceTest", "[", 
  RowBox[{"data", ",", "8"}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->8584],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.12471697284467782`"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->5291754]
}, Open  ]],

Cell["\<\
By default hypothesis test functions return a one\[Hyphen]sided \
p\[Hyphen]value. If the parameter estimate is smaller than the null \
hypothesis value, the p\[Hyphen]value is the probability of observing a value \
less than or equal to the parameter estimate. If the estimate is greater than \
the null hypothesis value, the p\[Hyphen]value is the probability of \
observing a value greater than or equal to the parameter estimate.\
\>", "Text",
 CellID->503681572],

Cell["\<\
Additional options are included to obtain two\[Hyphen]sided p\[Hyphen]values \
and to obtain more information about the test results.\
\>", "Text",
 CellID->281896613],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["SignificanceLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/SignificanceLevel"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "significance level of the test ", "TableText"]},
   {
    ButtonBox["TwoSided",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/TwoSided"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to perform a two\[Hyphen]sided test \
\>", "TableText"]},
   {
    ButtonBox["FullReport",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/FullReport"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to include the estimate, test statistic and distribution in output \
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->164564161],

Cell["Options for all hypothesis test functions.", "Caption",
 CellID->3106],

Cell[TextData[{
 "A two\[Hyphen]sided test can be requested using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TwoSided",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/TwoSided"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". More details about a test can be obtained using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FullReport",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/FullReport"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". A full report includes the parameter estimate, the test statistic and the \
distribution of the test statistic. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SignificanceLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/SignificanceLevel"], "->", 
   StyleBox["\[Alpha]", "TR"]}]], "InlineFormula"],
 ", a conclusion of the test at significance level ",
 Cell[BoxData[
  StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
 " is given, stating whether or not the null hypothesis is rejected at that \
level of significance."
}], "Text",
 CellID->8148],

Cell[TextData[{
 "This is the full report for a mean test of ",
 Cell[BoxData[
  StyleBox["data1", "TI"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->3265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanTest", "[", 
  RowBox[{"data1", ",", "35", ",", 
   RowBox[{"FullReport", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->10780],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FullReport", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         TagBox["\<\"Mean\"\>",
          HoldForm], 
         TagBox["\<\"TestStat\"\>",
          HoldForm], 
         TagBox["\<\"Distribution\"\>",
          HoldForm]},
        {"39.2`", "2.9898476866203723`", 
         RowBox[{"StudentTDistribution", "[", "9", "]"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {None, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, 
       TableHeadings -> {None, {"Mean", "TestStat", "Distribution"}}]]]}], 
   ",", 
   RowBox[{"OneSidedPValue", "\[Rule]", "0.0076023372531929985`"}]}], 
  "}"}]], "Output",
 ImageSize->{563, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->572817503]
}, Open  ]],

Cell[TextData[{
 "This is a two\[Hyphen]sided variance test of ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->99713113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VarianceTest", "[", 
  RowBox[{"data", ",", "8", ",", 
   RowBox[{"TwoSided", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->156073823],

Cell[BoxData[
 RowBox[{"TwoSidedPValue", "\[Rule]", "0.24943394568935565`"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->654481167]
}, Open  ]],

Cell[TextData[{
 "Given a test statistic in terms of the normal, chi\[Hyphen]square, \
Student's ",
 StyleBox["t",
  FontSlant->"Italic"],
 ", or ",
 StyleBox["F",
  FontSlant->"Italic"],
 "\[Hyphen]ratio distribution, a p\[Hyphen]value can be computed using the \
appropriate p\[Hyphen]value function. For example, ",
 Cell[BoxData[
  ButtonBox["NormalPValue",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/NormalPValue"]], 
  "InlineFormula"],
 " computes a p\[Hyphen]value for a test statistic using a normal \
distribution with mean zero and unit variance. A two\[Hyphen]sided \
p\[Hyphen]value can be obtained by setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TwoSided",
    BaseStyle->"Link",
    ButtonData->"paclet:HypothesisTesting/ref/TwoSided"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 "."
}], "Text",
 CellID->31259],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NormalPValue",
      BaseStyle->"Link",
      ButtonData->"paclet:HypothesisTesting/ref/NormalPValue"], "[", 
     StyleBox["teststat", "TI"], "]"}], Cell[TextData[{
     "gives the p\[Hyphen]value for ",
     Cell[BoxData[
      StyleBox["teststat", "TI"]], "InlineFormula"],
     " in terms of the normal distribution with mean 0 and unit variance"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StudentTPValue",
      BaseStyle->"Link",
      ButtonData->"paclet:HypothesisTesting/ref/StudentTPValue"], "[", 
     RowBox[{
      StyleBox["teststat", "TI"], ",", 
      StyleBox["dof", "TI"]}], "]"}], Cell[TextData[{
     "gives the p\[Hyphen]value for ",
     Cell[BoxData[
      StyleBox["teststat", "TI"]], "InlineFormula"],
     " in terms of Student's ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " distribution with ",
     Cell[BoxData[
      StyleBox["dof", "TI"]], "InlineFormula"],
     " degrees of freedom"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ChiSquarePValue",
      BaseStyle->"Link",
      ButtonData->"paclet:HypothesisTesting/ref/ChiSquarePValue"], "[", 
     RowBox[{
      StyleBox["teststat", "TI"], ",", 
      StyleBox["dof", "TI"]}], "]"}], Cell[TextData[{
     "gives the p\[Hyphen]value for ",
     Cell[BoxData[
      StyleBox["teststat", "TI"]], "InlineFormula"],
     " in terms of the ",
     Cell[BoxData[
      SuperscriptBox["\[Chi]", "2"]], "InlineFormula"],
     " distribution with ",
     Cell[BoxData[
      StyleBox["dof", "TI"]], "InlineFormula"],
     " degrees of freedom"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FRatioPValue",
      BaseStyle->"Link",
      ButtonData->"paclet:HypothesisTesting/ref/FRatioPValue"], "[", 
     RowBox[{
      StyleBox["teststat", "TI"], ",", 
      StyleBox["numdof", "TI"], ",", 
      StyleBox["dendof", "TI"]}], "]"}], Cell[TextData[{
     "gives the p\[Hyphen]value for ",
     Cell[BoxData[
      StyleBox["teststat", "TI"]], "InlineFormula"],
     " in terms of the F\[Hyphen]ratio distribution with ",
     Cell[BoxData[
      StyleBox["numdof", "TI"]], "InlineFormula"],
     " numerator and ",
     Cell[BoxData[
      StyleBox["dendof", "TI"]], "InlineFormula"],
     " denominator degrees of freedom"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->207867752],

Cell["\<\
Functions for p\[Hyphen]values of test statistics. \
\>", "Caption",
 CellID->20734],

Cell[TextData[{
 "This is the lower tail probability at -1.96 for a normal distribution with \
mean ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula"],
 " and unit variance. "
}], "MathCaption",
 CellID->28736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NormalPValue", "[", 
  RowBox[{"-", "1.96"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->27894],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.024997895148220428`"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->690323448]
}, Open  ]],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["TwoSidedPValue",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/TwoSidedPValue"]], 
  "InlineFormula"],
 " gives the probability of the absolute value of the test statistic being at \
least as extreme as ",
 Cell[BoxData[
  FormBox["1.96", TraditionalForm]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->8419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NormalPValue", "[", 
  RowBox[{
   RowBox[{"-", "1.96"}], ",", 
   RowBox[{"TwoSided", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->11810],

Cell[BoxData[
 RowBox[{"TwoSidedPValue", "\[Rule]", "0.049995790296440856`"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->421250152]
}, Open  ]],

Cell["\<\
A p\[Hyphen]value is not always equivalent to the cumulative distribution \
function. \
\>", "MathCaption",
 CellID->11489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"ChiSquareDistribution", "[", "5", "]"}], ",", "x"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->2334],

Cell[BoxData[
 GraphicsBox[{{}, {}, {
    {Hue[0.67, 0.6, 0.6]}, LineBox[CompressedData["
1:eJwVx30wG3YcgPGIMCpINaJUQ5Kp9xp2NG58f5Stdlt1pcWmStpMdaemlFtn
Uy9ps3jvSFFTmki9DYmel6UlM28zPS9RrVZlTJGQNrKZYpXFH88996EwEk8y
sRgMBrTt/unap+4YjAouhhS1lzjxYMCkJf+4kQrGOZSERx/xoM2ZoKgkqeCH
kSNiKyYPCpgTd+muKjA7LcT8fYcHR6dPE5M/V4Et+RdGOYkPzZKzGy/vq4Cn
J8F2vFMLrMKkh3/Er4G8TdmD2RSAh2tp8C2pGnTyjsdZkhqBEssUGi2sw55U
u5/svheBuBBnliN5AxGDJ0S8ug7gG+t7VhVsQ4JAVkN2egjUnCJeafkOuCxQ
yBsDv4JgK+X6sU4MYm973ata6QOW2+L8+wFY5Ho42TMkbQjweWwbdZ8ucjiP
j+s0HgE582aE0FUPib8RHuSkjQLhQQxddl8fbX/p7xJyexzyC7kkU6oBsptM
10s6IwUR563UlG2IeibbWBzSY6BgHekZeCPUJHjvdbp6Chb/FVeoUvEo+8oF
fVLDU1iP28cf0xijDI+t9s6MZ9CEqczPzDRF3V34PeTAGYgyGqBXpBBQF++w
r97cC2CHVWMavfcie1m3UFYqg7NRzf0PlHtR13af1Lv4T/jibtWsXpsZ8vUU
b5bEzoFz+r24jpR9KGCwweWY/TzUEhdexTsSkThcbRM7PQ9BK9jhUCURtTNe
6V788S8ounaK58c3R/xcxxamzwI010tWi8NJKJpKEQ0+WQA1wYRjbWWBqoXn
4pK/fQlzXoV2daMWiO8mrS83XoT1CjXxq5L9CFecmr7EX4QXNy+lcE9ZIr9h
SS7DYwkSg8kTvYZWiHQ790Pn1iWw92vNPvTICrVPxuM07svAWbvimZt9AJUO
++NcapdBciQsNMLLGrmb48srCHKw7iYORr2xRllFEdMfZMiBhjWkM34+iIbj
7U+azckhJEe2U5VERtyAyfa0IAUc6pf3zjjYIEJZ6CeWVQoYK8dvZM3YIJyi
ZoqhUsCJKTa0htgiwpbHuChwBUygNutOgy2q10lnrRWswOyAKNHJmIIc3C6l
DDxbgbKykRJ5gtbMywm/2a5CXTCG7jhEQbrPSwT+0aswbGl3A+dERQ1BmdGa
ylUI+P1cWAyLig5EKh6bTK4Cv7c5UjVLRaWXy2yX9ZWw/7nCwBrRUM93FrIe
HyXMTyDvoQoa6g5iRDpdUEK3/IYp4S0N5Ug/xoVzldBr3oJj79BQzGeEDp1b
SuhrDNAc1dCQqlgHE77r1Lz/arTGnYmuztQ6MMp9e0zr/FnWa67WuNHsq8ta
X11+wq3R+ryBq88/Wutc+1oh0Lrff2pTs+t3d3ybtP4fH3DYmw==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  Method->{},
  PlotRange->{{1, 10}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 ImageSize->{184, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->108621750]
}, Open  ]],

Cell["\<\
A one\[Hyphen]sided p\[Hyphen]value has a maximum value of 0.5.\
\>", "MathCaption",
 CellID->20178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"OneSidedPValue", "/.", "\[InvisibleSpace]", 
    RowBox[{"ChiSquarePValue", "[", 
     RowBox[{"x", ",", "5"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->29590],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdmE9MXFUUxh/MQKcUKVrAqWKdUlKpRoPRGKIxEjWITTWYRp3U2DDB6lSt
JVgjcSGJMWFjQuKGpF2Q6IIliWnCkiVLlixZsmTJcvydc+4d3ty5rzBNaqiT
MPPuvef7zp/v3Htf+Khyp3rjVuXOzZlK6YO5ymz15syPpYnbc0zl2pIkuc/f
78WE5xpP+ne/VuO3+buP7zwGF2SUE0v9JEN8tTMcdr8yluV2N84puj+FSiIs
5+UrfzA2nsNmxIek0Sa/OjUQ8JZc1EdhOwr/0wH/87G8GjguuDo0rxzOXkph
c1GOo8TcF0V5zUItW+fvz2BLZ96e8ppr6IysfvvH+UqSfMDbGYxPHLLeqv3j
vm51DXtpKKJOK+M4612d1bXc7u7uwsIC38mTUSvVMb+4uFgqlWZnZzE8HbXr
ULv9/f2lpaWRkREAPTXrmHu6rvnn9/b25ufnWV9fX++O8pxUu+3t7cnJyamp
Kfx1BXZ/6nhjY2N1dRVn5jk5pbNra2uQr6ysGE8K9Yd8ndzZ2cGEhGEnIZbH
x8fL5bIgjKfbxzk9PY0R/kPlFuWrCyb8kwwEhUIBMqKFmMRYUu9JjyKZsYSb
NP9NmagZyVhMvb29MBEQ9WOSJeVITvuosKlWq8yH++tXzY9wSQWL0dFRoiI2
CwlkckaZTOXl5eWxsTGq7LrggOcX+SrggDqhN5EXi0VqAWJra6uoHE8phiEc
mNmOT3H8rA2/ublJeTAhEGqDVOJvUBk0lg6iYgEvOpckPymO8uGMBXCgqQRM
eqr6GwkqMhPEnCKIxLqK2pE7IRG/7QV3t1DLxD4/6OZjjCHm1AkHBPZC406B
XzL7Vq15ogJowyyhEeCLB9ZyzloiEH2dYseeSeRg9eX6Hqifoan7Rx61+zrr
NSQfuoA0KjqPS4QkXosAxlHFdvoIXOUdT4pbxyfqFnxoW1ikI66rCoxtN+AB
P8lrGcxh9+YbskEjaikKX1NWmMiB3iEN6f03MljD3RX2o41hoxVExc+VHUaL
mZrL2TX2kOy2i2xfyRlw1fclRYadWYn9rQz2/AOrr1Q6Rkb6h1CTKV8bmt6a
VSr+dkN3dKZ+m28QigpKHq8oF3WnwnCxKUTTdxr72GELNbfr6UjZGx9q5ORG
J1BYWuDdOk5825lL37MorBNqzxiNKQpCvB/1Yzj2I3aS2XspHK5ZmIjiTnmV
scMoGVccbuq4ySiu2+tHnKKUVjJPTcb1A+5yFPeE18Xp/qbi8I8za7QrDfXo
VXtEpPzyqN0s57HpSIIfR/0YDuWBSt1fr7nzywSzfmhC2RlNXEQj1X/VV4Mj
DodMfRLF2blsqsqueEVxPMHDFJvzahR3xqtG6qLaS4ojXrv2ye7TKK4vUO2S
rz5jCgXBZ1Fcf6DaRV9NqmTXUjmKGwhUG/b5ujv/WhRV9NpxvsljKeXNbvgv
GvafnhEd6RMziezGszqGEhZ5PBfE8mXt6KdoevyM157QRPtnm6K9nsEsTHl3
Bkkeg6luEFXPBhFOP4AnfYOEEQ+mukVUH/DdUo+wksHsIwsZn9MxQPc+YX1F
G9BHEulMi3znfJ/Ypez2Baefu6G+atA7vCNCRbRf5Nx1e7jHKwK7vYvdiPbd
ea+k2412VrE7qL9k+U0UNeStXHW7fJ8xFpZqFGXv/XZLCrflRIz2BmjvMU2o
4aBOHV5Z6iR37XdR1EVfD+4d6VB7++M0c6fH91GUvl91ctG4DV4uc5Lh+lbd
WrS45JWnRtgmt6Ncd4/5bOw9Tx5jvWqIh3m3aA0pwEfjK9dCVvH3o6z6+d+4
1XFQ2vftvWMV0f+1T7PO+/8qtuwKZr2zHx+tH5dOlYrKZPg/hezqFoLZ3BG1
e7S4gz4+3P6vluzCnvtbZ5v/F5u0/QtsG8yC\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->59666540]
}, Open  ]],

Cell["\<\
A two\[Hyphen]sided p\[Hyphen]value is twice the one\[Hyphen]sided \
p\[Hyphen]value. \
\>", "MathCaption",
 CellID->4952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"TwoSidedPValue", "/.", "\[InvisibleSpace]", 
    RowBox[{"ChiSquarePValue", "[", 
     RowBox[{"x", ",", "5", ",", 
      RowBox[{"TwoSided", "\[Rule]", "True"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->16211],

Cell[BoxData[
 GraphicsBox[{{}, {}, {
    {Hue[0.67, 0.6, 0.6]}, LineBox[CompressedData["
1:eJwV0ms01AkYBvBxJ4P5S+SSDCtRasUpo8v7MkrO2XCKsBEpKdZKidosasil
XNZBoSi3SiiNRTtMs8ilctdsF2OIhBr/MVZIZWc/vOc5vw/P8+mlB4TtD5Sl
UChu0vs/X83ss6JQxBDsmlGbZcGGVvUHqS6qYuhNoYd2OrGBvYE2dUNbDMkv
bDl6gWxIC+wrYliKQfNgNWW2kA3M1we1zvwsBiPDvwJytWugiuc3/75GDMUK
PNk6pT8hIT288fnJGZhki55QFmthi2W287V+CchcdQnS1eYA/UhgterYHKyI
NL1pGtMEnHR5zXjeAni1uT0qvtsGJWqK1gVpSxBaJrxtaNEJxvEZxdm532Hj
GN1wvrUXyr5EXN5bT8Gkpa13Cj4OQMLm8Xc2DrJouemMtWvUK6BeTVoraZHD
9ceoQfVqgzAZmOlVbamAnPPVa1KihEBr8GcIaxRx6bj9Rtf8EUhNz9HWMFZG
04FohXDfUXiU8q1fI0kFnwywE1K03wNd1pwRS1XFirIfyWjJOIx/5uSJI6nI
OntCUbt8AuaCVpb0LKth7JYvtfWxU1BBuZF68aIGch9TVxg6fgIf1VZGXgQN
Hxdv2qkwIgLJZuubxnwaxl0e4osbpmFn02TXuCKBoZ/kBB3mJCS536Lc30ag
mZBbLcwmgbXKgRHqQmBpDlNGrZ0EyudMjy5vAuP2MH9aOUICHOeMxvgR2K+R
7pEpIuFwQbeFZwCB3TnJfT2zJMTwR8M3BxLoWBRXqP6FhAL1hXqlEwRmJtcz
a5ZJaNxDpQwHE+gf5/JP1CIJgzFGTvWhBA5XhurvkPa/1tqkZZwiUOLhQJOR
7tuZ+RrYRxIof7iBmjpMwvlrCeUzFwhsz9fv0h8g4XMUv3V/IoHco4sl9hwS
IrzMRtmZBA75FhWeLiIh+E2wuy2PwJ6lgKYyIMHPp+ppg4jANOVIrwzBNPjG
rtt/xE0Tj20/fvKc6jQcKioYUmBr4uXcZCp/hwg2RN8JqotYidHh5WVh1R+h
VGts+qS5Fqa46fN27puC3R9lnx0QaWGWncnChtcTkBHnUbyrZBXWTVTctrny
Aaru8T794amNuzmN+afcxkFCU08x0NNB3g1bK12V9zCyNd30brcOPr7lXfFi
bBTm8iRaIVmrcV6gqWRV+w4Emb9G5HjoIiskZsJO+j9hzoZ9TSp62N8xcfpe
4TCY7XrIWteph+aVXtNytkJImTlrfYWljxUvF6ZdQwTAs3U/4LXVALff787P
bnwLBlytNp8FA5xvvJlHlXsDJrIqjIDKNfjaK6Cu9sIrcI0Xfi8IN8Tyuaof
6FN8WPd0smlw/Vr8u7C6Ky/xJfTkUucvDa5Fiee50ohdA+DGT4KHrkbI1bHh
2Ij6QB1KLxWWG+GhRY0pRksvDLU+CrNQo6M/02nTeFYPXL/+ImsylI5P+L9k
jS12wV1nCsO8nY4fzLyfS9Q64ZmuaaK8hTE+6JtTVVj9HBw6jrr7Jxij2bZK
t2S/DihpqvIWDxmjZ8iOJW57G6x+O6VsgCaooumoJGPRCu/6cFt7nglS+0Q2
ldwW4E4matC+maDg6D2B075maFr1QD7puwnKn/3dSeLUDC33HZaZyybIOjW7
7LRb6sirX29LLdBR+yZhNoOjj9VSj9TXVHtZe6WW72b9NiH1xgZ0nnVohmPK
lnb/Sr20fKGiXeqn9vzFZakXhOq0Aqn/AwpoYOs=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  Method->{},
  PlotRange->{{1, 10}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 ImageSize->{184, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->26229441]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Confidence Intervals", "Section",
 CellID->16874],

Cell["\<\
A confidence interval gives bounds within which a parameter value is expected \
to lie with a certain probability. Interval estimation of a parameter is \
often useful in observing the accuracy of an estimator as well as in making \
statistical inferences about the parameter in question.\
\>", "Text",
 CellID->8702],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeanCI",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/MeanCI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MeanDifferenceCI",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/MeanDifferenceCI"]], 
  "InlineFormula"],
 " provide confidence intervals of means and differences of means based on \
the Central Limit Theorem. "
}], "Text",
 CellID->70389241],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MeanCI",
      BaseStyle->"Link",
      ButtonData->"paclet:HypothesisTesting/ref/MeanCI"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "gives a confidence interval for the population mean estimated from ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MeanDifferenceCI",
      BaseStyle->"Link",
      ButtonData->"paclet:HypothesisTesting/ref/MeanDifferenceCI"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], Cell[TextData[{
     "gives a confidence interval for the difference between the population \
means estimated from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "TI"], "1"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->43572526],

Cell["Confidence intervals for means.", "Caption",
 CellID->14442],

Cell["Here is a list of sample values. ", "MathCaption",
 CellID->11998],

Cell[BoxData[
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"{", 
    RowBox[{
    "2.1", ",", "1.2", ",", "0.7", ",", "1.0", ",", "1.1", ",", "3.2", ",", 
     "3.2", ",", "3.3", ",", "2.1", ",", "0.3"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->20862],

Cell["This gives a 95% confidence interval for the mean. ", "MathCaption",
 CellID->21298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanCI", "[", "data1", "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->12232],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.018573200058279`", ",", "2.6214267999417205`"}], "}"}]], "Output",\

 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->56925237]
}, Open  ]],

Cell[TextData[{
 "Assumptions about variances of the populations from which the data were \
sampled will effect the distribution of the parameter estimate. The ",
 Cell[BoxData[
  ButtonBox["KnownVariance",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/KnownVariance"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EqualVariances",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/EqualVariances"]], 
  "InlineFormula"],
 " options can be used to specify assumptions about population variances."
}], "Text",
 CellID->277304682],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["KnownVariance",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/KnownVariance"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "value of the known population variance", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->89890712],

Cell[TextData[{
 "Option for ",
 Cell[BoxData[
  ButtonBox["MeanCI",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/MeanCI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MeanDifferenceCI",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/MeanDifferenceCI"]], 
  "InlineFormula"],
 "."
}], "Caption",
 CellID->568485771],

Cell["\<\
Confidence intervals for the mean and for the difference between means are \
based on a normal distribution if the population variances are assumed known. \
\
\>", "Text",
 CellID->117071091],

Cell[TextData[{
 "Intervals for the mean are based on Student's ",
 Cell[BoxData[
  FormBox[
   StyleBox["t", "TI"], TraditionalForm]], "InlineFormula"],
 " distribution with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n", "TI"], "-", "1"}], TraditionalForm]], "InlineFormula"],
 " degrees of freedom when the population variance must be estimated from a \
list of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " elements. "
}], "Text",
 CellID->49162590],

Cell[TextData[{
 "Confidence interval for the mean assuming a population variance of ",
 Cell[BoxData[".25"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->40850390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanCI", "[", 
  RowBox[{"data1", ",", 
   RowBox[{"KnownVariance", "\[Rule]", ".25"}]}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->92848599],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.510102483847719`", ",", "2.1298975161522806`"}], "}"}]], "Output",\

 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->98139107]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["EqualVariances",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/EqualVariances"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether the unknown population variances are assumed equal", 
     "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->941818391],

Cell[TextData[{
 "Option for ",
 Cell[BoxData[
  ButtonBox["MeanDifferenceCI",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/MeanDifferenceCI"]], 
  "InlineFormula"],
 "."
}], "Caption",
 CellID->7556105],

Cell[TextData[{
 "Confidence intervals for the difference between means are also based on \
Student's ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution if the variances are not known. If the variances are assumed \
equal, ",
 Cell[BoxData[
  ButtonBox["MeanDifferenceCI",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/MeanDifferenceCI"]], 
  "InlineFormula"],
 " is based on Student's ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["1", "TR"]], "]"}], "+", 
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["2", "TR"]], "]"}], "-", "2"}]], "InlineFormula"],
 " degrees of freedom. If the population variances are not assumed equal, \
Welch's approximation for the degrees of freedom is used."
}], "Text",
 CellID->148158738],

Cell["This is a second data set. ", "MathCaption",
 CellID->334116480],

Cell[BoxData[
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"{", 
    RowBox[{
    "1.8", ",", "0.2", ",", "1.5", ",", "1.9", ",", "1.1", ",", "3.0", ",", 
     "2.3", ",", "0.9", ",", "2.4", ",", "1.0"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->229853906],

Cell["\<\
This gives a 95% confidence interval for the difference between means.\
\>", "MathCaption",
 CellID->17879757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDifferenceCI", "[", 
  RowBox[{"data1", ",", "data2"}], "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->159654217],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.72409287723243`"}], ",", "1.1440928772324295`"}], 
  "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->349872569]
}, Open  ]],

Cell["\<\
This gives the confidence interval assuming equal population variances.  \
\>", "MathCaption",
 CellID->178543262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDifferenceCI", "[", 
  RowBox[{"data1", ",", "data2", ",", 
   RowBox[{"EqualVariances", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->333535513],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.7186666910511745`"}], ",", "1.138666691051174`"}], 
  "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->204342362]
}, Open  ]],

Cell[TextData[{
 StyleBox[ButtonBox["VarianceCI",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/ref/VarianceCI"], "MR"],
 " and ",
 StyleBox[ButtonBox["VarianceRatioCI",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/ref/VarianceRatioCI"], "MR"],
 " provide tests of variances for normally distributed samples."
}], "Text",
 CellID->116204640],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["VarianceCI",
      BaseStyle->"Link",
      ButtonData->"paclet:HypothesisTesting/ref/VarianceCI"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "gives a confidence interval for the population variance estimated from \
",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["VarianceRatioCI",
      BaseStyle->"Link",
      ButtonData->"paclet:HypothesisTesting/ref/VarianceRatioCI"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], Cell[TextData[{
     "gives a confidence interval for the ratio of the population variances \
estimated from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->712533509],

Cell["Confidence intervals for variances.", "Caption",
 CellID->20695],

Cell[TextData[{
 "The variance confidence interval is based on a ",
 Cell[BoxData[
  SuperscriptBox["\[Chi]", "2"]], "InlineFormula"],
 " distribution and the variance ratio confidence interval is based on an ",
 StyleBox["F",
  FontSlant->"Italic"],
 "\[Hyphen]ratio distribution."
}], "Text",
 CellID->21678007],

Cell[TextData[{
 "Here is a variance confidence interval for ",
 Cell[BoxData[
  StyleBox["data1", "TI"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->171407313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VarianceCI", "[", "data1", "]"}]], "Input",
 CellLabel->"In[33]:=",
 CellID->52049262],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5938147444982541`", ",", "4.183100252790259`"}], "}"}]], "Output",\

 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->63882261]
}, Open  ]],

Cell[TextData[{
 "The default confidence level for confidence interval functions is ",
 Cell[BoxData[".95"], "InlineFormula"],
 ". Other levels can be specified via the ",
 Cell[BoxData[
  ButtonBox["ConfidenceLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/ConfidenceLevel"]], 
  "InlineFormula"],
 " option."
}], "Text",
 CellID->5086129],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["ConfidenceLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:HypothesisTesting/ref/ConfidenceLevel"], ".95", Cell[
    "confidence level for the interval ", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->298196611],

Cell["Option for all confidence interval functions.", "Caption",
 CellID->16233],

Cell["\<\
Here is a 90% confidence interval for the population variance of the first \
sample. \
\>", "MathCaption",
 CellID->24232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VarianceCI", "[", 
  RowBox[{"data1", ",", 
   RowBox[{"ConfidenceLevel", "\[Rule]", ".9"}]}], "]"}]], "Input",
 CellLabel->"In[34]:=",
 CellID->13513],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6676526362275664`", ",", "3.3971779404579503`"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]=",
 CellID->661859526]
}, Open  ]],

Cell[TextData[{
 "Given an estimate of the mean, variance or ratio of variances and necessary \
standard deviations or degrees of freedom confidence intervals can also be \
obtained for normal, chi\[Hyphen]square, Student ",
 StyleBox["t",
  FontSlant->"Italic"],
 ", or ",
 StyleBox["F",
  FontSlant->"Italic"],
 "\[Hyphen]ratio distributions."
}], "Text",
 CellID->249322763],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NormalCI",
      BaseStyle->"Link",
      ButtonData->"paclet:HypothesisTesting/ref/NormalCI"], "[", 
     RowBox[{
      StyleBox["mean", "TI"], ",", 
      StyleBox["sd", "TI"]}], "]"}], Cell[TextData[{
     "gives the confidence interval centered at ",
     Cell[BoxData[
      StyleBox["mean", "TI"]], "InlineFormula"],
     " with standard deviation ",
     Cell[BoxData[
      StyleBox["sd", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StudentTCI",
      BaseStyle->"Link",
      ButtonData->"paclet:HypothesisTesting/ref/StudentTCI"], "[", 
     RowBox[{
      StyleBox["mean", "TI"], ",", 
      StyleBox["se", "TI"], ",", 
      StyleBox["dof", "TI"]}], "]"}], Cell[TextData[{
     "gives the confidence interval centered at ",
     Cell[BoxData[
      StyleBox["mean", "TI"]], "InlineFormula"],
     " with standard error ",
     Cell[BoxData[
      StyleBox["se", "TI"]], "InlineFormula"],
     " and",
     " ",
     Cell[BoxData[
      StyleBox["dof", "TI"]], "InlineFormula"],
     " degrees of freedom"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ChiSquareCI",
      BaseStyle->"Link",
      ButtonData->"paclet:HypothesisTesting/ref/ChiSquareCI"], "[", 
     RowBox[{
      StyleBox["variance", "TI"], ",", 
      StyleBox["dof", "TI"]}], "]"}], Cell[TextData[{
     "gives the confidence interval for the population variance given the \
sample variance ",
     Cell[BoxData[
      StyleBox["variance", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["dof", "TI"]], "InlineFormula"],
     " degrees of freedom"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FRatioCI",
      BaseStyle->"Link",
      ButtonData->"paclet:HypothesisTesting/ref/FRatioCI"], "[", 
     RowBox[{
      StyleBox["ratio", "TI"], ",", 
      StyleBox["numdof", "TI"], ",", 
      StyleBox["dendof", "TI"]}], "]"}], Cell[TextData[{
     "gives the confidence interval for the ratio of population variances, \
given the ratio of sample variances ",
     Cell[BoxData[
      StyleBox["ratio", "TI"]], "InlineFormula"],
     " and where the sample variances in the numerator and denominator have ",
     
     Cell[BoxData[
      StyleBox["numdof", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["dendof", "TI"]], "InlineFormula"],
     " degrees of freedom"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->40669584],

Cell["Confidence intervals given sample estimates. ", "Caption",
 CellID->21848],

Cell[TextData[{
 "This calculates the mean of ",
 Cell[BoxData[
  StyleBox["data1", "TI"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->14114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mean", "=", 
  RowBox[{"Mean", "[", "data1", "]"}]}]], "Input",
 CellLabel->"In[35]:=",
 CellID->271],

Cell[BoxData["1.8199999999999998`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]=",
 CellID->19990513]
}, Open  ]],

Cell["This estimates the standard error of the mean. ", "MathCaption",
 CellID->20090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"se", "=", 
  RowBox[{
   RowBox[{"StandardDeviation", "[", "data1", "]"}], "/", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"Length", "[", "data1", "]"}], "]"}]}]}]], "Input",
 CellLabel->"In[36]:=",
 CellID->18307],

Cell[BoxData["0.3542754734823046`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]=",
 CellID->15944182]
}, Open  ]],

Cell[TextData[{
 "This is equivalent to ",
 Cell[BoxData[
  ButtonBox["MeanCI",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/MeanCI"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  StyleBox["data1", "TI"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->23032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StudentTCI", "[", 
  RowBox[{"mean", ",", "se", ",", 
   RowBox[{
    RowBox[{"Length", "[", "data1", "]"}], "-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[38]:=",
 CellID->16872],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.018573200058279`", ",", "2.6214267999417205`"}], "}"}]], "Output",\

 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]=",
 CellID->63210828]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hypothesis Testing Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 19.3997088}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Hypothesis Testing Package Tutorial", "language" -> "en", "paclet" -> 
    "HypothesisTesting Package", "status" -> "None", "summary" -> 
    "This package contains functions for testing hypotheses for and computing \
confidence intervals from data. Tests and confidence intervals for means, \
differences of means, variances and ratios of variances are included along \
with p-values and confidence intervals for distributions related to the \
normal distribution. The tests in this package are parametric tests. Given a \
null hypothesis value \\[Theta]_0 for a parameter \\[Theta] and an estimate \
OverscriptBox[StyleBox[\\[Theta], TR], ^] of \\[Theta] obtained from data, \
hypothesis test functions give the probability of observing a value at least \
as extreme as OverscriptBox[StyleBox[\\[Theta], TR], ^] if \\[Theta]_0 is the \
true value of \\[Theta]. A sufficiently small probability, or p-value, \
provides evidence that the true value of \\[Theta] is significantly different \
from \\[Theta]_0. MeanTest and MeanDifferenceTest provide tests of means \
based on the Central Limit Theorem. ", "synonyms" -> {}, "title" -> 
    "Hypothesis Testing Package", "type" -> "Tutorial", "uri" -> 
    "HypothesisTesting/tutorial/HypothesisTesting"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2733, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3358, 81, 59, 1, 70, "Title",
 CellID->30193],
Cell[3420, 84, 375, 7, 70, "Text",
 CellID->324111895],
Cell[CellGroupData[{
Cell[3820, 95, 54, 1, 70, "Section",
 CellID->65111861],
Cell[3877, 98, 1240, 41, 70, "Text",
 CellID->805085351],
Cell[5120, 141, 417, 13, 70, "Text",
 CellID->38669791],
Cell[5540, 156, 1484, 49, 70, "DefinitionBox",
 CellID->22389],
Cell[7027, 207, 62, 1, 70, "Caption",
 CellID->17890],
Cell[7092, 210, 63, 1, 70, "MathCaption",
 CellID->23560],
Cell[7158, 213, 101, 3, 70, "Input",
 CellID->24754],
Cell[7262, 218, 59, 1, 70, "MathCaption",
 CellID->17299],
Cell[7324, 221, 259, 8, 70, "Input",
 CellID->7809],
Cell[7586, 231, 122, 3, 70, "MathCaption",
 CellID->16503],
Cell[CellGroupData[{
Cell[7733, 238, 129, 4, 70, "Input",
 CellID->18954],
Cell[7865, 244, 221, 6, 36, "Output",
 CellID->93201983]
}, Open  ]],
Cell[8101, 253, 577, 16, 70, "Text",
 CellID->819706313],
Cell[8681, 271, 586, 16, 70, "DefinitionBox3Col",
 CellID->10713],
Cell[9270, 289, 377, 14, 70, "Caption",
 CellID->74019202],
Cell[9650, 305, 177, 4, 70, "Text",
 CellID->406018260],
Cell[9830, 311, 487, 18, 70, "Text",
 CellID->197757042],
Cell[10320, 331, 167, 4, 70, "MathCaption",
 CellID->109679975],
Cell[CellGroupData[{
Cell[10512, 339, 185, 5, 70, "Input",
 CellID->303330159],
Cell[10700, 346, 223, 6, 36, "Output",
 CellID->364339515]
}, Open  ]],
Cell[10938, 355, 619, 17, 70, "DefinitionBox3Col",
 CellID->31637940],
Cell[11560, 374, 230, 9, 70, "Caption",
 CellID->23917160],
Cell[11793, 385, 1099, 34, 70, "Text",
 CellID->20617408],
Cell[12895, 421, 66, 1, 70, "MathCaption",
 CellID->23530],
Cell[12964, 424, 259, 8, 70, "Input",
 CellID->9047],
Cell[13226, 434, 238, 7, 70, "MathCaption",
 CellID->15748],
Cell[CellGroupData[{
Cell[13489, 445, 152, 4, 70, "Input",
 CellID->20691],
Cell[13644, 451, 220, 6, 36, "Output",
 CellID->477823521]
}, Open  ]],
Cell[13879, 460, 160, 4, 70, "MathCaption",
 CellID->367713153],
Cell[CellGroupData[{
Cell[14064, 468, 212, 5, 70, "Input",
 CellID->183599562],
Cell[14279, 475, 220, 6, 36, "Output",
 CellID->326999066]
}, Open  ]],
Cell[14514, 484, 425, 14, 70, "Text",
 CellID->20232],
Cell[14942, 500, 1523, 50, 70, "DefinitionBox",
 CellID->133135456],
Cell[16468, 552, 65, 1, 70, "Caption",
 CellID->176],
Cell[16536, 555, 295, 9, 70, "Text",
 CellID->96957417],
Cell[16834, 566, 67, 1, 70, "MathCaption",
 CellID->6243],
Cell[16904, 569, 226, 8, 70, "Input",
 CellID->18021],
Cell[17133, 579, 247, 7, 70, "MathCaption",
 CellID->18365],
Cell[CellGroupData[{
Cell[17405, 590, 130, 4, 70, "Input",
 CellID->8584],
Cell[17538, 596, 218, 6, 36, "Output",
 CellID->5291754]
}, Open  ]],
Cell[17771, 605, 477, 8, 70, "Text",
 CellID->503681572],
Cell[18251, 615, 177, 4, 70, "Text",
 CellID->281896613],
Cell[18431, 621, 1178, 34, 70, "DefinitionBox3Col",
 CellID->164564161],
Cell[19612, 657, 76, 1, 70, "Caption",
 CellID->3106],
Cell[19691, 660, 1187, 33, 70, "Text",
 CellID->8148],
Cell[20881, 695, 163, 6, 70, "MathCaption",
 CellID->3265],
Cell[CellGroupData[{
Cell[21069, 705, 181, 5, 70, "Input",
 CellID->10780],
Cell[21253, 712, 1404, 41, 50, "Output",
 CellID->572817503]
}, Open  ]],
Cell[22672, 756, 169, 6, 70, "MathCaption",
 CellID->99713113],
Cell[CellGroupData[{
Cell[22866, 766, 185, 5, 70, "Input",
 CellID->156073823],
Cell[23054, 773, 220, 6, 36, "Output",
 CellID->654481167]
}, Open  ]],
Cell[23289, 782, 922, 28, 70, "Text",
 CellID->31259],
Cell[24214, 812, 2387, 71, 70, "DefinitionBox",
 CellID->207867752],
Cell[26604, 885, 94, 3, 70, "Caption",
 CellID->20734],
Cell[26701, 890, 228, 7, 70, "MathCaption",
 CellID->28736],
Cell[CellGroupData[{
Cell[26954, 901, 125, 4, 70, "Input",
 CellID->27894],
Cell[27082, 907, 220, 6, 36, "Output",
 CellID->690323448]
}, Open  ]],
Cell[27317, 916, 387, 13, 70, "MathCaption",
 CellID->8419],
Cell[CellGroupData[{
Cell[27729, 933, 190, 6, 70, "Input",
 CellID->11810],
Cell[27922, 941, 221, 6, 36, "Output",
 CellID->421250152]
}, Open  ]],
Cell[28158, 950, 133, 4, 70, "MathCaption",
 CellID->11489],
Cell[CellGroupData[{
Cell[28316, 958, 389, 13, 70, "Input",
 CellID->2334],
Cell[28708, 973, 1842, 38, 153, "Output",
 CellID->108621750]
}, Open  ]],
Cell[30565, 1014, 110, 3, 70, "MathCaption",
 CellID->20178],
Cell[CellGroupData[{
Cell[30700, 1021, 408, 12, 28, "Input",
 CellID->29590],
Cell[31111, 1035, 2140, 39, 153, "Output",
 Evaluatable->False,
 CellID->59666540]
}, Open  ]],
Cell[33266, 1077, 132, 4, 70, "MathCaption",
 CellID->4952],
Cell[CellGroupData[{
Cell[33423, 1085, 461, 13, 70, "Input",
 CellID->16211],
Cell[33887, 1100, 2195, 44, 153, "Output",
 CellID->26229441]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36131, 1150, 55, 1, 70, "Section",
 CellID->16874],
Cell[36189, 1153, 327, 6, 70, "Text",
 CellID->8702],
Cell[36519, 1161, 451, 14, 70, "Text",
 CellID->70389241],
Cell[36973, 1177, 1125, 35, 70, "DefinitionBox",
 CellID->43572526],
Cell[38101, 1214, 66, 1, 70, "Caption",
 CellID->14442],
Cell[38170, 1217, 72, 1, 70, "MathCaption",
 CellID->11998],
Cell[38245, 1220, 271, 8, 70, "Input",
 CellID->20862],
Cell[38519, 1230, 90, 1, 70, "MathCaption",
 CellID->21298],
Cell[CellGroupData[{
Cell[38634, 1235, 103, 3, 70, "Input",
 CellID->12232],
Cell[38740, 1240, 241, 8, 36, "Output",
 CellID->56925237]
}, Open  ]],
Cell[38996, 1251, 581, 16, 70, "Text",
 CellID->277304682],
Cell[39580, 1269, 589, 16, 70, "DefinitionBox3Col",
 CellID->89890712],
Cell[40172, 1287, 370, 14, 70, "Caption",
 CellID->568485771],
Cell[40545, 1303, 201, 5, 70, "Text",
 CellID->117071091],
Cell[40749, 1310, 481, 16, 70, "Text",
 CellID->49162590],
Cell[41233, 1328, 171, 5, 70, "MathCaption",
 CellID->40850390],
Cell[CellGroupData[{
Cell[41429, 1337, 173, 5, 70, "Input",
 CellID->92848599],
Cell[41605, 1344, 241, 8, 36, "Output",
 CellID->98139107]
}, Open  ]],
Cell[41861, 1355, 620, 17, 70, "DefinitionBox3Col",
 CellID->941818391],
Cell[42484, 1374, 225, 9, 70, "Caption",
 CellID->7556105],
Cell[42712, 1385, 1119, 35, 70, "Text",
 CellID->148158738],
Cell[43834, 1422, 70, 1, 70, "MathCaption",
 CellID->334116480],
Cell[43907, 1425, 275, 8, 70, "Input",
 CellID->229853906],
Cell[44185, 1435, 120, 3, 70, "MathCaption",
 CellID->17879757],
Cell[CellGroupData[{
Cell[44330, 1442, 144, 4, 70, "Input",
 CellID->159654217],
Cell[44477, 1448, 261, 9, 36, "Output",
 CellID->349872569]
}, Open  ]],
Cell[44753, 1460, 124, 3, 70, "MathCaption",
 CellID->178543262],
Cell[CellGroupData[{
Cell[44902, 1467, 200, 5, 70, "Input",
 CellID->333535513],
Cell[45105, 1474, 262, 9, 36, "Output",
 CellID->204342362]
}, Open  ]],
Cell[45382, 1486, 372, 10, 70, "Text",
 CellID->116204640],
Cell[45757, 1498, 1161, 37, 70, "DefinitionBox",
 CellID->712533509],
Cell[46921, 1537, 70, 1, 70, "Caption",
 CellID->20695],
Cell[46994, 1540, 313, 9, 70, "Text",
 CellID->21678007],
Cell[47310, 1551, 169, 6, 70, "MathCaption",
 CellID->171407313],
Cell[CellGroupData[{
Cell[47504, 1561, 110, 3, 70, "Input",
 CellID->52049262],
Cell[47617, 1566, 241, 8, 36, "Output",
 CellID->63882261]
}, Open  ]],
Cell[47873, 1577, 367, 11, 70, "Text",
 CellID->5086129],
Cell[48243, 1590, 513, 13, 70, "DefinitionBox3Col",
 CellID->298196611],
Cell[48759, 1605, 80, 1, 70, "Caption",
 CellID->16233],
Cell[48842, 1608, 132, 4, 70, "MathCaption",
 CellID->24232],
Cell[CellGroupData[{
Cell[48999, 1616, 175, 5, 70, "Input",
 CellID->13513],
Cell[49177, 1623, 244, 8, 36, "Output",
 CellID->661859526]
}, Open  ]],
Cell[49436, 1634, 377, 11, 70, "Text",
 CellID->249322763],
Cell[49816, 1647, 2481, 77, 70, "DefinitionBox",
 CellID->40669584],
Cell[52300, 1726, 80, 1, 70, "Caption",
 CellID->21848],
Cell[52383, 1729, 149, 6, 70, "MathCaption",
 CellID->14114],
Cell[CellGroupData[{
Cell[52557, 1739, 125, 4, 70, "Input",
 CellID->271],
Cell[52685, 1745, 176, 5, 36, "Output",
 CellID->19990513]
}, Open  ]],
Cell[52876, 1753, 86, 1, 70, "MathCaption",
 CellID->20090],
Cell[CellGroupData[{
Cell[52987, 1758, 233, 7, 70, "Input",
 CellID->18307],
Cell[53223, 1767, 176, 5, 36, "Output",
 CellID->15944182]
}, Open  ]],
Cell[53414, 1775, 286, 11, 70, "MathCaption",
 CellID->23032],
Cell[CellGroupData[{
Cell[53725, 1790, 203, 6, 70, "Input",
 CellID->16872],
Cell[53931, 1798, 241, 8, 36, "Output",
 CellID->63210828]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[54211, 1811, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

