(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7346,        255]
NotebookOptionsPosition[      4665,        176]
NotebookOutlinePosition[      6001,        210]
CellTagsIndexPosition[      5958,        207]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Linear Regression Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["Regress",
  BaseStyle->"Link",
  ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " perform a linear regression"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["DesignedRegress",
  BaseStyle->"Link",
  ButtonData->"paclet:LinearRegression/ref/DesignedRegress"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " perform a linear regression on a design matrix"
}], "GuideText",
 CellID->59990653],

Cell[TextData[{
 Cell[TextData[ButtonBox["DesignMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:LinearRegression/ref/DesignMatrix"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " construct a design matrix"
}], "GuideText",
 CellID->64469645],

Cell["\t", "GuideDelimiterSubsection",
 CellID->45579646],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Report Values",
 BaseStyle->"Link",
 ButtonData->
  "paclet:RegressionCommon/guide/RegressionCommonPackage"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->557424193],

Cell[TextData[{
 Cell[TextData[ButtonBox["BestFit",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/BestFit"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " the fitted function"
}], "GuideText",
 CellID->1304743537],

Cell[TextData[{
 Cell[TextData[ButtonBox["PredictedResponse",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/PredictedResponse"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " fitted values"
}], "GuideText",
 CellID->869106842],

Cell[TextData[{
 Cell[TextData[ButtonBox["FitResiduals",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/FitResiduals"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ParameterCITable",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/ref/ParameterCITable"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/guide/RegressionCommonPackage"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->683134210]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Linear Regression Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:LinearRegression/tutorial/LinearRegression"]], "GuideTutorial",
 CellID->86686203]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Nonlinear Regression Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NonlinearRegression/guide/NonlinearRegressionPackage"]], \
"GuideMoreAbout",
 CellID->31299110],

Cell[TextData[ButtonBox["Analysis of Variance Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ANOVA/guide/AnalysisOfVariancePackage"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Hypothesis Testing Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HypothesisTesting/guide/HypothesisTestingPackage"]], \
"GuideMoreAbout",
 CellID->86224133],

Cell[TextData[ButtonBox["Curve Fitting and Approximate Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CurveFittingAndApproximateFunctions"]], "GuideMoreAbout",
 CellID->1029892024],

Cell[TextData[ButtonBox["Matrix-Based Minimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixBasedMinimization"]], "GuideMoreAbout",
 CellID->774336447],

Cell[TextData[ButtonBox["Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Optimization"]], "GuideMoreAbout",
 CellID->15039546]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Linear Regression Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 19.8215946}", "context" -> 
    "LinearRegression`", 
    "keywords" -> {
     "least squares", "linear fitting", "linear models", "linear regression"},
     "index" -> True, "label" -> "Linear Regression Package Guide", 
    "language" -> "en", "paclet" -> "LinearRegression Package", "status" -> 
    "None", "summary" -> 
    "Regress -- perform a linear regression, DesignedRegress -- perform a \
linear regression on a design matrix, DesignMatrix -- construct a design \
matrix, BestFit -- the fitted function, PredictedResponse -- fitted values", 
    "synonyms" -> {}, "title" -> "Linear Regression Package", "type" -> 
    "Guide", "uri" -> "LinearRegression/guide/LinearRegressionPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 67, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[689, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[748, 31, 266, 8, 70, "GuideText",
 CellID->203374175],
Cell[1017, 41, 303, 9, 70, "GuideText",
 CellID->59990653],
Cell[1323, 52, 276, 9, 70, "GuideText",
 CellID->64469645],
Cell[1602, 63, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->45579646],
Cell[CellGroupData[{
Cell[1684, 68, 223, 5, 70, "GuideFunctionsSubsection",
 CellID->557424193],
Cell[1910, 75, 259, 8, 70, "GuideText",
 CellID->1304743537],
Cell[2172, 85, 275, 9, 70, "GuideText",
 CellID->869106842],
Cell[2450, 96, 700, 20, 70, "InlineGuideFunctionListing",
 CellID->683134210]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3199, 122, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[3264, 125, 179, 4, 70, "GuideTutorial",
 CellID->86686203]
}, Open  ]],
Cell[CellGroupData[{
Cell[3480, 134, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[3545, 137, 195, 5, 70, "GuideMoreAbout",
 CellID->31299110],
Cell[3743, 144, 179, 4, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[3925, 150, 189, 5, 70, "GuideMoreAbout",
 CellID->86224133],
Cell[4117, 157, 195, 4, 70, "GuideMoreAbout",
 CellID->1029892024],
Cell[4315, 163, 165, 3, 70, "GuideMoreAbout",
 CellID->774336447],
Cell[4483, 168, 140, 3, 70, "GuideMoreAbout",
 CellID->15039546]
}, Open  ]],
Cell[4638, 174, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

